/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.warehouse.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.json.JSONArray;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.warehouse.dao.WhStoreGoodsMapper;
import com.yqbsoft.laser.service.warehouse.dao.WhStoreSkuMapper;
import com.yqbsoft.laser.service.warehouse.domain.OcContractDomain;
import com.yqbsoft.laser.service.warehouse.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.warehouse.domain.RsSkuDomain;
import com.yqbsoft.laser.service.warehouse.domain.StockDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhChannelsendDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhDgnumDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhStoreGoodsDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhStoreSkuDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhStoreSkuNumBean;
import com.yqbsoft.laser.service.warehouse.es.SendPollThread;
import com.yqbsoft.laser.service.warehouse.es.SendPutThread;
import com.yqbsoft.laser.service.warehouse.es.SendService;
import com.yqbsoft.laser.service.warehouse.model.WhChannelsend;
import com.yqbsoft.laser.service.warehouse.model.WhDgnumList;
import com.yqbsoft.laser.service.warehouse.model.WhStoreGoods;
import com.yqbsoft.laser.service.warehouse.model.WhStoreSku;
import com.yqbsoft.laser.service.warehouse.model.WhUserwh;
import com.yqbsoft.laser.service.warehouse.service.WhChannelsendService;
import com.yqbsoft.laser.service.warehouse.service.WhStoreGoodsBaseService;
import com.yqbsoft.laser.service.warehouse.service.WhStoreGoodsService;
import com.yqbsoft.laser.service.warehouse.service.WhUserwhService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;

public class WhStoreGoodsServiceImpl
extends BaseServiceImpl
implements WhStoreGoodsService {
    private static final String SYS_CODE = "wh.WhStoreGoodsService";
    private WhStoreGoodsMapper whStoreGoodsMapper;
    private WhStoreSkuMapper whStoreSkuMapper;
    private WhChannelsendService whChannelsendService;
    @Autowired
    private WhUserwhService whUserwhService;
    private static SendService sendService;
    private static final Object lock;

    public void setWhChannelsendService(WhChannelsendService whChannelsendService) {
        this.whChannelsendService = whChannelsendService;
    }

    public void setWhStoreGoodsMapper(WhStoreGoodsMapper whStoreGoodsMapper) {
        this.whStoreGoodsMapper = whStoreGoodsMapper;
    }

    public void setWhStoreSkuMapper(WhStoreSkuMapper whStoreSkuMapper) {
        this.whStoreSkuMapper = whStoreSkuMapper;
    }

    private void updateGoodsStockModel(Map<String, Object> map) throws ApiException {
        if (map == null) {
            return;
        }
        int i = 0;
        try {
            i = this.whStoreGoodsMapper.updateResourceStock(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.updateGoodsStockModel.map.ex", map.toString(), (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhStoreGoodsService.updateGoodsStockModel.map.null", map.toString());
        }
    }

    private void updateSkuStockModel(Map<String, Object> map) throws ApiException {
        if (map == null) {
            return;
        }
        int i = 0;
        try {
            i = this.whStoreSkuMapper.updateSkuStock(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.updateSkuStockModel.map.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhStoreGoodsService.updateSkuStockModel.map.null", map.toString());
        }
    }

    private Date getSysDate() {
        try {
            return this.whStoreGoodsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkStoreGoods(WhStoreGoodsDomain whStoreGoodsDomain) {
        if (null == whStoreGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setStoreGoodsDefault(WhStoreGoods whStoreGoods) {
        if (null == whStoreGoods) {
            return;
        }
        if (null == whStoreGoods.getDataState()) {
            whStoreGoods.setDataState(0);
        }
        if (null == whStoreGoods.getGmtCreate()) {
            whStoreGoods.setGmtCreate(this.getSysDate());
        }
        whStoreGoods.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)whStoreGoods.getStoreGoodsCode())) {
            whStoreGoods.setStoreGoodsCode(this.createUUIDString());
        }
        if (StringUtils.isBlank((String)whStoreGoods.getStoreType())) {
            whStoreGoods.setStoreType("0");
        }
        whStoreGoods.setGoodsSupplynum(whStoreGoods.getGoodsNum());
        whStoreGoods.setGoodsSupplyweight(whStoreGoods.getGoodsWeight());
    }

    private int getStoreGoodsMaxCode() {
        int code = 0;
        try {
            return this.whStoreGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.getStoreGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setStoreGoodsUpdataDefault(WhStoreGoods whStoreGoods) {
        if (null == whStoreGoods) {
            return;
        }
        whStoreGoods.setGmtModified(this.getSysDate());
    }

    private void saveStoreGoodsModel(WhStoreGoods whStoreGoods) throws ApiException {
        if (null == whStoreGoods) {
            return;
        }
        try {
            this.whStoreGoodsMapper.insert(whStoreGoods);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.saveStoreGoodsModel.ex", (Throwable)e);
        }
    }

    private WhStoreGoods getStoreGoodsModelById(Integer storeGoodsId) {
        if (null == storeGoodsId) {
            return null;
        }
        try {
            return this.whStoreGoodsMapper.selectByPrimaryKey(storeGoodsId);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.getStoreGoodsModelById", (Throwable)e);
            return null;
        }
    }

    public WhStoreGoods getStoreGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.whStoreGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.getStoreGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delStoreGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.whStoreGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.delStoreGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhStoreGoodsService.delStoreGoodsModelByCode.num");
        }
    }

    private void deleteStoreGoodsModel(Integer storeGoodsId) throws ApiException {
        if (null == storeGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.whStoreGoodsMapper.deleteByPrimaryKey(storeGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.deleteStoreGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhStoreGoodsService.deleteStoreGoodsModel.num");
        }
    }

    private void updateStoreGoodsModel(WhStoreGoods whStoreGoods) throws ApiException {
        if (null == whStoreGoods) {
            return;
        }
        try {
            this.whStoreGoodsMapper.updateByPrimaryKeySelective(whStoreGoods);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.updateStoreGoodsModel.ex", (Throwable)e);
        }
    }

    private void updateStoreGoodsNumModel(WhStoreSkuNumBean whStoreSkuNumBean) throws ApiException {
        if (null == whStoreSkuNumBean) {
            return;
        }
        try {
            this.whStoreGoodsMapper.updateStoreSkuNum(whStoreSkuNumBean);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.updateStoreGoodsNumModel.ex", (Throwable)e);
        }
    }

    private void updateStoreSkuNumModel(WhStoreSkuNumBean whStoreSkuNumBean) throws ApiException {
        if (null == whStoreSkuNumBean) {
            return;
        }
        int i = 0;
        try {
            i = this.whStoreSkuMapper.updateStoreSkuNum(whStoreSkuNumBean);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.updateStoreSkuNumModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhStoreGoodsService.updateStoreSkuNumModel.i" + JsonUtil.buildNormalBinder().toJson((Object)whStoreSkuNumBean));
        }
    }

    private void updateStateStoreGoodsModel(Integer storeGoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == storeGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("storeGoodsId", storeGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.whStoreGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.updateStateStoreGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhStoreGoodsService.updateStateStoreGoodsModel.null");
        }
    }

    private WhStoreGoods makeStoreGoods(WhStoreGoodsDomain whStoreGoodsDomain, WhStoreGoods whStoreGoods) {
        if (null == whStoreGoodsDomain) {
            return null;
        }
        if (null == whStoreGoods) {
            whStoreGoods = new WhStoreGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)whStoreGoods, (Object)whStoreGoodsDomain);
            return whStoreGoods;
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.makeStoreGoods", (Throwable)e);
            return null;
        }
    }

    private List<WhStoreGoods> queryStoreGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.whStoreGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.queryStoreGoodsModel", (Throwable)e);
            return null;
        }
    }

    private List<WhStoreGoods> queryStoreGoodsModelPages(Map<String, Object> parammap) {
        try {
            return this.whStoreGoodsMapper.querys(parammap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.queryStoreGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countStoreGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.whStoreGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.countStoreGoods", (Throwable)e);
        }
        return i;
    }

    private int countStoreGoodsAll(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.whStoreGoodsMapper.countNums(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.countStoreGoods", (Throwable)e);
        }
        return i;
    }

    private Map<String, Object> querySumStoreSkuMode(Map<String, Object> map) {
        try {
            return this.whStoreSkuMapper.querySumStoreSkuMode(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.querySumStoreSkuMode", (Throwable)e);
            return null;
        }
    }

    private String checkStoreSku(WhStoreSkuDomain whStoreSkuDomain) {
        if (null == whStoreSkuDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setStoreSkuDefault(WhStoreSku whStoreSku) {
        if (null == whStoreSku) {
            return;
        }
        if (null == whStoreSku.getDataState()) {
            whStoreSku.setDataState(0);
        }
        if (null == whStoreSku.getGmtCreate()) {
            whStoreSku.setGmtCreate(this.getSysDate());
        }
        whStoreSku.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)whStoreSku.getStoreSkuCode())) {
            whStoreSku.setStoreSkuCode(this.createUUIDString());
        }
        if (StringUtils.isBlank((String)whStoreSku.getStoreType())) {
            whStoreSku.setStoreType("0");
        }
        whStoreSku.setGoodsSupplynum(whStoreSku.getGoodsNum());
        whStoreSku.setGoodsSupplyweight(whStoreSku.getGoodsWeight());
    }

    private int getStoreSkuMaxCode() {
        int code = 0;
        try {
            return this.whStoreSkuMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.getStoreSkuMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setStoreSkuUpdataDefault(WhStoreSku whStoreSku) {
        if (null == whStoreSku) {
            return;
        }
        whStoreSku.setGmtModified(this.getSysDate());
    }

    private void saveStoreSkuModel(WhStoreSku whStoreSku) throws ApiException {
        if (null == whStoreSku) {
            return;
        }
        try {
            this.whStoreSkuMapper.insert(whStoreSku);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.saveStoreSkuModel.ex", (Throwable)e);
        }
    }

    private void saveStoreSkuBatchModel(List<WhStoreSku> whStoreSkuList) throws ApiException {
        if (ListUtil.isEmpty(whStoreSkuList)) {
            return;
        }
        try {
            this.whStoreSkuMapper.insertBatch(whStoreSkuList);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.saveStoreSkuBatchModel.ex", (Throwable)e);
        }
    }

    private WhStoreSku getStoreSkuModelById(Integer storeSkuId) {
        if (null == storeSkuId) {
            return null;
        }
        try {
            return this.whStoreSkuMapper.selectByPrimaryKey(storeSkuId);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.getStoreSkuModelById", (Throwable)e);
            return null;
        }
    }

    public WhStoreSku getStoreSkuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.whStoreSkuMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.getStoreSkuModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delStoreSkuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.whStoreSkuMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.delStoreSkuModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhStoreGoodsService.delStoreSkuModelByCode.num");
        }
    }

    private void deleteStoreSkuModel(Integer storeSkuId) throws ApiException {
        if (null == storeSkuId) {
            return;
        }
        int i = 0;
        try {
            i = this.whStoreSkuMapper.deleteByPrimaryKey(storeSkuId);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.deleteStoreSkuModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhStoreGoodsService.deleteStoreSkuModel.num");
        }
    }

    private void updateStoreSkuModel(WhStoreSku whStoreSku) throws ApiException {
        if (null == whStoreSku) {
            return;
        }
        try {
            this.whStoreSkuMapper.updateByPrimaryKeySelective(whStoreSku);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.updateStoreSkuModel.ex", (Throwable)e);
        }
    }

    private void updateStateStoreSkuModel(Integer storeSkuId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == storeSkuId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("storeSkuId", storeSkuId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.whStoreSkuMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.updateStateStoreSkuModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhStoreGoodsService.updateStateStoreSkuModel.null");
        }
    }

    private WhStoreSku makeStoreSku(WhStoreSkuDomain whStoreSkuDomain, WhStoreSku whStoreSku) {
        if (null == whStoreSkuDomain) {
            return null;
        }
        if (null == whStoreSku) {
            whStoreSku = new WhStoreSku();
        }
        try {
            BeanUtils.copyAllPropertys((Object)whStoreSku, (Object)whStoreSkuDomain);
            return whStoreSku;
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.makeStoreSku", (Throwable)e);
            return null;
        }
    }

    private List<WhStoreSku> queryStoreSkuModelPage(Map<String, Object> parammap) {
        this.logger.info("wh.WhStoreGoodsService.queryStoreSkuModelPage.parammap", (Object)JsonUtil.buildNonDefaultBinder().toJson(parammap));
        try {
            if (Objects.nonNull(parammap) && parammap.containsKey("warehouseGroup")) {
                return this.whStoreSkuMapper.queryByWarehouseGroup(parammap);
            }
            return this.whStoreSkuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.queryStoreSkuModel", (Throwable)e);
            return null;
        }
    }

    private int countStoreSku(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.whStoreSkuMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.countStoreSku", (Throwable)e);
        }
        return i;
    }

    private boolean lockGoodsData(Map<String, Object> map) {
        if (map.isEmpty()) {
            return false;
        }
        int i = 0;
        try {
            i = this.whStoreGoodsMapper.lockDataByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.lockGoodsData", (Object)map.toString(), (Throwable)e);
        }
        return i > 0;
    }

    public String internalInvokeCallBack(String apiCode, Map<String, Object> paramMap, String routerdire) {
        return super.internalInvokeCallBack(apiCode, paramMap, routerdire);
    }

    @Override
    public List<WhChannelsend> saveStoreGoods(WhStoreGoodsDomain whStoreGoodsDomain) throws ApiException {
        if (null == whStoreGoodsDomain) {
            this.logger.error("wh.WhStoreGoodsService.saveStoreGoods.param", (Object)"whStoreGoodsDomain is null");
            return null;
        }
        List<WhStoreSkuDomain> whStoreSkuDomainList = whStoreGoodsDomain.getWhStoreSkuDomainList();
        if (ListUtil.isEmpty(whStoreSkuDomainList)) {
            this.logger.error("wh.WhStoreGoodsService.saveStoreGoods.param", (Object)"whStoreSkuDomainList is null");
            return null;
        }
        ArrayList<WhChannelsend> whChannelsendList = new ArrayList<WhChannelsend>();
        for (WhStoreSkuDomain whStoreSkuDomain : whStoreSkuDomainList) {
            List<WhChannelsend> chwhChannelsendList;
            WhStoreSku whStoreSku = this.createStoreSkuModel(whStoreSkuDomain);
            HashMap<String, Object> storeSkuMap = new HashMap<String, Object>();
            storeSkuMap.put("tenantCode", whStoreSku.getTenantCode());
            storeSkuMap.put("skuNo", whStoreSku.getSkuNo());
            storeSkuMap.put("storeType", whStoreSku.getStoreType());
            storeSkuMap.put("memberCcode", whStoreSku.getMemberCcode());
            storeSkuMap.put("skuBarcode", whStoreSku.getSkuBarcode());
            storeSkuMap.put("warehouseCode", whStoreSku.getWarehouseCode());
            storeSkuMap.put("storeWhlocal", whStoreSku.getStoreWhlocal());
            WhStoreSku oldStoreSku = this.queryStoreSkuMode(storeSkuMap);
            String opdir = whStoreSku.getOpstoreDir();
            if (StringUtils.isBlank((String)opdir)) {
                opdir = "1";
            }
            if ("0".equals(opdir) && null == oldStoreSku) {
                throw new ApiException("wh.WhStoreGoodsService.saveStoreGoods.oldStoreSku.null", ((Object)storeSkuMap).toString());
            }
            if (null == oldStoreSku || oldStoreSku.getStoreSkuId() == null) {
                chwhChannelsendList = this.saveStoreNum(whStoreSku, whStoreGoodsDomain);
                if (!ListUtil.isNotEmpty(chwhChannelsendList)) continue;
                whChannelsendList.addAll(chwhChannelsendList);
                continue;
            }
            whStoreSku.setGoodsCode(oldStoreSku.getGoodsCode());
            whStoreSku.setSkuCode(oldStoreSku.getSkuCode());
            chwhChannelsendList = this.updateStoreNum(whStoreSku, whStoreGoodsDomain);
            if (!ListUtil.isNotEmpty(chwhChannelsendList)) continue;
            whChannelsendList.addAll(chwhChannelsendList);
        }
        return whChannelsendList;
    }

    private List<WhChannelsend> saveStoreNum(WhStoreSku whStoreSku, WhStoreGoodsDomain whStoreGoodsDomain) {
        ArrayList<WhChannelsend> whChannelsendList = new ArrayList<WhChannelsend>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)whStoreSku.getGoodsCode())) {
            map.put("goodsCode", whStoreSku.getGoodsCode());
        }
        if (StringUtils.isNotBlank((String)whStoreSku.getGoodsNo())) {
            map.put("goodsNo", whStoreSku.getGoodsNo());
        }
        map.put("memberCode", whStoreSku.getMemberCode());
        map.put("tenantCode", whStoreSku.getTenantCode());
        map.put("warehouseCode", whStoreGoodsDomain.getWarehouseCode());
        map.put("storeType", whStoreSku.getStoreType());
        map.put("channelCode", whStoreSku.getChannelCode());
        map.put("memberCcode", whStoreSku.getMemberCcode());
        map.put("warehouseCode", whStoreSku.getWarehouseCode());
        WhStoreGoods whStoreGoods = this.queryStoreGoodsModel(map);
        if (null == whStoreGoods) {
            whStoreGoods = this.makeStoreGoods(whStoreGoodsDomain, null);
            whStoreGoods.setStoreType(whStoreSku.getStoreType());
            whStoreGoods.setGoodsNum(whStoreSku.getGoodsNum());
            whStoreGoods.setGoodsWeight(whStoreSku.getGoodsWeight());
            whStoreGoods.setGoodsSupplynum(whStoreSku.getGoodsNum());
            whStoreGoods.setGoodsSupplyweight(whStoreSku.getGoodsWeight());
            this.setStoreGoodsDefault(whStoreGoods);
            this.saveStoreGoodsModel(whStoreGoods);
            whStoreSku.setStoreGoodsCode(whStoreGoods.getStoreGoodsCode());
            this.saveStoreSkuModel(whStoreSku);
            List<WhChannelsend> chwhChannelsendList = this.saveSend(whStoreSku, whStoreGoodsDomain.getStoreGoodsBtype(), 0, null);
            if (ListUtil.isNotEmpty(chwhChannelsendList)) {
                whChannelsendList.addAll(chwhChannelsendList);
            }
        } else {
            HashMap<String, Object> updateMap = new HashMap<String, Object>();
            updateMap.put("goodsNum", whStoreSku.getGoodsNum());
            updateMap.put("goodsWeight", whStoreSku.getGoodsWeight());
            if (StringUtils.isNotBlank((String)whStoreSku.getGoodsCode())) {
                updateMap.put("goodsCode", whStoreSku.getGoodsCode());
            }
            if (StringUtils.isNotBlank((String)whStoreSku.getGoodsNo())) {
                updateMap.put("goodsNo", whStoreSku.getGoodsNo());
            }
            updateMap.put("warehouseCode", whStoreSku.getWarehouseCode());
            updateMap.put("memberCode", whStoreSku.getMemberCode());
            updateMap.put("tenantCode", whStoreSku.getTenantCode());
            updateMap.put("storeType", whStoreSku.getStoreType());
            updateMap.put("storeGoodsType", whStoreSku.getStoreGoodsType());
            updateMap.put("channelCode", whStoreSku.getChannelCode());
            updateMap.put("memberCcode", whStoreSku.getMemberCcode());
            this.updateStoreGoodsNum(updateMap);
            whStoreSku.setStoreGoodsCode(whStoreGoods.getStoreGoodsCode());
            this.saveStoreSkuModel(whStoreSku);
            List<WhChannelsend> chwhChannelsendList = this.saveSend(whStoreSku, whStoreGoodsDomain.getStoreGoodsBtype(), 0, null);
            if (ListUtil.isNotEmpty(chwhChannelsendList)) {
                whChannelsendList.addAll(chwhChannelsendList);
            }
        }
        return whChannelsendList;
    }

    private List<WhChannelsend> updateStoreNum(WhStoreSku whStoreSku, WhStoreGoodsDomain whStoreGoodsDomain) {
        if (null == whStoreSku) {
            return null;
        }
        WhStoreSkuNumBean whStoreSkuNumBean = new WhStoreSkuNumBean();
        try {
            BeanUtils.copyImplPropertys((Object)whStoreSkuNumBean, (Object)whStoreSku);
        }
        catch (Exception exception) {
            // empty catch block
        }
        whStoreSkuNumBean.setOpstoreDir(whStoreSku.getOpstoreDir());
        whStoreSkuNumBean.setTenantCode(whStoreSku.getTenantCode());
        whStoreSkuNumBean.setSkuEocode(whStoreSku.getSkuEocode());
        whStoreSkuNumBean.setGoodsNum(whStoreSku.getGoodsNum());
        whStoreSkuNumBean.setMemberCode(whStoreSku.getMemberCode());
        whStoreSkuNumBean.setSkuNo(whStoreSku.getSkuNo());
        String ddFalg = "false";
        ddFalg = this.getDdFalg(whStoreSku.getTenantCode(), "NegativeInventoryNum", "NegativeInventoryNum");
        Boolean checkFlag = Boolean.valueOf(ddFalg);
        if (checkFlag.booleanValue()) {
            whStoreSkuNumBean.setGoodsBalance(whStoreSku.getGoodsBalance());
        }
        whStoreSkuNumBean.setGoodsBalance(whStoreSku.getGoodsBalance());
        whStoreSkuNumBean.setWarehouseCode(whStoreSku.getWarehouseCode());
        whStoreSkuNumBean.setMemberCcode(whStoreSku.getMemberCcode());
        whStoreSkuNumBean.setStoreGoodsType(whStoreSku.getStoreGoodsType());
        whStoreSkuNumBean.setStoreWhlocal(whStoreSku.getStoreWhlocal());
        whStoreSkuNumBean.setChannelCode(whStoreSku.getChannelCode());
        whStoreSkuNumBean.setStoreType(whStoreSku.getStoreType());
        whStoreSkuNumBean.setSkuBarcode(whStoreSku.getSkuBarcode());
        whStoreSkuNumBean.setGoodsCode(whStoreSku.getGoodsCode());
        whStoreSkuNumBean.setSkuCode(whStoreSku.getSkuCode());
        whStoreSkuNumBean.setGoodsNo(whStoreSku.getGoodsNo());
        if (null != whStoreSku && StringUtils.isNotBlank((String)whStoreSku.getStoreWhlocal())) {
            whStoreSkuNumBean.setStoreType(whStoreSku.getStoreType());
        }
        whStoreSkuNumBean.setStoreGoodsBtype(whStoreGoodsDomain.getStoreGoodsBtype());
        return this.updateNum(whStoreSkuNumBean);
    }

    public String getDdFalg(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    private WhStoreSku queryStoreSkuMode(Map<String, Object> parammap) {
        try {
            return this.whStoreSkuMapper.queryStoreSkuMode(parammap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.queryStoreSkuMode", (Throwable)e);
            return null;
        }
    }

    private WhStoreGoods queryStoreGoodsModel(Map<String, Object> parammap) {
        try {
            return this.whStoreGoodsMapper.queryStoreGoodsModel(parammap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.queryStoreGoodsModel", (Throwable)e);
            return null;
        }
    }

    private List<WhStoreGoods> queryStoreGoodsListModel(Map<String, Object> parammap) {
        try {
            return this.whStoreGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.queryStoreGoodsListModel", (Throwable)e);
            return null;
        }
    }

    public void updateWhStroreGoodsNum(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            throw new ApiException("wh.WhStoreGoodsService.updateWhStroreGoodsNum.updateWhStroreGoodsNum.null");
        }
        try {
            this.whStoreGoodsMapper.updateStroreGoodsNum(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.updateWhStroreGoodsNum.updateStroreGoodsNum.e" + map.toString(), (Throwable)e);
        }
    }

    public void updateStoreGoodsNum(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            throw new ApiException("wh.WhStoreGoodsService.updateStoreGoodsNum.updateWhStroreGoodsNum.null");
        }
        int i = 0;
        try {
            i = this.whStoreGoodsMapper.updateStoreGoodNum(map);
        }
        catch (Exception e) {
            this.logger.info("wh.WhStoreGoodsService.updateStoreGoodsNum.updateStroreGoodsNum.e", (Object)map.toString(), (Throwable)e);
            throw new ApiException("wh.WhStoreGoodsService.updateStoreGoodsNum.updateStroreGoodsNum.e", map.toString(), (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhStoreGoodsService.updateStoreGoodsNum.updateStroreGoodsNum.i" + map.toString());
        }
    }

    public void deliStoreGoodNum(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            throw new ApiException("wh.WhStoreGoodsServicedeliStoreGoodNum.null");
        }
        try {
            this.whStoreGoodsMapper.deliStoreGoodNum(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsServicedeliStoreGoodNum.e" + map.toString(), (Throwable)e);
        }
    }

    @Override
    public List<WhChannelsend> saveStoreGoodsBatch(List<WhStoreGoodsDomain> whStoreGoodsDomainList) throws ApiException {
        if (ListUtil.isEmpty(whStoreGoodsDomainList)) {
            return null;
        }
        ArrayList<WhChannelsend> whChannelsendList = new ArrayList<WhChannelsend>();
        for (WhStoreGoodsDomain whStoreGoodsDomain : whStoreGoodsDomainList) {
            List<WhChannelsend> chwhChannelsendList = this.saveStoreGoods(whStoreGoodsDomain);
            if (!ListUtil.isNotEmpty(chwhChannelsendList)) continue;
            whChannelsendList.addAll(chwhChannelsendList);
        }
        return whChannelsendList;
    }

    private List<WhChannelsend> saveSend(WhStoreSku whStoreSku, String dir, Integer dataSate, StockDomain stockDomain) {
        if (null == whStoreSku) {
            return null;
        }
        ArrayList<WhChannelsendDomain> atChannelsendDomainList = new ArrayList<WhChannelsendDomain>();
        WhChannelsendDomain atChannelsendDomain = new WhChannelsendDomain();
        atChannelsendDomainList.add(atChannelsendDomain);
        atChannelsendDomain.setChannelsendDir(dir);
        atChannelsendDomain.setChannelsendOpcode(whStoreSku.getStoreSkuCode());
        if (null != stockDomain) {
            atChannelsendDomain.setChannelsendType("stockDomain");
            atChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)stockDomain));
        } else {
            atChannelsendDomain.setChannelsendType("whStoreSku");
            atChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)whStoreSku));
        }
        atChannelsendDomain.setTenantCode(whStoreSku.getTenantCode());
        return this.whChannelsendService.saveChannelsendBatch(atChannelsendDomainList);
    }

    private List<WhChannelsend> saveSkuDomain(List<WhStoreSkuDomain> whStoreSkuDomainList, String opstoreCode) {
        if (ListUtil.isEmpty(whStoreSkuDomainList)) {
            return null;
        }
        ArrayList<WhStoreSku> whStoreSkuList = new ArrayList<WhStoreSku>();
        ArrayList<WhChannelsend> whChannelsendList = new ArrayList<WhChannelsend>();
        for (WhStoreSkuDomain whStoreSkuDomain : whStoreSkuDomainList) {
            WhStoreSku whStoreSku = this.createStoreSkuModel(whStoreSkuDomain);
            if (null == whStoreSku) continue;
            whStoreSkuList.add(whStoreSku);
        }
        this.saveStoreSkuBatchModel(whStoreSkuList);
        for (WhStoreSku whStoreSku2 : whStoreSkuList) {
            List<WhChannelsend> chwhChannelsendList = this.saveSend(whStoreSku2, "add", 0, null);
            if (!ListUtil.isNotEmpty(chwhChannelsendList)) continue;
            whChannelsendList.addAll(chwhChannelsendList);
        }
        return whChannelsendList;
    }

    @Override
    public void updateStoreGoodsState(Integer storeGoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateStoreGoodsModel(storeGoodsId, dataState, oldDataState);
    }

    @Override
    public int updateStoreGoods(WhStoreGoodsDomain whStoreGoodsDomain) throws ApiException {
        String msg = this.checkStoreGoods(whStoreGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhStoreGoodsService.updateStoreGoods.checkStoreGoods", msg);
        }
        WhStoreGoods oldWhStoreGoods = this.getStoreGoodsModelById(whStoreGoodsDomain.getStoreGoodsId());
        if (null == oldWhStoreGoods) {
            throw new ApiException("wh.WhStoreGoodsService.updateStoreGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WhStoreGoods whStoreGoods = this.makeStoreGoods(whStoreGoodsDomain, oldWhStoreGoods);
        this.setStoreGoodsUpdataDefault(whStoreGoods);
        this.updateStoreGoodsModel(whStoreGoods);
        return 0;
    }

    @Override
    public WhStoreGoods getStoreGoods(Integer storeGoodsId) {
        return this.getStoreGoodsModelById(storeGoodsId);
    }

    @Override
    public void deleteStoreGoods(Integer storeGoodsId) throws ApiException {
        this.deleteStoreGoodsModel(storeGoodsId);
    }

    @Override
    public QueryResult<WhStoreGoods> queryStoreGoodsPage(Map<String, Object> map) {
        List<WhStoreGoods> whStoreGoodsList = this.queryStoreGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countStoreGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(whStoreGoodsList);
        return queryResult;
    }

    @Override
    public QueryResult<WhStoreGoods> queryStoreGoodsPages(Map<String, Object> map) {
        List<WhStoreGoods> whStoreGoodsList = this.queryStoreGoodsModelPages(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(whStoreGoodsList);
        return queryResult;
    }

    @Override
    public WhStoreGoods getStoreGoodsByCode(Map<String, Object> map) {
        return this.getStoreGoodsModelByCode(map);
    }

    @Override
    public void delStoreGoodsByCode(Map<String, Object> map) throws ApiException {
        this.delStoreGoodsModelByCode(map);
    }

    @Override
    public String saveStoreSku(WhStoreSkuDomain whStoreSkuDomain) throws ApiException {
        WhStoreSku whStoreSku = this.createStoreSkuModel(whStoreSkuDomain);
        this.saveStoreSkuModel(whStoreSku);
        return whStoreSku.getStoreSkuCode();
    }

    private WhStoreSku createStoreSkuModel(WhStoreSkuDomain whStoreSkuDomain) {
        String msg = this.checkStoreSku(whStoreSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhStoreGoodsService.saveStoreSku.checkStoreSku", msg);
        }
        WhStoreSku whStoreSku = this.makeStoreSku(whStoreSkuDomain, null);
        this.setStoreSkuDefault(whStoreSku);
        return whStoreSku;
    }

    @Override
    public void updateStoreSkuState(Integer storeSkuId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateStoreSkuModel(storeSkuId, dataState, oldDataState);
    }

    @Override
    public void updateStoreSku(WhStoreSkuDomain whStoreSkuDomain) throws ApiException {
        String msg = this.checkStoreSku(whStoreSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhStoreGoodsService.updateStoreSku.checkStoreSku", msg);
        }
        WhStoreSku oldWhStoreSku = this.getStoreSkuModelById(whStoreSkuDomain.getStoreSkuId());
        if (null == oldWhStoreSku && null == (oldWhStoreSku = this.getStoreSkuModelByCode(this.getQueryMapParam("storeSkuCode,tenantCode", new Object[]{whStoreSkuDomain.getStoreSkuCode(), whStoreSkuDomain.getTenantCode()})))) {
            throw new ApiException("wh.WhStoreGoodsService.updateStoreSku.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WhStoreSku whStoreSku = this.makeStoreSku(whStoreSkuDomain, oldWhStoreSku);
        this.setStoreSkuUpdataDefault(whStoreSku);
        this.updateStoreSkuModel(whStoreSku);
    }

    @Override
    public WhStoreSku getStoreSku(Integer storeSkuId) {
        return this.getStoreSkuModelById(storeSkuId);
    }

    @Override
    public void deleteStoreSku(Integer storeSkuId) throws ApiException {
        this.deleteStoreSkuModel(storeSkuId);
    }

    @Override
    public QueryResult<WhStoreSku> queryStoreSkuPage(Map<String, Object> map) {
        List<WhStoreSku> whStoreSkuList = this.queryStoreSkuModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countStoreSku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(whStoreSkuList);
        return queryResult;
    }

    @Override
    public WhStoreSku getStoreSkuByCode(Map<String, Object> map) {
        return this.getStoreSkuModelByCode(map);
    }

    @Override
    public void delStoreSkuByCode(Map<String, Object> map) throws ApiException {
        this.delStoreSkuModelByCode(map);
    }

    @Override
    public void updateStoreSkuStateByCode(Map<String, Object> map) {
        this.updateStateByCode(map);
    }

    private void updateStateByCode(Map<String, Object> map) throws ApiException {
        if (null == map) {
            return;
        }
        int i = 0;
        try {
            i = this.whStoreSkuMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.updateStateStoreGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhStoreGoodsService.updateStateStoreGoodsModel.null");
        }
    }

    @Override
    public void autoSend() {
        this.loadDb();
    }

    private void loadDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("order", true);
            map.put("dataState", 1);
            map.put("orderStr", "GMT_CREATE asc");
            int startRow = 0;
            boolean flag = true;
            QueryResult<WhStoreSku> result = null;
            do {
                startRow = WhStoreGoodsServiceImpl.getSendService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", WhStoreGoodsServiceImpl.getSendService().getPage());
                result = this.queryStoreSkuPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    WhStoreGoodsServiceImpl.getSendService().addPutPool(new SendPutThread(WhStoreGoodsServiceImpl.getSendService(), result.getRows()));
                    if (result.getRows().size() != WhStoreGoodsServiceImpl.getSendService().getPage()) {
                        flag = false;
                    }
                } else {
                    flag = false;
                }
                Thread.sleep(5000L);
            } while (flag);
            WhStoreGoodsServiceImpl.getSendService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.loadDb.an.e", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SendService getSendService() {
        Object object = lock;
        synchronized (object) {
            if (null == sendService) {
                sendService = new SendService((WhStoreGoodsBaseService)SpringApplicationContextUtil.getBean((String)"whStoreGoodsBaseService"));
                for (int i = 0; i < 20; ++i) {
                    sendService.addPollPool(new SendPollThread(sendService));
                }
            }
            return sendService;
        }
    }

    @Override
    public void saveSendChannelsend(WhStoreSku whStoreSku) {
        if (null == whStoreSku) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("storeSkuCode", whStoreSku.getStoreSkuCode());
        map.put("tenantCode", whStoreSku.getTenantCode());
        map.put("dataState", 0);
        map.put("oldDataState", 1);
        this.updateStoreSkuStateByCode(map);
        Map<String, Object> numMap = this.makeNum(whStoreSku);
        if (null == numMap) {
            return;
        }
        numMap.put("skuNo", whStoreSku.getSkuNo());
        numMap.put("tenantCode", whStoreSku.getTenantCode());
        numMap.put("memberCode", whStoreSku.getMemberCcode());
        try {
            this.internalInvoke("rs.resource.sendUpdateSkuNum", numMap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreGoodsService.saveSendChannelsend", numMap);
        }
    }

    private Map<String, List<String>> makeDgnumlist(List<WhDgnumList> whDgnumListList) {
        if (ListUtil.isEmpty(whDgnumListList)) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (WhDgnumList dhDgnumList : whDgnumListList) {
            ArrayList<String> list;
            if (StringUtils.isBlank((String)dhDgnumList.getDgnumListType())) {
                dhDgnumList.setDgnumListTerm("=");
            }
            if (null == (list = (ArrayList<String>)map.get(dhDgnumList.getDgnumListType() + "|" + dhDgnumList.getDgnumListTerm()))) {
                list = new ArrayList<String>();
                map.put(dhDgnumList.getDgnumListType() + "|" + dhDgnumList.getDgnumListTerm(), list);
            }
            list.add(dhDgnumList.getDgnumListValue());
        }
        return map;
    }

    private Map<String, Object> makeNum(List<WhDgnumDomain> whDgnumDomainList, WhStoreSku whStoreSku) {
        if (ListUtil.isEmpty(whDgnumDomainList)) {
            return null;
        }
        for (WhDgnumDomain whDgnumDomain : whDgnumDomainList) {
            Map<String, List<String>> map = this.makeDgnumlist(whDgnumDomain.getWhDgnumListList());
            if (!this.checkConf(map, whStoreSku)) continue;
            return this.buileNum(whDgnumDomain, whStoreSku);
        }
        return null;
    }

    private Map<String, Object> makeNum(WhStoreSku whStoreSku) {
        Map<String, Object> paramMap;
        if (null == whStoreSku) {
            return null;
        }
        List whDgnumDomainList = DisUtil.getMapListJson((String)"WhDgnumList-memberCode", (String)(whStoreSku.getMemberCcode() + "-" + whStoreSku.getTenantCode()), WhDgnumDomain.class);
        boolean flag = false;
        if (ListUtil.isEmpty((Collection)whDgnumDomainList)) {
            flag = true;
            whDgnumDomainList = DisUtil.getMapListJson((String)"WhDgnumList-memberCode", (String)("all-" + whStoreSku.getTenantCode()), WhDgnumDomain.class);
        }
        if (MapUtil.isNotEmpty(paramMap = this.makeNum(whDgnumDomainList, whStoreSku))) {
            return paramMap;
        }
        if (!flag && MapUtil.isNotEmpty(paramMap = this.makeNum(whDgnumDomainList = DisUtil.getMapListJson((String)"WhDgnumList-memberCode", (String)("all-" + whStoreSku.getTenantCode()), WhDgnumDomain.class), whStoreSku))) {
            return paramMap;
        }
        HashMap<String, Object> numMap = new HashMap<String, Object>();
        numMap.put("goodsNum", whStoreSku.getGoodsNum());
        numMap.put("goodsWeight", whStoreSku.getGoodsWeight());
        return numMap;
    }

    private Map<String, Object> buileNum(WhDgnumDomain whDgnumDomain, WhStoreSku whStoreSku) {
        if (null == whDgnumDomain || null == whStoreSku) {
            return null;
        }
        String pro = whDgnumDomain.getDgnumPro();
        BigDecimal rnum = BigDecimal.ZERO;
        BigDecimal rweight = BigDecimal.ZERO;
        if (null == whStoreSku.getGoodsNum()) {
            whStoreSku.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == whStoreSku.getGoodsWeight()) {
            whStoreSku.setGoodsWeight(BigDecimal.ZERO);
        }
        BigDecimal goodsNum = whStoreSku.getGoodsNum();
        BigDecimal goodsWeight = whStoreSku.getGoodsWeight();
        if ("0".equals(pro)) {
            rnum = goodsNum.add(whDgnumDomain.getDgnumPrice());
            rweight = goodsWeight.add(whDgnumDomain.getDgnumPrice());
        } else if ("1".equals(pro)) {
            rnum = whDgnumDomain.getDgnumPrice().divide(new BigDecimal("100"), 5).multiply(goodsNum);
            rweight = whDgnumDomain.getDgnumPrice().divide(new BigDecimal("100"), 5).multiply(goodsWeight);
        } else if ("2".equals(pro)) {
            rnum = whDgnumDomain.getDgnumPrice();
            rweight = whDgnumDomain.getDgnumPrice();
        }
        HashMap<String, Object> numMap = new HashMap<String, Object>();
        numMap.put("goodsNum", rnum);
        numMap.put("goodsWeight", rweight);
        return numMap;
    }

    private boolean cond(List<String> valueList, String term, Object objValue) {
        if (ListUtil.isEmpty(valueList)) {
            return false;
        }
        if (StringUtils.isBlank((String)term)) {
            term = "=";
        }
        boolean flag = true;
        String value = valueList.get(0);
        if ("<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) >= Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if (">".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) <= Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if (">=".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) < Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if ("=<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (Integer.valueOf(value) > Integer.valueOf(objValue.toString())) {
                flag = false;
            }
        } else if ("!=".equals(term)) {
            if (null == objValue) {
                objValue = "";
            }
            if (valueList.contains(objValue.toString())) {
                flag = false;
            }
        } else {
            if (null == objValue) {
                objValue = "";
            }
            if (!valueList.contains(objValue.toString())) {
                flag = false;
            }
        }
        return flag;
    }

    private boolean checkConf(Map<String, List<String>> map, Object obj) {
        if (null == map || map.isEmpty()) {
            return true;
        }
        boolean flag = true;
        String term = "";
        String key = "";
        for (String keys : map.keySet()) {
            String[] keyStr = keys.split("\\|");
            if (null == keyStr || keyStr.length == 0) continue;
            key = keyStr[0];
            if (keyStr.length > 1) {
                term = keyStr[1];
            }
            Object objValue = BeanUtils.newForceGetProperty((Object)obj, (String)key);
            List<String> valueList = map.get(keys);
            if (objValue instanceof String && null != objValue && objValue.toString().indexOf(",") > 0) {
                String[] otrs;
                for (String o : otrs = objValue.toString().split("\\,")) {
                    if (this.cond(valueList, term, o)) break;
                }
                continue;
            }
            if (this.cond(valueList, term, objValue)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    @Override
    public List<WhChannelsend> updateStoreSkuNum(List<WhStoreSkuNumBean> whStoreSkuNumBeanList) throws ApiException {
        if (ListUtil.isEmpty(whStoreSkuNumBeanList)) {
            return null;
        }
        ArrayList<WhChannelsend> whChannelsendList = new ArrayList<WhChannelsend>();
        for (WhStoreSkuNumBean whStoreSkuNumBean : whStoreSkuNumBeanList) {
            List<WhChannelsend> chwhChannelsendList = this.updateNum(whStoreSkuNumBean);
            if (!ListUtil.isNotEmpty(chwhChannelsendList)) continue;
            whChannelsendList.addAll(chwhChannelsendList);
        }
        return whChannelsendList;
    }

    private List<WhChannelsend> updateNum(WhStoreSkuNumBean whStoreSkuNumBean) {
        if (null == whStoreSkuNumBean) {
            return null;
        }
        String opdir = whStoreSkuNumBean.getOpstoreDir();
        if (StringUtils.isBlank((String)opdir)) {
            opdir = "1";
        }
        opdir = "1".equals(opdir) ? "1" : "-1";
        if (null == whStoreSkuNumBean.getGoodsNum()) {
            whStoreSkuNumBean.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == whStoreSkuNumBean.getGoodsWeight()) {
            whStoreSkuNumBean.setGoodsWeight(BigDecimal.ZERO);
        }
        whStoreSkuNumBean.setGoodsEocode(null);
        HashMap<String, Object> storeGoodsMap = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)whStoreSkuNumBean.getStoreGoodsType()) && whStoreSkuNumBean.getStoreGoodsType().equals("6")) {
            storeGoodsMap.put("goodsNum", whStoreSkuNumBean.getGoodsNum().multiply(new BigDecimal(opdir)));
            storeGoodsMap.put("goodsWeight", whStoreSkuNumBean.getGoodsWeight().multiply(new BigDecimal(opdir)));
            whStoreSkuNumBean.setGoodsNum(whStoreSkuNumBean.getGoodsNum().multiply(new BigDecimal(opdir)));
            whStoreSkuNumBean.setGoodsWeight(whStoreSkuNumBean.getGoodsWeight().multiply(new BigDecimal(opdir)));
        } else {
            whStoreSkuNumBean.setGoodsNum(whStoreSkuNumBean.getGoodsNum().multiply(new BigDecimal(opdir)));
            whStoreSkuNumBean.setGoodsWeight(whStoreSkuNumBean.getGoodsWeight().multiply(new BigDecimal(opdir)));
            storeGoodsMap.put("goodsNum", whStoreSkuNumBean.getGoodsNum());
            storeGoodsMap.put("goodsWeight", whStoreSkuNumBean.getGoodsWeight());
        }
        storeGoodsMap.put("goodsNo", whStoreSkuNumBean.getGoodsNo());
        storeGoodsMap.put("memberCcode", whStoreSkuNumBean.getMemberCcode());
        storeGoodsMap.put("tenantCode", whStoreSkuNumBean.getTenantCode());
        storeGoodsMap.put("storeType", whStoreSkuNumBean.getStoreType());
        storeGoodsMap.put("warehouseCode", whStoreSkuNumBean.getWarehouseCode());
        storeGoodsMap.put("goodsCode", whStoreSkuNumBean.getGoodsCode());
        storeGoodsMap.put("storeGoodsType", whStoreSkuNumBean.getStoreGoodsType());
        HashMap<String, Object> lockMap = new HashMap<String, Object>();
        lockMap.put("memberCcode", whStoreSkuNumBean.getMemberCcode());
        lockMap.put("goodsCode", whStoreSkuNumBean.getGoodsCode());
        lockMap.put("goodsNo", whStoreSkuNumBean.getGoodsNo());
        lockMap.put("tenantCode", whStoreSkuNumBean.getTenantCode());
        lockMap.put("storeType", whStoreSkuNumBean.getStoreType());
        lockMap.put("warehouseCode", whStoreSkuNumBean.getWarehouseCode());
        if (!this.lockGoodsData(lockMap)) {
            throw new ApiException("wh.WhStoreGoodsService.updateNum.lockGoodsData.null", ((Object)lockMap).toString());
        }
        HashMap<String, Object> storeSkuMap = new HashMap<String, Object>();
        storeSkuMap.put("tenantCode", whStoreSkuNumBean.getTenantCode());
        storeSkuMap.put("storeType", whStoreSkuNumBean.getStoreType());
        storeSkuMap.put("memberCcode", whStoreSkuNumBean.getMemberCcode());
        storeSkuMap.put("warehouseCode", whStoreSkuNumBean.getWarehouseCode());
        storeSkuMap.put("skuNo", whStoreSkuNumBean.getSkuNo());
        storeSkuMap.put("storeWhlocal", whStoreSkuNumBean.getStoreWhlocal());
        storeSkuMap.put("skuBarcode", whStoreSkuNumBean.getSkuBarcode());
        storeSkuMap.put("storeGoodsType", whStoreSkuNumBean.getStoreGoodsType());
        if (StringUtils.isNotBlank((String)whStoreSkuNumBean.getMemberCode())) {
            whStoreSkuNumBean.setMemberCode(null);
        }
        if (StringUtils.isNotBlank((String)whStoreSkuNumBean.getChannelCode())) {
            whStoreSkuNumBean.setChannelCode(null);
        }
        this.updateStoreGoodsNum(storeGoodsMap);
        this.updateStoreSkuNumModel(whStoreSkuNumBean);
        storeSkuMap.remove("storeGoodsType");
        List<WhStoreSku> qlist = this.queryStoreSkuModelPage(storeSkuMap);
        if (ListUtil.isEmpty(qlist)) {
            throw new ApiException("wh.WhStoreGoodsService.updateNum.qlist.null", ((Object)storeSkuMap).toString());
        }
        WhStoreSku whStoreSku = qlist.get(0);
        whStoreSku.setGoodsPro(whStoreSkuNumBean.getGoodsPro());
        lockMap.put("storeGoodsCode", whStoreSku.getStoreGoodsCode());
        WhStoreGoods whStoreGoods = this.getStoreGoodsModelByCode(lockMap);
        if (null == whStoreGoods) {
            throw new ApiException("wh.WhStoreGoodsService.updateNum.whStoreGoods.null", ((Object)lockMap).toString());
        }
        String type = whStoreGoods.getGoodsProperty2();
        if (StringUtils.isBlank((String)type)) {
            type = "10";
        }
        if (null == whStoreSku.getGoodsNum()) {
            whStoreSku.setGoodsNum(BigDecimal.ZERO);
        }
        if (null == whStoreSku.getGoodsWeight()) {
            whStoreSku.setGoodsWeight(BigDecimal.ZERO);
        }
        if (null == whStoreSku.getGoodsSupplynum()) {
            whStoreSku.setGoodsSupplynum(BigDecimal.ZERO);
        }
        if (null == whStoreSku.getGoodsSupplyweight()) {
            whStoreSku.setGoodsSupplyweight(BigDecimal.ZERO);
        }
        return this.saveSend(whStoreSku, whStoreSkuNumBean.getStoreGoodsBtype(), 1, null);
    }

    private String check(StockDomain stockDomain) {
        if (null == stockDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)stockDomain.getGoodsCode()) && StringUtils.isBlank((String)stockDomain.getGoodsNo())) {
            msg = msg + "goodsCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)stockDomain.getSkuCode()) && StringUtils.isBlank((String)stockDomain.getSkuNo()) && StringUtils.isBlank((String)stockDomain.getSkuBarcode())) {
            msg = msg + "skuCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)stockDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    @Override
    public List<WhChannelsend> updateSkuLockNum(List<StockDomain> stockDomainList) {
        if (ListUtil.isEmpty(stockDomainList)) {
            this.logger.error("wh.WhStoreGoodsService.updateSkuLockNum", (Object)"stockDomainList null");
            return null;
        }
        ArrayList<WhChannelsend> relist = new ArrayList<WhChannelsend>();
        for (StockDomain stockDomain : stockDomainList) {
            List<WhChannelsend> tlist;
            List<Object> glist;
            String msg = this.check(stockDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                throw new ApiException("wh.WhStoreGoodsService.updateSkuSNum.check", msg);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("type", stockDomain.getType());
            map.put("skuCode", stockDomain.getSkuCode());
            map.put("skuNo", stockDomain.getSkuNo());
            map.put("goodsNo", stockDomain.getGoodsNo());
            map.put("warehouseCode", stockDomain.getWarehouseCode());
            map.put("skuBarcode", stockDomain.getSkuBarcode());
            map.put("memberCode", stockDomain.getMemberCode());
            map.put("memberCcode", stockDomain.getMemberCcode());
            map.put("goodsNum", stockDomain.getGoodsNum());
            map.put("goodsWeight", stockDomain.getGoodsWeight());
            map.put("tenantCode", stockDomain.getTenantCode());
            HashMap<String, Object> qmap = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((String)stockDomain.getSkuBarcode())) {
                qmap.put("skuCode", stockDomain.getSkuCode());
                qmap.put("skuNo", stockDomain.getSkuNo());
                qmap.put("goodsNo", stockDomain.getGoodsNo());
                qmap.put("warehouseCode", stockDomain.getWarehouseCode());
                qmap.put("skuBarcode", stockDomain.getSkuBarcode());
                qmap.put("memberCode", stockDomain.getMemberCode());
                qmap.put("memberCcode", stockDomain.getMemberCcode());
                qmap.put("tenantCode", stockDomain.getTenantCode());
                glist = this.queryStoreSkuModelPage(qmap);
                if (ListUtil.isEmpty(glist)) {
                    throw new ApiException("wh.WhStoreGoodsService.updateSkuSNum.glist", ((Object)qmap).toString());
                }
                map.put("goodsCode", ((WhStoreSku)glist.get(0)).getGoodsCode());
                map.put("skuCode", ((WhStoreSku)glist.get(0)).getSkuCode());
                qmap.put("goodsCode", ((WhStoreSku)glist.get(0)).getGoodsCode());
                qmap.put("skuCode", ((WhStoreSku)glist.get(0)).getSkuCode());
            } else {
                qmap.put("skuCode", stockDomain.getSkuCode());
                qmap.put("skuNo", stockDomain.getSkuNo());
                qmap.put("goodsNo", stockDomain.getGoodsNo());
                qmap.put("warehouseCode", stockDomain.getWarehouseCode());
                qmap.put("skuBarcode", stockDomain.getSkuBarcode());
                qmap.put("memberCode", stockDomain.getMemberCode());
                qmap.put("memberCcode", stockDomain.getMemberCcode());
                qmap.put("tenantCode", stockDomain.getTenantCode());
                if (StringUtils.isBlank((String)stockDomain.getGoodsCode())) {
                    glist = this.queryStoreGoodsListModel(qmap);
                    if (ListUtil.isEmpty(glist)) {
                        throw new ApiException("wh.WhStoreGoodsService.updateSkuSNum.check", ((Object)map).toString());
                    }
                    map.put("goodsCode", ((WhStoreGoods)glist.get(0)).getGoodsCode());
                    qmap.put("goodsCode", ((WhStoreGoods)glist.get(0)).getGoodsCode());
                }
            }
            this.lockGoodsData(qmap);
            this.logger.error("wh.WhStoreGoodsService.updateSkuLockNum.lock", (Object)((Object)qmap).toString());
            this.updateGoodsStockModel(map);
            this.updateSkuStockModel(map);
            WhStoreSku whStoreSku = null;
            List<WhStoreSku> whStoreSkus = this.queryStoreSkuModelPage(qmap);
            if (ListUtil.isNotEmpty(whStoreSkus)) {
                whStoreSku = whStoreSkus.get(0);
            }
            if (!ListUtil.isNotEmpty(tlist = this.saveSend(whStoreSku, "edit", 0, stockDomain))) continue;
            relist.addAll(tlist);
        }
        return relist;
    }

    @Override
    public Map<String, Object> querySumStoreSku(Map<String, Object> map) {
        return this.querySumStoreSkuMode(map);
    }

    @Override
    public QueryResult<WhStoreSku> queryNumBySup(Map<String, Object> map) {
        this.logger.error("wh.WhStoreGoodsServicequeryNumBySup", (Object)map.toString());
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        List<WhStoreSku> whStoreList = this.whStoreSkuMapper.queryNumBySup(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countStoreSku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(whStoreList);
        return queryResult;
    }

    @Override
    public void saveOrUpdateStoreGoodsBatch(List<WhStoreGoodsDomain> whStoreGoodsDomainList) throws ApiException {
        if (ListUtil.isEmpty(whStoreGoodsDomainList)) {
            this.logger.error("wh.WhStoreGoodsService.saveOrUpdateStoreGoodsBatch", (Object)"whStoreGoodsDomainList is null");
            return;
        }
        for (WhStoreGoodsDomain whStoreGoodsDomain : whStoreGoodsDomainList) {
            if (whStoreGoodsDomain.getStoreGoodsId() == null) {
                this.saveStoreGoods(whStoreGoodsDomain);
                continue;
            }
            this.updateStoreGoods(whStoreGoodsDomain);
        }
    }

    @Override
    public String saveGoodsToStoreGoods(WhStoreGoodsDomain whStoreGoodsDomain) throws ApiException {
        if (null == whStoreGoodsDomain) {
            this.logger.error("wh.WhStoreGoodsService.saveGoodsToStoreGoods.param", (Object)"whStoreGoodsDomain is null");
            return null;
        }
        List<WhStoreSkuDomain> whStoreSkuDomainList = whStoreGoodsDomain.getWhStoreSkuDomainList();
        if (ListUtil.isEmpty(whStoreSkuDomainList)) {
            this.logger.error("wh.WhStoreGoodsService.saveGoodsToStoreGoods.param", (Object)"whStoreSkuDomainList is null");
            return null;
        }
        WhStoreSku whStoreSku = this.createStoreSkuModel(whStoreSkuDomainList.get(0));
        WhStoreGoods whStoreGoods = this.makeStoreGoods(whStoreGoodsDomain, null);
        this.setStoreGoodsDefault(whStoreGoods);
        this.saveStoreGoodsModel(whStoreGoods);
        this.saveStoreSkuModel(whStoreSku);
        return whStoreGoods.getStoreGoodsCode();
    }

    @Override
    public String updateStoreNumToERP(WhStoreSkuDomain whStoreSkuDomain) throws ApiException {
        if (StringUtils.isBlank((String)whStoreSkuDomain.getSkuNo()) || StringUtils.isBlank((String)whStoreSkuDomain.getWarehouseCode()) || StringUtils.isBlank((String)String.valueOf(whStoreSkuDomain.getGoodsSnum()))) {
            this.logger.error("wh.WhStoreGoodsService.updateStoreNumToERP", (Object)"userwhList is null");
            return "\u4e0b\u5355bom\u6216\u4ed3\u5e93code\u4e3a\u7a7a";
        }
        whStoreSkuDomain.setTenantCode("2020050600004084");
        WhStoreSku whStoreSku = this.makeStoreSku(whStoreSkuDomain, null);
        if (null == whStoreSku) {
            return "\u6570\u636e\u4e3a\u7a7a";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", "2020050600004084");
        map.put("warehouseCode", whStoreSku.getWarehouseCode());
        map.put("skuNo", whStoreSku.getSkuNo());
        map.put("memberCode", "20000210312305");
        QueryResult<WhStoreSku> whStoreSkuQueryResult = this.queryStoreSkuPage(map);
        if (null == whStoreSkuQueryResult || ListUtil.isEmpty((Collection)whStoreSkuQueryResult.getList())) {
            this.logger.error("wh.WhStoreGoodsService.updateStoreNumToERP", (Object)"whStoreSkuQueryResult is null");
            return "\u4ed3\u5e93\u65e0\u6b64\u5546\u54c1,\u65e0\u6cd5\u66f4\u65b0\u5e93\u5b58";
        }
        WhStoreSku StoreSku = (WhStoreSku)whStoreSkuQueryResult.getList().get(0);
        map.remove("skuNo");
        map.put("skuCode", whStoreSku.getSkuCode());
        map.put("goodsCode", whStoreSku.getGoodsCode());
        QueryResult<WhStoreGoods> whStoreGoodsQueryResult = this.queryStoreGoodsPage(map);
        if (null == whStoreGoodsQueryResult || ListUtil.isEmpty((Collection)whStoreGoodsQueryResult.getList())) {
            this.logger.error("wh.WhStoreGoodsService.updateStoreNumToERP", (Object)"whStoreGoodsQueryResult is null");
            return "\u4ed3\u5e93\u65e0\u6b64\u5546\u54c1,\u65e0\u6cd5\u66f4\u65b0\u5e93\u5b58";
        }
        if (StoreSku.getGoodsNum().equals(whStoreSku.getGoodsNum())) {
            return "\u5546\u54c1\u5e93\u5b58\u548c\u66f4\u65b0\u5e93\u5b58\u4e00\u6837,\u65e0\u987b\u66f4\u65b0";
        }
        map.put("goodsNum", whStoreSku.getGoodsNum());
        this.updateStoreGoodsNum(map);
        if (StoreSku.getGoodsSupplynum() == null) {
            StoreSku.setGoodsSupplynum(BigDecimal.ZERO);
        }
        BigDecimal goodsSupplynum = whStoreSku.getGoodsNum().subtract(StoreSku.getGoodsSnum());
        WhStoreSkuNumBean whStoreSkuNumBean = new WhStoreSkuNumBean();
        whStoreSkuNumBean.setWarehouseCode(StoreSku.getWarehouseCode());
        whStoreSkuNumBean.setTenantCode(StoreSku.getTenantCode());
        whStoreSkuNumBean.setGoodsNum(whStoreSku.getGoodsNum());
        whStoreSkuNumBean.setGoodsSupplynum(goodsSupplynum);
        whStoreSkuNumBean.setMemberCode(StoreSku.getMemberCode());
        whStoreSkuNumBean.setGoodsCode(StoreSku.getGoodsCode());
        whStoreSkuNumBean.setSkuCode(StoreSku.getSkuCode());
        this.updateStoreSkuNumModel(whStoreSkuNumBean);
        return this.makeSkuNumToERP(StoreSku, whStoreSkuDomain);
    }

    @Override
    public List<WhChannelsend> updateSkuNum(Map<String, Object> map) {
        List<WhChannelsend> tlist;
        List<WhStoreSku> skuList;
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        String warehouseCode = "";
        if (map.containsKey("depart")) {
            HashMap<String, Object> queryUserwhMap = new HashMap<String, Object>();
            queryUserwhMap.put("userwhUprovalue", String.valueOf(map.get("depart")));
            queryUserwhMap.put("tenantCode", String.valueOf(map.get("tenantCode")));
            QueryResult<WhUserwh> queryResult = this.whUserwhService.queryUserwhPage(queryUserwhMap);
            if (null != queryResult && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
                warehouseCode = ((WhUserwh)queryResult.getList().get(0)).getWarehouseCode();
            }
        }
        if (StringUtils.isNotBlank((String)warehouseCode)) {
            map.put("warehouseCode", warehouseCode);
        }
        if (ListUtil.isEmpty(skuList = this.queryStoreSkuModelPage(map))) {
            this.logger.error("wh.WhStoreGoodsService.skuList.null", (Object)map.toString());
            return null;
        }
        ArrayList<WhChannelsend> relist = new ArrayList<WhChannelsend>();
        WhStoreSku whStoreSku = skuList.get(0);
        if (StringUtils.isEmpty((String)whStoreSku.getMemberBcode()) && map.containsKey("depart")) {
            whStoreSku.setMemberBcode(String.valueOf(map.get("depart")));
        }
        if (ListUtil.isNotEmpty(tlist = this.saveSend(whStoreSku, "edit", 0, null))) {
            relist.addAll(tlist);
        }
        return relist;
    }

    @Override
    public String updateStockByContract(OcContractDomain ocContractDomain) {
        if (ocContractDomain == null || ListUtil.isEmpty(ocContractDomain.getGoodsList())) {
            return "success";
        }
        ArrayList<OcContractGoodsDomain> goodsDomains = new ArrayList<OcContractGoodsDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getGoodsList()) {
            if ("2".equals(ocContractGoodsDomain.getGoodsPro())) continue;
            goodsDomains.add(ocContractGoodsDomain);
        }
        if (ListUtil.isEmpty(goodsDomains)) {
            return "success";
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (OcContractGoodsDomain goodsDomain : goodsDomains) {
            paramMap.put("warehouseCode", goodsDomain.getWarehouseCode());
            paramMap.put("spuCode", goodsDomain.getSpuCode());
            paramMap.put("goodsNum", goodsDomain.getGoodsNum());
            paramMap.put("type", "5");
            this.updateSkuStockModel(paramMap);
        }
        return "success";
    }

    @Override
    public void sendUpdateStoreSku(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        Object sgSendgoodsDomainObj = map.get("sgSendgoodsDomain");
        if (sgSendgoodsDomainObj == null) {
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        JSONObject jsonObject = JSONObject.json2object((String)sgSendgoodsDomainObj.toString());
        String sgSendgoodsGoodsDomainListStr = JsonUtil.buildNormalBinder().toJson(jsonObject.get((Object)"sgSendgoodsGoodsDomainList"));
        JSONArray jsonArray = JSONArray.json2array((String)sgSendgoodsGoodsDomainListStr);
        for (JSONObject object : jsonArray) {
            if ("2".equals(object.getString("goodsPro"))) continue;
            paramMap.put("warehouseCode", object.getString("warehouseCode"));
            paramMap.put("spuCode", object.getString("spuCode"));
            paramMap.put("goodsNum", object.getString("goodsNum"));
            paramMap.put("type", "6");
            this.updateSkuStockModel(map);
        }
    }

    public String makeSkuNumToERP(WhStoreSku StoreSku, WhStoreSkuDomain whStoreSkuDomain) {
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("skuNo", whStoreSkuDomain.getSkuNo());
        sendMap.put("tenantCode", StoreSku.getTenantCode());
        HashMap<String, Object> invokeQueryMap = new HashMap<String, Object>();
        invokeQueryMap.put("map", JsonUtil.buildNonNullBinder().toJson(sendMap));
        String skuList = this.internalInvoke("rs.sku.querySkuPage", invokeQueryMap);
        List rsSkuList = new ArrayList();
        if (StringUtils.isNotBlank((String)skuList)) {
            SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(skuList, SupQueryResult.class);
            rsSkuList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), RsSkuDomain.class);
            if (ListUtil.isEmpty(rsSkuList)) {
                this.logger.error("wh.WhStoreGoodsService.makeSkuNum", (Object)"rsSkuList is null");
                return "\u6e20\u9053\u65e0\u6b64\u5546\u54c1";
            }
        }
        sendMap.clear();
        invokeQueryMap.clear();
        sendMap.put("warehouseCode", whStoreSkuDomain.getWarehouseCode());
        sendMap.put("tenantCode", StoreSku.getTenantCode());
        invokeQueryMap.put("map", JsonUtil.buildNonNullBinder().toJson(sendMap));
        String wareList = this.internalInvoke("wh.WhUserwh.queryUserwhPage", invokeQueryMap);
        if (StringUtils.isBlank((String)wareList)) {
            this.logger.error("wh.WhStoreGoodsService.makeSkuNum", (Object)"userwhList is null");
            return "\u65e0\u6b64\u4ed3\u5e93";
        }
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(wareList, SupQueryResult.class);
        List userwhList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), WhUserwh.class);
        if (ListUtil.isEmpty((Collection)userwhList)) {
            this.logger.error("wh.WhStoreGoodsService.makeSkuNum", (Object)"userwhList is null");
            return "\u65e0\u6b64\u4ed3\u5e93";
        }
        ArrayList<RsSkuDomain> list = new ArrayList<RsSkuDomain>();
        ArrayList<Integer> idList = new ArrayList<Integer>();
        block0: for (WhUserwh userwh : userwhList) {
            for (RsSkuDomain skuDomain : rsSkuList) {
                if (!StringUtils.isNotBlank((String)skuDomain.getChannelCode()) || !skuDomain.getChannelCode().equals(userwh.getChannelCode())) continue;
                skuDomain.setGoodsSupplynum(whStoreSkuDomain.getGoodsSupplynum());
                skuDomain.setGoodsNum(whStoreSkuDomain.getGoodsNum());
                list.add(skuDomain);
                idList.add(skuDomain.getSkuId());
                continue block0;
            }
        }
        HashMap<String, String> paramList = new HashMap<String, String>();
        paramList.put("skuList", JsonUtil.buildNonDefaultBinder().toJson(list));
        this.internalInvoke("rs.sku.updateSkuList", paramList);
        ArrayList<Integer> idShelList = new ArrayList<Integer>();
        for (RsSkuDomain skuDomain : list) {
            if (!"1".equals(String.valueOf(skuDomain.getDataOpbillstate()))) continue;
            idShelList.add(skuDomain.getSkuId());
        }
        invokeQueryMap.clear();
        invokeQueryMap.put("skuIdList", idShelList);
        this.internalInvoke("rs.resource.sendUpdateSoldOutBatchSku", invokeQueryMap);
        invokeQueryMap.clear();
        invokeQueryMap.put("skuIdList", idList);
        this.internalInvoke("rs.resource.sendUpdateShelveBatchSku", invokeQueryMap);
        return "success";
    }

    @Override
    public List<String> queryNoByBarcode(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            this.logger.error("wh.WhStoreGoodsService.queryNoByBarcode.", (Object)"map is null");
            return null;
        }
        return this.whStoreSkuMapper.queryNoByBarcode(map);
    }

    @Override
    public void deliveryStoreGoodsSkusStr(WhStoreGoodsDomain whStoreGoodsDomain) throws ApiException {
        if (null == whStoreGoodsDomain) {
            this.logger.error("wh.WhStoreGoodsService.deliveryStoreGoodsSkusStr", (Object)"whStoreGoodsDomain is null");
            return;
        }
        List<WhStoreSkuDomain> whStoreSkuDomainList = whStoreGoodsDomain.getWhStoreSkuDomainList();
        if (ListUtil.isEmpty(whStoreSkuDomainList)) {
            this.logger.error("wh.WhStoreGoodsService.deliveryStoreGoodsSkusStr", (Object)"whStoreSkuDomainList is null");
            return;
        }
        HashMap<String, Object> storeGoodsMap = new HashMap<String, Object>();
        storeGoodsMap.put("tenantCode", whStoreGoodsDomain.getTenantCode());
        storeGoodsMap.put("goodsNo", whStoreGoodsDomain.getGoodsNo());
        storeGoodsMap.put("warehouseCode", whStoreGoodsDomain.getWarehouseCode());
        List<WhStoreGoods> whStoreGoodsList = this.queryStoreGoodsModelPage(storeGoodsMap);
        if (ListUtil.isEmpty(whStoreGoodsList)) {
            this.logger.error("wh.WhStoreGoodsService.deliveryStoreGoodsSkusStr", (Object)"whStoreGoodsList is null");
            return;
        }
        WhStoreGoods whStoreGoods = whStoreGoodsList.get(0);
        if ("15".equals(whStoreGoodsDomain.getGoodsSpec())) {
            if ("".equals(whStoreGoods.getGoodsSnum()) || null == whStoreGoods.getGoodsSnum()) {
                this.logger.error("wh.WhStoreGoodsService.deliveryStoreGoodsSkusStr", (Object)"whStoreGoodsList is null");
                return;
            }
            BigDecimal bigNum = whStoreGoods.getGoodsSnum().subtract(whStoreGoodsDomain.getGoodsNum());
            int num = bigNum.compareTo(BigDecimal.ZERO);
            if (num < 0) {
                this.logger.error("wh.WhStoreGoodsService.deliveryStoreGoodsSkusStr.skuNo-warehouseCode", (Object)"num<0");
                return;
            }
            storeGoodsMap.put("goodsSnum", bigNum);
            storeGoodsMap.put("type", "15");
            this.deliStoreGoodNum(storeGoodsMap);
        } else if ("16".equals(whStoreGoodsDomain.getGoodsSpec())) {
            if ("".equals(whStoreGoods.getGoodsSnum()) || null == whStoreGoods.getGoodsSnum()) {
                whStoreGoods.setGoodsSnum(new BigDecimal("0"));
            }
            BigDecimal bigNum = whStoreGoods.getGoodsSnum().add(whStoreGoodsDomain.getGoodsNum());
            storeGoodsMap.put("goodsSnum", bigNum);
            storeGoodsMap.put("type", "15");
            this.deliStoreGoodNum(storeGoodsMap);
        } else {
            BigDecimal bigNum = whStoreGoods.getGoodsNum().subtract(whStoreGoodsDomain.getGoodsNum());
            storeGoodsMap.put("goodsNum", bigNum);
            int num = bigNum.compareTo(BigDecimal.ZERO);
            if (num < 0) {
                this.logger.error("wh.WhStoreGoodsService.deliveryStoreGoodsSkusStr.skuNo-warehouseCode", (Object)"num<0");
                return;
            }
            this.updateStoreGoodsNum(storeGoodsMap);
        }
        this.deliveryStoreGoodsNums(whStoreGoodsDomain, whStoreSkuDomainList);
    }

    private void makeStoreGoodsNums(WhStoreGoodsDomain whStoreGoodsDomain, List<WhStoreSkuDomain> whStoreSkuDomainList) {
        for (WhStoreSkuDomain whStoreSkuDomain : whStoreSkuDomainList) {
            WhStoreSku whStoreSku = this.createStoreSkuModel(whStoreSkuDomain);
            if (null == whStoreGoodsDomain) {
                this.logger.error("wh.WhStoreGoodsService.saveStoreGoodsStr1");
                whStoreSku.setGoodsSupplynum(whStoreSku.getGoodsNum());
                this.saveStoreSkuModel(whStoreSku);
                continue;
            }
            this.logger.error("wh.WhStoreGoodsService.saveStoreGoodsStr2");
            this.updateStoreNumByStoreSku(whStoreSku, whStoreGoodsDomain);
        }
    }

    private void updateStoreNumByStoreSku(WhStoreSku whStoreSku, WhStoreGoodsDomain whStoreGoodsDomain) {
        if (null == whStoreSku || null == whStoreGoodsDomain) {
            this.logger.error("wh.WhStoreGoodsService.updateStoreNumByStoreSku", (Object)"whStoreSku or whStoreGoodsDomain is null");
            return;
        }
        HashMap<String, Object> storeSkuMap = new HashMap<String, Object>();
        storeSkuMap.put("tenantCode", whStoreSku.getTenantCode());
        storeSkuMap.put("skuNo", whStoreSku.getSkuNo());
        storeSkuMap.put("warehouseCode", whStoreSku.getWarehouseCode());
        this.logger.error("wh.WhStoreGoodsService.skuNo-warehouseCode", (Object)(whStoreSku.getSkuNo() + "-" + whStoreGoodsDomain.getWarehouseCode()));
        List<WhStoreSku> oldStoreSkuList = this.queryStoreSkuModelPage(storeSkuMap);
        if (ListUtil.isEmpty(oldStoreSkuList)) {
            this.logger.error("wh.WhStoreGoodsServiceupdateStoreNumByStoreSku", (Object)"oldStoreSkuList is null");
            this.saveStoreSkuModel(whStoreSku);
            return;
        }
        WhStoreSku oldStoreSku = oldStoreSkuList.get(0);
        WhStoreSkuNumBean whStoreSkuNumBean = new WhStoreSkuNumBean();
        oldStoreSku.setGoodsNum(oldStoreSku.getGoodsNum().add(whStoreSku.getGoodsNum()));
        whStoreSkuNumBean.setGoodsNum(oldStoreSku.getGoodsNum());
        whStoreSkuNumBean.setWarehouseCode(oldStoreSku.getWarehouseCode());
        whStoreSkuNumBean.setSkuNo(oldStoreSku.getSkuNo());
        whStoreSkuNumBean.setTenantCode(oldStoreSku.getTenantCode());
        this.updateStoreSkuNumModel(whStoreSkuNumBean);
    }

    @Override
    public void saveStoreGoodsSkusStr(WhStoreGoodsDomain whStoreGoodsDomain) throws ApiException {
        if (null == whStoreGoodsDomain) {
            this.logger.error("wh.WhStoreGoodsService.saveStoreGoodsSkusStr", (Object)"whStoreGoodsDomain is null");
            return;
        }
        List<WhStoreSkuDomain> whStoreSkuDomainList = whStoreGoodsDomain.getWhStoreSkuDomainList();
        if (ListUtil.isEmpty(whStoreSkuDomainList)) {
            this.logger.error("wh.WhStoreGoodsService.saveStoreGoodsSkusStr", (Object)"whStoreSkuDomainList is null");
            return;
        }
        HashMap<String, Object> storeGoodsMap = new HashMap<String, Object>();
        storeGoodsMap.put("tenantCode", whStoreGoodsDomain.getTenantCode());
        storeGoodsMap.put("goodsNo", whStoreGoodsDomain.getGoodsNo());
        storeGoodsMap.put("warehouseCode", whStoreGoodsDomain.getWarehouseCode());
        storeGoodsMap.put("storeGoodsType", whStoreGoodsDomain.getStoreGoodsType());
        List<WhStoreGoods> whStoreGoodsList = this.queryStoreGoodsModelPage(storeGoodsMap);
        if (ListUtil.isEmpty(whStoreGoodsList)) {
            WhStoreGoods whStoreGoods = this.makeStoreGoods(whStoreGoodsDomain, null);
            this.setStoreGoodsDefault(whStoreGoods);
            whStoreGoods.setGoodsSupplynum(whStoreGoods.getGoodsNum());
            this.saveStoreGoodsModel(whStoreGoods);
            this.makeStoreGoodsNums(null, whStoreSkuDomainList);
        } else {
            WhStoreGoods whStoreGoods = whStoreGoodsList.get(0);
            BigDecimal bigNum = whStoreGoods.getGoodsNum().add(whStoreGoodsDomain.getGoodsNum());
            storeGoodsMap.put("goodsNum", bigNum);
            this.updateStoreGoodsNum(storeGoodsMap);
            this.makeStoreGoodsNums(whStoreGoodsDomain, whStoreSkuDomainList);
        }
    }

    private void deliveryStoreGoodsNums(WhStoreGoodsDomain whStoreGoodsDomain, List<WhStoreSkuDomain> whStoreSkuDomainList) {
        for (WhStoreSkuDomain whStoreSkuDomain : whStoreSkuDomainList) {
            HashMap<String, Object> map;
            int num;
            WhStoreSku whStoreSku = this.createStoreSkuModel(whStoreSkuDomain);
            this.logger.error("wh.WhStoreGoodsService.deliveryStoreGoodsSkusStr2");
            if (null == whStoreSku || null == whStoreGoodsDomain) {
                this.logger.error("wh.WhStoreGoodsService.deliveryStoreGoodsNums", (Object)"whStoreSku or whStoreGoodsDomain is null");
                return;
            }
            HashMap<String, Object> storeSkuMap = new HashMap<String, Object>();
            storeSkuMap.put("tenantCode", whStoreSku.getTenantCode());
            storeSkuMap.put("skuNo", whStoreSku.getSkuNo());
            storeSkuMap.put("warehouseCode", whStoreSku.getWarehouseCode());
            this.logger.error("wh.WhStoreGoodsService.deliveryStoreGoodsSkusStr.skuNo-warehouseCode", (Object)(whStoreSku.getSkuNo() + "-" + whStoreGoodsDomain.getWarehouseCode()));
            List<WhStoreSku> oldStoreSkuList = this.queryStoreSkuModelPage(storeSkuMap);
            if (ListUtil.isEmpty(oldStoreSkuList)) {
                throw new ApiException("wh.WhStoreGoodsService.deliveryStoreGoodsNums.map.null", "\u4ed3\u5e93\u5546\u54c1\u6570\u636e\u9519\u8bef");
            }
            WhStoreSku oldStoreSku = oldStoreSkuList.get(0);
            WhStoreSkuNumBean whStoreSkuNumBean = new WhStoreSkuNumBean();
            BigDecimal bigDecimalNum = null;
            if ("15".equals(whStoreGoodsDomain.getGoodsSpec())) {
                if ("".equals(oldStoreSku.getGoodsSnum()) || null == oldStoreSku.getGoodsSnum()) {
                    oldStoreSku.setGoodsSnum(new BigDecimal("0"));
                }
                if ((num = (bigDecimalNum = oldStoreSku.getGoodsSnum().subtract(whStoreSku.getGoodsNum())).compareTo(BigDecimal.ZERO)) < 0) {
                    this.logger.error("wh.WhStoreGoodsService.deliveryStoreGoodsSkusStr.skuNo-warehouseCode", (Object)(whStoreSku.getSkuNo() + "-" + whStoreGoodsDomain.getWarehouseCode()));
                    return;
                }
                oldStoreSku.setGoodsSnum(bigDecimalNum);
                map = new HashMap<String, Object>();
                map.put("goodsSnum", oldStoreSku.getGoodsSnum());
                map.put("warehouseCode", oldStoreSku.getWarehouseCode());
                map.put("skuNo", oldStoreSku.getSkuNo());
                map.put("tenantCode", oldStoreSku.getTenantCode());
                map.put("type", whStoreGoodsDomain.getGoodsSpec());
                this.updateSkuStockModel(map);
                continue;
            }
            if ("16".equals(whStoreGoodsDomain.getGoodsSpec())) {
                if ("".equals(oldStoreSku.getGoodsSnum()) || null == oldStoreSku.getGoodsSnum()) {
                    oldStoreSku.setGoodsSnum(new BigDecimal("0"));
                }
                if ((num = (bigDecimalNum = oldStoreSku.getGoodsSnum().add(whStoreSku.getGoodsNum())).compareTo(BigDecimal.ZERO)) < 0) {
                    this.logger.error("wh.WhStoreGoodsService.deliveryStoreGoodsSkusStr.skuNo-warehouseCode", (Object)(whStoreSku.getSkuNo() + "-" + whStoreGoodsDomain.getWarehouseCode()));
                    return;
                }
                oldStoreSku.setGoodsSnum(bigDecimalNum);
                map = new HashMap();
                map.put("goodsSnum", oldStoreSku.getGoodsSnum());
                map.put("warehouseCode", oldStoreSku.getWarehouseCode());
                map.put("skuNo", oldStoreSku.getSkuNo());
                map.put("tenantCode", oldStoreSku.getTenantCode());
                map.put("type", "15");
                this.updateSkuStockModel(map);
                continue;
            }
            bigDecimalNum = oldStoreSku.getGoodsNum().subtract(whStoreSku.getGoodsNum());
            num = bigDecimalNum.compareTo(BigDecimal.ZERO);
            if (num < 0) {
                this.logger.error("wh.WhStoreGoodsService.deliveryStoreGoodsSkusStr.skuNo-warehouseCode", (Object)(whStoreSku.getSkuNo() + "-" + whStoreGoodsDomain.getWarehouseCode()));
                return;
            }
            oldStoreSku.setGoodsNum(bigDecimalNum);
            whStoreSkuNumBean.setGoodsNum(oldStoreSku.getGoodsNum());
            whStoreSkuNumBean.setWarehouseCode(oldStoreSku.getWarehouseCode());
            whStoreSkuNumBean.setSkuNo(oldStoreSku.getSkuNo());
            whStoreSkuNumBean.setTenantCode(oldStoreSku.getTenantCode());
            this.updateStoreSkuNumModel(whStoreSkuNumBean);
        }
    }

    @Override
    public void modifyStoreSkuSnum(String tenantCode, String storeSkuCode, BigDecimal goodsSnum) throws ApiException {
        if (null == tenantCode || null == storeSkuCode || null == goodsSnum) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeSkuCode", storeSkuCode);
        map.put("goodsSnum", goodsSnum);
        int i = 0;
        try {
            i = this.whStoreSkuMapper.modifyStoreSkuSnum(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.modifyStoreSkuSnum.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhStoreGoodsService.modifyStoreSkuSnum.null");
        }
    }

    @Override
    public void modifyStoreSkuNum(String tenantCode, String storeSkuCode, BigDecimal goodsNum) throws ApiException {
        if (null == tenantCode || null == storeSkuCode || null == goodsNum) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeSkuCode", storeSkuCode);
        map.put("goodsNum", goodsNum);
        int i = 0;
        try {
            i = this.whStoreSkuMapper.modifyStoreSkuNum(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreGoodsService.modifyStoreSkuNum.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhStoreGoodsService.modifyStoreSkuNum.null");
        }
    }

    static {
        lock = new Object();
    }
}

