/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.warehouse.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.warehouse.dao.WhOpstoreGoodsMapper;
import com.yqbsoft.laser.service.warehouse.dao.WhOpstoreMapper;
import com.yqbsoft.laser.service.warehouse.dao.WhOpstoreSkuMapper;
import com.yqbsoft.laser.service.warehouse.dao.WhWarehouseMapper;
import com.yqbsoft.laser.service.warehouse.domain.ResourceStockDomain;
import com.yqbsoft.laser.service.warehouse.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.warehouse.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.warehouse.domain.RsSkuDomain;
import com.yqbsoft.laser.service.warehouse.domain.StockDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhChannelsendDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhOpstoreDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhOpstoreGoodsDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhOpstoreGoodsReDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhOpstoreReDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhOpstoreSkuDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhOpstoreSkuReDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhStoreGoodsDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhStoreSkuDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhStoreSkuNumBean;
import com.yqbsoft.laser.service.warehouse.enums.StoreGoodsBtypeEnum;
import com.yqbsoft.laser.service.warehouse.model.RsSku;
import com.yqbsoft.laser.service.warehouse.model.WhChannelsend;
import com.yqbsoft.laser.service.warehouse.model.WhOpstore;
import com.yqbsoft.laser.service.warehouse.model.WhOpstoreGoods;
import com.yqbsoft.laser.service.warehouse.model.WhOpstoreSku;
import com.yqbsoft.laser.service.warehouse.model.WhUserwh;
import com.yqbsoft.laser.service.warehouse.model.WhWarehouse;
import com.yqbsoft.laser.service.warehouse.service.WhChannelsendService;
import com.yqbsoft.laser.service.warehouse.service.WhOpstoreService;
import com.yqbsoft.laser.service.warehouse.service.WhStoreGoodsBaseService;
import com.yqbsoft.laser.service.warehouse.service.WhStoreGoodsService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.util.CollectionUtils;

public class WhOpstoreServiceImpl
extends BaseServiceImpl
implements WhOpstoreService {
    private static final String SYS_CODE = "wh.WhOpstoreServiceImpl";
    private WhOpstoreMapper whOpstoreMapper;
    private WhOpstoreGoodsMapper whOpstoreGoodsMapper;
    private WhOpstoreSkuMapper whOpstoreSkuMapper;
    private WhStoreGoodsService whStoreGoodsService;
    private WhChannelsendService whChannelsendService;
    private WhWarehouseMapper whWarehouseMapper;
    private WhStoreGoodsBaseService whStoreGoodsBaseService;

    public WhStoreGoodsBaseService getWhStoreGoodsBaseService() {
        return this.whStoreGoodsBaseService;
    }

    public void setWhStoreGoodsBaseService(WhStoreGoodsBaseService whStoreGoodsBaseService) {
        this.whStoreGoodsBaseService = whStoreGoodsBaseService;
    }

    public WhWarehouseMapper getWhWarehouseMapper() {
        return this.whWarehouseMapper;
    }

    public void setWhWarehouseMapper(WhWarehouseMapper whWarehouseMapper) {
        this.whWarehouseMapper = whWarehouseMapper;
    }

    public WhChannelsendService getWhChannelsendService() {
        return this.whChannelsendService;
    }

    public void setWhChannelsendService(WhChannelsendService whChannelsendService) {
        this.whChannelsendService = whChannelsendService;
    }

    public WhStoreGoodsService getWhStoreGoodsService() {
        return this.whStoreGoodsService;
    }

    public void setWhStoreGoodsService(WhStoreGoodsService whStoreGoodsService) {
        this.whStoreGoodsService = whStoreGoodsService;
    }

    public void setWhOpstoreMapper(WhOpstoreMapper whOpstoreMapper) {
        this.whOpstoreMapper = whOpstoreMapper;
    }

    public void setWhOpstoreGoodsMapper(WhOpstoreGoodsMapper whOpstoreGoodsMapper) {
        this.whOpstoreGoodsMapper = whOpstoreGoodsMapper;
    }

    public void setWhOpstoreSkuMapper(WhOpstoreSkuMapper whOpstoreSkuMapper) {
        this.whOpstoreSkuMapper = whOpstoreSkuMapper;
    }

    private Date getSysDate() {
        try {
            return new Date();
        }
        catch (Exception e) {
            this.logger.error("wh.WhOpstoreServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOpstore(WhOpstoreDomain whOpstoreDomain) {
        if (null == whOpstoreDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)whOpstoreDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOpstoreDefault(WhOpstore whOpstore) {
        if (null == whOpstore) {
            return;
        }
        if (null == whOpstore.getDataState()) {
            whOpstore.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == whOpstore.getGmtCreate()) {
            whOpstore.setGmtCreate(date);
        }
        whOpstore.setGmtModified(date);
        if (StringUtils.isBlank((String)whOpstore.getOpstoreCode())) {
            String type = "";
            StoreGoodsBtypeEnum storeGoodsBtypeEnum = StoreGoodsBtypeEnum.getByCode(whOpstore.getStoreGoodsBtype());
            if (storeGoodsBtypeEnum != null) {
                type = storeGoodsBtypeEnum.getType();
            }
            whOpstore.setOpstoreCode(this.getNo(null, "WhOpstore", "whOpstore" + type, whOpstore.getTenantCode()));
        }
        if (StringUtils.isBlank((String)whOpstore.getOpstoreOcode())) {
            whOpstore.setOpstoreOcode(this.getNo(null, "OpstoreOcode", "opstoreOcode", whOpstore.getTenantCode()));
        }
        if (StringUtils.isBlank((String)whOpstore.getStoreType())) {
            whOpstore.setStoreType("0");
        }
    }

    private int getOpstoreMaxCode() {
        int code = 0;
        try {
            return this.whOpstoreMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wh.WhOpstoreServiceImpl.getOpstoreMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOpstoreUpdataDefault(WhOpstore whOpstore) {
        if (null == whOpstore) {
            return;
        }
        whOpstore.setGmtModified(this.getSysDate());
    }

    private void saveOpstoreModel(WhOpstore whOpstore) throws ApiException {
        if (null == whOpstore) {
            return;
        }
        try {
            this.whOpstoreMapper.insert(whOpstore);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhOpstoreServiceImpl.saveOpstoreModel.ex", (Throwable)e);
        }
    }

    private void saveOpstoreBatchModel(List<WhOpstore> whOpstoreList) throws ApiException {
        if (null == whOpstoreList || whOpstoreList.isEmpty()) {
            return;
        }
        try {
            this.whOpstoreMapper.insertBatch(whOpstoreList);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhOpstoreServiceImpl.saveOpstoreBatchModel.ex", (Throwable)e);
        }
    }

    private WhOpstore getOpstoreModelById(Integer opstoreId) {
        if (null == opstoreId) {
            return null;
        }
        try {
            WhOpstore whOpstore = this.whOpstoreMapper.selectByPrimaryKey(opstoreId);
            return whOpstore;
        }
        catch (Exception e) {
            this.logger.error("wh.WhOpstoreServiceImpl.getOpstoreModelById", (Throwable)e);
            return null;
        }
    }

    private WhOpstore getOpstoreModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.whOpstoreMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhOpstoreServiceImpl.getOpstoreModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOpstoreModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.whOpstoreMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhOpstoreServiceImpl.delOpstoreModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhOpstoreServiceImpl.delOpstoreModelByCode.num");
        }
    }

    private void deleteOpstoreModel(Integer opstoreId) throws ApiException {
        if (null == opstoreId) {
            return;
        }
        int i = 0;
        try {
            i = this.whOpstoreMapper.deleteByPrimaryKey(opstoreId);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhOpstoreServiceImpl.deleteOpstoreModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhOpstoreServiceImpl.deleteOpstoreModel.num");
        }
    }

    private void updateOpstoreModel(WhOpstore whOpstore) throws ApiException {
        if (null == whOpstore) {
            return;
        }
        int i = 0;
        try {
            i = this.whOpstoreMapper.updateByPrimaryKeySelective(whOpstore);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhOpstoreServiceImpl.updateOpstoreModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhOpstoreServiceImpl.updateOpstoreModel.num");
        }
    }

    private void updateStateOpstoreModel(Integer opstoreId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == opstoreId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("opstoreId", opstoreId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.whOpstoreMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhOpstoreServiceImpl.updateStateOpstoreModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhOpstoreServiceImpl.updateStateOpstoreModel.null");
        }
    }

    private void updateStateOpstoreModelByCode(String tenantCode, String opstoreCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)opstoreCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opstoreCode", opstoreCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.whOpstoreMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhOpstoreServiceImpl.updateStateOpstoreModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhOpstoreServiceImpl.updateStateOpstoreModelByCode.null");
        }
    }

    private WhOpstore makeOpstore(WhOpstoreDomain whOpstoreDomain, WhOpstore whOpstore) {
        if (null == whOpstoreDomain) {
            return null;
        }
        if (null == whOpstore) {
            whOpstore = new WhOpstore();
        }
        try {
            BeanUtils.copyAllPropertys((Object)whOpstore, (Object)whOpstoreDomain);
            return whOpstore;
        }
        catch (Exception e) {
            this.logger.error("wh.WhOpstoreServiceImpl.makeOpstore", (Throwable)e);
            return null;
        }
    }

    private WhOpstoreReDomain makeWhOpstoreReDomain(WhOpstore whOpstore) {
        if (null == whOpstore) {
            return null;
        }
        WhOpstoreReDomain whOpstoreReDomain = new WhOpstoreReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whOpstoreReDomain, (Object)whOpstore);
            return whOpstoreReDomain;
        }
        catch (Exception e) {
            this.logger.error("wh.WhOpstoreServiceImpl.makeWhOpstoreReDomain", (Throwable)e);
            return null;
        }
    }

    private List<WhOpstore> queryOpstoreModelPage(Map<String, Object> parammap) {
        try {
            return this.whOpstoreMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhOpstoreServiceImpl.queryOpstoreModel", (Throwable)e);
            return null;
        }
    }

    private int countOpstore(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.whOpstoreMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhOpstoreServiceImpl.countOpstore", (Throwable)e);
        }
        return i;
    }

    private WhOpstore createWhOpstore(WhOpstoreDomain whOpstoreDomain) {
        String msg = this.checkOpstore(whOpstoreDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhOpstoreServiceImpl.saveOpstore.checkOpstore", msg);
        }
        WhOpstore whOpstore = this.makeOpstore(whOpstoreDomain, null);
        this.setOpstoreDefault(whOpstore);
        whOpstoreDomain.setOpstoreCode(whOpstore.getOpstoreCode());
        whOpstoreDomain.setOpstoreOcode(whOpstore.getOpstoreOcode());
        return whOpstore;
    }

    private String checkOpstoreGoods(WhOpstoreGoodsDomain whOpstoreGoodsDomain) {
        if (null == whOpstoreGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOpstoreGoodsDefault(WhOpstoreGoods whOpstoreGoods) {
        if (null == whOpstoreGoods) {
            return;
        }
        if (null == whOpstoreGoods.getDataState()) {
            whOpstoreGoods.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == whOpstoreGoods.getGmtCreate()) {
            whOpstoreGoods.setGmtCreate(date);
        }
        whOpstoreGoods.setGmtModified(date);
        if (StringUtils.isBlank((String)whOpstoreGoods.getOpstoreGoodsCode())) {
            whOpstoreGoods.setOpstoreGoodsCode(this.getNo(null, "WhOpstoreGoods", "whOpstoreGoods", whOpstoreGoods.getTenantCode()));
        }
        if (StringUtils.isBlank((String)whOpstoreGoods.getStoreType())) {
            whOpstoreGoods.setStoreType("0");
        }
    }

    private int getOpstoreGoodsMaxCode() {
        int code = 0;
        try {
            return this.whOpstoreGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wh.WhOpstoreServiceImpl.getOpstoreGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOpstoreGoodsUpdataDefault(WhOpstoreGoods whOpstoreGoods) {
        if (null == whOpstoreGoods) {
            return;
        }
        whOpstoreGoods.setGmtModified(this.getSysDate());
    }

    private void saveOpstoreGoodsModel(WhOpstoreGoods whOpstoreGoods) throws ApiException {
        if (null == whOpstoreGoods) {
            return;
        }
        try {
            this.whOpstoreGoodsMapper.insertSelective(whOpstoreGoods);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhOpstoreServiceImpl.saveOpstoreGoodsModel.ex", (Throwable)e);
        }
    }

    private void saveOpstoreGoodsBatchModel(List<WhOpstoreGoods> whOpstoreGoodsList) throws ApiException {
        if (null == whOpstoreGoodsList || whOpstoreGoodsList.isEmpty()) {
            return;
        }
        try {
            this.whOpstoreGoodsMapper.insertBatch(whOpstoreGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhOpstoreServiceImpl.saveOpstoreGoodsBatchModel.ex", (Throwable)e);
        }
    }

    private WhOpstoreGoods getOpstoreGoodsModelById(Integer opstoreGoodsId) {
        if (null == opstoreGoodsId) {
            return null;
        }
        try {
            return this.whOpstoreGoodsMapper.selectByPrimaryKey(opstoreGoodsId);
        }
        catch (Exception e) {
            this.logger.error("wh.WhOpstoreServiceImpl.getOpstoreGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private WhOpstoreGoods getOpstoreGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.whOpstoreGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhOpstoreServiceImpl.getOpstoreGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOpstoreGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.whOpstoreGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhOpstoreServiceImpl.delOpstoreGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhOpstoreServiceImpl.delOpstoreGoodsModelByCode.num");
        }
    }

    private void deleteOpstoreGoodsModel(Integer opstoreGoodsId) throws ApiException {
        if (null == opstoreGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.whOpstoreGoodsMapper.deleteByPrimaryKey(opstoreGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhOpstoreServiceImpl.deleteOpstoreGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhOpstoreServiceImpl.deleteOpstoreGoodsModel.num");
        }
    }

    private void updateOpstoreGoodsModel(WhOpstoreGoods whOpstoreGoods) throws ApiException {
        if (null == whOpstoreGoods) {
            return;
        }
        int i = 0;
        try {
            i = this.whOpstoreGoodsMapper.updateByPrimaryKeySelective(whOpstoreGoods);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhOpstoreServiceImpl.updateOpstoreGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhOpstoreServiceImpl.updateOpstoreGoodsModel.num");
        }
    }

    private void updateStateOpstoreGoodsModel(Integer opstoreGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == opstoreGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("opstoreGoodsId", opstoreGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.whOpstoreGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhOpstoreServiceImpl.updateStateOpstoreGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhOpstoreServiceImpl.updateStateOpstoreGoodsModel.null");
        }
    }

    private void updateStateOpstoreGoodsModelByCode(String tenantCode, String opstoreGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)opstoreGoodsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opstoreGoodsCode", opstoreGoodsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.whOpstoreGoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhOpstoreServiceImpl.updateStateOpstoreGoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhOpstoreServiceImpl.updateStateOpstoreGoodsModelByCode.null");
        }
    }

    private WhOpstoreGoods makeOpstoreGoods(WhOpstoreGoodsDomain whOpstoreGoodsDomain, WhOpstoreGoods whOpstoreGoods) {
        if (null == whOpstoreGoodsDomain) {
            return null;
        }
        if (null == whOpstoreGoods) {
            whOpstoreGoods = new WhOpstoreGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)whOpstoreGoods, (Object)whOpstoreGoodsDomain);
            return whOpstoreGoods;
        }
        catch (Exception e) {
            this.logger.error("wh.WhOpstoreServiceImpl.makeOpstoreGoods", (Throwable)e);
            return null;
        }
    }

    private WhOpstoreGoodsReDomain makeWhOpstoreGoodsReDomain(WhOpstoreGoods whOpstoreGoods) {
        if (null == whOpstoreGoods) {
            return null;
        }
        WhOpstoreGoodsReDomain whOpstoreGoodsReDomain = new WhOpstoreGoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whOpstoreGoodsReDomain, (Object)whOpstoreGoods);
            return whOpstoreGoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error("wh.WhOpstoreServiceImpl.makeWhOpstoreGoodsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<WhOpstoreGoods> queryOpstoreGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.whOpstoreGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhOpstoreServiceImpl.queryOpstoreGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countOpstoreGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.whOpstoreGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhOpstoreServiceImpl.countOpstoreGoods", (Throwable)e);
        }
        return i;
    }

    private WhOpstoreGoods createWhOpstoreGoods(WhOpstoreGoodsDomain whOpstoreGoodsDomain) {
        String msg = this.checkOpstoreGoods(whOpstoreGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhOpstoreServiceImpl.saveOpstoreGoods.checkOpstoreGoods", msg);
        }
        WhOpstoreGoods whOpstoreGoods = this.makeOpstoreGoods(whOpstoreGoodsDomain, null);
        this.setOpstoreGoodsDefault(whOpstoreGoods);
        whOpstoreGoodsDomain.setOpstoreGoodsCode(whOpstoreGoods.getOpstoreGoodsCode());
        return whOpstoreGoods;
    }

    private String checkOpstoreSku(WhOpstoreSkuDomain whOpstoreSkuDomain) {
        if (null == whOpstoreSkuDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)whOpstoreSkuDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOpstoreSkuDefault(WhOpstoreSku whOpstoreSku) {
        if (null == whOpstoreSku) {
            return;
        }
        if (null == whOpstoreSku.getDataState()) {
            whOpstoreSku.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == whOpstoreSku.getGmtCreate()) {
            whOpstoreSku.setGmtCreate(date);
        }
        whOpstoreSku.setGmtModified(date);
        if (StringUtils.isBlank((String)whOpstoreSku.getOpstoreSkuCode())) {
            whOpstoreSku.setOpstoreSkuCode(this.getNo(null, "WhOpstoreSku", "whOpstoreSku", whOpstoreSku.getTenantCode()));
        }
        if (StringUtils.isBlank((String)whOpstoreSku.getStoreType())) {
            whOpstoreSku.setStoreType("0");
        }
    }

    private int getOpstoreSkuMaxCode() {
        int code = 0;
        try {
            return this.whOpstoreSkuMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wh.WhOpstoreServiceImpl.getOpstoreSkuMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOpstoreSkuUpdataDefault(WhOpstoreSku whOpstoreSku) {
        if (null == whOpstoreSku) {
            return;
        }
        whOpstoreSku.setGmtModified(this.getSysDate());
    }

    private void saveOpstoreSkuModel(WhOpstoreSku whOpstoreSku) throws ApiException {
        if (null == whOpstoreSku) {
            return;
        }
        try {
            this.whOpstoreSkuMapper.insertSelective(whOpstoreSku);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhOpstoreServiceImpl.saveOpstoreSkuModel.ex", (Throwable)e);
        }
    }

    private void saveOpstoreSkuBatchModel(List<WhOpstoreSku> whOpstoreSkuList) throws ApiException {
        if (null == whOpstoreSkuList || whOpstoreSkuList.isEmpty()) {
            return;
        }
        try {
            this.whOpstoreSkuMapper.insertBatch(whOpstoreSkuList);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhOpstoreServiceImpl.saveOpstoreSkuBatchModel.ex", (Throwable)e);
        }
    }

    private WhOpstoreSku getOpstoreSkuModelById(Integer opstoreSkuId) {
        if (null == opstoreSkuId) {
            return null;
        }
        try {
            return this.whOpstoreSkuMapper.selectByPrimaryKey(opstoreSkuId);
        }
        catch (Exception e) {
            this.logger.error("wh.WhOpstoreServiceImpl.getOpstoreSkuModelById", (Throwable)e);
            return null;
        }
    }

    private WhOpstoreSku getOpstoreSkuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.whOpstoreSkuMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhOpstoreServiceImpl.getOpstoreSkuModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOpstoreSkuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.whOpstoreSkuMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhOpstoreServiceImpl.delOpstoreSkuModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhOpstoreServiceImpl.delOpstoreSkuModelByCode.num");
        }
    }

    private void deleteOpstoreSkuModel(Integer opstoreSkuId) throws ApiException {
        if (null == opstoreSkuId) {
            return;
        }
        int i = 0;
        try {
            i = this.whOpstoreSkuMapper.deleteByPrimaryKey(opstoreSkuId);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhOpstoreServiceImpl.deleteOpstoreSkuModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhOpstoreServiceImpl.deleteOpstoreSkuModel.num");
        }
    }

    private void updateOpstoreSkuModel(WhOpstoreSku whOpstoreSku) throws ApiException {
        if (null == whOpstoreSku) {
            return;
        }
        int i = 0;
        try {
            i = this.whOpstoreSkuMapper.updateByPrimaryKeySelective(whOpstoreSku);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhOpstoreServiceImpl.updateOpstoreSkuModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhOpstoreServiceImpl.updateOpstoreSkuModel.num");
        }
    }

    private void updateStateOpstoreSkuModel(Integer opstoreSkuId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == opstoreSkuId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("opstoreSkuId", opstoreSkuId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.whOpstoreSkuMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhOpstoreServiceImpl.updateStateOpstoreSkuModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhOpstoreServiceImpl.updateStateOpstoreSkuModel.null");
        }
    }

    private void updateStateOpstoreSkuModelByCode(String tenantCode, String opstoreSkuCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)opstoreSkuCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opstoreSkuCode", opstoreSkuCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.whOpstoreSkuMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhOpstoreServiceImpl.updateStateOpstoreSkuModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhOpstoreServiceImpl.updateStateOpstoreSkuModelByCode.null");
        }
    }

    private WhOpstoreSku makeOpstoreSku(WhOpstoreSkuDomain whOpstoreSkuDomain, WhOpstoreSku whOpstoreSku) {
        if (null == whOpstoreSkuDomain) {
            return null;
        }
        if (null == whOpstoreSku) {
            whOpstoreSku = new WhOpstoreSku();
        }
        try {
            BeanUtils.copyAllPropertys((Object)whOpstoreSku, (Object)whOpstoreSkuDomain);
            return whOpstoreSku;
        }
        catch (Exception e) {
            this.logger.error("wh.WhOpstoreServiceImpl.makeOpstoreSku", (Throwable)e);
            return null;
        }
    }

    private WhOpstoreSkuReDomain makeWhOpstoreSkuReDomain(WhOpstoreSku whOpstoreSku) {
        if (null == whOpstoreSku) {
            return null;
        }
        WhOpstoreSkuReDomain whOpstoreSkuReDomain = new WhOpstoreSkuReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whOpstoreSkuReDomain, (Object)whOpstoreSku);
            return whOpstoreSkuReDomain;
        }
        catch (Exception e) {
            this.logger.error("wh.WhOpstoreServiceImpl.makeWhOpstoreSkuReDomain", (Throwable)e);
            return null;
        }
    }

    private List<WhOpstoreSku> queryOpstoreSkuModelPage(Map<String, Object> parammap) {
        try {
            if (Objects.nonNull(parammap) && parammap.containsKey("warehouseGroup")) {
                return this.whOpstoreSkuMapper.queryByWarehouseGroup(parammap);
            }
            if (Objects.nonNull(parammap) && parammap.containsKey("groupWarehouse")) {
                return this.whOpstoreSkuMapper.queryByGroupWarehouse(parammap);
            }
            return this.whOpstoreSkuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhOpstoreServiceImpl.queryOpstoreSkuModel", (Throwable)e);
            return null;
        }
    }

    private int countOpstoreSku(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.whOpstoreSkuMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhOpstoreServiceImpl.countOpstoreSku", (Throwable)e);
        }
        return i;
    }

    private WhOpstoreSku createWhOpstoreSku(WhOpstoreSkuDomain whOpstoreSkuDomain) {
        String msg = this.checkOpstoreSku(whOpstoreSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhOpstoreServiceImpl.saveOpstoreSku.checkOpstoreSku", msg);
        }
        WhOpstoreSku whOpstoreSku = this.makeOpstoreSku(whOpstoreSkuDomain, null);
        this.setOpstoreSkuDefault(whOpstoreSku);
        return whOpstoreSku;
    }

    @Override
    public List<WhChannelsend> saveOpstore(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        List<WhChannelsend> relist1;
        if (StringUtils.isNotBlank((String)whOpstoreDomain.getOpstoreOldcode())) {
            String[] oldCodes;
            for (String storeCode : oldCodes = whOpstoreDomain.getOpstoreOldcode().split(",")) {
                this.updateStateOpstoreModelByCode(whOpstoreDomain.getTenantCode(), storeCode, 1, 0, null);
            }
        }
        WhOpstore whOpstore = this.createWhOpstore(whOpstoreDomain);
        this.saveOpstoreModel(whOpstore);
        List<WhChannelsend> relist = this.saveWhOpstoreGoodsDomainList(whOpstoreDomain);
        if (null == relist) {
            relist = new ArrayList<WhChannelsend>();
        }
        if (ListUtil.isNotEmpty(relist1 = this.saveSend(whOpstoreDomain, "add"))) {
            relist.addAll(relist1);
        }
        return relist;
    }

    @Override
    public List<WhChannelsend> saveOpstoreTwo(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        WhOpstore whOpstore = this.createWhOpstore(whOpstoreDomain);
        this.saveOpstoreModel(whOpstore);
        return this.saveWhOpstoreGoodsDomainListTwo(whOpstoreDomain);
    }

    private List<WhChannelsend> saveWhOpstoreGoodsDomainListTwo(WhOpstoreDomain whOpstoreDomain) {
        if (null == whOpstoreDomain || ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreSkuDomainList())) {
            this.logger.error("wh.WhOpstoreServiceImpl.saveWhOpstoreGoodsDomainListTwo", (Object)"whOpstoreDomain.getWhOpstoreGoodsDomainList()");
            throw new ApiException("wh.WhOpstoreServiceImpl.saveWhOpstoreGoodsDomainListTwo.null");
        }
        ArrayList<WhChannelsend> relist = new ArrayList<WhChannelsend>();
        ArrayList skuDomainList = new ArrayList();
        HashMap<String, WhOpstoreSkuDomain> skuMap = new HashMap<String, WhOpstoreSkuDomain>();
        for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreDomain.getWhOpstoreSkuDomainList()) {
            if (StringUtils.isBlank((String)whOpstoreSkuDomain.getSkuNo()) || null == whOpstoreSkuDomain.getGoodsNum()) continue;
            whOpstoreSkuDomain.setOperatorCode(whOpstoreDomain.getOperatorCode());
            whOpstoreSkuDomain.setOpstoreCode(whOpstoreDomain.getOpstoreCode());
            whOpstoreSkuDomain.setTenantCode(whOpstoreDomain.getTenantCode());
            whOpstoreSkuDomain.setWarehouseCode(whOpstoreDomain.getWarehouseCode());
            whOpstoreSkuDomain.setWarehouseName(whOpstoreDomain.getWarehouseName());
            this.saveOpstoreSku(whOpstoreSkuDomain);
            WhOpstoreSkuDomain whOpstoreSkuDomain1 = (WhOpstoreSkuDomain)skuMap.get(whOpstoreSkuDomain.getSkuNo());
            if (null == whOpstoreSkuDomain1) {
                skuMap.put(whOpstoreSkuDomain.getSkuNo(), whOpstoreSkuDomain);
                continue;
            }
            whOpstoreSkuDomain.setGoodsNum(whOpstoreSkuDomain.getGoodsNum().add(whOpstoreSkuDomain1.getGoodsNum()));
            skuMap.put(whOpstoreSkuDomain.getSkuNo(), whOpstoreSkuDomain);
        }
        for (String key : skuMap.keySet()) {
            WhOpstoreSkuDomain whOpstoreSkuDomain = (WhOpstoreSkuDomain)skuMap.get(key);
            List<WhChannelsend> add = this.saveSend(whOpstoreSkuDomain, "add");
            relist.addAll(add);
        }
        return relist;
    }

    private List<WhChannelsend> saveSend(WhOpstoreSkuDomain whOpstoreSkuDomain, String chanelsendDir) {
        if (null == whOpstoreSkuDomain) {
            return null;
        }
        ArrayList<WhChannelsendDomain> atChannelsendDomainList = new ArrayList<WhChannelsendDomain>();
        WhChannelsendDomain atChannelsendDomain = new WhChannelsendDomain();
        atChannelsendDomainList.add(atChannelsendDomain);
        atChannelsendDomain.setChannelsendDir(chanelsendDir);
        atChannelsendDomain.setChannelsendOpcode(whOpstoreSkuDomain.getOpstoreCode());
        atChannelsendDomain.setChannelsendType("whOpstoreSkuDomain");
        atChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)whOpstoreSkuDomain));
        atChannelsendDomain.setTenantCode(whOpstoreSkuDomain.getTenantCode());
        return this.whChannelsendService.saveChannelsendBatch(atChannelsendDomainList);
    }

    private List<WhChannelsend> saveSend(WhOpstoreDomain whOpstoreDomain, String chanelsendDir) {
        if (null == whOpstoreDomain) {
            return null;
        }
        ArrayList<WhChannelsendDomain> atChannelsendDomainList = new ArrayList<WhChannelsendDomain>();
        WhChannelsendDomain atChannelsendDomain = new WhChannelsendDomain();
        atChannelsendDomainList.add(atChannelsendDomain);
        atChannelsendDomain.setChannelsendDir(chanelsendDir);
        atChannelsendDomain.setChannelsendOpcode(whOpstoreDomain.getOpstoreCode());
        atChannelsendDomain.setChannelsendType("whOpstoreDomain");
        atChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)whOpstoreDomain));
        atChannelsendDomain.setTenantCode(whOpstoreDomain.getTenantCode());
        return this.whChannelsendService.saveChannelsendBatch(atChannelsendDomainList);
    }

    private List<WhChannelsend> saveWhOpstoreGoodsDomainList(WhOpstoreDomain whOpstoreDomain) {
        if (null == whOpstoreDomain || ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
            this.logger.error("wh.WhOpstoreServiceImpl.saveWhOpstoreGoodsDomainList", (Object)"whOpstoreDomain.getWhOpstoreGoodsDomainList()");
            throw new ApiException("wh.WhOpstoreServiceImpl.saveWhOpstoreGoodsDomainList.null");
        }
        ArrayList<WhChannelsend> relist = new ArrayList<WhChannelsend>();
        for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreDomain.getWhOpstoreGoodsDomainList()) {
            List<WhChannelsend> list;
            whOpstoreGoodsDomain.setOperatorCode(whOpstoreDomain.getOperatorCode());
            whOpstoreGoodsDomain.setOpstoreCode(whOpstoreDomain.getOpstoreCode());
            whOpstoreGoodsDomain.setOpstoreOcode(whOpstoreDomain.getOpstoreOcode());
            whOpstoreGoodsDomain.setTenantCode(whOpstoreDomain.getTenantCode());
            if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getWarehouseCode())) {
                List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
                if (Objects.isNull(whOpstoreSkuDomainList.get(0))) {
                    whOpstoreGoodsDomain.setWarehouseCode(whOpstoreDomain.getWarehouseCode());
                    whOpstoreGoodsDomain.setWarehouseName(whOpstoreDomain.getWarehouseName());
                    whOpstoreGoodsDomain.setOpstoreGoodsEocode(whOpstoreDomain.getStoreWhlocalCode());
                    whOpstoreGoodsDomain.setStoreWhlocal(whOpstoreDomain.getStoreWhlocal());
                } else {
                    whOpstoreGoodsDomain.setWarehouseCode(whOpstoreSkuDomainList.get(0).getWarehouseCode());
                    whOpstoreGoodsDomain.setWarehouseName(whOpstoreSkuDomainList.get(0).getWarehouseName());
                    whOpstoreGoodsDomain.setOpstoreGoodsEocode(whOpstoreSkuDomainList.get(0).getOpstoreGoodsEocode());
                    whOpstoreGoodsDomain.setStoreWhlocal(whOpstoreSkuDomainList.get(0).getStoreWhlocal());
                }
            }
            if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getStoreType())) {
                whOpstoreGoodsDomain.setStoreType("0");
            }
            if (!ListUtil.isNotEmpty(list = this.saveNum(whOpstoreGoodsDomain, whOpstoreDomain))) continue;
            relist.addAll(list);
        }
        return relist;
    }

    @Override
    public List<WhChannelsend> saveOpstoreBatch(List<WhOpstoreDomain> whOpstoreDomainList) throws ApiException {
        if (null == whOpstoreDomainList || whOpstoreDomainList.isEmpty()) {
            return null;
        }
        ArrayList<WhChannelsend> relist = new ArrayList<WhChannelsend>();
        for (WhOpstoreDomain whOpstoreDomain : whOpstoreDomainList) {
            List<WhChannelsend> list = this.saveOpstore(whOpstoreDomain);
            if (!ListUtil.isNotEmpty(list)) continue;
            relist.addAll(list);
        }
        return relist;
    }

    @Override
    public List<WhChannelsend> updateOpstoreState(Integer opstoreId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == opstoreId) {
            return null;
        }
        if (MapUtil.isNotEmpty(map) && !EmptyUtil.isEmpty((Object)map.get("opstoreOldCodeStr"))) {
            for (String opstoreOldCodeStr : map.get("opstoreOldCodeStr").toString().split(",")) {
                this.updateStateOpstoreModelByCode(null, opstoreOldCodeStr, dataState, oldDataState, null);
            }
        }
        this.updateStateOpstoreModel(opstoreId, dataState, oldDataState, map);
        WhOpstoreReDomain whOpstoreReDomain = this.getOpstore(opstoreId);
        if (null == whOpstoreReDomain) {
            this.logger.error("wh.WhOpstoreServiceImpl.updateOpstoreState", (Object)opstoreId);
            throw new ApiException("wh.WhOpstoreServiceImpl.updateOpstoreStateByCode", "\u6dfb\u52a0\u5165\u5e93\u5355\u5931\u8d25");
        }
        return this.saveSend(whOpstoreReDomain, "audt");
    }

    @Override
    public List<WhChannelsend> updateOpstoreStateByCode(String tenantCode, String opstoreCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)opstoreCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        this.updateStateOpstoreModelByCode(tenantCode, opstoreCode, dataState, oldDataState, map);
        WhOpstore whOpstore = this.getOpstoreByCode(tenantCode, opstoreCode);
        if (null == whOpstore) {
            this.logger.error("wh.WhOpstoreServiceImpl.updateOpstoreState", (Object)(opstoreCode + "=" + tenantCode));
            throw new ApiException("wh.WhOpstoreServiceImpl.updateOpstoreStateByCode", "\u6dfb\u52a0\u5165\u5e93\u5355\u5931\u8d25");
        }
        WhOpstoreReDomain whOpstoreReDomain = this.makeAll(whOpstore);
        return this.saveSend(whOpstoreReDomain, "audt");
    }

    @Override
    public void updateOpstoreByCode(Map<String, Object> map) {
        if (null == map) {
            return;
        }
        int i = 0;
        try {
            i = this.whOpstoreMapper.updateOpstoreByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhOpstoreServiceImpl.updateStateStoreGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhOpstoreServiceImpl.updateStateStoreGoodsModel.null");
        }
    }

    @Override
    public List<WhChannelsend> updateOpstore(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        List<WhChannelsend> relist1;
        if (null == whOpstoreDomain) {
            this.logger.error("wh.WhOpstoreServiceImpl.updateOpstore-whOpstoreDomain", (Object)"whOpstoreDomain is null");
            return null;
        }
        String newOpstoreOldcode = whOpstoreDomain.getOpstoreOldcode();
        String msg = this.checkOpstore(whOpstoreDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhOpstoreServiceImpl.updateOpstore.checkOpstore", msg);
        }
        WhOpstore oldWhOpstore = this.getOpstoreModelById(whOpstoreDomain.getOpstoreId());
        String OldOpstoreOldcode = oldWhOpstore.getOpstoreOldcode();
        if (null == oldWhOpstore) {
            throw new ApiException("wh.WhOpstoreServiceImpl.updateOpstore.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((String)OldOpstoreOldcode)) {
            for (String oldOpstoreCode : OldOpstoreOldcode.split(",")) {
                this.updateStateOpstoreModelByCode(whOpstoreDomain.getTenantCode(), oldOpstoreCode, 0, null, null);
            }
        }
        if (StringUtils.isNotBlank((String)newOpstoreOldcode)) {
            for (String newOpstoreCode : newOpstoreOldcode.split(",")) {
                this.updateStateOpstoreModelByCode(whOpstoreDomain.getTenantCode(), newOpstoreCode, 1, 0, null);
            }
        }
        WhOpstore whOpstore = this.makeOpstore(whOpstoreDomain, oldWhOpstore);
        this.setOpstoreUpdataDefault(whOpstore);
        this.updateOpstoreModel(whOpstore);
        List<WhChannelsend> relist = this.updateWhOpstoreGoodsDomainList(whOpstoreDomain);
        if (null == relist) {
            relist = new ArrayList<WhChannelsend>();
        }
        if (ListUtil.isNotEmpty(relist1 = this.saveSend(whOpstoreDomain, "update"))) {
            relist.addAll(relist1);
        }
        return relist1;
    }

    @Override
    public WhOpstoreReDomain getOpstore(Integer opstoreId) {
        if (null == opstoreId) {
            return null;
        }
        WhOpstore whOpstore = this.getOpstoreModelById(opstoreId);
        if (null == whOpstore) {
            return null;
        }
        return this.makeAll(whOpstore);
    }

    private WhOpstoreReDomain makeAll(WhOpstore whOpstore) {
        if (null == whOpstore) {
            return null;
        }
        WhOpstoreReDomain whOpstoreReDomain = this.makeWhOpstoreReDomain(whOpstore);
        if (null == whOpstoreReDomain) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", whOpstore.getTenantCode());
        map.put("opstoreCode", whOpstore.getOpstoreCode());
        map.put("order", true);
        map.put("orderStr", "GOODS_EOCODE");
        List<WhOpstoreGoods> List2 = this.queryOpstoreGoodsModelPage(map);
        whOpstoreReDomain.setWhOpstoreGoodsReDomainList(this.makeWhOpstoreGoodsReDomainList(List2));
        return whOpstoreReDomain;
    }

    private List<WhOpstoreGoodsReDomain> makeWhOpstoreGoodsReDomainList(List<WhOpstoreGoods> List2) {
        if (ListUtil.isEmpty(List2)) {
            return null;
        }
        ArrayList<WhOpstoreGoodsReDomain> relist = new ArrayList<WhOpstoreGoodsReDomain>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<WhOpstoreSku> skuList = null;
        for (WhOpstoreGoods whOpstoreGoods : List2) {
            WhOpstoreGoodsReDomain whOpstoreGoodsReDomain = new WhOpstoreGoodsReDomain();
            try {
                BeanUtils.copyAllPropertys((Object)whOpstoreGoodsReDomain, (Object)whOpstoreGoods);
            }
            catch (Exception exception) {
                // empty catch block
            }
            map.put("tenantCode", whOpstoreGoods.getTenantCode());
            map.put("opstoreCode", whOpstoreGoods.getOpstoreCode());
            map.put("opstoreGoodsCode", whOpstoreGoods.getOpstoreGoodsCode());
            skuList = this.queryOpstoreSkuModelPage(map);
            whOpstoreGoodsReDomain.setWhOpstoreSkuReDomainList(this.makeWhOpstoreSkuReDomainList(skuList));
            relist.add(whOpstoreGoodsReDomain);
        }
        return relist;
    }

    private List<WhOpstoreSkuReDomain> makeWhOpstoreSkuReDomainList(List<WhOpstoreSku> List2) {
        if (ListUtil.isEmpty(List2)) {
            return null;
        }
        ArrayList<WhOpstoreSkuReDomain> relist = new ArrayList<WhOpstoreSkuReDomain>();
        for (WhOpstoreSku whOpstoreSku : List2) {
            WhOpstoreSkuReDomain whOpstoreSkuReDomain = new WhOpstoreSkuReDomain();
            try {
                BeanUtils.copyAllPropertys((Object)whOpstoreSkuReDomain, (Object)whOpstoreSku);
            }
            catch (Exception exception) {
                // empty catch block
            }
            relist.add(whOpstoreSkuReDomain);
        }
        return relist;
    }

    @Override
    public void deleteOpstore(Integer opstoreId) throws ApiException {
        if (null == opstoreId) {
            return;
        }
        this.deleteOpstoreModel(opstoreId);
    }

    @Override
    public QueryResult<WhOpstore> queryOpstorePage(Map<String, Object> map) {
        List<WhOpstore> whOpstoreList = this.queryOpstoreModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOpstore(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(whOpstoreList);
        return queryResult;
    }

    @Override
    public QueryResult<WhOpstoreReDomain> queryOpstorePages(Map<String, Object> map) {
        int count = this.countOpstore(map);
        List<Object> opstoreList = new ArrayList();
        if (count > 0) {
            opstoreList = this.queryOpstoreModel(map);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(opstoreList);
        return queryResult;
    }

    private List<WhOpstoreReDomain> queryOpstoreModel(Map<String, Object> map) {
        List whOpstoreList = this.queryOpstorePage(map).getList();
        return this.childFlagNew(map, whOpstoreList);
    }

    private List<WhOpstore> queryOpstoreModelNewPage(Map<String, Object> parammap) {
        try {
            return this.whOpstoreMapper.queryNew(parammap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhOpstoreServiceImpl.queryContractModel", (Throwable)e);
            return null;
        }
    }

    private List<WhOpstoreReDomain> childFlagNew(Map<String, Object> map, List<WhOpstore> whOpstoreList) {
        if (whOpstoreList == null || whOpstoreList.isEmpty()) {
            return null;
        }
        ArrayList<WhOpstoreReDomain> whOpstoreReDomainList = new ArrayList<WhOpstoreReDomain>();
        for (WhOpstore whOpstore : whOpstoreList) {
            WhOpstoreReDomain whOpstoreReDomain = this.makeWhOpstoreReDomain(whOpstore);
            HashMap<String, Object> parammap = new HashMap<String, Object>();
            parammap.put("opstoreCode", whOpstore.getOpstoreCode());
            parammap.put("tenantCode", whOpstore.getTenantCode());
            whOpstoreReDomain.setWhOpstoreGoodsDomainList(this.queryWhOpstoreGoodsDomainList(parammap));
            if (ListUtil.isNotEmpty(whOpstoreReDomain.getWhOpstoreGoodsDomainList())) {
                for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreReDomain.getWhOpstoreGoodsDomainList()) {
                    HashMap<String, Object> WhOpstoreSkuMap = new HashMap<String, Object>();
                    WhOpstoreSkuMap.put("opstoreGoodsCode", whOpstoreGoodsDomain.getOpstoreGoodsCode());
                    WhOpstoreSkuMap.put("tenantCode", whOpstoreGoodsDomain.getTenantCode());
                    whOpstoreGoodsDomain.setWhOpstoreSkuDomainList(this.queryWhOpstoreSkuDomainListNew(WhOpstoreSkuMap));
                }
            }
            whOpstoreReDomainList.add(whOpstoreReDomain);
        }
        return whOpstoreReDomainList;
    }

    private List<WhOpstoreGoodsDomain> queryWhOpstoreGoodsDomainList(Map<String, Object> parammap) {
        List goodsList = this.queryOpstoreGoodsPage(parammap).getList();
        if (ListUtil.isEmpty((Collection)goodsList)) {
            return null;
        }
        ArrayList<WhOpstoreGoodsDomain> goodsDomainList = new ArrayList<WhOpstoreGoodsDomain>();
        for (WhOpstoreGoods opstoreGoods : goodsList) {
            WhOpstoreGoodsDomain whOpstoreGoodsDomain = new WhOpstoreGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)whOpstoreGoodsDomain, (Object)opstoreGoods);
                goodsDomainList.add(whOpstoreGoodsDomain);
            }
            catch (Exception e) {
                this.logger.error("wh.WhOpstoreServiceImpl.queryWhOpstoreSkuDomainListNew.foreach.ex", (Throwable)e);
            }
        }
        return goodsDomainList;
    }

    private List<WhOpstoreSkuDomain> queryWhOpstoreSkuDomainListNew(Map<String, Object> parammap) {
        List<WhOpstoreSku> skuList = this.queryOpstoreSkuModelPage(parammap);
        if (ListUtil.isEmpty(skuList)) {
            return null;
        }
        ArrayList<WhOpstoreSkuDomain> skuDomainList = new ArrayList<WhOpstoreSkuDomain>();
        for (WhOpstoreSku opstoreSku : skuList) {
            WhOpstoreSkuDomain skuDomain = new WhOpstoreSkuDomain();
            try {
                BeanUtils.copyAllPropertys((Object)skuDomain, (Object)opstoreSku);
                skuDomainList.add(skuDomain);
            }
            catch (Exception e) {
                this.logger.error("wh.WhOpstoreServiceImpl.queryWhOpstoreSkuDomainListNew.foreach.ex", (Throwable)e);
            }
        }
        return skuDomainList;
    }

    private int countOpstoreNew(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.whOpstoreMapper.countNew(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhOpstoreServiceImpl.countContractNew", (Throwable)e);
        }
        return i;
    }

    @Override
    public WhOpstore getOpstoreByCode(String tenantCode, String opstoreCode) throws ApiException {
        if (StringUtils.isBlank((String)opstoreCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opstoreCode", opstoreCode);
        return this.getOpstoreModelByCode(map);
    }

    @Override
    public void deleteOpstoreByCode(String tenantCode, String opstoreCode) throws ApiException {
        if (StringUtils.isBlank((String)opstoreCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opstoreCode", opstoreCode);
        this.delOpstoreModelByCode(map);
    }

    @Override
    public List<WhChannelsend> saveOpstoreGoods(WhOpstoreGoodsDomain whOpstoreGoodsDomain) throws ApiException {
        return this.saveNum(whOpstoreGoodsDomain, null);
    }

    private List<WhChannelsend> saveNum(WhOpstoreGoodsDomain whOpstoreGoodsDomain, WhOpstoreDomain whOpstoreDomain) {
        if (null == whOpstoreGoodsDomain) {
            return null;
        }
        WhOpstoreGoods whOpstoreGoods = this.createWhOpstoreGoods(whOpstoreGoodsDomain);
        this.saveOpstoreGoodsModel(whOpstoreGoods);
        this.saveWhOpstoreSkuDomainList(whOpstoreGoodsDomain);
        return this.saveWhStoreGoodsDomain(whOpstoreDomain, whOpstoreGoodsDomain);
    }

    public List<WhChannelsend> saveOpstoreGoods(List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList) throws ApiException {
        return this.saveNum(whOpstoreGoodsDomainList, null);
    }

    private List<WhChannelsend> saveNum(List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList, WhOpstoreDomain whOpstoreDomain) {
        if (null == whOpstoreGoodsDomainList) {
            return null;
        }
        this.sortGoods(whOpstoreGoodsDomainList);
        for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
            WhOpstoreGoods whOpstoreGoods = this.createWhOpstoreGoods(whOpstoreGoodsDomain);
            this.saveOpstoreGoodsModel(whOpstoreGoods);
            this.saveWhOpstoreSkuDomainList(whOpstoreGoodsDomain);
        }
        return this.saveWhStoreGoodsDomain(whOpstoreDomain, whOpstoreGoodsDomainList);
    }

    private List<WhChannelsend> saveWhStoreGoodsDomain(WhOpstoreDomain whOpstoreDomain, List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList) {
        if (ListUtil.isEmpty(whOpstoreGoodsDomainList)) {
            return null;
        }
        if (null != whOpstoreDomain && "2".equals(whOpstoreDomain.getStoreGoodsType())) {
            return null;
        }
        this.sortGoods(whOpstoreGoodsDomainList);
        ArrayList<WhChannelsend> channelsendList = new ArrayList<WhChannelsend>();
        for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
            List<WhChannelsend> list;
            WhStoreGoodsDomain whStoreGoodsDomain = new WhStoreGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)whStoreGoodsDomain, (Object)whOpstoreGoodsDomain);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ListUtil.isNotEmpty(whOpstoreGoodsDomain.getWhOpstoreSkuDomainList())) {
                ArrayList<WhStoreSkuDomain> whStoreSkuDomainList = new ArrayList<WhStoreSkuDomain>();
                for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreGoodsDomain.getWhOpstoreSkuDomainList()) {
                    WhStoreSkuDomain whStoreSkuDomain = new WhStoreSkuDomain();
                    try {
                        BeanUtils.copyAllPropertys((Object)whStoreSkuDomain, (Object)whOpstoreSkuDomain);
                        whStoreSkuDomainList.add(whStoreSkuDomain);
                    }
                    catch (Exception exception) {}
                }
                whStoreGoodsDomain.setWhStoreSkuDomainList(whStoreSkuDomainList);
            }
            if (!ListUtil.isNotEmpty(list = this.whStoreGoodsService.saveStoreGoods(whStoreGoodsDomain))) continue;
            channelsendList.addAll(list);
        }
        return channelsendList;
    }

    private void sortGoods(List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList) {
        if (ListUtil.isEmpty(whOpstoreGoodsDomainList)) {
            return;
        }
        Collections.sort(whOpstoreGoodsDomainList, new Comparator<WhOpstoreGoodsDomain>(){

            @Override
            public int compare(WhOpstoreGoodsDomain arg0, WhOpstoreGoodsDomain arg1) {
                int sComp;
                String x1 = arg0.getTenantCode();
                String x2 = arg1.getTenantCode();
                if (StringUtils.isBlank((String)x1)) {
                    x1 = "";
                }
                if (StringUtils.isBlank((String)x2)) {
                    x2 = "";
                }
                if ((sComp = x1.compareTo(x2)) != 0) {
                    return sComp;
                }
                return arg0.getGoodsCode().compareTo(arg0.getGoodsCode());
            }
        });
    }

    private List<WhChannelsend> saveWhStoreGoodsDomain(WhOpstoreDomain whOpstoreDomain, WhOpstoreGoodsDomain whOpstoreGoodsDomain) {
        if (null == whOpstoreGoodsDomain) {
            return null;
        }
        if (null != whOpstoreDomain && "2".equals(whOpstoreDomain.getStoreGoodsType())) {
            return null;
        }
        WhStoreGoodsDomain whStoreGoodsDomain = new WhStoreGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whStoreGoodsDomain, (Object)whOpstoreGoodsDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ListUtil.isNotEmpty(whOpstoreGoodsDomain.getWhOpstoreSkuDomainList())) {
            ArrayList<WhStoreSkuDomain> whStoreSkuDomainList = new ArrayList<WhStoreSkuDomain>();
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreGoodsDomain.getWhOpstoreSkuDomainList()) {
                WhStoreSkuDomain whStoreSkuDomain = new WhStoreSkuDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)whStoreSkuDomain, (Object)whOpstoreSkuDomain);
                    whStoreSkuDomainList.add(whStoreSkuDomain);
                }
                catch (Exception exception) {}
            }
            whStoreGoodsDomain.setWhStoreSkuDomainList(whStoreSkuDomainList);
        }
        return this.whStoreGoodsService.saveStoreGoods(whStoreGoodsDomain);
    }

    private void saveWhOpstoreSkuDomainList(WhOpstoreGoodsDomain whOpstoreGoodsDomain) {
        this.logger.error("wh.WhOpstoreServiceImpl.saveWhOpstoreSkuDomainList-----" + JsonUtil.buildNonDefaultBinder().toJson((Object)whOpstoreGoodsDomain));
        if (null == whOpstoreGoodsDomain || ListUtil.isEmpty(whOpstoreGoodsDomain.getWhOpstoreSkuDomainList())) {
            return;
        }
        for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreGoodsDomain.getWhOpstoreSkuDomainList()) {
            whOpstoreSkuDomain.setOperatorCode(whOpstoreGoodsDomain.getOperatorCode());
            whOpstoreSkuDomain.setOpstoreCode(whOpstoreGoodsDomain.getOpstoreCode());
            whOpstoreSkuDomain.setTenantCode(whOpstoreGoodsDomain.getTenantCode());
            whOpstoreSkuDomain.setOpstoreGoodsCode(whOpstoreGoodsDomain.getOpstoreGoodsCode());
            if (Objects.isNull(whOpstoreSkuDomain.getWarehouseCode())) {
                whOpstoreSkuDomain.setWarehouseCode(whOpstoreGoodsDomain.getWarehouseCode());
                whOpstoreSkuDomain.setWarehouseName(whOpstoreGoodsDomain.getWarehouseName());
                whOpstoreSkuDomain.setOpstoreGoodsEocode(whOpstoreGoodsDomain.getOpstoreGoodsEocode());
                whOpstoreSkuDomain.setStoreWhlocal(whOpstoreGoodsDomain.getStoreWhlocal());
            }
            this.logger.error("wh.WhOpstoreServiceImpl.saveWhOpstoreSkuDomainList" + JsonUtil.buildNonDefaultBinder().toJson((Object)whOpstoreSkuDomain));
            this.saveOpstoreSku(whOpstoreSkuDomain);
        }
    }

    private void makeSKu(WhOpstoreGoodsDomain rsResourceGoods, WhOpstoreSkuDomain sku) {
        if (null == rsResourceGoods || null == sku) {
            return;
        }
        sku.setGoodsNo(rsResourceGoods.getGoodsNo());
        sku.setGoodsName(rsResourceGoods.getGoodsName());
        sku.setPntreeCode(rsResourceGoods.getPntreeCode());
        sku.setPntreeName(rsResourceGoods.getPntreeName());
        sku.setBrandCode(rsResourceGoods.getBrandCode());
        sku.setBrandName(rsResourceGoods.getBrandName());
        sku.setGoodsCode(rsResourceGoods.getGoodsCode());
        sku.setTenantCode(rsResourceGoods.getTenantCode());
        sku.setSpuCode(rsResourceGoods.getSpuCode());
        sku.setMemberCcode(rsResourceGoods.getMemberCcode());
        sku.setMemberCname(rsResourceGoods.getMemberCname());
        sku.setMemberCode(rsResourceGoods.getMemberCode());
        sku.setMemberName(rsResourceGoods.getMemberName());
        sku.setChannelCode(rsResourceGoods.getChannelCode());
        sku.setChannelName(rsResourceGoods.getChannelName());
        if (StringUtils.isBlank((String)sku.getPartsnameNumunit())) {
            sku.setPartsnameNumunit(rsResourceGoods.getPartsnameNumunit());
        }
        if (StringUtils.isBlank((String)sku.getPartsnameWeightunit())) {
            sku.setPartsnameWeightunit(rsResourceGoods.getPartsnameWeightunit());
        }
        if (null == sku.getGoodsMinnum()) {
            sku.setGoodsMinnum(rsResourceGoods.getGoodsMinnum());
        }
        if (null == sku.getGoodsOneweight()) {
            sku.setGoodsOneweight(rsResourceGoods.getGoodsOneweight());
        }
        sku.setGoodsEocode(rsResourceGoods.getGoodsEocode());
        sku.setClasstreeCode(rsResourceGoods.getClasstreeCode());
        sku.setClasstreeName(rsResourceGoods.getClasstreeName());
    }

    @Override
    public List<WhChannelsend> saveOpstoreGoodsBatch(List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList) throws ApiException {
        if (null == whOpstoreGoodsDomainList || whOpstoreGoodsDomainList.isEmpty()) {
            return null;
        }
        return this.saveOpstoreGoods(whOpstoreGoodsDomainList);
    }

    @Override
    public void updateOpstoreGoodsBatch(List<WhOpstoreGoodsReDomain> whOpstoreGoodsDomainList) throws ApiException {
        if (null == whOpstoreGoodsDomainList || whOpstoreGoodsDomainList.isEmpty()) {
            return;
        }
        for (WhOpstoreGoodsReDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
            WhOpstoreGoods whOpstoreGoods = new WhOpstoreGoods();
            org.springframework.beans.BeanUtils.copyProperties((Object)whOpstoreGoodsDomain, (Object)whOpstoreGoods);
            this.updateOpstoreGoodsModel(whOpstoreGoods);
        }
    }

    @Override
    public void updateOpstoreGoodsState(Integer opstoreGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == opstoreGoodsId) {
            return;
        }
        this.updateStateOpstoreGoodsModel(opstoreGoodsId, dataState, oldDataState, map);
    }

    @Override
    public void updateOpstoreGoodsStateByCode(String tenantCode, String opstoreGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)opstoreGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateOpstoreGoodsModelByCode(tenantCode, opstoreGoodsCode, dataState, oldDataState, map);
    }

    @Override
    public List<WhChannelsend> updateOpstoreGoods(WhOpstoreGoodsDomain whOpstoreGoodsDomain) throws ApiException {
        String msg = this.checkOpstoreGoods(whOpstoreGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhOpstoreServiceImpl.updateOpstoreGoods.checkOpstoreGoods", msg);
        }
        WhOpstoreGoods whOpstoreGoods = this.makeOpstoreGoods(whOpstoreGoodsDomain, null);
        this.setOpstoreGoodsDefault(whOpstoreGoods);
        this.saveOpstoreGoodsModel(whOpstoreGoods);
        whOpstoreGoodsDomain.setOpstoreGoodsCode(whOpstoreGoods.getOpstoreGoodsCode());
        return this.updateWhOpstoreSkuDomainList(whOpstoreGoodsDomain);
    }

    private List<WhChannelsend> updateWhOpstoreGoodsDomainList(WhOpstoreDomain whOpstoreDomain) {
        if (null == whOpstoreDomain || ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
            return null;
        }
        ArrayList<WhChannelsend> relist = new ArrayList<WhChannelsend>();
        this.deleteOpstoreGoodsByOpstoreCode(whOpstoreDomain.getTenantCode(), whOpstoreDomain.getOpstoreCode());
        this.deleteOpstoreSkuByGoodsCode(whOpstoreDomain.getTenantCode(), whOpstoreDomain.getOpstoreCode());
        for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreDomain.getWhOpstoreGoodsDomainList()) {
            whOpstoreGoodsDomain.setOpstoreCode(whOpstoreDomain.getOpstoreCode());
            List<WhChannelsend> list = this.updateOpstoreGoods(whOpstoreGoodsDomain);
            if (!ListUtil.isNotEmpty(list)) continue;
            relist.addAll(list);
        }
        return relist;
    }

    public void deleteOpstoreGoodsByOpstoreCode(String tenantCode, String opstoreCode) throws ApiException {
        if (StringUtils.isBlank((String)opstoreCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("wh.WhOpstoreServiceImpl.deleteOpstoreGoodsByOpstoreCode", (Object)"param is null");
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opstoreCode", opstoreCode);
        this.delOpstoreGoodsModelByOpstoreCode(map);
    }

    private void delOpstoreGoodsModelByOpstoreCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.whOpstoreGoodsMapper.delByOpstoreCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhOpstoreServiceImpl.delOpstoreGoodsModelByCode.ex", (Throwable)e);
        }
        if (i == 0) {
            throw new ApiException("wh.WhOpstoreServiceImpl.delOpstoreGoodsModelByCode.num");
        }
    }

    private List<WhChannelsend> updateWhOpstoreSkuDomainList(WhOpstoreGoodsDomain whOpstoreGoodsDomain) {
        if (null == whOpstoreGoodsDomain || ListUtil.isEmpty(whOpstoreGoodsDomain.getWhOpstoreSkuDomainList())) {
            return null;
        }
        ArrayList<WhChannelsend> relist = new ArrayList<WhChannelsend>();
        for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreGoodsDomain.getWhOpstoreSkuDomainList()) {
            whOpstoreSkuDomain.setOpstoreCode(whOpstoreGoodsDomain.getOpstoreCode());
            whOpstoreSkuDomain.setOpstoreGoodsCode(whOpstoreGoodsDomain.getOpstoreGoodsCode());
            List<WhChannelsend> list = this.updateOpstoreSku(whOpstoreSkuDomain);
            if (!ListUtil.isNotEmpty(list)) continue;
            relist.addAll(list);
        }
        return relist;
    }

    public void deleteOpstoreSkuByGoodsCode(String tenantCode, String opstoreGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)opstoreGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opstoreCode", opstoreGoodsCode);
        this.delOpstoreSkuModelByGoodsCode(map);
    }

    private void delOpstoreSkuModelByGoodsCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.whOpstoreSkuMapper.delByGoodsCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhOpstoreServiceImpl.delOpstoreSkuModelByCode.ex", (Throwable)e);
        }
        if (i == 0) {
            throw new ApiException("wh.WhOpstoreServiceImpl.delOpstoreSkuModelByCode.num");
        }
    }

    @Override
    public WhOpstoreGoods getOpstoreGoods(Integer opstoreGoodsId) {
        if (null == opstoreGoodsId) {
            return null;
        }
        return this.getOpstoreGoodsModelById(opstoreGoodsId);
    }

    @Override
    public void deleteOpstoreGoods(Integer opstoreGoodsId) throws ApiException {
        if (null == opstoreGoodsId) {
            return;
        }
        this.deleteOpstoreGoodsModel(opstoreGoodsId);
    }

    @Override
    public QueryResult<WhOpstoreGoods> queryOpstoreGoodsPage(Map<String, Object> map) {
        List<WhOpstoreGoods> whOpstoreGoodsList = this.queryOpstoreGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOpstoreGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(whOpstoreGoodsList);
        return queryResult;
    }

    @Override
    public WhOpstoreGoods getOpstoreGoodsByCode(String tenantCode, String opstoreGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)opstoreGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opstoreGoodsCode", opstoreGoodsCode);
        return this.getOpstoreGoodsModelByCode(map);
    }

    @Override
    public void deleteOpstoreGoodsByCode(String tenantCode, String opstoreGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)opstoreGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opstoreGoodsCode", opstoreGoodsCode);
        this.delOpstoreGoodsModelByCode(map);
    }

    @Override
    public String saveOpstoreSku(WhOpstoreSkuDomain whOpstoreSkuDomain) throws ApiException {
        WhOpstoreSku whOpstoreSku = this.createWhOpstoreSku(whOpstoreSkuDomain);
        this.saveOpstoreSkuModel(whOpstoreSku);
        return whOpstoreSku.getOpstoreSkuCode();
    }

    @Override
    public String saveOpstoreSkuBatch(List<WhOpstoreSkuDomain> whOpstoreSkuDomainList) throws ApiException {
        if (null == whOpstoreSkuDomainList || whOpstoreSkuDomainList.isEmpty()) {
            return null;
        }
        ArrayList<WhOpstoreSku> whOpstoreSkuList = new ArrayList<WhOpstoreSku>();
        String code = "";
        for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
            WhOpstoreSku whOpstoreSku = this.createWhOpstoreSku(whOpstoreSkuDomain);
            code = whOpstoreSku.getOpstoreSkuCode();
            whOpstoreSkuList.add(whOpstoreSku);
        }
        this.saveOpstoreSkuBatchModel(whOpstoreSkuList);
        return code;
    }

    @Override
    public void updateOpstoreSkuState(Integer opstoreSkuId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == opstoreSkuId) {
            return;
        }
        this.updateStateOpstoreSkuModel(opstoreSkuId, dataState, oldDataState, map);
    }

    @Override
    public void updateOpstoreSkuStateByCode(String tenantCode, String opstoreSkuCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)opstoreSkuCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateOpstoreSkuModelByCode(tenantCode, opstoreSkuCode, dataState, oldDataState, map);
    }

    @Override
    public List<WhChannelsend> updateOpstoreSku(WhOpstoreSkuDomain whOpstoreSkuDomain) throws ApiException {
        String msg = this.checkOpstoreSku(whOpstoreSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhOpstoreServiceImpl.updateOpstoreSku.checkOpstoreSku", msg);
        }
        WhOpstoreSku whOpstoreSku = this.makeOpstoreSku(whOpstoreSkuDomain, null);
        this.setOpstoreSkuDefault(whOpstoreSku);
        this.saveOpstoreSkuModel(whOpstoreSku);
        return null;
    }

    private List<WhChannelsend> updateSku(WhOpstoreSkuDomain whOpstoreSkuDomain) {
        if (null == whOpstoreSkuDomain) {
            return null;
        }
        ArrayList<WhStoreSkuNumBean> whStoreSkuNumBeanList = new ArrayList<WhStoreSkuNumBean>();
        WhStoreSkuNumBean whStoreSkuNumBean = new WhStoreSkuNumBean();
        try {
            BeanUtils.copyAllPropertys((Object)whStoreSkuNumBean, (Object)whOpstoreSkuDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        whStoreSkuNumBean.setTenantCode(whOpstoreSkuDomain.getTenantCode());
        whStoreSkuNumBean.setGoodsEocode(whOpstoreSkuDomain.getGoodsEocode());
        whStoreSkuNumBean.setSkuEocode(whOpstoreSkuDomain.getSkuEocode());
        whStoreSkuNumBean.setGoodsNum(whOpstoreSkuDomain.getGoodsNum());
        whStoreSkuNumBean.setMemberCode(whOpstoreSkuDomain.getMemberCode());
        whStoreSkuNumBean.setMemberCcode(whOpstoreSkuDomain.getMemberCcode());
        whStoreSkuNumBeanList.add(whStoreSkuNumBean);
        return this.whStoreGoodsService.updateStoreSkuNum(whStoreSkuNumBeanList);
    }

    @Override
    public WhOpstoreSku getOpstoreSku(Integer opstoreSkuId) {
        if (null == opstoreSkuId) {
            return null;
        }
        return this.getOpstoreSkuModelById(opstoreSkuId);
    }

    @Override
    public void deleteOpstoreSku(Integer opstoreSkuId) throws ApiException {
        if (null == opstoreSkuId) {
            return;
        }
        this.deleteOpstoreSkuModel(opstoreSkuId);
    }

    @Override
    public QueryResult<WhOpstoreSku> queryOpstoreSkuPage(Map<String, Object> map) {
        List<WhOpstoreSku> whOpstoreSkuList = this.queryOpstoreSkuModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOpstoreSku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(whOpstoreSkuList);
        return queryResult;
    }

    @Override
    public WhOpstoreSku getOpstoreSkuByCode(String tenantCode, String opstoreSkuCode) throws ApiException {
        if (StringUtils.isBlank((String)opstoreSkuCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opstoreSkuCode", opstoreSkuCode);
        return this.getOpstoreSkuModelByCode(map);
    }

    @Override
    public void deleteOpstoreSkuByCode(String tenantCode, String opstoreSkuCode) throws ApiException {
        if (StringUtils.isBlank((String)opstoreSkuCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opstoreSkuCode", opstoreSkuCode);
        this.delOpstoreSkuModelByCode(map);
    }

    public void makeSkuNum(WhOpstoreDomain whOpstoreDomain, List<WhChannelsend> relist) {
        for (WhOpstoreGoodsDomain whOpstoreDo : whOpstoreDomain.getWhOpstoreGoodsDomainList()) {
            whOpstoreDo.getWhOpstoreSkuDomainList().get(0).getSkuNo();
            whOpstoreDomain.getWarehouseCode();
            HashMap<String, String> sendMap = new HashMap<String, String>();
            sendMap.put("skuNo", whOpstoreDo.getWhOpstoreSkuDomainList().get(0).getSkuNo());
            sendMap.put("tenantCode", whOpstoreDomain.getTenantCode());
            HashMap<String, Object> invokeQueryMap = new HashMap<String, Object>();
            invokeQueryMap.put("map", JsonUtil.buildNonNullBinder().toJson(sendMap));
            String skuList = this.internalInvoke("rs.sku.querySkuPage", invokeQueryMap);
            List rsSkuList = new ArrayList();
            if (StringUtils.isNotBlank((String)skuList)) {
                SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(skuList, SupQueryResult.class);
                rsSkuList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), RsSkuDomain.class);
                if (ListUtil.isEmpty(rsSkuList)) {
                    this.logger.error("wh.WhOpstoreServiceImpl.makeSkuNum", (Object)"rsSkuList is null");
                    return;
                }
            }
            sendMap.clear();
            invokeQueryMap.clear();
            sendMap.put("warehouseCode", whOpstoreDomain.getWarehouseCode());
            sendMap.put("tenantCode", whOpstoreDomain.getTenantCode());
            invokeQueryMap.put("map", JsonUtil.buildNonNullBinder().toJson(sendMap));
            String wareList = this.internalInvoke("wh.WhUserwh.queryUserwhPage", invokeQueryMap);
            List userwhList = new ArrayList();
            if (StringUtils.isNotBlank((String)wareList)) {
                SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(wareList, SupQueryResult.class);
                userwhList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), WhUserwh.class);
                if (ListUtil.isEmpty(userwhList)) {
                    this.logger.error("wh.WhOpstoreServiceImpl.makeSkuNum", (Object)"userwhList is null");
                    return;
                }
            }
            ArrayList<RsSkuDomain> list = new ArrayList<RsSkuDomain>();
            ArrayList<Integer> idList = new ArrayList<Integer>();
            block1: for (WhUserwh userwh : userwhList) {
                for (RsSkuDomain skuDomain : rsSkuList) {
                    if (!StringUtils.isNotBlank((String)skuDomain.getChannelCode()) || !skuDomain.getChannelCode().equals(userwh.getChannelCode())) continue;
                    BigDecimal num = skuDomain.getGoodsNum().subtract(skuDomain.getGoodsSupplynum());
                    BigDecimal supplyNum = whOpstoreDo.getGoodsNum().subtract(num);
                    skuDomain.setGoodsSupplynum(supplyNum);
                    skuDomain.setGoodsNum(whOpstoreDo.getGoodsNum());
                    list.add(skuDomain);
                    idList.add(skuDomain.getSkuId());
                    continue block1;
                }
            }
            HashMap<String, String> paramList = new HashMap<String, String>();
            paramList.put("skuList", JsonUtil.buildNonDefaultBinder().toJson(list));
            this.internalInvoke("rs.sku.updateSkuList", paramList);
            ArrayList<Integer> idShelList = new ArrayList<Integer>();
            for (RsSkuDomain skuDomain : list) {
                if (!"1".equals(String.valueOf(skuDomain.getDataOpbillstate()))) continue;
                idShelList.add(skuDomain.getSkuId());
            }
            invokeQueryMap.clear();
            invokeQueryMap.put("skuIdList", idShelList);
            this.internalInvoke("rs.resource.sendUpdateSoldOutBatchSku", invokeQueryMap);
            invokeQueryMap.clear();
            invokeQueryMap.put("skuIdList", idList);
            this.internalInvoke("rs.resource.sendUpdateShelveBatchSku", invokeQueryMap);
            if (!ListUtil.isNotEmpty(relist)) continue;
            relist = null;
        }
    }

    @Override
    public List<WhChannelsend> saveOpstoreByOpCode(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        WhOpstore whOpstore = this.createWhOpstore(whOpstoreDomain);
        this.saveOpstoreModel(whOpstore);
        this.saveWhOpstoreGoodsDomainListByOpCode(whOpstoreDomain);
        WhOpstore whOpstore1 = this.getOpstoreByCode(whOpstore.getTenantCode(), whOpstore.getOpstoreCode());
        if (null == whOpstore1) {
            this.logger.error("wh.WhOpstoreServiceImpl.saveOpstoreByOpCode", (Object)"whOpstore1 is null");
            throw new ApiException("wh.WhOpstoreServiceImpl.saveOpstoreByOpCode", "\u6dfb\u52a0\u5165\u5e93\u5355\u5931\u8d25");
        }
        WhOpstoreReDomain whOpstoreReDomain = this.makeWhOpstoreReDomain(whOpstore1);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", whOpstore.getTenantCode());
        map.put("opstoreCode", whOpstore.getOpstoreCode());
        List<WhOpstoreGoods> list = this.queryOpstoreGoodsModelPage(map);
        if (ListUtil.isEmpty(list)) {
            this.logger.error("wh.WhOpstoreServiceImpl.saveOpstoreByOpCode", (Object)"list is null");
            throw new ApiException("wh.WhOpstoreServiceImpl.saveOpstoreByOpCode", "\u6dfb\u52a0\u5165\u5e93\u5355\u5931\u8d251");
        }
        List<WhOpstoreGoodsDomain> whOpstoreGoodsReDomains = this.makeWhOpstoreGoodsDomainList(list);
        whOpstoreReDomain.setWhOpstoreGoodsDomainList(whOpstoreGoodsReDomains);
        return this.saveSend(whOpstoreReDomain, "add");
    }

    private List<WhChannelsend> saveSend(WhOpstoreReDomain whOpstoreReDomain, String chanelsendDir) {
        if (null == whOpstoreReDomain) {
            return null;
        }
        ArrayList<WhChannelsendDomain> atChannelsendDomainList = new ArrayList<WhChannelsendDomain>();
        WhChannelsendDomain atChannelsendDomain = new WhChannelsendDomain();
        atChannelsendDomainList.add(atChannelsendDomain);
        atChannelsendDomain.setChannelsendDir(chanelsendDir);
        atChannelsendDomain.setChannelsendOpcode(whOpstoreReDomain.getOpstoreCode());
        atChannelsendDomain.setChannelsendType("whOpstoreDomain");
        atChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)whOpstoreReDomain));
        atChannelsendDomain.setTenantCode(whOpstoreReDomain.getTenantCode());
        return this.whChannelsendService.saveChannelsendBatch(atChannelsendDomainList);
    }

    private List<WhChannelsend> saveWhOpstoreGoodsDomainListByOpCode(WhOpstoreDomain whOpstoreDomain) {
        if (null == whOpstoreDomain || ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
            this.logger.error("wh.WhOpstoreServiceImpl.saveWhOpstoreGoodsDomainList", (Object)"whOpstoreDomain.getWhOpstoreGoodsDomainList()");
            return null;
        }
        ArrayList<WhChannelsend> relist = new ArrayList<WhChannelsend>();
        for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreDomain.getWhOpstoreGoodsDomainList()) {
            whOpstoreGoodsDomain.setOperatorCode(whOpstoreDomain.getOperatorCode());
            whOpstoreGoodsDomain.setOpstoreCode(whOpstoreDomain.getOpstoreCode());
            whOpstoreGoodsDomain.setTenantCode(whOpstoreDomain.getTenantCode());
            whOpstoreGoodsDomain.setWarehouseCode(whOpstoreDomain.getWarehouseCode());
            whOpstoreGoodsDomain.setWarehouseName(whOpstoreDomain.getWarehouseName());
            List<WhChannelsend> list = this.saveOpstoreGoodsByOpCode(whOpstoreGoodsDomain);
            if (!ListUtil.isNotEmpty(list)) continue;
            relist.addAll(list);
        }
        return relist;
    }

    @Override
    public List<WhChannelsend> saveOpstoreGoodsByOpCode(WhOpstoreGoodsDomain whOpstoreGoodsDomain) throws ApiException {
        WhOpstoreGoods whOpstoreGoods = this.createWhOpstoreGoods(whOpstoreGoodsDomain);
        this.saveOpstoreGoodsModel(whOpstoreGoods);
        this.saveWhOpstoreSkuDomainList(whOpstoreGoodsDomain);
        return null;
    }

    private void saveWhStoreGoodsDomainStr(WhOpstoreGoodsDomain whOpstoreGoodsDomain) {
        if (null == whOpstoreGoodsDomain) {
            return;
        }
        WhStoreGoodsDomain whStoreGoodsDomain = new WhStoreGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whStoreGoodsDomain, (Object)whOpstoreGoodsDomain);
        }
        catch (Exception e) {
            this.logger.error("wh.WhOpstoreServiceImplsaveWhStoreGoodsDomainStr", (Throwable)e);
        }
        if (ListUtil.isNotEmpty(whOpstoreGoodsDomain.getWhOpstoreSkuDomainList())) {
            ArrayList<WhStoreSkuDomain> whStoreSkuDomainList = new ArrayList<WhStoreSkuDomain>();
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreGoodsDomain.getWhOpstoreSkuDomainList()) {
                WhStoreSkuDomain whStoreSkuDomain = new WhStoreSkuDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)whStoreSkuDomain, (Object)whOpstoreSkuDomain);
                    whStoreSkuDomainList.add(whStoreSkuDomain);
                }
                catch (Exception e) {
                    this.logger.error("wh.WhOpstoreServiceImplsaveWhStoreGoodsDomainStr", (Throwable)e);
                }
            }
            whStoreGoodsDomain.setWhStoreSkuDomainList(whStoreSkuDomainList);
        }
        this.whStoreGoodsService.saveStoreGoodsSkusStr(whStoreGoodsDomain);
    }

    @Override
    public String saveStoreGoodsAndSkus(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (null == whOpstoreDomain) {
            this.logger.error("wh.WhOpstoreServiceImpl.saveStoreGoodsAndSkus", (Object)"whOpstoreDomain is null");
            return null;
        }
        List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
        if (ListUtil.isEmpty(whOpstoreGoodsDomainList)) {
            this.logger.error("wh.WhOpstoreServiceImpl.saveStoreGoodsAndSkus", (Object)"whOpstoreGoodsDomainList is null");
            return null;
        }
        for (WhOpstoreGoodsDomain whOpstoreGoods : whOpstoreGoodsDomainList) {
            this.saveWhStoreGoodsDomainStr(whOpstoreGoods);
        }
        return "success";
    }

    private List<WhOpstoreGoodsDomain> makeWhOpstoreGoodsDomainList(List<WhOpstoreGoods> List2) {
        if (ListUtil.isEmpty(List2)) {
            return null;
        }
        ArrayList<WhOpstoreGoodsDomain> relist = new ArrayList<WhOpstoreGoodsDomain>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<WhOpstoreSku> skuList = null;
        for (WhOpstoreGoods whOpstoreGoods : List2) {
            WhOpstoreGoodsDomain whOpstoreGoodsDomain = new WhOpstoreGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)whOpstoreGoodsDomain, (Object)whOpstoreGoods);
            }
            catch (Exception exception) {
                // empty catch block
            }
            map.put("tenantCode", whOpstoreGoods.getTenantCode());
            map.put("opstoreCode", whOpstoreGoods.getOpstoreCode());
            map.put("opstoreGoodsCode", whOpstoreGoods.getOpstoreGoodsCode());
            skuList = this.queryOpstoreSkuModelPage(map);
            whOpstoreGoodsDomain.setWhOpstoreSkuDomainList(this.makeWhOpstoreSkuDomainList(skuList));
            relist.add(whOpstoreGoodsDomain);
        }
        return relist;
    }

    private List<WhOpstoreSkuDomain> makeWhOpstoreSkuDomainList(List<WhOpstoreSku> List2) {
        if (ListUtil.isEmpty(List2)) {
            return null;
        }
        ArrayList<WhOpstoreSkuDomain> relist = new ArrayList<WhOpstoreSkuDomain>();
        for (WhOpstoreSku whOpstoreSku : List2) {
            WhOpstoreSkuDomain whOpstoreSkuDomain = new WhOpstoreSkuDomain();
            try {
                BeanUtils.copyAllPropertys((Object)whOpstoreSkuDomain, (Object)whOpstoreSku);
            }
            catch (Exception exception) {
                // empty catch block
            }
            relist.add(whOpstoreSkuDomain);
        }
        return relist;
    }

    @Override
    public String deliveryStoreGoods(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (null == whOpstoreDomain) {
            this.logger.error("wh.WhOpstoreServiceImpl.deliveryStoreGoods", (Object)"whOpstoreDomain is null");
            return null;
        }
        List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
        if (ListUtil.isEmpty(whOpstoreGoodsDomainList)) {
            this.logger.error("wh.WhOpstoreServiceImpl.deliveryStoreGoods", (Object)"whOpstoreGoodsDomainList is null");
            return null;
        }
        for (WhOpstoreGoodsDomain whOpstoreGoods : whOpstoreGoodsDomainList) {
            this.deliveryWhStoreGoodsDomainStr(whOpstoreGoods);
        }
        return "success";
    }

    private void deliveryWhStoreGoodsDomainStr(WhOpstoreGoodsDomain whOpstoreGoodsDomain) {
        if (null == whOpstoreGoodsDomain) {
            return;
        }
        WhStoreGoodsDomain whStoreGoodsDomain = new WhStoreGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whStoreGoodsDomain, (Object)whOpstoreGoodsDomain);
        }
        catch (Exception e) {
            this.logger.error("wh.WhOpstoreServiceImpldeliveryWhStoreGoodsDomainStr", (Throwable)e);
        }
        if (ListUtil.isNotEmpty(whOpstoreGoodsDomain.getWhOpstoreSkuDomainList())) {
            ArrayList<WhStoreSkuDomain> whStoreSkuDomainList = new ArrayList<WhStoreSkuDomain>();
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreGoodsDomain.getWhOpstoreSkuDomainList()) {
                WhStoreSkuDomain whStoreSkuDomain = new WhStoreSkuDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)whStoreSkuDomain, (Object)whOpstoreSkuDomain);
                    whStoreSkuDomainList.add(whStoreSkuDomain);
                }
                catch (Exception e) {
                    this.logger.error("wh.WhOpstoreServiceImpldeliveryWhStoreGoodsDomainStr", (Throwable)e);
                }
            }
            whStoreGoodsDomain.setWhStoreSkuDomainList(whStoreSkuDomainList);
        }
        this.whStoreGoodsService.deliveryStoreGoodsSkusStr(whStoreGoodsDomain);
    }

    @Override
    public String updateResourceGoodsAndSkuNum(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        List<ResourceStockDomain> resourceStockDomainList = new ArrayList<ResourceStockDomain>();
        if (ListUtil.isEmpty(resourceStockDomainList = this.makeOpstoreResource(whOpstoreDomain, resourceStockDomainList))) {
            this.logger.error("wh.WhOpstoreServiceImpl.saveStoreGoodsAndSkus", (Object)"resourceStockDomainList is null");
            return null;
        }
        if (ListUtil.isNotEmpty(resourceStockDomainList)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("resourceGoodsList", JsonUtil.buildNormalBinder().toJson(resourceStockDomainList));
            this.internalInvoke("rs.resource.updateResourceStockChannelByBackStr", map);
        }
        return "success";
    }

    public List<ResourceStockDomain> makeOpstoreResource(WhOpstoreDomain whOpstoreDomain, List<ResourceStockDomain> resourceStockDomainList) {
        if (null == whOpstoreDomain) {
            this.logger.error("wh.WhOpstoreServiceImpl.saveStoreGoodsAndSkus", (Object)"whOpstoreDomain is null");
            return null;
        }
        List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
        if (ListUtil.isEmpty(whOpstoreGoodsDomainList)) {
            this.logger.error("wh.WhOpstoreServiceImpl.saveStoreGoodsAndSkus", (Object)"whOpstoreGoodsDomainList is null");
            return null;
        }
        for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            String apiCode = "rs.resourceGoods.queryRsGoodsSkuPage";
            paramMap.put("tenantCode", whOpstoreGoodsDomain.getTenantCode());
            paramMap.put("goodsNo", whOpstoreGoodsDomain.getGoodsNo());
            paramMap.put("memberCode", whOpstoreDomain.getMemberCode());
            HashMap<String, String> sendmap = new HashMap<String, String>();
            sendmap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
            String resourceJson = this.internalInvoke(apiCode, sendmap);
            if (StringUtils.isBlank((String)resourceJson)) {
                this.logger.error("wh.WhOpstoreServiceImpl.updateResourceGoodsAndSkuNum", (Object)"resourceJson is null");
                continue;
            }
            SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(resourceJson, SupQueryResult.class);
            if (null == supQueryResult) {
                this.logger.error("wh.WhOpstoreServiceImpl.updateResourceGoodsAndSkuNum", (Object)"supQueryResult is null");
                continue;
            }
            List resourceGoodsDomainList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), RsResourceGoodsDomain.class);
            if (ListUtil.isEmpty((Collection)resourceGoodsDomainList)) {
                this.logger.error("wh.WhOpstoreServiceImpl.updateResourceGoodsAndSkuNum", (Object)"resourceGoodsDomainList is null");
                continue;
            }
            if (ListUtil.isEmpty(whOpstoreGoodsDomain.getWhOpstoreSkuDomainList())) {
                this.logger.error("wh.WhOpstoreServiceImpl.updateResourceGoodsAndSkuNum", (Object)"whOpstoreSkuDomainList is null");
                return null;
            }
            ResourceStockDomain resourceStockDomain = new ResourceStockDomain();
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreGoodsDomain.getWhOpstoreSkuDomainList()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("tenantCode", whOpstoreSkuDomain.getTenantCode());
                map.put("skuNo", whOpstoreSkuDomain.getSkuNo());
                map.put("memberCode", whOpstoreDomain.getMemberCode());
                HashMap<String, String> sendMap = new HashMap<String, String>();
                sendMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
                this.logger.error("sendMap----" + JsonUtil.buildNormalBinder().toJson(sendMap));
                String skuJson = this.internalInvoke("rs.sku.querySkuOnePage", sendMap);
                if (StringUtils.isBlank((String)skuJson)) {
                    this.logger.error("wh.WhOpstoreServiceImpl.updateResourceGoodsAndSkuNum", (Object)"skuJson is null");
                    continue;
                }
                this.logger.error("skuJson----" + JsonUtil.buildNormalBinder().toJson((Object)skuJson));
                SupQueryResult supQueryResu = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(skuJson, SupQueryResult.class);
                List rsSkuDomainList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResu.getList()), RsSkuDomain.class);
                if (ListUtil.isEmpty((Collection)rsSkuDomainList)) {
                    this.logger.error("wh.WhOpstoreServiceImpl.updateResourceGoodsAndSkuNum", (Object)"rsSkuDomainList is null");
                    continue;
                }
                RsSkuDomain rsSkuDomain = (RsSkuDomain)rsSkuDomainList.get(0);
                try {
                    BeanUtils.copyAllPropertys((Object)resourceStockDomain, (Object)rsSkuDomain);
                    resourceStockDomain.setGoodsNum(whOpstoreSkuDomain.getGoodsNum());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                resourceStockDomainList.add(resourceStockDomain);
            }
        }
        return resourceStockDomainList;
    }

    @Override
    public String deliveryResourceGoodsAndSkuNum(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        List<ResourceStockDomain> resourceStockDomainList = new ArrayList<ResourceStockDomain>();
        if (ListUtil.isEmpty(resourceStockDomainList = this.makeOpstoreResource(whOpstoreDomain, resourceStockDomainList))) {
            this.logger.error("wh.WhOpstoreServiceImpl.saveStoreGoodsAndSkus", (Object)"resourceStockDomainList is null");
            return null;
        }
        if (ListUtil.isNotEmpty(resourceStockDomainList)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("resourceGoodsList", JsonUtil.buildNormalBinder().toJson(resourceStockDomainList));
            this.internalInvoke("rs.resource.sendUpdateResourceStockChannelByOrderStr", map);
        }
        return "success";
    }

    @Override
    public String lockStoreGoodsAndSkus(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (null == whOpstoreDomain) {
            this.logger.error("wh.WhOpstoreServiceImpl.deliveryStoreGoods", (Object)"whOpstoreDomain is null");
            return null;
        }
        List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
        if (ListUtil.isEmpty(whOpstoreGoodsDomainList)) {
            this.logger.error("wh.WhOpstoreServiceImpl.deliveryStoreGoods", (Object)"whOpstoreGoodsDomainList is null");
            return null;
        }
        for (WhOpstoreGoodsDomain whOpstoreGoods : whOpstoreGoodsDomainList) {
            whOpstoreGoods.setGoodsSpec("15");
            this.deliveryWhStoreGoodsDomainStr(whOpstoreGoods);
        }
        return "success";
    }

    @Override
    public String addLockStoreGoodsAndSkus(WhOpstoreDomain whOpstoreDomain) throws ApiException {
        if (null == whOpstoreDomain) {
            this.logger.error("wh.WhOpstoreServiceImpl.deliveryStoreGoods", (Object)"whOpstoreDomain is null");
            return null;
        }
        List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
        if (ListUtil.isEmpty(whOpstoreGoodsDomainList)) {
            this.logger.error("wh.WhOpstoreServiceImpl.deliveryStoreGoods", (Object)"whOpstoreGoodsDomainList is null");
            return null;
        }
        for (WhOpstoreGoodsDomain whOpstoreGoods : whOpstoreGoodsDomainList) {
            whOpstoreGoods.setGoodsSpec("16");
            this.deliveryWhStoreGoodsDomainStr(whOpstoreGoods);
        }
        return "success";
    }

    @Override
    public void updateOpStoreSkuDomainByCode(WhOpstoreSkuDomain whOpstoreSkuDomain) throws ApiException {
        if (null == whOpstoreSkuDomain) {
            this.logger.error("wh.WhOpstoreServiceImpl.updateOpStoreSkuDomainByCode.null", (Object)"param is null");
            throw new ApiException("updateOpStoreSkuDomainByCode.null");
        }
        WhOpstoreSku whOpstoreSku = this.makeOpstoreSku(whOpstoreSkuDomain, null);
        this.updateOpstoreSkuModel(whOpstoreSku);
    }

    @Override
    public void outPutAndInPutOfWarehouse(List<StockDomain> stockDomainList, String goodsContract) throws ApiException {
        try {
            if (CollectionUtils.isEmpty(stockDomainList)) {
                throw new ApiException("\u672a\u83b7\u53d6\u5230\u5546\u54c1\u660e\u7ec6");
            }
            WhOpstoreDomain whOpstoreDomain = new WhOpstoreDomain();
            whOpstoreDomain.setGoodsContract(goodsContract);
            whOpstoreDomain.setOpstoreRemark("ERP\u63a8\u9001");
            whOpstoreDomain.setStoreGoodsType("2");
            whOpstoreDomain.setWhOpstoreSkuDomainList(new ArrayList<WhOpstoreSkuDomain>());
            boolean isFirst = true;
            for (StockDomain stockDomain : stockDomainList) {
                this.outPutAndInPutOfWarehouseValid(stockDomain);
                HashMap<String, String> skuNoMap = new HashMap<String, String>();
                HashMap<String, String> skuNoMapStr = new HashMap<String, String>();
                skuNoMap.put("tenantCode", stockDomain.getTenantCode());
                skuNoMap.put("skuCode", stockDomain.getSkuCode());
                skuNoMapStr.put("map", JsonUtil.buildNonDefaultBinder().toJson(skuNoMap));
                String s = this.internalInvoke("rs.sku.getSkuByCode", skuNoMapStr);
                RsSku rsSku = (RsSku)JsonUtil.buildNormalBinder().getJsonToObject(s, RsSku.class);
                if (null == rsSku) {
                    this.logger.error("wh.WhOpstoreServiceImpl.outPutAndInPutOfWarehouse.rsSku", (Object)"rsSku is null");
                    throw new ApiException("\u672a\u83b7\u53d6\u5230SKU\u4fe1\u606f");
                }
                HashMap<String, Object> whOpstoreSkuPram = new HashMap<String, Object>();
                whOpstoreSkuPram.put("warehouseCode", stockDomain.getWarehouseCode());
                whOpstoreSkuPram.put("tenantCode", stockDomain.getTenantCode());
                WhWarehouse whWarehouse = this.whWarehouseMapper.getByCode(whOpstoreSkuPram);
                if (Objects.isNull(whWarehouse)) {
                    throw new ApiException("\u672a\u83b7\u53d6\u5230\u4ed3\u5e93\u4fe1\u606f");
                }
                if (isFirst) {
                    whOpstoreDomain.setStoreGoodsBtype(stockDomain.getType());
                    whOpstoreDomain.setMemberCode(stockDomain.getMemberCode());
                    whOpstoreDomain.setMemberName(stockDomain.getMemberName());
                    whOpstoreDomain.setMemberCcode(stockDomain.getMemberCcode());
                    whOpstoreDomain.setMemberCname(stockDomain.getMemberCname());
                    whOpstoreDomain.setTenantCode(stockDomain.getTenantCode());
                    isFirst = false;
                }
                whOpstoreDomain.getWhOpstoreSkuDomainList().add(new WhOpstoreSkuDomain(rsSku, stockDomain, whWarehouse));
            }
            String msg = this.make(whOpstoreDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                throw new ApiException(msg);
            }
            this.whStoreGoodsBaseService.sendSaveOpstore(whOpstoreDomain);
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreDomain.getWhOpstoreSkuDomainList()) {
                BigDecimal goodsNum = whOpstoreSkuDomain.getGoodsNum().abs();
                if (Arrays.asList("SL02").contains(whOpstoreSkuDomain.getStoreGoodsBtype())) {
                    goodsNum = goodsNum.negate();
                }
                this.whStoreGoodsService.modifyStoreSkuNumByWarehouse(whOpstoreSkuDomain.getTenantCode(), whOpstoreSkuDomain.getSkuCode(), whOpstoreSkuDomain.getWarehouseCode(), whOpstoreSkuDomain.getOpstoreGoodsEocode(), goodsNum);
            }
        }
        catch (Exception e) {
            this.logger.error("wh.WhOpstoreServiceImpl.outPutAndInPutOfWarehouse", (Throwable)e);
            throw new ApiException("\u51fa\u5165\u5e93\u5355\u751f\u6210\u5931\u8d25: " + e.getMessage());
        }
    }

    private void outPutAndInPutOfWarehouseValid(StockDomain stockDomain) {
        if (StringUtils.isBlank((String)stockDomain.getSkuCode())) {
            throw new ApiException("\u672a\u83b7\u53d6\u5230SKU\u7f16\u7801");
        }
        if (StringUtils.isBlank((String)stockDomain.getWarehouseCode())) {
            throw new ApiException("\u672a\u83b7\u53d6\u5230\u4ed3\u5e93\u7f16\u7801");
        }
        if (StringUtils.isBlank((String)stockDomain.getTenantCode())) {
            throw new ApiException("\u672a\u83b7\u53d6\u5230\u5546\u6237\u53f7");
        }
        if (Objects.isNull(stockDomain.getGoodsNum())) {
            throw new ApiException("\u672a\u83b7\u53d6\u5230\u51fa\u5165\u5e93\u6570\u91cf");
        }
    }

    private String make(WhOpstoreDomain whOpstoreDomain) {
        if (null == whOpstoreDomain) {
            return "error";
        }
        if (ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreSkuDomainList()) && ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
            return "error";
        }
        if (ListUtil.isNotEmpty(whOpstoreDomain.getWhOpstoreSkuDomainList()) && ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
            HashMap<String, WhOpstoreGoodsDomain> goodsmap = new HashMap<String, WhOpstoreGoodsDomain>();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("tenantCode", whOpstoreDomain.getTenantCode());
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreDomain.getWhOpstoreSkuDomainList()) {
                List<WhOpstoreSkuDomain> whOpstoreSkuDomainList;
                WhOpstoreGoodsDomain whOpstoreGoodsDomain = (WhOpstoreGoodsDomain)goodsmap.get(whOpstoreSkuDomain.getGoodsCode());
                if (null == whOpstoreGoodsDomain) {
                    HashMap<String, String> paramMap = new HashMap<String, String>();
                    paramMap.put("goodsCode", whOpstoreSkuDomain.getGoodsCode());
                    paramMap.put("tenantCode", whOpstoreSkuDomain.getTenantCode());
                    RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)this.readObj("rs.resourceGoods.getResourceGoodsByCodeStr", paramMap, "object", new Object[]{RsResourceGoodsReDomain.class});
                    whOpstoreGoodsDomain = new WhOpstoreGoodsDomain();
                    try {
                        org.springframework.beans.BeanUtils.copyProperties((Object)rsResourceGoodsReDomain, (Object)whOpstoreGoodsDomain);
                    }
                    catch (Exception e) {
                        return "error1:" + ((Object)map).toString();
                    }
                    goodsmap.put(whOpstoreSkuDomain.getGoodsCode(), whOpstoreGoodsDomain);
                }
                if (null == (whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList())) {
                    whOpstoreSkuDomainList = new ArrayList<WhOpstoreSkuDomain>();
                    whOpstoreGoodsDomain.setWhOpstoreSkuDomainList(whOpstoreSkuDomainList);
                }
                whOpstoreSkuDomainList.add(whOpstoreSkuDomain);
            }
            if (MapUtil.isEmpty(goodsmap)) {
                return "error3";
            }
            ArrayList<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = new ArrayList<WhOpstoreGoodsDomain>();
            for (String goodsCode : goodsmap.keySet()) {
                whOpstoreGoodsDomainList.add((WhOpstoreGoodsDomain)goodsmap.get(goodsCode));
            }
            whOpstoreDomain.setWhOpstoreGoodsDomainList(whOpstoreGoodsDomainList);
        }
        BigDecimal num = BigDecimal.ZERO;
        BigDecimal weight = BigDecimal.ZERO;
        BigDecimal amt = BigDecimal.ZERO;
        BigDecimal mainnum = BigDecimal.ZERO;
        BigDecimal mainweight = BigDecimal.ZERO;
        BigDecimal mainamt = BigDecimal.ZERO;
        for (WhOpstoreGoodsDomain whOpstoreGoodsReDomain : whOpstoreDomain.getWhOpstoreGoodsDomainList()) {
            num = BigDecimal.ZERO;
            weight = BigDecimal.ZERO;
            amt = BigDecimal.ZERO;
            for (WhOpstoreSkuDomain whOpstoreSkuReDomain : whOpstoreGoodsReDomain.getWhOpstoreSkuDomainList()) {
                if (null == whOpstoreSkuReDomain.getGoodsNum()) {
                    whOpstoreSkuReDomain.setGoodsNum(BigDecimal.ZERO);
                }
                if (null == whOpstoreSkuReDomain.getGoodsWeight()) {
                    whOpstoreSkuReDomain.setGoodsWeight(BigDecimal.ZERO);
                }
                if (null == whOpstoreSkuReDomain.getPricesetNprice()) {
                    whOpstoreSkuReDomain.setPricesetNprice(BigDecimal.ZERO);
                }
                num = num.add(whOpstoreSkuReDomain.getGoodsNum());
                weight = weight.add(whOpstoreSkuReDomain.getGoodsWeight());
                amt = amt.add(whOpstoreSkuReDomain.getPricesetNprice().multiply(whOpstoreSkuReDomain.getGoodsNum()));
                if (!StringUtils.isNotBlank((String)whOpstoreDomain.getStoreGoodsType())) continue;
                whOpstoreSkuReDomain.setStoreGoodsType(whOpstoreDomain.getStoreGoodsType());
            }
            whOpstoreGoodsReDomain.setGoodsNum(num);
            whOpstoreGoodsReDomain.setGoodsWeight(weight);
            mainnum = mainnum.add(num);
            mainweight = mainweight.add(weight);
            mainamt = mainamt.add(amt);
        }
        whOpstoreDomain.setGoodsNum(mainnum);
        whOpstoreDomain.setGoodsWeight(mainweight);
        whOpstoreDomain.setGoodsAmt(mainamt);
        return null;
    }
}

