/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.warehouse.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.warehouse.dao.WhShippingMapper;
import com.yqbsoft.laser.service.warehouse.domain.WhShippingDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhShippingReDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhShippingSendgoodsReDomain;
import com.yqbsoft.laser.service.warehouse.model.WhShipping;
import com.yqbsoft.laser.service.warehouse.service.WhShippingSendgoodsService;
import com.yqbsoft.laser.service.warehouse.service.WhShippingService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class WhShippingServiceImpl
extends BaseServiceImpl
implements WhShippingService {
    private static final String SYS_CODE = "wh.WhShippingServiceImpl";
    private WhShippingMapper whShippingMapper;
    private WhShippingSendgoodsService whShippingSendgoodsService;

    public void setWhShippingMapper(WhShippingMapper whShippingMapper) {
        this.whShippingMapper = whShippingMapper;
    }

    public void setWhShippingSendgoodsService(WhShippingSendgoodsService whShippingSendgoodsService) {
        this.whShippingSendgoodsService = whShippingSendgoodsService;
    }

    private Date getSysDate() {
        try {
            return this.whShippingMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("wh.WhShippingServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkWhShipping(WhShippingDomain whShippingDomain) {
        if (null == whShippingDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)whShippingDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setWhShippingDefault(WhShipping whShipping) {
        if (null == whShipping) {
            return;
        }
        if (null == whShipping.getDataState()) {
            whShipping.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == whShipping.getGmtCreate()) {
            whShipping.setGmtCreate(date);
        }
        whShipping.setGmtModified(date);
        if (StringUtils.isBlank((String)whShipping.getShippingCode())) {
            whShipping.setShippingCode(this.getNo(null, "WhShipping", "whShipping", whShipping.getTenantCode()));
        }
    }

    private int getWhShippingMaxCode() {
        int code = 0;
        try {
            return this.whShippingMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wh.WhShippingServiceImpl.getWhShippingMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setWhShippingUpdataDefault(WhShipping whShipping) {
        if (null == whShipping) {
            return;
        }
        whShipping.setGmtModified(this.getSysDate());
    }

    private void saveWhShippingModel(WhShipping whShipping) throws ApiException {
        if (null == whShipping) {
            return;
        }
        try {
            this.whShippingMapper.insert(whShipping);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhShippingServiceImpl.saveWhShippingModel.ex", (Throwable)e);
        }
    }

    private void saveWhShippingBatchModel(List<WhShipping> whShippingList) throws ApiException {
        if (null == whShippingList || whShippingList.isEmpty()) {
            return;
        }
        try {
            this.whShippingMapper.insertBatch(whShippingList);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhShippingServiceImpl.saveWhShippingBatchModel.ex", (Throwable)e);
        }
    }

    private WhShipping getWhShippingModelById(Integer whShippingId) {
        if (null == whShippingId) {
            return null;
        }
        try {
            return this.whShippingMapper.selectByPrimaryKey(whShippingId);
        }
        catch (Exception e) {
            this.logger.error("wh.WhShippingServiceImpl.getWhShippingModelById", (Throwable)e);
            return null;
        }
    }

    private WhShipping getWhShippingModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.whShippingMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhShippingServiceImpl.getWhShippingModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delWhShippingModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.whShippingMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhShippingServiceImpl.delWhShippingModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhShippingServiceImpl.delWhShippingModelByCode.num");
        }
    }

    private void deleteWhShippingModel(Integer whShippingId) throws ApiException {
        if (null == whShippingId) {
            return;
        }
        int i = 0;
        try {
            i = this.whShippingMapper.deleteByPrimaryKey(whShippingId);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhShippingServiceImpl.deleteWhShippingModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhShippingServiceImpl.deleteWhShippingModel.num");
        }
    }

    private void updateWhShippingModel(WhShipping whShipping) throws ApiException {
        if (null == whShipping) {
            return;
        }
        int i = 0;
        try {
            i = this.whShippingMapper.updateByPrimaryKey(whShipping);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhShippingServiceImpl.updateWhShippingModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhShippingServiceImpl.updateWhShippingModel.num");
        }
    }

    private void updateStateWhShippingModel(Integer whShippingId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == whShippingId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("whShippingId", whShippingId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.whShippingMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhShippingServiceImpl.updateStateWhShippingModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhShippingServiceImpl.updateStateWhShippingModel.null");
        }
    }

    private void updateStateWhShippingModelByCode(String tenantCode, String whShippingCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)whShippingCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("whShippingCode", whShippingCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.whShippingMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhShippingServiceImpl.updateStateWhShippingModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhShippingServiceImpl.updateStateWhShippingModelByCode.null");
        }
    }

    private WhShipping makeWhShipping(WhShippingDomain whShippingDomain, WhShipping whShipping) {
        if (null == whShippingDomain) {
            return null;
        }
        if (null == whShipping) {
            whShipping = new WhShipping();
        }
        try {
            BeanUtils.copyAllPropertys((Object)whShipping, (Object)whShippingDomain);
            return whShipping;
        }
        catch (Exception e) {
            this.logger.error("wh.WhShippingServiceImpl.makeWhShipping", (Throwable)e);
            return null;
        }
    }

    private WhShippingReDomain makeWhShippingReDomain(WhShipping whShipping) {
        if (null == whShipping) {
            return null;
        }
        WhShippingReDomain whShippingReDomain = new WhShippingReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whShippingReDomain, (Object)whShipping);
            return whShippingReDomain;
        }
        catch (Exception e) {
            this.logger.error("wh.WhShippingServiceImpl.makeWhShippingReDomain", (Throwable)e);
            return null;
        }
    }

    private List<WhShipping> queryWhShippingModelPage(Map<String, Object> parammap) {
        try {
            return this.whShippingMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhShippingServiceImpl.queryWhShippingModel", (Throwable)e);
            return null;
        }
    }

    private int countWhShipping(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.whShippingMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhShippingServiceImpl.countWhShipping", (Throwable)e);
        }
        return i;
    }

    private WhShipping createWhShipping(WhShippingDomain whShippingDomain) {
        String msg = this.checkWhShipping(whShippingDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhShippingServiceImpl.saveWhShipping.checkWhShipping", msg);
        }
        WhShipping whShipping = this.makeWhShipping(whShippingDomain, null);
        this.setWhShippingDefault(whShipping);
        return whShipping;
    }

    @Override
    public String saveWhShipping(WhShippingDomain whShippingDomain) throws ApiException {
        if (CollectionUtils.isEmpty(whShippingDomain.getWhShippingSendgoodsReDomainList())) {
            throw new ApiException("wh.WhShippingServiceImpl.saveWhShipping.checkWhShipping", "\u8bf7\u9009\u62e9\u53d1\u8d27\u5355\u636e");
        }
        WhShipping whShipping = this.createWhShipping(whShippingDomain);
        this.saveWhShippingModel(whShipping);
        for (WhShippingSendgoodsReDomain whShippingSendgoodsReDomain : whShippingDomain.getWhShippingSendgoodsReDomainList()) {
            whShippingSendgoodsReDomain.setShippingCode(whShipping.getShippingCode());
            this.whShippingSendgoodsService.saveShippingSendgoods(whShippingSendgoodsReDomain);
        }
        return whShipping.getShippingCode();
    }

    @Override
    public String saveWhShippingBatch(List<WhShippingDomain> whShippingDomainList) throws ApiException {
        if (null == whShippingDomainList || whShippingDomainList.isEmpty()) {
            return null;
        }
        ArrayList<WhShipping> whShippingList = new ArrayList<WhShipping>();
        String code = "";
        for (WhShippingDomain whShippingDomain : whShippingDomainList) {
            WhShipping whShipping = this.createWhShipping(whShippingDomain);
            code = whShipping.getShippingCode();
            whShippingList.add(whShipping);
        }
        this.saveWhShippingBatchModel(whShippingList);
        return code;
    }

    @Override
    public void updateWhShippingState(Integer whShippingId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == whShippingId) {
            return;
        }
        this.updateStateWhShippingModel(whShippingId, dataState, oldDataState, map);
    }

    @Override
    public void updateWhShippingStateByCode(String tenantCode, String whShippingCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)whShippingCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateWhShippingModelByCode(tenantCode, whShippingCode, dataState, oldDataState, map);
    }

    @Override
    public void updateWhShipping(WhShippingDomain whShippingDomain) throws ApiException {
        String msg = this.checkWhShipping(whShippingDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhShippingServiceImpl.updateWhShipping.checkWhShipping", msg);
        }
        WhShipping oldWhShipping = this.getWhShippingModelById(whShippingDomain.getShippingId());
        if (null == oldWhShipping) {
            throw new ApiException("wh.WhShippingServiceImpl.updateWhShipping.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WhShipping whShipping = this.makeWhShipping(whShippingDomain, oldWhShipping);
        this.setWhShippingUpdataDefault(whShipping);
        this.updateWhShippingModel(whShipping);
    }

    @Override
    public WhShipping getWhShipping(Integer whShippingId) {
        if (null == whShippingId) {
            return null;
        }
        return this.getWhShippingModelById(whShippingId);
    }

    @Override
    public void deleteWhShipping(Integer whShippingId) throws ApiException {
        if (null == whShippingId) {
            return;
        }
        this.deleteWhShippingModel(whShippingId);
    }

    @Override
    public QueryResult<WhShipping> queryWhShippingPage(Map<String, Object> map) {
        List<WhShipping> whShippingList = this.queryWhShippingModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countWhShipping(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(whShippingList);
        return queryResult;
    }

    @Override
    public WhShipping getWhShippingByCode(String tenantCode, String whShippingCode) throws ApiException {
        if (StringUtils.isBlank((String)whShippingCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("whShippingCode", whShippingCode);
        return this.getWhShippingModelByCode(map);
    }

    @Override
    public void deleteWhShippingByCode(String tenantCode, String whShippingCode) throws ApiException {
        if (StringUtils.isBlank((String)whShippingCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("whShippingCode", whShippingCode);
        this.delWhShippingModelByCode(map);
    }
}

