/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.feign;

import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableCaching
public class RestTemplateConfig {
    @Value(value="${spring.restTemp.maxTotal:500}")
    private int maxTotal;
    @Value(value="${spring.restTemp.defaultMaxPerRoute:200}")
    private int defaultMaxPerRoute;
    @Value(value="${spring.restTemp.socketTimeout:30000}")
    private int socketTimeout;
    @Value(value="${spring.restTemp.connectTimeout:10000}")
    private int connectTimeout;
    @Value(value="${spring.restTemp.timeToLive:300}")
    private int timeToLive;
    @Value(value="${spring.restTemp.connectionRequestTimeout:10000}")
    private int connectionRequestTimeout;
    @Value(value="${spring.restTemp.retry:3}")
    private int retry;

    @Bean
    @LoadBalanced
    public RestTemplate restTemplate() {
        return new RestTemplate(this.httpRequestFactory());
    }

    @Bean
    public ClientHttpRequestFactory httpRequestFactory() {
        return new HttpComponentsClientHttpRequestFactory(this.httpClient());
    }

    @Bean
    public HttpClient httpClient() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager((long)this.timeToLive, TimeUnit.SECONDS);
        connectionManager.setMaxTotal(this.maxTotal);
        connectionManager.setDefaultMaxPerRoute(this.defaultMaxPerRoute);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.socketTimeout).setConnectTimeout(this.connectTimeout).setConnectionRequestTimeout(this.connectionRequestTimeout).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy()).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(this.retry, true)).build();
    }
}

