/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.http;

import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpUtil {
    public static final MediaType FORM_CONTENT_TYPE = MediaType.parse((String)"application/x-www-form-urlencoded;charset=utf-8");

    public static String httpGet(String url, Map<String, String> httpParam, String ctype, String charset, int connectTimeout, int readTimeout) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        if (MapUtil.isNotEmpty(httpParam)) {
            String pstr = "";
            for (String key : httpParam.keySet()) {
                if (StringUtils.isNotBlank((String)pstr)) {
                    pstr = pstr + "&";
                }
                pstr = pstr + key + "=" + httpParam.get(key);
            }
            url = url + "?" + pstr;
        }
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        Request request = new Request.Builder().url(url).get().addHeader("Content-Type", ctype).build();
        try {
            Response response = client.newCall(request).execute();
            return response.body().string();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void main(String[] args) {
        System.out.println(OkHttpUtil.httpPost("http", null, null, null, 0, 0));
    }

    public static String httpPost(String url, Map<String, String> httpParam, String ctype, String charset, int connectTimeout, int readTimeout) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        if (StringUtils.isBlank((String)charset)) {
            charset = "UTF-8";
        }
        StringBuffer sb = new StringBuffer();
        if (MapUtil.isNotEmpty(httpParam)) {
            for (String key : httpParam.keySet()) {
                sb.append(key + "=" + httpParam.get(key) + "&");
            }
        }
        RequestBody body = RequestBody.create((MediaType)FORM_CONTENT_TYPE, (String)sb.toString());
        Request request = new Request.Builder().post(body).addHeader("Content-Type", ctype).url(url).build();
        try {
            OkHttpClient mOkHttpClient = new OkHttpClient();
            Response response = mOkHttpClient.newCall(request).execute();
            return new String(response.body().bytes(), "utf-8");
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

