/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.mq;

import com.yqbsoft.laser.service.adapter.mq.ConsumerSession;
import com.yqbsoft.laser.service.adapter.mq.ProducerCall;
import com.yqbsoft.laser.service.adapter.mq.ProducerSession;
import com.yqbsoft.laser.service.adapter.mq.RepConsumerSession;
import com.yqbsoft.laser.service.adapter.mq.SupperConsumerSession;
import com.yqbsoft.laser.service.adapter.mq.SupperProducerSession;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.endpoint.AbstractEndpoint;
import com.yqbsoft.laser.service.esb.core.jms.JmsConnetService;
import com.yqbsoft.laser.service.esb.core.jms.JmsConstans;
import com.yqbsoft.laser.service.esb.core.jms.invo.ConnetBean;
import com.yqbsoft.laser.service.esb.core.jms.invo.ProducerSessionBean;
import com.yqbsoft.laser.service.esb.core.jms.invo.SessionBean;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.suppercore.point.RegeditUtil;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.pool.PooledConnection;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.springframework.stereotype.Service;

@Service(value="jmsConnetService")
public class JmsConnetServiceImpl
extends AbstractEndpoint
implements JmsConnetService {
    private static final String sys_code = "amq.ADAPTER.MQ.JmsConnetServiceImpl";
    private static final long serialVersionUID = -6744083091285460238L;
    public static Map<String, PooledConnection> connectionMap = new HashMap<String, PooledConnection>();
    public static Map<String, PooledConnectionFactory> pooledFactoryMap = new HashMap<String, PooledConnectionFactory>();
    public static Map<String, List<String>> sessionMap = new HashMap<String, List<String>>();
    public static Map<String, List<String>> consessionMap = new HashMap<String, List<String>>();
    public static Map<String, ProducerSession> producerSessionMap = new HashMap<String, ProducerSession>();
    public static Map<String, RepConsumerSession> repConsumerSessionMap = new HashMap<String, RepConsumerSession>();
    public static Map<String, ConsumerSession> consumerSessionMap = new HashMap<String, ConsumerSession>();
    public static Map<String, SupperProducerSession> repProducerSessionMap = new HashMap<String, SupperProducerSession>();
    private static int MAX_CONNECTIONS = 2000;
    private static int DEFAULT_MAXIMUM_ACTIVE_SESSION_PER_CONNECTION = 600;
    private static int DEFAULT_IDLETIMEOUT = 0;
    private Object obj = new Object();
    private Object obj1 = new Object();
    private Object obj2 = new Object();
    private Object sycCallobj = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doJmsStart(ConnetBean connetBean) {
        if (null == connetBean) {
            return;
        }
        Map<String, PooledConnection> map = connectionMap;
        synchronized (map) {
            if (null != connectionMap.get(connetBean.getName())) {
                this.doJmsStop(connetBean.getName());
            }
            if (StringUtils.isNotBlank((String)connetBean.getMqAppkey())) {
                connetBean.setBrokerURL(RegeditUtil.replaceUrl((String)connetBean.getMqAppkey(), (String)connetBean.getBrokerURL()));
            }
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(connetBean.getBrokerURL());
            connectionFactory.setTrustAllPackages(true);
            PooledConnectionFactory pooledFactory = new PooledConnectionFactory(connectionFactory);
            try {
                pooledFactory.setMaxConnections(MAX_CONNECTIONS);
                pooledFactory.setMaximumActiveSessionPerConnection(DEFAULT_MAXIMUM_ACTIVE_SESSION_PER_CONNECTION);
                pooledFactory.setIdleTimeout(DEFAULT_IDLETIMEOUT);
                PooledConnection connection = (PooledConnection)pooledFactory.createConnection();
                connection.setClientID(ServletMain.getAppKey() + UUID.randomUUID().toString());
                connection.setExceptionListener(new ExceptionListener(){

                    public void onException(JMSException arg0) {
                        JmsConnetServiceImpl.this.logger.error("amq.ADAPTER.MQ.JmsConnetServiceImpl.onException", (Throwable)arg0);
                        JmsConnetServiceImpl.this.doJmsStartAll();
                    }
                });
                connection.start();
                connectionMap.put(connetBean.getName(), connection);
                pooledFactoryMap.put(connetBean.getName(), pooledFactory);
                this.logger.info("doJmsStart", (Object)("MQ-connect:" + connetBean.getName() + ":" + connetBean.getBrokerURL() + "==\u542f\u52a8\u6210\u529f"));
            }
            catch (JMSException e) {
                this.logger.error("amq.ADAPTER.MQ.JmsConnetServiceImpl.doJmsStart", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doJmsStop(String connectName) {
        Map<String, List<String>> map = sessionMap;
        synchronized (map) {
            List<String> slist = sessionMap.get(connectName);
            if (null != slist && !slist.isEmpty()) {
                for (String string : slist) {
                    this.doJmsProducerSessionStop(string);
                }
            }
            sessionMap.remove(connectName);
            List<String> conslist = consessionMap.get(connectName);
            if (null != conslist && !conslist.isEmpty()) {
                for (String string : conslist) {
                    this.doJmsConsumerSessionStop(string);
                }
            }
            sessionMap.remove(connectName);
            try {
                connectionMap.get(connectName).stop();
                connectionMap.get(connectName).close();
                pooledFactoryMap.get(connectName).clear();
                pooledFactoryMap.get(connectName).stop();
                pooledFactoryMap.remove(connectName);
                connectionMap.remove(connectName);
            }
            catch (Exception exception) {
                this.logger.error("amq.ADAPTER.MQ.JmsConnetServiceImpl.doJmsStop", (Throwable)exception);
            }
        }
    }

    public void doJmsProducerSessionStop(String sessionName) {
        try {
            if (null != producerSessionMap.get(sessionName)) {
                this.close(producerSessionMap.get(sessionName));
                producerSessionMap.remove(sessionName);
            }
        }
        catch (Exception e) {
            this.logger.error("amq.ADAPTER.MQ.JmsConnetServiceImpl.doJmsProducerSessionStop", (Throwable)e);
        }
        try {
            if (null != repConsumerSessionMap.get(sessionName)) {
                this.closeCon(repConsumerSessionMap.get(sessionName));
                repConsumerSessionMap.remove(sessionName);
            }
        }
        catch (Exception e) {
            this.logger.error("amq.ADAPTER.MQ.JmsConnetServiceImpl.doRepConsumerSessionStop", (Throwable)e);
        }
    }

    private void close(SupperProducerSession producerSession) {
        try {
            producerSession.getProducer().close();
            producerSession.getSession().close();
        }
        catch (Exception e) {
            this.logger.error("amq.ADAPTER.MQ.JmsConnetServiceImpl.close.ProducerSession", (Throwable)e);
        }
    }

    private void closeCon(SupperConsumerSession consumerSession) {
        try {
            consumerSession.stopExecutorService();
            consumerSession.getConsumer().close();
            consumerSession.getSession().close();
            this.logger.info("amq.ADAPTER.MQ.JmsConnetServiceImpl.close.ConsumerSession.closeCon." + consumerSession.getName() + ".finish");
        }
        catch (Exception e) {
            this.logger.error("amq.ADAPTER.MQ.JmsConnetServiceImpl.close.ConsumerSession", (Throwable)e);
        }
    }

    public void doJmsConsumerSessionStop(String sessionName) {
        try {
            if (null != consumerSessionMap.get(sessionName)) {
                this.closeCon(consumerSessionMap.get(sessionName));
                consumerSessionMap.remove(sessionName);
            }
        }
        catch (Exception e) {
            this.logger.error("amq.ADAPTER.MQ.JmsConnetServiceImpl.doJmsConsumerSessionStop", (Throwable)e);
        }
        try {
            if (null != repProducerSessionMap.get(sessionName)) {
                this.close(repProducerSessionMap.get(sessionName));
                repProducerSessionMap.remove(sessionName);
            }
        }
        catch (Exception e) {
            this.logger.error("amq.ADAPTER.MQ.JmsConnetServiceImpl.doRepProducerSessionStop", (Throwable)e);
        }
    }

    public void createProducer(String connectName, ProducerSessionBean producerSessionBean) {
        PooledConnection connection;
        if (StringUtils.isEmpty((String)connectName) || null == producerSessionBean) {
            return;
        }
        if (null != producerSessionMap.get(producerSessionBean.getName())) {
            this.doJmsProducerSessionStop(producerSessionBean.getName());
        }
        if (null == (connection = connectionMap.get(connectName))) {
            return;
        }
        if (connection.getNumSessions() >= MAX_CONNECTIONS) {
            this.logger.error("amq.ADAPTER.MQ.JmsConnetServiceImpl.createProducer", (Object)(connection.getNumSessions() + ">=" + MAX_CONNECTIONS));
            return;
        }
        ProducerSession producerSession = new ProducerSession();
        producerSession.setConnection(connection);
        try {
            producerSession.setProducerSessionBean(producerSessionBean);
            producerSession.setSession(connection.createSession(producerSessionBean.isTransacted(), producerSessionBean.getAckMode()));
            Object adminQueue = null;
            adminQueue = JmsConstans.messageType_queue.equals(producerSessionBean.getMessageType()) ? producerSession.getSession().createQueue(producerSessionBean.getMessageName()) : (JmsConstans.messageType_topic.equals(producerSessionBean.getMessageType()) ? producerSession.getSession().createTopic(producerSessionBean.getMessageName()) : producerSession.getSession().createQueue(producerSessionBean.getMessageName()));
            producerSession.setProducer(producerSession.getSession().createProducer((Destination)adminQueue));
            producerSession.getProducer().setDeliveryMode(producerSessionBean.getDeliveryMode());
            producerSessionMap.put(producerSessionBean.getName(), producerSession);
            ArrayList<String> snamelist = new ArrayList<String>();
            if (StringUtils.isBlank((String)producerSessionBean.getReplyType()) || "1".equals(producerSessionBean.getReplyType())) {
                int maxnum = producerSessionBean.getMaximumPoolSize();
                if (maxnum == 0) {
                    maxnum = 5;
                }
                String sessionName = producerSessionBean.getName();
                for (int i = 0; i < maxnum; ++i) {
                    producerSessionBean.setName(sessionName + "-" + i);
                    this.createRepConsumerSession(connectName, producerSessionBean, producerSession);
                    snamelist.add(producerSessionBean.getName());
                }
            } else {
                this.createRepConsumerSession(connectName, producerSessionBean, producerSession);
                snamelist.add(producerSessionBean.getName());
            }
            List<String> slist = sessionMap.get(connectName);
            if (null == slist) {
                slist = new ArrayList<String>();
            }
            slist.addAll(snamelist);
            sessionMap.put(connectName, slist);
            this.logger.info("createProducer", (Object)("MQ-connect-producer:" + connectName + ":" + producerSessionBean.getName() + "==\u542f\u52a8\u6210\u529f"));
        }
        catch (JMSException e) {
            this.logger.error("amq.ADAPTER.MQ.JmsConnetServiceImpl.createProducer", (Throwable)e);
        }
    }

    private RepConsumerSession createRepConsumerSession(String connectName, ProducerSessionBean producerSessionBean, ProducerSession producerSession) {
        if (StringUtils.isEmpty((String)connectName) || null == producerSessionBean || null == producerSessionBean.getReplyMessageName() || null == producerSession) {
            return null;
        }
        PooledConnection connection = connectionMap.get(connectName);
        if (null == connection) {
            return null;
        }
        if (connection.getNumSessions() >= MAX_CONNECTIONS) {
            this.logger.error("amq.ADAPTER.MQ.JmsConnetServiceImpl.createRepConsumerSession", (Object)(connection.getNumSessions() + ">=" + MAX_CONNECTIONS));
            return null;
        }
        RepConsumerSession consumerSession = new RepConsumerSession(producerSessionBean.getCorePoolSize(), producerSessionBean.getMaximumPoolSize(), producerSessionBean.getKeepAliveTime(), producerSessionBean.getReplyType());
        consumerSession.setName(producerSessionBean.getName());
        try {
            consumerSession.setConnection(connection);
            consumerSession.setSessionBean((SessionBean)producerSessionBean);
            consumerSession.setSession(connection.createSession(producerSessionBean.isReplyTransacted(), producerSessionBean.getReplyAckMode()));
            Object adminQueue = null;
            adminQueue = JmsConstans.messageType_queue.equals(producerSessionBean.getMessageType()) ? consumerSession.getSession().createQueue(producerSessionBean.getReplyMessageName()) : (JmsConstans.messageType_topic.equals(producerSessionBean.getMessageType()) ? consumerSession.getSession().createTopic(producerSessionBean.getReplyMessageName()) : consumerSession.getSession().createQueue(producerSessionBean.getReplyMessageName()));
            MessageConsumer consumer = consumerSession.getSession().createConsumer((Destination)adminQueue, "mq_filter_appKey = '" + ServletMain.getAppKey() + "'");
            producerSession.setRepDest((Destination)adminQueue);
            consumerSession.setConsumer(consumer);
            consumer.setMessageListener((MessageListener)consumerSession);
            repConsumerSessionMap.put(producerSessionBean.getName(), consumerSession);
            this.logger.info("RepConsumerSession", (Object)("MQ-connect-repconsumer:" + connectName + ":" + producerSessionBean.getName() + "==\u542f\u52a8\u6210\u529f"));
        }
        catch (Exception e) {
            this.logger.error("amq.ADAPTER.MQ.JmsConnetServiceImpl.ctreateConsumer", (Throwable)e);
            return null;
        }
        return consumerSession;
    }

    public void ctreateConsumer(String connectName, SessionBean sessionBean) {
        PooledConnection connection;
        if (StringUtils.isEmpty((String)connectName) || null == sessionBean) {
            return;
        }
        if (null != consumerSessionMap.get(sessionBean.getName())) {
            this.doJmsConsumerSessionStop(sessionBean.getName());
        }
        if (null == (connection = connectionMap.get(connectName))) {
            return;
        }
        if (connection.getNumSessions() >= MAX_CONNECTIONS) {
            this.logger.error("amq.ADAPTER.MQ.JmsConnetServiceImpl.ctreateConsumer", (Object)(connection.getNumSessions() + ">=" + MAX_CONNECTIONS));
            return;
        }
        ConsumerSession consumerSession = new ConsumerSession(sessionBean.getCorePoolSize(), sessionBean.getMaximumPoolSize(), sessionBean.getKeepAliveTime(), sessionBean.getReplyType());
        consumerSession.setName(sessionBean.getName());
        try {
            consumerSession.setConnection(connection);
            consumerSession.setSessionBean(sessionBean);
            consumerSession.setSession(connection.createSession(sessionBean.isTransacted(), sessionBean.getAckMode()));
            Object adminQueue = null;
            adminQueue = JmsConstans.messageType_queue.equals(sessionBean.getMessageType()) ? consumerSession.getSession().createQueue(sessionBean.getMessageName()) : (JmsConstans.messageType_topic.equals(sessionBean.getMessageType()) ? consumerSession.getSession().createTopic(sessionBean.getMessageName()) : consumerSession.getSession().createQueue(sessionBean.getMessageName()));
            SupperProducerSession repProducerSession = new SupperProducerSession();
            repProducerSession.setSession(connection.createSession(sessionBean.isReplyTransacted(), sessionBean.getReplyAckMode()));
            repProducerSession.setProducer(consumerSession.getSession().createProducer(null));
            repProducerSession.getProducer().setDeliveryMode(sessionBean.getReplyDeliveryMode());
            this.logger.info("ctreateRepProducer", (Object)("MQ-connect-RepProducer:" + connectName + ":" + sessionBean.getName() + "==\u542f\u52a8\u6210\u529f"));
            consumerSession.setRepProducerSession(repProducerSession);
            repProducerSessionMap.put(sessionBean.getName(), repProducerSession);
            MessageConsumer consumer = consumerSession.getSession().createConsumer((Destination)adminQueue);
            consumerSession.setConsumer(consumer);
            consumer.setMessageListener((MessageListener)consumerSession);
            consumerSessionMap.put(sessionBean.getName(), consumerSession);
            List<String> slist = consessionMap.get(connectName);
            if (null == slist) {
                slist = new ArrayList<String>();
            }
            slist.add(sessionBean.getName());
            sessionMap.put(connectName, slist);
            this.logger.info("ctreateConsumer", (Object)("MQ-connect-consumer:" + connectName + ":" + sessionBean.getName() + "==\u542f\u52a8\u6210\u529f"));
        }
        catch (Exception e) {
            this.logger.error("amq.ADAPTER.MQ.JmsConnetServiceImpl.ctreateConsumer", (Throwable)e);
        }
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doJmsStartAll() {
        Object object = this.obj;
        synchronized (object) {
            String key = "McChannel-start";
            Map cacheMap = DisUtil.getMapJson((String)key, String.class, String.class);
            if (null == cacheMap || cacheMap.isEmpty()) {
                this.logger.error("amq.ADAPTER.MQ.JmsConnetServiceImpl.doJmsStartAll.cacheMap");
                return;
            }
            String list = (String)cacheMap.get(ServletMain.getAppName());
            if (StringUtils.isBlank((String)list)) {
                this.logger.error("amq.ADAPTER.MQ.JmsConnetServiceImpl.doJmsStartAll.list", (Object)ServletMain.getAppName());
                return;
            }
            List beanlist = (List)JsonUtil.buildNormalBinder().getJsonToList(list, ConnetBean.class);
            for (ConnetBean connetBean : beanlist) {
                this.doJmsStart(connetBean);
                this.createProducerAll(connetBean.getName());
                this.ctreateConsumerAll(connetBean.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createProducerAll(String connectName) {
        Object object = this.obj1;
        synchronized (object) {
            String key = "McChannelList-p-start";
            Map cacheMap = DisUtil.getMapJson((String)key, String.class, String.class);
            if (null == cacheMap || cacheMap.isEmpty()) {
                return;
            }
            String list = (String)cacheMap.get(connectName + "-" + "Producer");
            if (StringUtils.isBlank((String)list)) {
                return;
            }
            List beanlist = (List)JsonUtil.buildNormalBinder().getJsonToList(list, ProducerSessionBean.class);
            for (ProducerSessionBean producerSessionBean : beanlist) {
                this.createProducer(connectName, producerSessionBean);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ctreateConsumerAll(String connectName) {
        Object object = this.obj2;
        synchronized (object) {
            String key = "McChannelList-c-start";
            Map cacheMap = DisUtil.getMapJson((String)key, String.class, String.class);
            if (null == cacheMap || cacheMap.isEmpty()) {
                return;
            }
            String list = (String)cacheMap.get(connectName + "-" + "Consumer");
            if (StringUtils.isBlank((String)list)) {
                return;
            }
            List beanlist = (List)JsonUtil.buildNormalBinder().getJsonToList(list, SessionBean.class);
            String sessionName = "";
            for (SessionBean sessionBean : beanlist) {
                if (null == connectName || null == sessionBean) continue;
                if (StringUtils.isBlank((String)sessionBean.getReplyType()) || "1".equals(sessionBean.getReplyType())) {
                    int maxnum = sessionBean.getMaximumPoolSize();
                    if (maxnum == 0) {
                        maxnum = 5;
                    }
                    sessionName = sessionBean.getName();
                    for (int i = 0; i < maxnum; ++i) {
                        sessionBean.setName(sessionName + "-" + i);
                        this.ctreateConsumer(connectName, sessionBean);
                    }
                    continue;
                }
                this.ctreateConsumer(connectName, sessionBean);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStartSyncCall() {
        Object object = this.sycCallobj;
        synchronized (object) {
            Map map = SupDisUtil.getMapAll((String)"PRODUCERSYNCCALL-res");
            if (null == map || map.isEmpty()) {
                return;
            }
            for (Map.Entry entry : map.entrySet()) {
                String js = (String)entry.getValue();
                ProducerCall.call((String)entry.getKey(), (OutMessage)JsonUtil.buildNormalBinder().getJsonToObject(js, OutMessage.class));
            }
        }
    }
}

