/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.cache;

import com.fasterxml.jackson.core.type.TypeReference;
import com.yqbsoft.laser.service.esb.cache.SpringBootRedisUtil;
import com.yqbsoft.laser.service.esb.cache.local.LocalCache;
import com.yqbsoft.laser.service.suppercore.cache.dis.DisCache;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@Service(value="disCache")
@DependsOn(value={"supSpringApplicationContextUtil"})
public class DisCacheImpl
implements DisCache {
    protected final SupperLogUtil logger = new SupperLogUtil(this.getClass());
    private static final Long SYNC_TIME = 120000L;
    private static final String stringCache = "StringCache";
    private static final String mapCache = "MapCache";
    private static final String OBJECT_CACHE = "ObjectCache";
    public static final String redis_ver = "-1";
    public static final String vm_cver = "-2";
    public static final String vm_ccver = "-2";
    private Map<String, String> versionMap = new ConcurrentHashMap<String, String>();
    private Map<String, Long> timeMap = new ConcurrentHashMap<String, Long>();
    private Map<String, Long> timeValueMap = new ConcurrentHashMap<String, Long>();
    private static final LocalCache stringLocalCache = new LocalCache("StringCache", "defcmname");
    private static final LocalCache mapLocalCache = new LocalCache("MapCache", "defcmname");
    private static final LocalCache objectLocalCache = new LocalCache("ObjectCache", "defcmname");
    @Autowired
    SpringBootRedisUtil springBootRedisUtil;

    public void setSpringBootRedisUtil(SpringBootRedisUtil springBootRedisUtil) {
        this.springBootRedisUtil = springBootRedisUtil;
    }

    public Map<String, Long> getTimeValueMap() {
        return this.timeValueMap;
    }

    public void setTimeValueMap(Map<String, Long> timeValueMap) {
        this.timeValueMap = timeValueMap;
    }

    public Map<String, String> getVersionMap() {
        return this.versionMap;
    }

    public void setVersionMap(Map<String, String> versionMap) {
        this.versionMap = versionMap;
    }

    public Map<String, Long> getTimeMap() {
        return this.timeMap;
    }

    public void setTimeMap(Map<String, Long> timeMap) {
        this.timeMap = timeMap;
    }

    private Long getSyncTime(String key) {
        Long syncTime = this.getTimeValueMap().get(key);
        if (null == syncTime) {
            String st = this.springBootRedisUtil.getMap("synctimer", key);
            syncTime = "redis.error".equals(st) || StringUtils.isBlank((String)st) ? SYNC_TIME : Long.valueOf(st);
            this.getTimeValueMap().put(key, syncTime);
        }
        return syncTime;
    }

    private boolean exesync(String key, String field, Long ctime, String ver) {
        boolean sync = false;
        if (this.rometflag(key)) {
            return true;
        }
        Long vtime = this.getTimeMap().get(key + "-" + field);
        if (vtime == null) {
            return true;
        }
        if (StringUtils.isBlank((String)ver)) {
            ver = redis_ver;
        }
        if (redis_ver.equals(ver)) {
            return true;
        }
        Long syncTime = this.getSyncTime(key);
        if (null == syncTime) {
            syncTime = SYNC_TIME;
        }
        if ("0".equals(String.valueOf(syncTime))) {
            return false;
        }
        if (vtime == null || ctime - vtime >= syncTime) {
            String cver = this.getVersionMap().get(key);
            String ccver = this.getVersionMap().get(key + "-" + field);
            if (StringUtils.isBlank((String)cver)) {
                cver = "-2";
            }
            if (StringUtils.isBlank((String)ccver)) {
                ccver = "-2";
            }
            if (Integer.valueOf(cver) < 0 || Integer.valueOf(ver) > Integer.valueOf(cver)) {
                sync = true;
            } else if (Integer.valueOf(ccver) < 0 || Integer.valueOf(ver) > Integer.valueOf(ccver)) {
                sync = true;
            }
        }
        return sync;
    }

    private void exesyncUpdate(String key, String field, Long ctime, String ver) {
        this.getTimeMap().put(key + "-" + field, ctime);
        if (StringUtils.isBlank((String)ver)) {
            ver = redis_ver;
        }
        this.getVersionMap().put(key + "-" + field, ver);
    }

    private void exesyncUpdate(String key, Long ctime, String ver) {
        this.getTimeMap().put(key, ctime);
        if (StringUtils.isBlank((String)ver)) {
            ver = redis_ver;
        }
        this.getVersionMap().put(key, ver);
    }

    private boolean exesync(String key, Long ctime, String ver) {
        boolean sync = false;
        if (this.rometflag(key)) {
            return true;
        }
        Long vtime = this.getTimeMap().get(key);
        if (vtime == null) {
            return true;
        }
        if (StringUtils.isBlank((String)ver)) {
            ver = redis_ver;
        }
        if (redis_ver.equals(ver)) {
            return true;
        }
        Long syncTime = this.getSyncTime(key);
        if (null == syncTime) {
            syncTime = SYNC_TIME;
        }
        if ("0".equals(String.valueOf(syncTime))) {
            return false;
        }
        if (vtime == null || ctime - vtime >= syncTime) {
            String cver = this.getVersionMap().get(key);
            if (StringUtils.isBlank((String)cver)) {
                cver = "-2";
            }
            if (Integer.valueOf(cver) < 0 || Integer.valueOf(ver) > Integer.valueOf(cver)) {
                sync = true;
            }
        }
        return sync;
    }

    private boolean rometflag(String key) {
        Long syncTime = this.getSyncTime(key);
        return redis_ver.equals(String.valueOf(syncTime));
    }

    public void set(String key, String value) {
        this.springBootRedisUtil.set(key, value);
    }

    public void setJson(String key, Object value) {
        this.springBootRedisUtil.set(key, JsonUtil.buildNormalBinder().toJson(value));
    }

    public void setJsonVer(String key, Object value) {
        this.springBootRedisUtil.addVersion(key + "-ver");
        this.springBootRedisUtil.set(key, JsonUtil.buildNormalBinder().toJson(value));
    }

    public void append(String key, String value) {
        this.springBootRedisUtil.append(key, value);
    }

    public String get(String key) {
        if (this.rometflag(key)) {
            return this.getRemot(key);
        }
        String obj = (String)stringLocalCache.get(key);
        Long ctime = System.currentTimeMillis();
        String ver = this.getRemot(key + "-ver");
        if (StringUtils.isBlank((String)ver) || "redis.error".equals(ver)) {
            ver = redis_ver;
        }
        if (this.exesync(key, ctime, ver)) {
            obj = this.springBootRedisUtil.get(key);
            if (!"redis.error".equals(obj) && null != obj) {
                stringLocalCache.put(key, obj);
                this.exesyncUpdate(key, ctime, ver);
            } else {
                stringLocalCache.del(key);
                if ("redis.error".equals(obj)) {
                    ver = redis_ver;
                    obj = null;
                }
                this.exesyncUpdate(key, ctime, ver);
            }
        }
        return obj;
    }

    public String getRemot(String key) {
        String obj = this.springBootRedisUtil.get(key);
        if ("redis.error".equals(obj)) {
            return null;
        }
        return obj;
    }

    public <T> T getRemot(String key, Class<T> classz, FormatJson formatJson) {
        T object = null;
        String json = this.getRemot(key);
        if (StringUtils.isBlank((String)json)) {
            return null;
        }
        object = formatJson.format(json, classz);
        return object;
    }

    public <T> T get(String key, Class<T> classz, FormatJson formatJson) {
        Object object = null;
        if (!this.rometflag(key)) {
            Long ctime = System.currentTimeMillis();
            String ver = this.getRemot(key + "-ver");
            if (StringUtils.isBlank((String)ver) || "redis.error".equals(ver)) {
                ver = redis_ver;
            }
            if (this.exesync(key, ctime, ver)) {
                String obj = this.springBootRedisUtil.get(key);
                if (!"redis.error".equals(obj) && StringUtils.isNotBlank((String)obj)) {
                    object = formatJson.format(obj, classz);
                    objectLocalCache.put(key, object);
                    this.exesyncUpdate(key, ctime, ver);
                } else {
                    objectLocalCache.del(key);
                    if ("redis.error".equals(obj)) {
                        ver = redis_ver;
                        obj = null;
                    }
                    this.exesyncUpdate(key, ctime, ver);
                }
            } else {
                object = objectLocalCache.get(key);
            }
        } else {
            object = this.getRemot(key, classz, formatJson);
        }
        return (T)object;
    }

    public <T> T getCache(String key, Class<T> classz, FormatJson formatJson) {
        T object = null;
        String json = this.get(key);
        if (StringUtils.isBlank((String)json)) {
            return null;
        }
        object = formatJson.format(json, classz);
        return object;
    }

    public List getListJson(String key, final Class clazz) {
        List object = this.get(key, List.class, new FormatJson(){

            @Override
            <T> T format(String json, Class<T> classz) {
                return (T)JsonUtil.buildNormalBinder().getJsonToList(json, clazz);
            }
        });
        return object;
    }

    public List getListByMapJson(String key, final Class clazz) {
        List object = this.get(key, List.class, new FormatJson(){

            @Override
            <T> T format(String json, Class<T> classz) {
                return (T)JsonUtil.buildNormalBinder().getJsonToListByMap(json, clazz);
            }
        });
        return object;
    }

    public Object getObjectJson(String key, final Class clazz) {
        Object object = this.get(key, Object.class, new FormatJson(){

            @Override
            <T> T format(String json, Class<T> classz) {
                return (T)JsonUtil.buildNormalBinder().getJsonToObject(json, clazz);
            }
        });
        return object;
    }

    public Map getMapJson(String key, final Class keyclazz, final Class valueclazz) {
        Map object = this.get(key, Map.class, new FormatJson(){

            @Override
            <T> T format(String json, Class<T> classz) {
                return (T)JsonUtil.buildNormalBinder().getJsonToMap(json, keyclazz, valueclazz);
            }
        });
        return object;
    }

    public Map getConcMapJson(String key, final Class keyclazz, final Class valueclazz) {
        Map object = this.get(key, Map.class, new FormatJson(){

            @Override
            <T> T format(String json, Class<T> classz) {
                return (T)JsonUtil.buildNormalBinder().getJsonToConcMap(json, keyclazz, valueclazz);
            }
        });
        return object;
    }

    public <T> Object getObject(String key, final TypeReference<T> typeReference) {
        Object object = this.get(key, Object.class, new FormatJson(){

            <K> K format(String json, Class<K> classz) {
                return (K)JsonUtil.buildNormalBinder().getJsonToObject(json, typeReference);
            }
        });
        return object;
    }

    public Map getMapByListJson(String key, final Class keyclazz, final Class valueclazz) {
        Map object = this.get(key, Map.class, new FormatJson(){

            @Override
            <T> T format(String json, Class<T> classz) {
                return (T)JsonUtil.buildNormalBinder().getJsonToMapByList(json, keyclazz, valueclazz);
            }
        });
        return object;
    }

    public Map getRemotMapByListJson(String key, final Class keyclazz, final Class valueclazz) {
        Map object = this.getRemot(key, Map.class, new FormatJson(){

            @Override
            <T> T format(String json, Class<T> classz) {
                return (T)JsonUtil.buildNormalBinder().getJsonToMapByList(json, keyclazz, valueclazz);
            }
        });
        return object;
    }

    public Map getMapByMapJson(String key, final Class keyclazz, final Class valueclazz) {
        Map object = this.get(key, Map.class, new FormatJson(){

            @Override
            <T> T format(String json, Class<T> classz) {
                return (T)JsonUtil.buildNormalBinder().getJsonToMapByMap(json, keyclazz, valueclazz);
            }
        });
        return object;
    }

    public void del(String key) {
        this.delCache(key);
        this.springBootRedisUtil.delVer(key);
    }

    public void delCache(String key) {
        stringLocalCache.del(key);
        mapLocalCache.del(key);
        objectLocalCache.del(key);
    }

    public void setVer(String key, String value) {
        this.springBootRedisUtil.setVer(key, value);
    }

    public void appendVer(String key, String value) {
        this.springBootRedisUtil.appendVer(key, value);
    }

    public void delVer(String key) {
        this.springBootRedisUtil.delVer(key);
        this.delCache(key);
    }

    public void setList(String key, String ... strings) {
        this.springBootRedisUtil.setList(key, strings);
    }

    public void setListVer(String key, String ... strings) {
        this.springBootRedisUtil.setListVer(key, strings);
    }

    public List<String> blpop(String key) {
        return this.springBootRedisUtil.blpop(key);
    }

    public List<String> brpop(String key) {
        return this.springBootRedisUtil.brpop(key);
    }

    public List<String> getList(String key, long start, long end) {
        return this.springBootRedisUtil.getList(key, start, end);
    }

    public String lpop(String key) {
        String obj = this.springBootRedisUtil.lpop(key);
        if ("redis.error".equals(obj)) {
            return null;
        }
        return obj;
    }

    public String rpop(String key) {
        String obj = this.springBootRedisUtil.rpop(key);
        if ("redis.error".equals(obj)) {
            return null;
        }
        return obj;
    }

    public void setMap(String key, String field, String value) {
        if (null == field || "".equals(field)) {
            return;
        }
        this.springBootRedisUtil.setMap(key, field, value);
    }

    public String getRemotMap(String key, String field) {
        String obj = this.springBootRedisUtil.getMap(key, field);
        if ("redis.error".equals(obj)) {
            return null;
        }
        return obj;
    }

    public String getMap(String key, String field) {
        if (this.rometflag(key)) {
            return this.getRemotMap(key, field);
        }
        Long ctime = System.currentTimeMillis();
        String obj = null;
        String ver = this.getRemot(key + "-ver");
        if (StringUtils.isBlank((String)ver) || "redis.error".equals(ver)) {
            ver = redis_ver;
        }
        if (this.exesync(key, "map-" + field, ctime, ver)) {
            obj = this.springBootRedisUtil.getMap(key, field);
            if (!"redis.error".equals(obj) && StringUtils.isNotBlank((String)obj)) {
                mapLocalCache.putMap(key, field, obj);
                this.exesyncUpdate(key, "map-" + field, ctime, ver);
            } else {
                mapLocalCache.delMap(key, field);
                if ("redis.error".equals(obj)) {
                    ver = redis_ver;
                    obj = null;
                }
                this.exesyncUpdate(key, "map-" + field, ctime, ver);
            }
        } else {
            obj = mapLocalCache.getMap(key, field);
        }
        return obj;
    }

    public List<?> getMapListJson(String key, String field, Class<?> keyclazz) {
        List obj = null;
        if (!this.rometflag(key)) {
            Long ctime = System.currentTimeMillis();
            String ver = this.getRemot(key + "-ver");
            if (StringUtils.isBlank((String)ver) || "redis.error".equals(ver)) {
                ver = redis_ver;
            }
            if (this.exesync(key, field, ctime, ver)) {
                String json = this.springBootRedisUtil.getMap(key, field);
                if (!"redis.error".equals(json) && null != json) {
                    obj = (List)JsonUtil.buildNormalBinder().getJsonToList(json, keyclazz);
                    objectLocalCache.put(key + "-" + field, obj);
                    this.exesyncUpdate(key, field, ctime, ver);
                } else {
                    obj = null;
                    objectLocalCache.del(key + "-" + field);
                    if ("redis.error".equals(json)) {
                        ver = redis_ver;
                    }
                    this.exesyncUpdate(key, field, ctime, ver);
                }
            } else {
                obj = (List)objectLocalCache.get(key + "-" + field);
            }
        } else {
            String json = this.getRemotMap(key, field);
            obj = !"redis.error".equals(json) && null != json ? (List)JsonUtil.buildNormalBinder().getJsonToList(json, keyclazz) : null;
        }
        return obj;
    }

    public Map<?, ?> getMapMapJson(String key, String field, Class<?> keyclazz, Class<?> keyclazzy) {
        Map obj = null;
        if (!this.rometflag(key)) {
            Long ctime = System.currentTimeMillis();
            String ver = this.getRemot(key + "-ver");
            if (StringUtils.isBlank((String)ver) || "redis.error".equals(ver)) {
                ver = redis_ver;
            }
            if (this.exesync(key, field, ctime, ver)) {
                String json = this.springBootRedisUtil.getMap(key, field);
                if (!"redis.error".equals(json) && null != json) {
                    obj = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, keyclazz, keyclazzy);
                    objectLocalCache.put(key + "-" + field, obj);
                    this.exesyncUpdate(key, field, ctime, ver);
                } else {
                    obj = null;
                    objectLocalCache.del(key + "-" + field);
                    if ("redis.error".equals(json)) {
                        ver = redis_ver;
                        json = null;
                    }
                    this.exesyncUpdate(key, field, ctime, ver);
                }
            } else {
                obj = (Map)objectLocalCache.get(key + "-" + field);
            }
        } else {
            String json = this.getRemotMap(key, field);
            obj = !"redis.error".equals(json) && null != json ? (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, keyclazz, keyclazzy) : null;
        }
        return obj;
    }

    public <T> Object getMapJson(String key, String field, Class<T> keyclazz) {
        Object obj = null;
        if (!this.rometflag(key)) {
            Long ctime = System.currentTimeMillis();
            String ver = this.getRemot(key + "-ver");
            if (StringUtils.isBlank((String)ver) || "redis.error".equals(ver)) {
                ver = redis_ver;
            }
            if (this.exesync(key, field, ctime, ver)) {
                String json = this.springBootRedisUtil.getMap(key, field);
                if (!"redis.error".equals(json) && null != json) {
                    obj = JsonUtil.buildNormalBinder().getJsonToObject(json, keyclazz);
                    objectLocalCache.put(key + "-" + field, obj);
                    this.exesyncUpdate(key, field, ctime, ver);
                } else {
                    obj = null;
                    objectLocalCache.del(key + "-" + field);
                    if ("redis.error".equals(json)) {
                        ver = redis_ver;
                    }
                    this.exesyncUpdate(key, field, ctime, ver);
                }
            } else {
                obj = objectLocalCache.get(key + "-" + field);
            }
        } else {
            String json = this.getRemotMap(key, field);
            obj = !"redis.error".equals(json) && null != json ? JsonUtil.buildNormalBinder().getJsonToObject(json, keyclazz) : null;
        }
        return obj;
    }

    public Map<String, String> getRemotMapAll(String key) {
        return this.springBootRedisUtil.getMapAll(key);
    }

    public Map<String, String> getMapAll(String key) {
        if (this.rometflag(key)) {
            return this.getRemotMapAll(key);
        }
        Map<String, String> obj = mapLocalCache.getMapAll(key);
        Long ctime = System.currentTimeMillis();
        String ver = this.springBootRedisUtil.get(key + "-ver");
        if (StringUtils.isBlank((String)ver) || "redis.error".equals(ver)) {
            ver = redis_ver;
        }
        if (this.exesync(key, ctime, ver)) {
            obj = this.getRemotMapAll(key);
            if (null != obj) {
                mapLocalCache.putMapAll(key, obj);
                this.exesyncUpdate(key, ctime, ver);
            } else {
                mapLocalCache.del(key);
                ver = redis_ver;
                this.exesyncUpdate(key, ctime, ver);
            }
        }
        return obj;
    }

    public List<String> getMap(String key, String ... fields) {
        return null;
    }

    public void delMap(String key, String ... fields) {
        this.springBootRedisUtil.delMap(key, fields);
    }

    public void setMap(String key, Map<String, String> hash) {
        if (null == hash || hash.isEmpty()) {
            return;
        }
        this.springBootRedisUtil.setMap(key, hash);
    }

    public void setMapVer(String key, String field, String value) {
        if (null == field || "".equals(field)) {
            return;
        }
        this.springBootRedisUtil.setMapVer(key, field, value);
    }

    public void delMapVer(String key, String ... fields) {
        this.springBootRedisUtil.delMapVer(key, fields);
    }

    public void setMapVer(String key, Map<String, String> hash) {
        if (null == hash || hash.isEmpty()) {
            return;
        }
        this.springBootRedisUtil.setMapVer(key, hash);
    }

    public void sadd(String key, String ... values) {
        this.springBootRedisUtil.sadd(key, values);
    }

    public Set<String> smembers(String key) {
        return this.springBootRedisUtil.smembers(key);
    }

    public String spop(String key) {
        return this.springBootRedisUtil.spop(key);
    }

    public void set(String key, String value, int expires) {
        this.springBootRedisUtil.set(key, value, expires);
    }

    public void setJson(String key, Object value, int expires) {
        this.springBootRedisUtil.set(key, JsonUtil.buildNormalBinder().toJson(value), expires);
    }

    abstract class FormatJson {
        FormatJson() {
        }

        abstract <T> T format(String var1, Class<T> var2);
    }
}

