/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.cache;

import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
@EnableCaching
@DependsOn(value={"regeditUtil"})
public class RedisConfig
extends CachingConfigurerSupport {
    protected SupperLogUtil logger = new SupperLogUtil(RedisConfig.class);
    @Value(value="${spring.redis.jedis.pool.testOnReturn:true}")
    private boolean testOnReturn;
    @Value(value="${spring.redis.jedis.pool.testOnBorrow:true}")
    private boolean testOnBorrow;
    @Value(value="${spring.redis.jedis.pool.testWhileIdle:true}")
    private boolean testWhileIdle;
    @Value(value="${spring.redis.host}")
    private String host;
    @Value(value="${spring.redis.port}")
    private int port;
    @Value(value="${spring.redis.timeout}")
    private int timeout;
    @Value(value="${spring.redis.jedis.pool.maxidle:100}")
    private int maxIdle;
    @Value(value="${spring.redis.jedis.pool.minIdle:5}")
    private int minIdle;
    @Value(value="${spring.redis.jedis.pool.maxTotal:100}")
    private int maxTotal;
    @Value(value="${spring.redis.jedis.pool.maxwait}")
    private long maxWaitMillis;
    @Value(value="${spring.redis.jedis.pool.timeBetweenEvictionRunsMillis:30000}")
    private long timeBetweenEvictionRunsMillis;
    @Value(value="${spring.redis.jedis.pool.minEvictableIdleTimeMillis:60000}")
    private long minEvictableIdleTimeMillis;
    @Value(value="${spring.redis.jedis.pool.numTestsPerEvictionRun:3}")
    private int numTestsPerEvictionRun;
    @Value(value="${spring.redis.password}")
    private String password;
    @Value(value="${spring.redis.blockwhenexhausted}")
    private boolean blockWhenExhausted;
    @Value(value="${spring.redis.ssl:false}")
    private boolean ssl;

    @Bean
    public RedisConnectionFactory redisConnectionFactory() {
        JedisPoolConfig jedisPoolConfig = this.jedisPoolConfig();
        RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration();
        redisStandaloneConfiguration.setHostName(this.host);
        redisStandaloneConfiguration.setPort(this.port);
        if (StringUtils.isNotBlank((String)this.password)) {
            redisStandaloneConfiguration.setPassword(RedisPassword.of((String)this.password));
        }
        JedisClientConfiguration.JedisClientConfigurationBuilder jedisClientConfigurationBuilder = JedisClientConfiguration.builder();
        JedisClientConfiguration jedisClientConfiguration = jedisClientConfigurationBuilder.usePooling().poolConfig((GenericObjectPoolConfig)jedisPoolConfig).build();
        return new JedisConnectionFactory(redisStandaloneConfiguration, jedisClientConfiguration);
    }

    @Bean(name={"jedisPool"})
    public JedisPool redisPoolFactory() throws Exception {
        this.logger.info("=====", (Object)"JedisPool start");
        JedisPoolConfig jedisPoolConfig = this.jedisPoolConfig();
        JedisPool jedisPool = null;
        if (StringUtils.isNotBlank((String)this.password)) {
            this.logger.info("==p===", (Object)"JedisPool end");
            jedisPool = new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, this.host, this.port, this.timeout, this.password, this.ssl);
        } else {
            this.logger.info("==np===", (Object)"JedisPool end");
            jedisPool = new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, this.host, this.port, this.timeout, this.ssl);
        }
        this.logger.info("=====", (Object)("JedisPool end" + this.host + ":" + this.port));
        return jedisPool;
    }

    @Bean
    public JedisPoolConfig jedisPoolConfig() {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxIdle(this.maxIdle);
        jedisPoolConfig.setMaxTotal(this.maxTotal);
        jedisPoolConfig.setMinIdle(this.minIdle);
        jedisPoolConfig.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis);
        jedisPoolConfig.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        jedisPoolConfig.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis);
        jedisPoolConfig.setMaxWaitMillis(this.maxWaitMillis);
        jedisPoolConfig.setBlockWhenExhausted(this.blockWhenExhausted);
        jedisPoolConfig.setJmxEnabled(true);
        jedisPoolConfig.setTestOnBorrow(this.testOnBorrow);
        jedisPoolConfig.setTestWhileIdle(this.testWhileIdle);
        jedisPoolConfig.setTestOnReturn(this.testOnReturn);
        return jedisPoolConfig;
    }
}

