/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.cache;

import com.yqbsoft.laser.service.esb.cache.RedisCache;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedisUtil {
    public static final String SYS_CODE = "ecache.CACHE.RedisUtil";
    @Autowired
    RedisCache redisCache;
    protected final SupperLogUtil logger = new SupperLogUtil(this.getClass());

    public void setRedisCache(RedisCache redisCache) {
        this.redisCache = redisCache;
    }

    private String setKeyIndex(String key) {
        if (null != key) {
            // empty if block
        }
        return key;
    }

    public void addVersion(String key) {
        key = this.setKeyIndex(key);
        this.redisCache.addVersion(key);
    }

    public boolean checkVersion(String key, String value) {
        key = this.setKeyIndex(key);
        return this.redisCache.checkVersion(key, value);
    }

    public void set(String key, String value) {
        key = this.setKeyIndex(key);
        this.redisCache.setVer(key, value);
    }

    public void set(String key, String value, int expires) {
        key = this.setKeyIndex(key);
        this.redisCache.set(key, value, expires);
    }

    public void append(String key, String value) {
        key = this.setKeyIndex(key);
        this.redisCache.append(key, value);
    }

    public String get(String key) {
        key = this.setKeyIndex(key);
        return this.redisCache.get(key);
    }

    public void del(String key) {
        key = this.setKeyIndex(key);
        this.redisCache.delVer(key);
    }

    public void setVer(String key, String value) {
        key = this.setKeyIndex(key);
        this.redisCache.setVer(key, value);
    }

    public void appendVer(String key, String value) {
        key = this.setKeyIndex(key);
        this.redisCache.appendVer(key, value);
    }

    public void delVer(String key) {
        key = this.setKeyIndex(key);
        this.redisCache.delVer(key);
    }

    public void setList(String key, String ... strings) {
        key = this.setKeyIndex(key);
        this.redisCache.setListVer(key, strings);
    }

    public List<String> getList(String key, long start, long end) {
        key = this.setKeyIndex(key);
        return this.redisCache.getList(key, start, end);
    }

    public String lpop(String key) {
        key = this.setKeyIndex(key);
        return this.redisCache.lpop(key);
    }

    public String rpop(String key) {
        key = this.setKeyIndex(key);
        return this.redisCache.rpop(key);
    }

    public List<String> blpop(String key) {
        key = this.setKeyIndex(key);
        return this.redisCache.blpop(key);
    }

    public List<String> brpop(String key) {
        key = this.setKeyIndex(key);
        return this.redisCache.brpop(key);
    }

    public void setListVer(String key, String ... strings) {
        key = this.setKeyIndex(key);
        this.redisCache.setListVer(key, strings);
    }

    public void setMap(String key, String field, String value) {
        key = this.setKeyIndex(key);
        this.redisCache.setMapVer(key, field, value);
    }

    public String getMap(String key, String field) {
        key = this.setKeyIndex(key);
        return this.redisCache.getMap(key, field);
    }

    public Map<String, String> getMapAll(String key) {
        key = this.setKeyIndex(key);
        return this.redisCache.getMapAll(key);
    }

    public List<String> getMap(String key, String ... fields) {
        key = this.setKeyIndex(key);
        return this.redisCache.getMap(key, fields);
    }

    public void delMap(String key, String ... fields) {
        key = this.setKeyIndex(key);
        this.redisCache.delMapVer(key, fields);
    }

    public void setMap(String key, Map<String, String> hash) {
        key = this.setKeyIndex(key);
        this.redisCache.setMapVer(key, hash);
    }

    public void setMapVer(String key, String field, String value) {
        key = this.setKeyIndex(key);
        this.redisCache.setMapVer(key, field, value);
    }

    public void delMapVer(String key, String ... fields) {
        key = this.setKeyIndex(key);
        this.redisCache.delMapVer(key, fields);
    }

    public void setMapVer(String key, Map<String, String> hash) {
        key = this.setKeyIndex(key);
        this.redisCache.setMapVer(key, hash);
    }

    public String getJedisConfig(String key) {
        return this.redisCache.getJedisConfig(key);
    }

    public long getDbSize(String key) {
        return this.redisCache.getDbSize(key);
    }

    public Set<String> getAllKeys(String key) {
        return this.redisCache.getAllKeys(key);
    }

    public void sadd(String key, String ... values) {
        key = this.setKeyIndex(key);
        this.redisCache.sadd(key, values);
    }

    public Set<String> smembers(String key) {
        key = this.setKeyIndex(key);
        return this.redisCache.smembers(key);
    }

    public String spop(String key) {
        key = this.setKeyIndex(key);
        return this.redisCache.spop(key);
    }
}

