/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.cache;

import com.yqbsoft.laser.service.esb.cache.RedisCache;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Client;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.util.Slowlog;

@Service
public class SpringBootRedisUtil
implements RedisCache {
    public static final String SYS_CODE = "ecache.CACHE.JedisSentineUtil";
    public static final String errorCode = "redis.error";
    private String index = "0";
    protected SupperLogUtil logger = new SupperLogUtil(SpringBootRedisUtil.class);
    private JedisPool jedisPool;

    @Autowired
    public void setJedisPool(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    private Jedis getJedis() {
        try {
            return this.jedisPool.getResource();
        }
        catch (Exception e) {
            this.logger.error("==getJedis==", (Throwable)e);
            return null;
        }
    }

    private String setKeyIndex(String key) {
        if (null != key && key.indexOf(this.index + "_") != 0) {
            key = this.index + "_" + key;
        }
        return key;
    }

    private void returnRes(Jedis shardedJedis) {
        if (null != shardedJedis) {
            shardedJedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addVersion(String key) {
        String value = this.get(key);
        if (StringUtils.isBlank((String)value)) {
            value = "0";
        }
        Jedis shardedJedis = this.getJedis();
        try {
            value = String.valueOf(Integer.valueOf(value) + 1);
            shardedJedis.set(key, value);
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.addVersion", (Object)key, (Throwable)e);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    @Override
    public boolean checkVersion(String key, String value) {
        String oldValue = this.get(key);
        if (StringUtils.isBlank((String)oldValue)) {
            oldValue = "0";
        }
        if (StringUtils.isBlank((String)value)) {
            value = "0";
        }
        return Integer.valueOf(oldValue) - Integer.valueOf(value) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String key, String value) {
        key = this.setKeyIndex(key);
        this.addVersion(key + "-ver");
        Jedis shardedJedis = this.getJedis();
        try {
            shardedJedis.set(key, value);
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.set", (Object)key, (Throwable)e);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(String key, String value) {
        key = this.setKeyIndex(key);
        this.addVersion(key + "-ver");
        Jedis shardedJedis = this.getJedis();
        try {
            shardedJedis.append(key, value);
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.append", (Object)key, (Throwable)e);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String key) {
        long star = System.currentTimeMillis();
        this.logger.error("=======get.star=====", (Object)(System.currentTimeMillis() - star));
        key = this.setKeyIndex(key);
        Jedis shardedJedis = this.getJedis();
        try {
            String res;
            this.logger.error("=======get.star1=====", (Object)(System.currentTimeMillis() - star));
            String string = res = shardedJedis.get(key);
            return string;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.get", (Object)key, (Throwable)e);
            String string = errorCode;
            return string;
        }
        finally {
            this.returnRes(shardedJedis);
            this.logger.error("=======get.end=====", (Object)(System.currentTimeMillis() - star));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void del(String key) {
        key = this.setKeyIndex(key);
        this.addVersion(key + "-ver");
        Jedis shardedJedis = this.getJedis();
        try {
            shardedJedis.del(key);
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.del", (Object)key, (Throwable)e);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVer(String key, String value) {
        key = this.setKeyIndex(key);
        this.addVersion(key + "-ver");
        Jedis shardedJedis = this.getJedis();
        try {
            shardedJedis.set(key, value);
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.setVer", (Object)key, (Throwable)e);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendVer(String key, String value) {
        key = this.setKeyIndex(key);
        this.addVersion(key + "-ver");
        Jedis shardedJedis = this.getJedis();
        try {
            shardedJedis.append(key, value);
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.appendVer", (Object)key, (Throwable)e);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delVer(String key) {
        key = this.setKeyIndex(key);
        this.addVersion(key + "-ver");
        Jedis shardedJedis = this.getJedis();
        try {
            shardedJedis.del(key);
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.delVer", (Object)key, (Throwable)e);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setList(String key, String ... strings) {
        key = this.setKeyIndex(key);
        this.addVersion(key + "-ver");
        Jedis shardedJedis = this.getJedis();
        try {
            shardedJedis.rpush(key, strings);
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.setList", (Object)key, (Throwable)e);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getList(String key, long start, long end) {
        key = this.setKeyIndex(key);
        Jedis shardedJedis = this.getJedis();
        try {
            ArrayList<String> res = shardedJedis.lrange(key, start, end);
            if (null == res) {
                res = new ArrayList<String>();
            }
            ArrayList<String> arrayList = res;
            return arrayList;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.getList", (Object)key, (Throwable)e);
            List<String> list = null;
            return list;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lpop(String key) {
        key = this.setKeyIndex(key);
        Jedis shardedJedis = this.getJedis();
        try {
            String res;
            String string = res = shardedJedis.lpop(key);
            return string;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.lpop", (Object)key, (Throwable)e);
            String string = errorCode;
            return string;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String rpop(String key) {
        key = this.setKeyIndex(key);
        Jedis shardedJedis = this.getJedis();
        try {
            String res;
            String string = res = shardedJedis.rpop(key);
            return string;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.rpop", (Object)key, (Throwable)e);
            String string = errorCode;
            return string;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> blpop(String key) {
        key = this.setKeyIndex(key);
        Jedis shardedJedis = this.getJedis();
        try {
            ArrayList<String> res = shardedJedis.blpop(key);
            if (null == res) {
                res = new ArrayList<String>();
            }
            ArrayList<String> arrayList = res;
            return arrayList;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.blpop", (Object)key, (Throwable)e);
            List<String> list = null;
            return list;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> brpop(String key) {
        key = this.setKeyIndex(key);
        Jedis shardedJedis = this.getJedis();
        try {
            ArrayList<String> res = shardedJedis.brpop(key);
            if (null == res) {
                res = new ArrayList<String>();
            }
            ArrayList<String> arrayList = res;
            return arrayList;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.brpop", (Object)key, (Throwable)e);
            List<String> list = null;
            return list;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setListVer(String key, String ... strings) {
        key = this.setKeyIndex(key);
        this.addVersion(key + "-ver");
        Jedis shardedJedis = this.getJedis();
        try {
            shardedJedis.rpush(key, strings);
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.setListVer", (Object)key, (Throwable)e);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMap(String key, String field, String value) {
        key = this.setKeyIndex(key);
        this.addVersion(key + "-ver");
        Jedis shardedJedis = this.getJedis();
        try {
            shardedJedis.hset(key, field, value);
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.setMap", (Object)key, (Throwable)e);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMap(String key, String field) {
        key = this.setKeyIndex(key);
        Jedis shardedJedis = this.getJedis();
        try {
            String res;
            String string = res = shardedJedis.hget(key, field);
            return string;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.getMap", (Object)(key + "=" + field), (Throwable)e);
            String string = errorCode;
            return string;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getMapAll(String key) {
        long star = System.currentTimeMillis();
        this.logger.error("=======getMapAll.star=====", (Object)(System.currentTimeMillis() - star));
        key = this.setKeyIndex(key);
        Jedis shardedJedis = this.getJedis();
        try {
            this.logger.error("=======getMapAll.star1=====", (Object)(System.currentTimeMillis() - star));
            HashMap<String, String> res = shardedJedis.hgetAll(key);
            if (null == res) {
                res = new HashMap<String, String>();
            }
            HashMap<String, String> hashMap = res;
            return hashMap;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.getMapAll", (Object)key, (Throwable)e);
            Map<String, String> map = null;
            return map;
        }
        finally {
            this.returnRes(shardedJedis);
            this.logger.error("=======getMapAll.end=====", (Object)(System.currentTimeMillis() - star));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getMap(String key, String ... fields) {
        key = this.setKeyIndex(key);
        Jedis shardedJedis = this.getJedis();
        try {
            ArrayList<String> res = shardedJedis.hmget(key, fields);
            if (null == res) {
                res = new ArrayList<String>();
            }
            ArrayList<String> arrayList = res;
            return arrayList;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.getMap", (Object)key, (Throwable)e);
            List<String> list = null;
            return list;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delMap(String key, String ... fields) {
        key = this.setKeyIndex(key);
        this.addVersion(key + "-ver");
        Jedis shardedJedis = this.getJedis();
        try {
            shardedJedis.hdel(key, fields);
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.delMap", (Object)key, (Throwable)e);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMap(String key, Map<String, String> hash) {
        key = this.setKeyIndex(key);
        this.addVersion(key + "-ver");
        Jedis shardedJedis = this.getJedis();
        try {
            shardedJedis.del(key);
            shardedJedis.hmset(key, hash);
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.setMap", (Object)key, (Throwable)e);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMapVer(String key, String field, String value) {
        key = this.setKeyIndex(key);
        this.addVersion(key + "-ver");
        Jedis shardedJedis = this.getJedis();
        try {
            shardedJedis.hset(key, field, value);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delMapVer(String key, String ... fields) {
        key = this.setKeyIndex(key);
        this.addVersion(key + "-ver");
        Jedis shardedJedis = this.getJedis();
        try {
            shardedJedis.hdel(key, fields);
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.delMapVer", (Object)key, (Throwable)e);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMapVer(String key, Map<String, String> hash) {
        key = this.setKeyIndex(key);
        this.addVersion(key + "-ver");
        Jedis shardedJedis = this.getJedis();
        try {
            shardedJedis.del(key);
            shardedJedis.hmset(key, hash);
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.setMapVer", (Object)key, (Throwable)e);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    @Override
    public String getJedisConfig(String key) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Slowlog> getShowLog(String key) {
        Jedis shardedJedis = null;
        try {
            shardedJedis = this.getJedis();
            List list = shardedJedis.slowlogGet();
            return list;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.getJedisConfig.ex", (Throwable)e);
        }
        finally {
            if (null != shardedJedis) {
                this.returnRes(shardedJedis);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDbSize(String key) {
        Client client = null;
        Jedis shardedJedis = null;
        try {
            shardedJedis = this.getJedis();
            client = shardedJedis.getClient();
            if (null == client) {
                long l = 0L;
                return l;
            }
            client.dbSize();
            long l = client.getIntegerReply();
            return l;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.getJedisConfig.ex", (Throwable)e);
        }
        finally {
            if (null != shardedJedis) {
                this.returnRes(shardedJedis);
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getAllKeys(String key) {
        Jedis shardedJedis = null;
        Set s = null;
        try {
            shardedJedis = this.getJedis();
            s = shardedJedis.keys(key);
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.getJedisConfig.ex", (Throwable)e);
        }
        finally {
            if (null != shardedJedis) {
                this.returnRes(shardedJedis);
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sadd(String key, String ... values) {
        key = this.setKeyIndex(key);
        this.addVersion(key + "-ver");
        Jedis shardedJedis = this.getJedis();
        try {
            shardedJedis.sadd(key, values);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> smembers(String key) {
        key = this.setKeyIndex(key);
        Jedis shardedJedis = this.getJedis();
        try {
            Set set = shardedJedis.smembers(key);
            return set;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String spop(String key) {
        key = this.setKeyIndex(key);
        Jedis shardedJedis = this.getJedis();
        try {
            String string = shardedJedis.spop(key);
            return string;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String key, String value, int expires) {
        key = this.setKeyIndex(key);
        this.addVersion(key + "-ver");
        Jedis shardedJedis = this.getJedis();
        try {
            shardedJedis.set(key, value);
            shardedJedis.expire(key, expires);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }
}

