/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.cache.local;

import com.yqbsoft.laser.service.esb.cache.local.CacheUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;

public class LocalCache {
    public static final String SYS_CODE = "ecache.CACHE.local.LocalCache";
    protected final SupperLogUtil logger = new SupperLogUtil(this.getClass());
    public Cache cache;
    private String cacheName;
    private String cacheManagerName;
    private CacheManager cacheManager;
    private static Object objlock = new Object();
    private static Object lock = new Object();
    private static Object alllock = new Object();

    public LocalCache(String name, String cmName) {
        this.setCacheManager(CacheUtil.create(cmName));
        if (null == this.getCacheManager()) {
            this.logger.error("ecache.CACHE.local.LocalCache.LocalCache", (Object)(cmName + " is null"));
            return;
        }
        this.setCacheName(name);
        this.setCacheManagerName(cmName);
        CacheConfiguration cacheConfiguration = new CacheConfiguration(name, 1000).overflowToDisk(true).eternal(true).timeToLiveSeconds(0L).timeToIdleSeconds(0L);
        cacheConfiguration.setDiskSpoolBufferSizeMB(1024);
        cacheConfiguration.setDiskPersistent(true);
        this.setCache(new Cache(cacheConfiguration));
        this.getCacheManager().addCache(this.getCache());
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public String getCacheManagerName() {
        return this.cacheManagerName;
    }

    public void setCacheManagerName(String cacheManagerName) {
        this.cacheManagerName = cacheManagerName;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object objKey, Object objValue) {
        Object object = objlock;
        synchronized (object) {
            Element el = this.getCacheManager().getCache(this.getCacheName()).get(objKey);
            if (null != el) {
                this.getCacheManager().getCache(this.getCacheName()).remove(objKey);
            }
            this.getCacheManager().getCache(this.getCacheName()).put(new Element(objKey, objValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object get(Object objKey) {
        Element el = null;
        Object object = objlock;
        synchronized (object) {
            el = this.getCacheManager().getCache(this.getCacheName()).get(objKey);
        }
        if (null == el) {
            return null;
        }
        return el.getObjectValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putMap(String objKey, String field, String value) {
        ConcurrentHashMap<String, String> objValue = null;
        Object object = lock;
        synchronized (object) {
            objValue = (ConcurrentHashMap<String, String>)this.get(objKey);
        }
        if (null == objValue) {
            objValue = new ConcurrentHashMap<String, String>();
            this.put(objKey, objValue);
        }
        objValue.put(field, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putMapAll(String objKey, Map<String, String> value) {
        Object object = alllock;
        synchronized (object) {
            this.put(objKey, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getMap(String objKey, String field) {
        Object object = lock;
        synchronized (object) {
            Map objValue = (Map)this.get(objKey);
            if (null == objValue) {
                return null;
            }
            return (String)objValue.get(field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<String> getMap(String objKey, String ... fields) {
        Map objValue;
        if (null == fields) {
            return null;
        }
        Object object = lock;
        synchronized (object) {
            objValue = (Map)this.get(objKey);
            if (null == objValue) {
                return null;
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String string : fields) {
            list.add((String)objValue.get(string));
        }
        return list;
    }

    public final Map<String, String> getMapAll(String objKey) {
        return (Map)this.get(objKey);
    }

    public void del(String objKey) {
        try {
            this.getCacheManager().getCache(this.getCacheName()).remove((Serializable)((Object)objKey));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void delMap(String objKey, String ... fields) {
        if (null == fields) {
            return;
        }
        Map objValue = (Map)this.get(objKey);
        if (null == objValue) {
            return;
        }
        for (String string : fields) {
            objValue.remove(string);
        }
    }
}

