/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.cache;

import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
@EnableCaching
@DependsOn(value={"regeditUtil"})
public class RedisConfig
extends CachingConfigurerSupport {
    protected SupperLogUtil logger = new SupperLogUtil(RedisConfig.class);
    @Value(value="${spring.redis.jedis.pool.testOnReturn:true}")
    private boolean testOnReturn;
    @Value(value="${spring.redis.jedis.pool.testOnBorrow:true}")
    private boolean testOnBorrow;
    @Value(value="${spring.redis.jedis.pool.testWhileIdle:true}")
    private boolean testWhileIdle;
    @Value(value="${spring.redis.host}")
    private String host;
    @Value(value="${spring.redis.port}")
    private int port;
    @Value(value="${spring.redis.timeout}")
    private int timeout;
    @Value(value="${spring.redis.jedis.pool.maxidle:100}")
    private int maxIdle;
    @Value(value="${spring.redis.jedis.pool.minIdle:20}")
    private int minIdle;
    @Value(value="${spring.redis.jedis.pool.maxTotal:100}")
    private int maxTotal;
    @Value(value="${spring.redis.jedis.pool.maxwait}")
    private long maxWaitMillis;
    @Value(value="${spring.redis.jedis.pool.timeBetweenEvictionRunsMillis:30000}")
    private long timeBetweenEvictionRunsMillis;
    @Value(value="${spring.redis.jedis.pool.minEvictableIdleTimeMillis:60000}")
    private long minEvictableIdleTimeMillis;
    @Value(value="${spring.redis.jedis.pool.numTestsPerEvictionRun:3}")
    private int numTestsPerEvictionRun;
    @Value(value="${spring.redis.password}")
    private String password;
    @Value(value="${spring.redis.blockwhenexhausted}")
    private boolean blockWhenExhausted;
    @Value(value="${spring.redis.ssl:false}")
    private boolean ssl;
    @Value(value="${spring.redis.jmxEnabled:false}")
    private boolean jmxEnabled;
    @Value(value="${spring.redis.database:0}")
    private int db;
    @Value(value="${spring.redis.sentinel.master:}")
    private String master;
    @Value(value="${spring.redis.sentinel.nodes:}")
    private String sentinelnodes;
    @Value(value="${spring.redis.cluster.nodes:}")
    private String clusternodes;
    @Value(value="${spring.redis.cluster.max-redirects:3}")
    private int redirects;
    @Value(value="${spring.redis.cluster.timeout:5000}")
    private int clustertimeout;

    @Bean
    public RedisConnectionFactory redisConnectionFactory() {
        JedisPoolConfig jedisPoolConfig = this.jedisPoolConfig();
        if (StringUtils.isNotBlank((String)this.sentinelnodes)) {
            return this.getSentinelJedisConnectionFactory(this.db, this.sentinelnodes, this.master, this.password);
        }
        if (StringUtils.isNotBlank((String)this.clusternodes)) {
            return this.getClusterJedisConnectionFactory(this.clusternodes, this.password, this.redirects);
        }
        RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration();
        redisStandaloneConfiguration.setHostName(this.host);
        redisStandaloneConfiguration.setPort(this.port);
        if (StringUtils.isNotBlank((String)this.password)) {
            redisStandaloneConfiguration.setPassword(RedisPassword.of((String)this.password));
        }
        JedisClientConfiguration.JedisClientConfigurationBuilder jedisClientConfigurationBuilder = JedisClientConfiguration.builder();
        JedisClientConfiguration jedisClientConfiguration = jedisClientConfigurationBuilder.usePooling().poolConfig((GenericObjectPoolConfig)jedisPoolConfig).build();
        return new JedisConnectionFactory(redisStandaloneConfiguration, jedisClientConfiguration);
    }

    private JedisConnectionFactory getClusterJedisConnectionFactory(String nodes, String password, int redirects) {
        if (StringUtils.isBlank((String)nodes)) {
            this.logger.info("RedisConfig.getClusterJedisConnectionFactory.null");
            return null;
        }
        HashMap<String, Object> source = new HashMap<String, Object>();
        source.put("spring.redis.cluster.nodes", nodes);
        source.put("spring.redis.cluster.timeout", this.clustertimeout);
        RedisClusterConfiguration conf = new RedisClusterConfiguration((PropertySource)new MapPropertySource("RedisClusterConfiguration", source));
        if (StringUtils.isNotBlank((String)password)) {
            conf.setPassword(RedisPassword.of((String)password));
        }
        conf.setMaxRedirects(redirects);
        JedisConnectionFactory jedisConnectionFactory = new JedisConnectionFactory(conf);
        jedisConnectionFactory.afterPropertiesSet();
        return jedisConnectionFactory;
    }

    private JedisConnectionFactory getSentinelJedisConnectionFactory(int db, String nodes, String master, String password) {
        if (StringUtils.isBlank((String)master) || StringUtils.isBlank((String)nodes)) {
            this.logger.info("RedisConfig.getSentinelJedisConnectionFactory.null");
            return null;
        }
        String[] split = nodes.split(",");
        RedisSentinelConfiguration redisSentinelConfiguration = new RedisSentinelConfiguration();
        for (int i = 0; i < split.length; ++i) {
            String[] node = split[i].split(":");
            RedisNode redisNode = new RedisNode(node[0], Integer.parseInt(node[1]));
            redisNode.setName(master);
            redisSentinelConfiguration.addSentinel(redisNode);
        }
        redisSentinelConfiguration.setDatabase(db);
        redisSentinelConfiguration.setMaster(master);
        if (StringUtils.isNotBlank((String)password)) {
            redisSentinelConfiguration.setPassword(RedisPassword.of((String)password));
        }
        JedisConnectionFactory jedisConnectionFactory = new JedisConnectionFactory(redisSentinelConfiguration);
        jedisConnectionFactory.afterPropertiesSet();
        return jedisConnectionFactory;
    }

    @Bean(name={"jedisPool"})
    public JedisPool redisPoolFactory() throws Exception {
        this.logger.info("=====", (Object)"JedisPool start");
        JedisPoolConfig jedisPoolConfig = this.jedisPoolConfig();
        JedisPool jedisPool = null;
        if (StringUtils.isNotBlank((String)this.password)) {
            this.logger.info("==p===", (Object)"JedisPool end");
            jedisPool = new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, this.host, this.port, this.timeout, this.password, this.ssl);
        } else {
            this.logger.info("==np===", (Object)"JedisPool end");
            jedisPool = new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, this.host, this.port, this.timeout, this.ssl);
        }
        this.logger.info("=====", (Object)("JedisPool end" + this.host + ":" + this.port));
        return jedisPool;
    }

    @Bean
    public JedisPoolConfig jedisPoolConfig() {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxIdle(this.maxIdle);
        jedisPoolConfig.setMaxTotal(this.maxTotal);
        jedisPoolConfig.setMinIdle(this.minIdle);
        jedisPoolConfig.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis);
        jedisPoolConfig.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        jedisPoolConfig.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis);
        jedisPoolConfig.setMaxWaitMillis(this.maxWaitMillis);
        jedisPoolConfig.setBlockWhenExhausted(this.blockWhenExhausted);
        jedisPoolConfig.setJmxEnabled(this.jmxEnabled);
        jedisPoolConfig.setTestOnBorrow(this.testOnBorrow);
        jedisPoolConfig.setTestWhileIdle(this.testWhileIdle);
        jedisPoolConfig.setTestOnReturn(this.testOnReturn);
        return jedisPoolConfig;
    }
}

