/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.cache;

import com.fasterxml.jackson.core.type.TypeReference;
import com.yqbsoft.laser.service.esb.cache.CacheBean;
import com.yqbsoft.laser.service.esb.cache.OkHttpUtil;
import com.yqbsoft.laser.service.esb.cache.RedisConfig;
import com.yqbsoft.laser.service.esb.cache.SpringBootRedisUtil;
import com.yqbsoft.laser.service.esb.cache.local.LocalCache;
import com.yqbsoft.laser.service.suppercore.cache.dis.DisCache;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@Service(value="disCache")
@DependsOn(value={"supSpringApplicationContextUtil"})
public class DisCacheImpl
implements DisCache {
    protected final SupperLogUtil logger = new SupperLogUtil(this.getClass());
    private static final Long SYNC_TIME = 300000L;
    private static final String stringCache = "StringCache";
    private static final String mapCache = "MapCache";
    private static final String OBJECT_CACHE = "ObjectCache";
    public static final String redis_ver = "-1";
    public static final String vm_cver = "-2";
    public static final String vm_ccver = "-2";
    private Map<String, String> versionMap = new ConcurrentHashMap<String, String>();
    private Map<String, Long> timeMap = new ConcurrentHashMap<String, Long>();
    private Map<String, Long> timeValueMap = new ConcurrentHashMap<String, Long>();
    private static final LocalCache stringLocalCache = new LocalCache("StringCache", "defcmname");
    private static final LocalCache mapLocalCache = new LocalCache("MapCache", "defcmname");
    private static final LocalCache objectLocalCache = new LocalCache("ObjectCache", "defcmname");
    @Autowired
    SpringBootRedisUtil springBootRedisUtil;
    @Autowired
    private RedisConfig redisConfig;

    public void setSpringBootRedisUtil(SpringBootRedisUtil springBootRedisUtil) {
        this.springBootRedisUtil = springBootRedisUtil;
    }

    public Map<String, Long> getTimeValueMap() {
        return this.timeValueMap;
    }

    public void setTimeValueMap(Map<String, Long> timeValueMap) {
        this.timeValueMap = timeValueMap;
    }

    public Map<String, String> getVersionMap() {
        return this.versionMap;
    }

    public void setVersionMap(Map<String, String> versionMap) {
        this.versionMap = versionMap;
    }

    public Map<String, Long> getTimeMap() {
        return this.timeMap;
    }

    public void setTimeMap(Map<String, Long> timeMap) {
        this.timeMap = timeMap;
    }

    private Long getSyncTime(String key) {
        Long syncTime = this.getTimeValueMap().get(key);
        if (null == syncTime) {
            String st = this.springBootRedisUtil.getMap("synctimer", key);
            syncTime = "redis.error".equals(st) || StringUtils.isBlank((String)st) ? SYNC_TIME : Long.valueOf(st);
            this.getTimeValueMap().put(key, syncTime);
        }
        return syncTime;
    }

    private CacheBean exesync(String key, String field, Long ctime) {
        CacheBean cacheBean = new CacheBean();
        cacheBean.setFlag(false);
        if (this.rometflag(key)) {
            cacheBean.setFlag(true);
            return cacheBean;
        }
        Long vtime = this.getTimeMap().get(key + "-" + field);
        if (vtime == null) {
            cacheBean.setFlag(true);
            return cacheBean;
        }
        Long syncTime = this.getSyncTime(key);
        if (null == syncTime) {
            syncTime = SYNC_TIME;
        }
        if ("0".equals(String.valueOf(syncTime))) {
            cacheBean.setFlag(false);
            return cacheBean;
        }
        if (vtime == null || ctime - vtime >= syncTime) {
            String ver;
            this.getTimeMap().put(key + "-" + field, ctime);
            String cver = this.getVersionMap().get(key);
            String ccver = this.getVersionMap().get(key + "-" + field);
            if (StringUtils.isBlank((String)cver)) {
                cver = "-2";
            }
            if (StringUtils.isBlank((String)ccver)) {
                ccver = "-2";
            }
            if (StringUtils.isBlank((String)(ver = this.getRemot(key + "-ver"))) || "redis.error".equals(ver)) {
                ver = redis_ver;
            }
            if (StringUtils.isBlank((String)ver)) {
                ver = redis_ver;
            }
            cacheBean.setVer(ver);
            if (redis_ver.equals(ver)) {
                cacheBean.setFlag(true);
                return cacheBean;
            }
            if (Integer.valueOf(cver) < 0 || Integer.valueOf(ver) > Integer.valueOf(cver)) {
                cacheBean.setFlag(true);
            } else if (Integer.valueOf(ccver) < 0 || Integer.valueOf(ver) > Integer.valueOf(ccver)) {
                cacheBean.setFlag(true);
            }
        }
        return cacheBean;
    }

    private void exesyncUpdate(String key, String field, Long ctime, String ver) {
        this.getTimeMap().put(key + "-" + field, ctime);
        if (StringUtils.isNotBlank((String)ver)) {
            this.getVersionMap().put(key + "-" + field, ver);
        }
    }

    private void exesyncUpdate(String key, Long ctime, String ver) {
        this.getTimeMap().put(key, ctime);
        if (StringUtils.isNotBlank((String)ver)) {
            this.getVersionMap().put(key, ver);
        }
    }

    private CacheBean exesync(String key, Long ctime) {
        CacheBean cacheBean = new CacheBean();
        cacheBean.setFlag(false);
        if (this.rometflag(key)) {
            cacheBean.setFlag(true);
            return cacheBean;
        }
        Long vtime = this.getTimeMap().get(key);
        if (vtime == null) {
            cacheBean.setFlag(true);
            return cacheBean;
        }
        Long syncTime = this.getSyncTime(key);
        if (null == syncTime) {
            syncTime = SYNC_TIME;
        }
        if ("0".equals(String.valueOf(syncTime))) {
            cacheBean.setFlag(true);
            return cacheBean;
        }
        if (vtime == null || ctime - vtime >= syncTime) {
            String ver;
            this.getTimeMap().put(key, ctime);
            String cver = this.getVersionMap().get(key);
            if (StringUtils.isBlank((String)cver)) {
                cver = "-2";
            }
            if (StringUtils.isBlank((String)(ver = this.getRemot(key + "-ver"))) || "redis.error".equals(ver)) {
                ver = "0";
            }
            if (StringUtils.isBlank((String)ver)) {
                ver = "0";
            }
            cacheBean.setVer(ver);
            if (redis_ver.equals(ver)) {
                cacheBean.setFlag(true);
                return cacheBean;
            }
            if (Integer.valueOf(cver) < 0 || Integer.valueOf(ver) > Integer.valueOf(cver)) {
                cacheBean.setFlag(true);
                return cacheBean;
            }
        }
        return cacheBean;
    }

    private boolean rometflag(String key) {
        Long syncTime = this.getSyncTime(key);
        this.logger.info("DisCacheImpl.rometflag.key:" + key, (Object)syncTime);
        return redis_ver.equals(String.valueOf(syncTime));
    }

    public void setJson(String key, Object value) {
        this.springBootRedisUtil.set(key, JsonUtil.buildNormalBinder().toJson(value));
    }

    public void setJsonVer(String key, Object value) {
        if (StringUtils.isNotBlank((String)this.redisConfig.getTestUrl())) {
            this.setJson(key, null, value.toString(), 0, "setJsonVer");
        } else {
            this.springBootRedisUtil.set(key, JsonUtil.buildNormalBinder().toJson(value));
        }
    }

    public void append(String key, String value) {
        if (StringUtils.isNotBlank((String)this.redisConfig.getTestUrl())) {
            this.setJson(key, null, value, 0, "append");
        } else {
            this.springBootRedisUtil.append(key, value);
        }
    }

    public <T> T getRemot(String key, Class<T> classz, String formatJson, Class clazz, Class valueclazz, TypeReference typeReference) {
        Object object = null;
        String json = this.get(key);
        if (StringUtils.isBlank((String)json)) {
            return null;
        }
        object = this.getFormat(formatJson, json, clazz, valueclazz, typeReference);
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(String key, Class<T> classz, String formatJson, Class clazz, Class valueclazz, TypeReference typeReference) {
        Object object = null;
        if (!this.rometflag(key)) {
            Long ctime = System.currentTimeMillis();
            CacheBean cacheBean = null;
            DisCacheImpl disCacheImpl = this;
            synchronized (disCacheImpl) {
                cacheBean = this.exesync(key, ctime);
            }
            if (null != cacheBean && cacheBean.isFlag()) {
                String ver = cacheBean.getVer();
                String obj = this.springBootRedisUtil.get(key);
                if (!"redis.error".equals(obj) && StringUtils.isNotBlank((String)obj)) {
                    object = this.getFormat(formatJson, obj, clazz, valueclazz, typeReference);
                    objectLocalCache.put(key, object);
                    this.exesyncUpdate(key, ctime, ver);
                } else {
                    objectLocalCache.del(key);
                    if ("redis.error".equals(obj)) {
                        ver = redis_ver;
                        obj = null;
                    }
                    this.exesyncUpdate(key, ctime, ver);
                }
            } else {
                object = objectLocalCache.get(key);
            }
        } else {
            object = this.getRemot(key, classz, formatJson, clazz, valueclazz, typeReference);
        }
        if (null == object) {
            return null;
        }
        return (T)object;
    }

    private Object getFormat(String formatJson, String json, Class clazz, Class valueclazz, TypeReference typeReference) {
        if (StringUtils.isBlank((String)formatJson)) {
            return null;
        }
        if ("getJsonToList".equals(formatJson)) {
            return this.getJsonToList(json, clazz);
        }
        if ("getJsonToListByMap".equals(formatJson)) {
            return this.getJsonToListByMap(json, clazz);
        }
        if ("getJsonToObject".equals(formatJson)) {
            return this.getJsonToObject(json, clazz);
        }
        if ("getJsonToMap".equals(formatJson)) {
            return this.getJsonToMap(json, clazz, valueclazz);
        }
        if ("getJsonToConcMap".equals(formatJson)) {
            return this.getJsonToConcMap(json, clazz, valueclazz);
        }
        if ("getJsonToObject".equals(formatJson)) {
            return this.getJsonToObject(json, typeReference);
        }
        if ("getJsonToMapByList".equals(formatJson)) {
            return this.getJsonToMapByList(json, clazz, valueclazz);
        }
        if ("getJsonToMapByMap".equals(formatJson)) {
            return this.getJsonToMapByMap(json, clazz, valueclazz);
        }
        return null;
    }

    private List getJsonToList(String json, Class clazz) {
        return JsonUtil.buildNormalBinder().getJsonToList(json, clazz);
    }

    private List getJsonToListByMap(String json, Class clazz) {
        return JsonUtil.buildNormalBinder().getJsonToListByMap(json, clazz);
    }

    public List getListByMapJson(String key, Class clazz) {
        List object = this.getRemot(key, List.class, "getJsonToListByMap", clazz, null, null);
        return object;
    }

    private Object getJsonToObject(String json, Class classz) {
        return JsonUtil.buildNormalBinder().getJsonToObject(json, classz);
    }

    public Object getObjectJson(String key, Class clazz) {
        Object object = this.getRemot(key, Object.class, "getJsonToObject", clazz, null, null);
        return object;
    }

    private Map getJsonToMap(String json, Class keyclazz, Class valueclazz) {
        return JsonUtil.buildNormalBinder().getJsonToMap(json, keyclazz, valueclazz);
    }

    private ConcurrentHashMap getJsonToConcMap(String json, Class keyclazz, Class valueclazz) {
        return JsonUtil.buildNormalBinder().getJsonToConcMap(json, keyclazz, valueclazz);
    }

    public Map getConcMapJson(String key, Class keyclazz, Class valueclazz) {
        Map object = this.getRemot(key, Map.class, "getJsonToConcMap", keyclazz, valueclazz, null);
        return object;
    }

    private <T> T getJsonToObject(String json, TypeReference<T> typeReference) {
        return (T)JsonUtil.buildNormalBinder().getJsonToObject(json, typeReference);
    }

    public <T> Object getObject(String key, TypeReference<T> typeReference) {
        Object object = this.getRemot(key, Object.class, "getJsonToObject", null, null, typeReference);
        return object;
    }

    private <K, V> Map<K, List<V>> getJsonToMapByList(String json, Class<K> keyclazz, Class<V> valueclazz) {
        return JsonUtil.buildNormalBinder().getJsonToMapByList(json, keyclazz, valueclazz);
    }

    public Map getMapByListJson(String key, Class keyclazz, Class valueclazz) {
        Map object = this.getRemot(key, Map.class, "getJsonToMapByList", keyclazz, valueclazz, null);
        return object;
    }

    public Map getRemotMapByListJson(String key, Class keyclazz, Class valueclazz) {
        Map object = this.getRemot(key, Map.class, "getJsonToMapByList", keyclazz, valueclazz, null);
        return object;
    }

    private Map getJsonToMapByMap(String json, Class keyclazz, Class valueclazz) {
        return JsonUtil.buildNormalBinder().getJsonToMapByMap(json, keyclazz, valueclazz);
    }

    public Map getMapByMapJson(String key, Class keyclazz, Class valueclazz) {
        Map object = this.getRemot(key, Map.class, "getJsonToMapByMap", keyclazz, valueclazz, null);
        return object;
    }

    public void del(String key) {
        this.delCache(key);
        this.springBootRedisUtil.delVer(key);
    }

    public void delCache(String key) {
        stringLocalCache.del(key);
        mapLocalCache.del(key);
        objectLocalCache.del(key);
    }

    public void setVer(String key, String value) {
        this.springBootRedisUtil.setVer(key, value);
    }

    public void appendVer(String key, String value) {
        this.springBootRedisUtil.appendVer(key, value);
    }

    public void delVer(String key) {
        this.springBootRedisUtil.delVer(key);
        this.delCache(key);
    }

    public void setList(String key, String ... strings) {
        this.springBootRedisUtil.setList(key, strings);
    }

    public void setListVer(String key, String ... strings) {
        this.springBootRedisUtil.setListVer(key, strings);
    }

    public List<String> blpop(String key) {
        return this.springBootRedisUtil.blpop(key);
    }

    public List<String> brpop(String key) {
        return this.springBootRedisUtil.brpop(key);
    }

    public List<String> getList(String key, long start, long end) {
        return this.springBootRedisUtil.getList(key, start, end);
    }

    public String lpop(String key) {
        String obj = this.springBootRedisUtil.lpop(key);
        if ("redis.error".equals(obj)) {
            return null;
        }
        return obj;
    }

    public String rpop(String key) {
        String obj = this.springBootRedisUtil.rpop(key);
        if ("redis.error".equals(obj)) {
            return null;
        }
        return obj;
    }

    public String getRemotMap(String key, String field) {
        String obj = this.springBootRedisUtil.getMap(key, field);
        if ("redis.error".equals(obj)) {
            return null;
        }
        return obj;
    }

    public Map<?, ?> getMapMapJson(String key, String field, Class<?> keyclazz, Class<?> keyclazzy) {
        Map obj = null;
        if (!this.rometflag(key)) {
            Long ctime = System.currentTimeMillis();
            CacheBean cacheBean = this.exesync(key, field, ctime);
            if (null != cacheBean && cacheBean.isFlag()) {
                String ver = cacheBean.getVer();
                String json = this.springBootRedisUtil.getMap(key, field);
                if (!"redis.error".equals(json) && null != json) {
                    obj = JsonUtil.buildNormalBinder().getJsonToMap(json, keyclazz, keyclazzy);
                    objectLocalCache.put(key + "-" + field, obj);
                    this.exesyncUpdate(key, field, ctime, ver);
                } else {
                    obj = null;
                    objectLocalCache.del(key + "-" + field);
                    if ("redis.error".equals(json)) {
                        ver = redis_ver;
                        json = null;
                    }
                    this.exesyncUpdate(key, field, ctime, ver);
                }
            } else {
                obj = (Map)objectLocalCache.get(key + "-" + field);
            }
        } else {
            String json = this.getRemotMap(key, field);
            obj = !"redis.error".equals(json) && null != json ? JsonUtil.buildNormalBinder().getJsonToMap(json, keyclazz, keyclazzy) : null;
        }
        return obj;
    }

    public Map<String, String> getRemotMapAll(String key) {
        return this.springBootRedisUtil.getMapAll(key);
    }

    public List<String> getMap(String key, String ... fields) {
        return null;
    }

    public void delMap(String key, String ... fields) {
        this.springBootRedisUtil.delMap(key, fields);
    }

    public void setMap(String key, Map<String, String> hash) {
        if (null == hash || hash.isEmpty()) {
            return;
        }
        this.springBootRedisUtil.setMap(key, hash);
    }

    public void setMapVer(String key, String field, String value) {
        if (null == field || "".equals(field)) {
            return;
        }
        this.springBootRedisUtil.setMapVer(key, field, value);
    }

    public void delMapVer(String key, String ... fields) {
        this.springBootRedisUtil.delMapVer(key, fields);
    }

    public void setMapVer(String key, Map<String, String> hash) {
        if (null == hash || hash.isEmpty()) {
            hash = new HashMap<String, String>();
        }
        this.springBootRedisUtil.setMapVer(key, hash);
    }

    public void sadd(String key, String ... values) {
        this.springBootRedisUtil.sadd(key, values);
    }

    public Set<String> smembers(String key) {
        return this.springBootRedisUtil.smembers(key);
    }

    public String spop(String key) {
        return this.springBootRedisUtil.spop(key);
    }

    public void setJson(String key, Object value, int expires) {
        if (StringUtils.isNotBlank((String)this.redisConfig.getTestUrl())) {
            this.setJson(key, null, value.toString(), expires, "setJson");
        } else {
            this.springBootRedisUtil.set(key, JsonUtil.buildNormalBinder().toJson(value), expires);
        }
    }

    public void setExpire(String key, int expires) {
        this.springBootRedisUtil.setExpire(key, expires);
    }

    public String get(String key) {
        if (this.rometflag(key)) {
            return this.getRemot(key);
        }
        String obj = (String)stringLocalCache.get(key);
        Long ctime = System.currentTimeMillis();
        CacheBean cacheBean = this.exesync(key, ctime);
        if (null != cacheBean && cacheBean.isFlag()) {
            String ver = cacheBean.getVer();
            obj = this.springBootRedisUtil.get(key);
            if (!"redis.error".equals(obj) && null != obj) {
                stringLocalCache.put(key, obj);
                this.exesyncUpdate(key, ctime, ver);
            } else {
                stringLocalCache.del(key);
                if ("redis.error".equals(obj)) {
                    ver = redis_ver;
                    obj = null;
                }
                this.exesyncUpdate(key, ctime, ver);
            }
        }
        return obj;
    }

    public String getRemot(String key) {
        String obj = this.springBootRedisUtil.get(key);
        if ("redis.error".equals(obj)) {
            return null;
        }
        return obj;
    }

    public String getMap(String key, String field) {
        if (this.rometflag(key)) {
            return this.getRemotMap(key, field);
        }
        Long ctime = System.currentTimeMillis();
        String obj = null;
        CacheBean cacheBean = this.exesync(key, "map-" + field, ctime);
        if (null != cacheBean && cacheBean.isFlag()) {
            String ver = cacheBean.getVer();
            obj = this.springBootRedisUtil.getMap(key, field);
            if (!"redis.error".equals(obj) && StringUtils.isNotBlank((String)obj)) {
                mapLocalCache.putMap(key, field, obj);
                this.exesyncUpdate(key, "map-" + field, ctime, ver);
            } else {
                mapLocalCache.delMap(key, field);
                if ("redis.error".equals(obj)) {
                    ver = redis_ver;
                    obj = null;
                }
                this.exesyncUpdate(key, "map-" + field, ctime, ver);
            }
        } else {
            obj = mapLocalCache.getMap(key, field);
        }
        return obj;
    }

    public List getMapListJson(String key, String field, Class keyclazz) {
        List obj = null;
        if (!this.rometflag(key)) {
            Long ctime = System.currentTimeMillis();
            CacheBean cacheBean = this.exesync(key, field, ctime);
            if (null != cacheBean && cacheBean.isFlag()) {
                String ver = cacheBean.getVer();
                String json = this.springBootRedisUtil.getMap(key, field);
                if (!"redis.error".equals(json) && null != json) {
                    obj = JsonUtil.buildNormalBinder().getJsonToList(json, keyclazz);
                    objectLocalCache.put(key + "-" + field, obj);
                    this.exesyncUpdate(key, field, ctime, ver);
                } else {
                    obj = null;
                    objectLocalCache.del(key + "-" + field);
                    if ("redis.error".equals(json)) {
                        ver = redis_ver;
                    }
                    this.exesyncUpdate(key, field, ctime, ver);
                }
            } else {
                obj = (List)objectLocalCache.get(key + "-" + field);
            }
        } else {
            String json = this.getRemotMap(key, field);
            obj = !"redis.error".equals(json) && null != json ? JsonUtil.buildNormalBinder().getJsonToList(json, keyclazz) : null;
        }
        return obj;
    }

    public Map getMapJson(String key, Class keyclazz, Class valueclazz) {
        Map object = this.get(key, Map.class, "getMapJson", keyclazz, valueclazz, null);
        return object;
    }

    public <T> Object getMapJson(String key, String field, Class<T> keyclazz) {
        Object obj = null;
        if (!this.rometflag(key)) {
            Long ctime = System.currentTimeMillis();
            CacheBean cacheBean = this.exesync(key, field, ctime);
            if (null != cacheBean && cacheBean.isFlag()) {
                String ver = cacheBean.getVer();
                String json = this.springBootRedisUtil.getMap(key, field);
                if (!"redis.error".equals(json) && null != json) {
                    obj = JsonUtil.buildNormalBinder().getJsonToObject(json, keyclazz);
                    objectLocalCache.put(key + "-" + field, obj);
                    this.exesyncUpdate(key, field, ctime, ver);
                } else {
                    obj = null;
                    objectLocalCache.del(key + "-" + field);
                    if ("redis.error".equals(json)) {
                        ver = redis_ver;
                    }
                    this.exesyncUpdate(key, field, ctime, ver);
                }
            } else {
                obj = objectLocalCache.get(key + "-" + field);
            }
        } else {
            String json = this.getRemotMap(key, field);
            obj = !"redis.error".equals(json) && null != json ? JsonUtil.buildNormalBinder().getJsonToObject(json, keyclazz) : null;
        }
        return obj;
    }

    public List getListJson(String key, Class clazz) {
        this.logger.info("DisCacheImpl.getListJson.key" + key);
        List object = this.get(key, List.class, "getJsonToList", clazz, null, null);
        if (null == object) {
            return null;
        }
        ArrayList relist = new ArrayList();
        for (Object object2 : object) {
            relist.add(object2);
        }
        return relist;
    }

    public Map<String, String> getMapAll(String key) {
        if (this.rometflag(key)) {
            return this.getRemotMapAll(key);
        }
        Map<String, String> obj = mapLocalCache.getMapAll(key);
        Long ctime = System.currentTimeMillis();
        CacheBean cacheBean = this.exesync(key, ctime);
        if (null != cacheBean && cacheBean.isFlag()) {
            String ver = cacheBean.getVer();
            obj = this.getRemotMapAll(key);
            if (null != obj) {
                mapLocalCache.putMapAll(key, obj);
                this.exesyncUpdate(key, ctime, ver);
            } else {
                mapLocalCache.del(key);
                ver = redis_ver;
                this.exesyncUpdate(key, ctime, ver);
            }
        }
        return obj;
    }

    public void set(String key, String value) {
        if (StringUtils.isNotBlank((String)this.redisConfig.getTestUrl())) {
            this.setJson(key, null, value, 0, "set");
        } else {
            this.springBootRedisUtil.set(key, value);
        }
    }

    public void set(String key, String value, int expires) {
        if (StringUtils.isNotBlank((String)this.redisConfig.getTestUrl())) {
            this.setJson(key, null, value, expires, "setExpires");
        } else {
            this.springBootRedisUtil.set(key, value, expires);
        }
    }

    public void setMap(String key, String field, String value) {
        if (StringUtils.isNotBlank((String)this.redisConfig.getTestUrl())) {
            this.setJson(key, field, value, 0, "setMap");
        } else {
            if (null == field || "".equals(field)) {
                return;
            }
            this.springBootRedisUtil.setMap(key, field, value);
        }
    }

    public String setJson(String key, String field, String value, int expires, String type) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        try {
            pmap.put("key", key);
            pmap.put("field", field);
            pmap.put("value", value);
            pmap.put("expires", String.valueOf(expires));
            pmap.put("type", type);
            pmap.put("method", "es.redisCache.setJson");
            String testUrl = "http://172.20.1.71:8080";
            if (StringUtils.isNotBlank((String)this.redisConfig.getTestUrl())) {
                testUrl = this.redisConfig.getTestUrl();
            }
            OkHttpUtil.httpPostJson(testUrl + "/laserIr/http/post", pmap);
        }
        catch (Exception e) {
            this.logger.error("DisCacheImpl.setJson" + JsonUtil.buildNormalBinder().toJson(pmap), (Throwable)e);
        }
        return null;
    }

    public <T> Object getRemotMapJson(String key, String field, Class<T> keyclazz) {
        return null;
    }

    public List<?> getRemotMapListJson(String key, String field, Class<?> keyclazz) {
        return null;
    }

    public Map<?, ?> getRemotMapMapJson(String key, String field, Class<?> keyclazz, Class<?> keyclazzy) {
        return null;
    }

    public boolean setnx(String key, String value, int expires) {
        return this.springBootRedisUtil.setnx(key, value, expires);
    }

    abstract class FormatJson {
        FormatJson() {
        }

        abstract <T> T format(String var1, Class<T> var2);
    }
}

