/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.cache;

import com.yqbsoft.laser.service.esb.cache.HtmlJsonReBean;
import com.yqbsoft.laser.service.esb.cache.OkHttpUtil;
import com.yqbsoft.laser.service.esb.cache.RedisCache;
import com.yqbsoft.laser.service.esb.cache.RedisConfig;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.util.Slowlog;

@Service
public class SpringBootRedisUtil
implements RedisCache {
    public static final String SYS_CODE = "ecache.CACHE.JedisSentineUtil";
    public static final String errorCode = "redis.error";
    private String index = "0";
    protected SupperLogUtil logger = new SupperLogUtil(SpringBootRedisUtil.class);
    RedisTemplate<String, String> redisTemplate;
    @Autowired
    private RedisConfig redisConfig;

    @Autowired
    public void setRedisTemplate(RedisTemplate<String, String> jedisRedisTemplate) {
        this.redisTemplate = jedisRedisTemplate;
    }

    private String setKeyIndex(String key) {
        if (null != key && key.indexOf(this.index + "_") != 0) {
            key = this.index + "_" + key;
        }
        return key;
    }

    private void returnRes(Jedis shardedJedis) {
        if (null != shardedJedis) {
            shardedJedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVersion(String key) {
        if (null == this.redisTemplate) {
            return;
        }
        String value = this.get(this.redisTemplate, key);
        if (StringUtils.isBlank((String)value)) {
            value = "0";
        }
        try {
            value = String.valueOf(Integer.valueOf(value) + 1);
            this.redisTemplate.opsForValue().set((Object)key, (Object)value);
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.addVersion", (Object)key, (Throwable)e);
        }
    }

    @Override
    public boolean checkVersion(String key, String value) {
        String oldValue = this.get(key);
        if (StringUtils.isBlank((String)oldValue)) {
            oldValue = "0";
        }
        if (StringUtils.isBlank((String)value)) {
            value = "0";
        }
        return Integer.valueOf(oldValue) - Integer.valueOf(value) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String key, String value) {
        key = this.setKeyIndex(key);
        try {
            this.addVersion(key + "-ver");
            this.redisTemplate.opsForValue().set((Object)key, (Object)value);
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.set", (Object)key, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setnx(String key, String value, int timeout) {
        key = this.setKeyIndex(key);
        try {
            boolean bl = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, (long)timeout, TimeUnit.SECONDS);
            return bl;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.setnx", (Object)key, (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(String key1, String value) {
        String key = this.setKeyIndex(key1);
        try {
            this.addVersion(key + "-ver");
            this.redisTemplate.opsForValue().append((Object)key, value);
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.append", (Object)key, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkKey(String key1) {
        String key = this.setKeyIndex(key1);
        try {
            boolean bl = this.redisTemplate.hasKey((Object)key);
            return bl;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.get", (Object)key, (Throwable)e);
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String key1) {
        this.logger.info("SpringBootRedisUtil.get.key" + key1, (Object)this.redisConfig.getTestUrl());
        if (StringUtils.isNotBlank((String)this.redisConfig.getTestUrl())) {
            return this.getJson(key1, null, "get");
        }
        String key = this.setKeyIndex(key1);
        try {
            String res;
            String string = res = (String)this.redisTemplate.opsForValue().get((Object)key);
            return string;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.get", (Object)key, (Throwable)e);
            String string = errorCode;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(RedisTemplate<String, String> redisTemplate, String key) {
        if (null == redisTemplate) {
            return null;
        }
        key = this.setKeyIndex(key);
        try {
            String res;
            String string = res = (String)redisTemplate.opsForValue().get((Object)key);
            return string;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.get", (Object)key, (Throwable)e);
            String string = errorCode;
            return string;
        }
    }

    @Override
    public void del(String key) {
        this.delVer(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVer(String key, String value) {
        try {
            key = this.setKeyIndex(key);
            this.addVersion(key + "-ver");
            this.redisTemplate.opsForValue().set((Object)key, (Object)value);
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.setVer", (Object)key, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendVer(String key, String value) {
        try {
            key = this.setKeyIndex(key);
            this.addVersion(key + "-ver");
            this.redisTemplate.opsForValue().append((Object)key, value);
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.appendVer", (Object)key, (Throwable)e);
        }
    }

    @Override
    public void delVer(String key) {
        try {
            this.delMap(key);
            key = this.setKeyIndex(key);
            this.addVersion(key + "-ver");
            this.redisTemplate.delete((Object)key);
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.delVer", (Object)key, (Throwable)e);
        }
    }

    private void delMap(String key) {
        Map entries = this.redisTemplate.opsForHash().entries((Object)key);
        if (entries == null || entries.size() == 0) {
            return;
        }
        for (Map.Entry entry : entries.entrySet()) {
            String hashKey = null != entry.getKey() ? entry.getKey().toString() : null;
            if (hashKey == null) continue;
            this.del(this.creatMapKey(key, hashKey));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setList(String key, String ... strings) {
        key = this.setKeyIndex(key);
        try {
            this.addVersion(key + "-ver");
            this.redisTemplate.opsForList().rightPushAll((Object)key, (Object[])strings);
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.setList", (Object)key, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getList(String key, long start, long end) {
        key = this.setKeyIndex(key);
        try {
            ArrayList<String> res = this.redisTemplate.opsForList().range((Object)key, start, end);
            if (null == res) {
                res = new ArrayList<String>();
            }
            ArrayList<String> arrayList = res;
            return arrayList;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.getList", (Object)key, (Throwable)e);
            List<String> list = null;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lpop(String key) {
        if (StringUtils.isNotBlank((String)this.redisConfig.getTestUrl())) {
            return this.getJson(key, null, "lpop");
        }
        key = this.setKeyIndex(key);
        try {
            String res;
            String string = res = (String)this.redisTemplate.opsForList().leftPop((Object)key);
            return string;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.lpop", (Object)key, (Throwable)e);
            String string = errorCode;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String rpop(String key) {
        if (StringUtils.isNotBlank((String)this.redisConfig.getTestUrl())) {
            return this.getJson(key, null, "rpop");
        }
        key = this.setKeyIndex(key);
        try {
            String res;
            String string = res = (String)this.redisTemplate.opsForList().rightPop((Object)key);
            return string;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.rpop", (Object)key, (Throwable)e);
            String string = errorCode;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> blpop(String key) {
        if (StringUtils.isNotBlank((String)this.redisConfig.getTestUrl())) {
            String json = this.getJson(key, null, "blpop");
            return JsonUtil.buildNormalBinder().getJsonToList(json, String.class);
        }
        key = this.setKeyIndex(key);
        try {
            this.redisTemplate.opsForList().leftPop((Object)key);
            ArrayList<String> res = this.redisTemplate.opsForList().range((Object)"list", 0L, -1L);
            if (null == res) {
                res = new ArrayList<String>();
            }
            ArrayList<String> arrayList = res;
            return arrayList;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.blpop", (Object)key, (Throwable)e);
            List<String> list = null;
            return list;
        }
    }

    public String getJson(String key, String field, String type) {
        try {
            HtmlJsonReBean htmlJsonReBean;
            HashMap<String, String> pmap = new HashMap<String, String>();
            pmap.put("key", key);
            pmap.put("field", field);
            pmap.put("type", type);
            pmap.put("method", "es.redisCache.getJson");
            String testUrl = this.redisConfig.getTestUrl();
            this.logger.debug("DisCacheImpl.getJson.map", (Object)JsonUtil.buildNormalBinder().toJson(pmap));
            long startime = System.currentTimeMillis();
            String json = OkHttpUtil.httpPostJson(testUrl + "/laserIr/http/post", pmap);
            long endtime = System.currentTimeMillis();
            this.logger.info("DisCacheImpl.getJson.key:" + key + "field\uff1a" + field, (Object)("\u8017\u65f6\u3010" + (endtime - startime) + "\u3011"));
            if (StringUtils.isNotBlank((String)json) && (htmlJsonReBean = (HtmlJsonReBean)((Object)JsonUtil.buildNormalBinder().getJsonToObject(json, HtmlJsonReBean.class))).isSuccess() && null != htmlJsonReBean.getDataObj()) {
                return htmlJsonReBean.getDataObj().toString();
            }
        }
        catch (Exception e) {
            this.logger.error("DisCacheImpl.setJson", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> brpop(String key) {
        if (StringUtils.isNotBlank((String)this.redisConfig.getTestUrl())) {
            String json = this.getJson(key, null, "brpop");
            return JsonUtil.buildNormalBinder().getJsonToList(json, String.class);
        }
        key = this.setKeyIndex(key);
        try {
            this.redisTemplate.opsForList().rightPop((Object)key);
            ArrayList<String> res = this.redisTemplate.opsForList().range((Object)"list", 0L, -1L);
            if (null == res) {
                res = new ArrayList<String>();
            }
            ArrayList<String> arrayList = res;
            return arrayList;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.brpop", (Object)key, (Throwable)e);
            List<String> list = null;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setListVer(String key, String ... strings) {
        key = this.setKeyIndex(key);
        try {
            this.addVersion(key + "-ver");
            this.redisTemplate.opsForList().rightPushAll((Object)key, (Object[])strings);
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.setListVer", (Object)key, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMap(String key, String field, String value) {
        try {
            this.set(this.creatMapKey(key, field), value);
            key = this.setKeyIndex(key);
            this.addVersion(key + "-ver");
            this.redisTemplate.opsForHash().put((Object)key, (Object)field, (Object)value);
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.setMap", (Object)key, (Throwable)e);
        }
    }

    public String creatMapKey(String key, String field) {
        return key + "-map-" + field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMap(String key, String field) {
        Object res;
        block8: {
            block7: {
                if (StringUtils.isNotBlank((String)this.redisConfig.getTestUrl())) {
                    return this.getJson(key, field, "getRemotMap");
                }
                if (!this.checkKey(this.creatMapKey(key, field))) break block7;
                String string = this.get(this.creatMapKey(key, field));
                return string;
            }
            key = this.setKeyIndex(key);
            res = this.redisTemplate.opsForHash().get((Object)key, (Object)field);
            if (null != res) break block8;
            String string = null;
            return string;
        }
        try {
            String string = res.toString();
            return string;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.getMap", (Object)(key + "=" + field), (Throwable)e);
            String string = errorCode;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, String> getMapAll(String key) {
        if (StringUtils.isNotBlank((String)this.redisConfig.getTestUrl())) {
            String json = this.getJson(key, null, "getRemotMapAll");
            return JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, String.class);
        }
        try {
            key = this.setKeyIndex(key);
            Map entries = this.redisTemplate.opsForHash().entries((Object)key);
            if (entries == null) return null;
            if (entries.size() == 0) {
                return null;
            }
            LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>(entries.size());
            Iterator iterator = entries.entrySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return resultMap;
                }
                Map.Entry entry = iterator.next();
                Object valueObj = entry.getValue();
                if (null == entry.getKey()) return null;
                String string = entry.getKey().toString();
                String hashKey = string;
                if (hashKey == null) {
                    return null;
                }
                resultMap.put(hashKey, null == valueObj ? "" : valueObj.toString());
            }
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.getMapAll", (Object)key, (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getMap(String key, String ... fields) {
        List res;
        block6: {
            key = this.setKeyIndex(key);
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(fields));
            res = this.redisTemplate.opsForHash().multiGet((Object)key, list);
            if (null != res) break block6;
            ArrayList<String> arrayList = new ArrayList<String>();
            return arrayList;
        }
        try {
            ArrayList<String> reslist = new ArrayList<String>();
            for (Object obj : res) {
                reslist.add((String)obj);
            }
            ArrayList<String> arrayList = reslist;
            return arrayList;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.getMap", (Object)key, (Throwable)e);
            List<String> list = null;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delMap(String key, String ... fields) {
        try {
            if (null != fields) {
                for (String field : fields) {
                    this.del(this.creatMapKey(key, field));
                }
            }
            key = this.setKeyIndex(key);
            this.addVersion(key + "-ver");
            this.redisTemplate.opsForHash().delete((Object)key, (Object[])fields);
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.delMap", (Object)key, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMap(String key, Map<String, String> hash) {
        try {
            Map<String, String> map = this.getMapAll(key);
            if (MapUtil.isNotEmpty(map)) {
                for (String field : map.keySet()) {
                    this.del(this.creatMapKey(key, field));
                }
            }
            if (MapUtil.isNotEmpty(hash)) {
                for (String field : hash.keySet()) {
                    this.set(this.creatMapKey(key, field), hash.get(field));
                }
            }
            key = this.setKeyIndex(key);
            this.addVersion(key + "-ver");
            this.redisTemplate.delete((Object)key);
            this.redisTemplate.opsForHash().putAll((Object)key, hash);
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.setMap", (Object)key, (Throwable)e);
        }
    }

    @Override
    public void setMapVer(String key, String field, String value) {
        this.setMap(key, field, value);
    }

    @Override
    public void delMapVer(String key, String ... fields) {
        this.delMap(key, fields);
    }

    @Override
    public void setMapVer(String key, Map<String, String> hash) {
        this.setMap(key, hash);
    }

    @Override
    public String getJedisConfig(String key) {
        return null;
    }

    public List<Slowlog> getShowLog(String key) {
        try {
            List<Slowlog> list = null;
            return list;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.getJedisConfig.ex", (Throwable)e);
        }
        return null;
    }

    @Override
    public long getDbSize(String key) {
        return 0L;
    }

    @Override
    public Set<String> getAllKeys(String key) {
        return null;
    }

    @Override
    public void sadd(String key, String ... values) {
        key = this.setKeyIndex(key);
        this.addVersion(key + "-ver");
        this.redisTemplate.opsForSet().add((Object)key, (Object[])values);
    }

    @Override
    public Set<String> smembers(String key) {
        key = this.setKeyIndex(key);
        return this.redisTemplate.opsForSet().members((Object)key);
    }

    @Override
    public String spop(String key) {
        key = this.setKeyIndex(key);
        return (String)this.redisTemplate.opsForSet().pop((Object)key);
    }

    @Override
    public void set(String key, String value, int expires) {
        key = this.setKeyIndex(key);
        this.addVersion(key + "-ver");
        this.redisTemplate.opsForValue().set((Object)key, (Object)value, (long)expires, TimeUnit.SECONDS);
    }

    @Override
    public void setExpire(String key, int expires) {
        key = this.setKeyIndex(key);
        this.addVersion(key + "-ver");
        this.redisTemplate.expire((Object)key, (long)expires, TimeUnit.SECONDS);
    }

    @Override
    public void addVersion(Jedis shardedJedis, String key) {
        this.addVersion(key);
    }
}

