/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.rest.dubbo3.impl;

import com.yqbsoft.laser.service.esb.core.handler.ProxyContext;
import com.yqbsoft.laser.service.esb.core.log.OpenLogUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.rest.controller.DubboSupper;
import com.yqbsoft.laser.service.esb.rest.controller.DubboUtil;
import com.yqbsoft.laser.service.esb.rest.dubboapi.service.DubboComService;
import com.yqbsoft.laser.service.suppercore.core.InMessage;
import com.yqbsoft.laser.service.suppercore.core.Invoke;
import com.yqbsoft.laser.service.suppercore.core.MessageChannel;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;

@DubboService
public class DubboComServiceImpl
extends DubboSupper
implements DubboComService {
    private static final long serialVersionUID = -94136488843001368L;
    private static final String sys_code = "DubboServiceImpl";
    protected final OpenLogUtil logger = new OpenLogUtil(((Object)((Object)this)).getClass());

    public boolean writeMessage(ProxyContext proxyContext) {
        return DubboUtil.writeRetrn((ProxyContext)proxyContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutMessage execute(InMessage inMessage) {
        if (null == inMessage) {
            this.logger.error("DubboServiceImpl.inMessage");
            return new OutMessage("error", "inMessage");
        }
        long startime = System.currentTimeMillis();
        String apiCode = (String)inMessage.getAllParamMap().get("method");
        String tenantCode = (String)inMessage.getAllParamMap().get("tenantCode");
        if (StringUtils.isBlank((String)tenantCode)) {
            tenantCode = "00000000";
        }
        try {
            Invoke invoke = inMessage.getInvoke();
            if (null == invoke) {
                this.logger.error("DubboServiceImpl.invoke", (Object)JsonUtil.buildNormalBinder().toJson((Object)inMessage));
                OutMessage outMessage = new OutMessage("error", "invoke");
                return outMessage;
            }
            if (null == invoke.getApiRouterProperty()) {
                this.logger.error("DubboServiceImpl.apiRouterProperty", (Object)invoke.getRouterServiceName());
                OutMessage outMessage = new OutMessage("error", "apiRouterProperty");
                return outMessage;
            }
            MessageChannel messageChannel = (MessageChannel)SpringApplicationContextUtil.getBean((String)invoke.getApiRouterProperty().getRouterServicemessid());
            if (null == messageChannel) {
                this.logger.error("DubboServiceImpl.messageChannel", (Object)invoke.getApiRouterProperty().getRouterServicemessid());
                OutMessage outMessage = new OutMessage("error", "messageChannel");
                return outMessage;
            }
            OutMessage outMessage = messageChannel.send(inMessage);
            return outMessage;
        }
        finally {
            long endtime = System.currentTimeMillis();
            this.logger.info("DubboServiceImpl.ex.time", (Object)(apiCode + "\u3010" + tenantCode + "\u3011\u8017\u65f6\u3010" + (endtime - startime) + "\u3011"));
        }
    }

    public OutMessage postUrl(String apiCode, String tenantCode, InMessage inMessage) {
        OutMessage outMessage = this.execute(inMessage);
        return outMessage;
    }

    public OutMessage get(InMessage inMessage) {
        return this.execute(inMessage);
    }

    public OutMessage post(InMessage inMessage) {
        return this.execute(inMessage);
    }
}

