/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.rest.ir.controller;

import com.yqbsoft.laser.service.esb.core.handler.ProxyContext;
import com.yqbsoft.laser.service.esb.core.log.OpenLogUtil;
import com.yqbsoft.laser.service.esb.rest.controller.HttpUtil;
import com.yqbsoft.laser.service.esb.rest.feignapi.controller.HttpFeign;
import com.yqbsoft.laser.service.esb.rest.ir.controller.InFeignSupper;
import com.yqbsoft.laser.service.suppercore.core.InMessage;
import com.yqbsoft.laser.service.suppercore.core.Invoke;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/feignIr"})
public class InFeignHttpController
extends InFeignSupper
implements HttpFeign {
    private static final long serialVersionUID = -94136488843001368L;
    private static final String sys_code = "InFeignHttpController";
    private static String routerDire = "0";
    protected final OpenLogUtil logger = new OpenLogUtil(((Object)((Object)this)).getClass());

    @RequestMapping(value={"/http/post/{apiCode}/{tenantCode}"}, method={RequestMethod.POST})
    public void executeUrl(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="apiCode") String apiCode, @PathVariable(value="tenantCode") String tenantCode, @RequestBody(required=false) String resStream) {
        long startime = System.currentTimeMillis();
        request.setAttribute("method", (Object)apiCode);
        request.setAttribute(HttpUtil.BANK_TENANTCODE, (Object)tenantCode);
        request.setAttribute("version", (Object)"1.0");
        this.invoke(request, response, routerDire);
        long endtime = System.currentTimeMillis();
        this.logger.info("InFeignHttpController.executeUrl.time", (Object)(apiCode + "\u3010" + tenantCode + "\u3011\u8017\u65f6\u3010" + (endtime - startime) + "\u3011"));
    }

    @RequestMapping(value={"/http/post/{apiCode}/{version}/{tenantCode}/{charset}/{app_id}"}, method={RequestMethod.POST})
    public void executeUrl(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="apiCode") String apiCode, @PathVariable(value="version") String version, @PathVariable(value="tenantCode") String tenantCode, @PathVariable(value="charset") String charset, @PathVariable(value="app_id") String app_id, @RequestBody(required=false) String resStream) {
        long startime = System.currentTimeMillis();
        request.setAttribute("method", (Object)apiCode);
        request.setAttribute("version", (Object)version);
        request.setAttribute(HttpUtil.BANK_TENANTCODE, (Object)tenantCode);
        request.setAttribute("charset", (Object)charset);
        request.setAttribute("app_id", (Object)app_id);
        this.invoke(request, response, routerDire);
        long endtime = System.currentTimeMillis();
        this.logger.info("InFeignHttpController.executeUrl.time", (Object)(apiCode + "\u3010" + tenantCode + "\u3011\u8017\u65f6\u3010" + (endtime - startime) + "\u3011"));
    }

    @RequestMapping(value={"/http/post"}, method={RequestMethod.POST})
    public void execute(HttpServletRequest request, HttpServletResponse response, @RequestBody(required=false) String resStream) {
        ProxyContext proxyContext = null;
        long startime = System.currentTimeMillis();
        if (StringUtils.isNotBlank((String)resStream)) {
            proxyContext = (ProxyContext)JsonUtil.buildNormalBinder().getJsonToObject(resStream, ProxyContext.class);
        }
        this.invoke(request, response, routerDire);
        String url = proxyContext.getApiCode();
        if (StringUtils.isBlank((String)url) && MapUtil.isNotEmpty((Map)proxyContext.getParams())) {
            url = (String)proxyContext.getParams().get("method");
        }
        long endtime = System.currentTimeMillis();
        this.logger.info("InFeignHttpController.execute.time", (Object)(url + "\u8017\u65f6\u3010" + (endtime - startime) + "\u3011"));
    }

    @Override
    public boolean writeMessage(ProxyContext proxyContext) {
        return HttpUtil.writeRetrn((ProxyContext)proxyContext);
    }

    public OutMessage executeIn(InMessage inMessage) {
        if (null == inMessage) {
            this.logger.error("InFeignHttpController.inMessage");
            return new OutMessage("error", "inMessage");
        }
        Invoke invoke = inMessage.getInvoke();
        if (null == invoke) {
            this.logger.error("InFeignHttpController.invoke", (Object)JsonUtil.buildNormalBinder().toJson((Object)inMessage));
            return new OutMessage("error", "invoke");
        }
        if (null == invoke.getApiRouterProperty()) {
            this.logger.error("InFeignHttpController.apiRouterProperty", (Object)invoke.getRouterServiceName());
            return new OutMessage("error", "apiRouterProperty");
        }
        ProxyContext proxyContext = new ProxyContext();
        try {
            BeanUtils.copyAllPropertys((Object)proxyContext, (Object)inMessage);
        }
        catch (Exception exception) {
            // empty catch block
        }
        OutMessage outMessage = this.invoke(routerDire, proxyContext);
        return outMessage;
    }

    public OutMessage postUrl(String apiCode, String tenantCode, InMessage inMessage) {
        long startime = System.currentTimeMillis();
        OutMessage outMessage = this.executeIn(inMessage);
        long endtime = System.currentTimeMillis();
        this.logger.info("InFeignHttpController.postUrl.time", (Object)(apiCode + "\u3010" + tenantCode + "\u3011\u8017\u65f6\u3010" + (endtime - startime) + "\u3011"));
        return outMessage;
    }

    public OutMessage get(InMessage inMessage) {
        return this.executeIn(inMessage);
    }

    public OutMessage post(InMessage inMessage) {
        if (null == inMessage || MapUtil.isEmpty((Map)inMessage.getAllParamMap())) {
            return new OutMessage("error", "inMessage is null");
        }
        long startime = System.currentTimeMillis();
        String apiCode = (String)inMessage.getAllParamMap().get("method");
        String tenantCode = (String)inMessage.getAllParamMap().get("tenantCode");
        if (StringUtils.isBlank((String)tenantCode)) {
            tenantCode = "00000000";
        }
        OutMessage outMessage = this.executeIn(inMessage);
        long endtime = System.currentTimeMillis();
        this.logger.info("InFeignHttpController.post.time", (Object)(apiCode + "\u3010" + tenantCode + "\u3011\u8017\u65f6\u3010" + (endtime - startime) + "\u3011"));
        return outMessage;
    }
}

