/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.plugin;

import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.logging.Log;
import org.mybatis.generator.logging.LogFactory;

public class FuzzyPageableQueryPlugin
extends PluginAdapter {
    private static final String fuzzyColumnSql = " AND (%1$s like concat('%%',#{%2$s},'%%')) ";
    private static final String fuzzyStartDateColumnSql = " AND (%1$s &gt;= #{%2$s}) ";
    private static final String fuzzyendDateColumnSql = " AND (%1$s &lt;= #{%2$s}) ";
    private static final String normalColumnSql = "AND (%1$s = #{%2$s})";
    private static final String testSqlVarchar = "%1$s != null and %1$s.trim().length() != 0 and %1$s.indexOf(',')==-1";
    private static final String testSql = "%1$s != null";
    private static final String fuzzyQueryId = "%1$s_query_fuzzy_condition";
    private static final String normalQueryId = "%1$s_query_condition";
    private static final String testInSqlVarchar = "%1$s != null and %1$s.trim().length() != 0 and %1$s.indexOf(',')!=-1";
    private static final String testMaxSqlVarchar = "%1$sQmax != null ";
    private static final String testMinSqlVarchar = "%1$sQmin != null ";
    private static final String testStartSqlVarchar = "%1$sQstart != null ";
    private static final String testEndSqlVarchar = "%1$sQend != null ";
    private static final String stringInColumnSql = "  AND (%1$s in\t <foreach close=\")\" collection=\"%2$s.split(',')\" index=\"index\" item=\"item\" open=\"(\" separator=\",\">'${item}'</foreach>  )";
    private static final String decMinColumnSql = " AND (%1$s &gt;= #{%2$sQmin}) ";
    private static final String decMaxColumnSql = " AND (%1$s &lt; #{%2$sQmax}) ";
    private static final String startDateColumnSql = " AND (%1$s &gt;= #{%2$sQstart}) ";
    private static final String endDateColumnSql = " AND (%1$s &lt;= #{%2$sQend}) ";
    protected String paginationStartId = "PAGINATION.MYSQL_paginationStart";
    protected String paginationEndId = "PAGINATION.MYSQL_paginationEnd";
    protected String paginationSysDateId = "PAGINATION.MYSQL_selectSysDate";
    protected boolean isFuzzy = false;
    protected boolean needOrderby = false;
    protected String orderbyColumns = "GMT_CREATE desc";
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private FullyQualifiedJavaType implparameterType = FullyQualifiedJavaType.getNewMapInstance();
    private FullyQualifiedJavaType parameterType = new FullyQualifiedJavaType("java.util.Map<String,Object>");
    private FullyQualifiedJavaType returnType = FullyQualifiedJavaType.getNewListInstance();
    private List<XmlElement> xmlElementsToAdd;

    public static void main(String ... args) {
        String tpl = " AND (%1$s like '%%' || #{%2$s} || '%%') ";
        System.out.println(String.format(tpl, "a", "b"));
    }

    public boolean validate(List<String> warnings) {
        if (StringUtility.stringHasValue((String)this.properties.getProperty("paginationStart"))) {
            this.paginationStartId = this.properties.getProperty("paginationStart");
        }
        if (StringUtility.stringHasValue((String)this.properties.getProperty("paginationEnd"))) {
            this.paginationEndId = this.properties.getProperty("paginationEnd");
        }
        if (StringUtility.stringHasValue((String)this.properties.getProperty("isFuzzy"))) {
            this.isFuzzy = StringUtility.isTrue((String)this.properties.getProperty("isFuzzy"));
        }
        if (StringUtility.stringHasValue((String)this.properties.getProperty("orderByColumns"))) {
            this.needOrderby = true;
        }
        if (StringUtility.stringHasValue((String)this.properties.getProperty("orderByColumns"))) {
            this.orderbyColumns = this.properties.getProperty("orderByColumns");
        }
        if (StringUtility.stringHasValue((String)this.properties.getProperty("selectSysDate"))) {
            this.paginationSysDateId = this.properties.getProperty("selectSysDate");
        }
        return true;
    }

    public boolean sqlMapDocumentGenerated(Document document, IntrospectedTable introspectedTable) {
        List<XmlElement> elements = this.xmlElementsToAdd;
        this.logger.debug("elements:" + elements);
        if (elements != null) {
            for (XmlElement element : elements) {
                document.getRootElement().addElement((Element)element);
            }
        }
        return true;
    }

    public boolean clientSelectByPrimaryKeyMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        if (introspectedTable.getTargetRuntime() == IntrospectedTable.TargetRuntime.MYBATIS3) {
            this.copyAndAddMethod(method, interfaze, introspectedTable);
        }
        return true;
    }

    public boolean sqlMapSelectByPrimaryKeyElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        if (introspectedTable.getTargetRuntime() == IntrospectedTable.TargetRuntime.MYBATIS3) {
            try {
                this.xmlElementsToAdd = this.copyAndSaveElement(introspectedTable);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return true;
    }

    private void copyAndAddMethod(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        Method newMethod = new Method("query");
        newMethod.addParameter(new Parameter(this.parameterType, "parameters"));
        interfaze.addImportedType(this.implparameterType);
        newMethod.setReturnType(new FullyQualifiedJavaType("java.util.List<" + introspectedTable.getFullyQualifiedTable().getDomainObjectName() + ">"));
        interfaze.addImportedType(this.returnType);
        interfaze.addMethod(newMethod);
        Method countMethod = new Method("count");
        countMethod.addParameter(new Parameter(this.parameterType, "parameters"));
        countMethod.setReturnType(new FullyQualifiedJavaType("int"));
        interfaze.addMethod(countMethod);
        Method sdatacodeMethod = new Method("updateStateByCode");
        sdatacodeMethod.addParameter(new Parameter(this.parameterType, "map"));
        sdatacodeMethod.setReturnType(new FullyQualifiedJavaType("int"));
        interfaze.addMethod(sdatacodeMethod);
        Method sdataMethod = new Method("updateStateByPrimaryKey");
        sdataMethod.addParameter(new Parameter(this.parameterType, "map"));
        sdataMethod.setReturnType(new FullyQualifiedJavaType("int"));
        interfaze.addMethod(sdataMethod);
        if (!"".equals(introspectedTable.getTableConfigurationProperty("codeColumn"))) {
            Method getMethod = new Method("getByCode");
            getMethod.addParameter(new Parameter(this.parameterType, "map"));
            getMethod.setReturnType(new FullyQualifiedJavaType(introspectedTable.getFullyQualifiedTable().getDomainObjectName()));
            interfaze.addMethod(getMethod);
            Method delMethod = new Method("delByCode");
            delMethod.addParameter(new Parameter(this.parameterType, "map"));
            delMethod.setReturnType(new FullyQualifiedJavaType("int"));
            interfaze.addMethod(delMethod);
        }
        Method insertBachMethod = new Method("insertBatch");
        insertBachMethod.addParameter(new Parameter(new FullyQualifiedJavaType("java.util.List<" + introspectedTable.getFullyQualifiedTable().getDomainObjectName() + ">"), "list"));
        interfaze.addMethod(insertBachMethod);
        HashSet<FullyQualifiedJavaType> importedTypes = new HashSet<FullyQualifiedJavaType>();
        importedTypes.add(new FullyQualifiedJavaType("com.yqbsoft.laser.service.mybatis.BaseSupportDao"));
        interfaze.addImportedTypes(importedTypes);
        if (!interfaze.getSuperInterfaceTypes().isEmpty()) {
            interfaze.getSuperInterfaceTypes().clear();
            interfaze.getSuperInterfaceTypes().add(new FullyQualifiedJavaType("com.yqbsoft.laser.service.mybatis.BaseSupportDao"));
        }
    }

    private XmlElement generateTrim() {
        XmlElement ret = new XmlElement("trim");
        ret.addAttribute(new Attribute("prefix", "WHERE"));
        ret.addAttribute(new Attribute("prefixOverrides", "AND |OR "));
        return ret;
    }

    private XmlElement generateCondition(IntrospectedTable introspectedTable, boolean fuzzy) {
        XmlElement queryCondition = new XmlElement("sql");
        if (fuzzy) {
            queryCondition.addAttribute(new Attribute("id", String.format(fuzzyQueryId, introspectedTable.getFullyQualifiedTable().getIntrospectedTableName())));
        } else {
            queryCondition.addAttribute(new Attribute("id", String.format(normalQueryId, introspectedTable.getFullyQualifiedTable().getIntrospectedTableName())));
        }
        XmlElement trimElement = this.generateTrim();
        List columns = introspectedTable.getBaseColumns();
        for (IntrospectedColumn column : columns) {
            XmlElement columnElement1;
            XmlElement columnElement;
            if (column.getJdbcType() == 12) {
                columnElement = new XmlElement("if");
                columnElement.addAttribute(new Attribute("test", String.format(testInSqlVarchar, column.getJavaProperty())));
                columnElement.addElement((Element)new TextElement(String.format(stringInColumnSql, column.getActualColumnName(), column.getJavaProperty())));
                trimElement.addElement((Element)columnElement);
            }
            if (column.getJdbcType() == 3 || column.getJdbcType() == 8) {
                columnElement = new XmlElement("if");
                columnElement.addAttribute(new Attribute("test", String.format(testMinSqlVarchar, column.getJavaProperty())));
                columnElement.addElement((Element)new TextElement(String.format(decMinColumnSql, column.getActualColumnName(), column.getJavaProperty())));
                trimElement.addElement((Element)columnElement);
                columnElement1 = new XmlElement("if");
                columnElement1.addAttribute(new Attribute("test", String.format(testMaxSqlVarchar, column.getJavaProperty())));
                columnElement1.addElement((Element)new TextElement(String.format(decMaxColumnSql, column.getActualColumnName(), column.getJavaProperty())));
                trimElement.addElement((Element)columnElement1);
            }
            if (column.getJdbcType() == 91 || column.getJdbcType() == 93) {
                columnElement = new XmlElement("if");
                columnElement.addAttribute(new Attribute("test", String.format(testStartSqlVarchar, column.getJavaProperty())));
                columnElement.addElement((Element)new TextElement(String.format(startDateColumnSql, column.getActualColumnName(), column.getJavaProperty())));
                trimElement.addElement((Element)columnElement);
                columnElement1 = new XmlElement("if");
                columnElement1.addAttribute(new Attribute("test", String.format(testEndSqlVarchar, column.getJavaProperty())));
                columnElement1.addElement((Element)new TextElement(String.format(endDateColumnSql, column.getActualColumnName(), column.getJavaProperty())));
                trimElement.addElement((Element)columnElement1);
            }
            if (column.getActualColumnName().equals("GMT_CREATE")) {
                columnElement = new XmlElement("if");
                columnElement.addAttribute(new Attribute("test", String.format(testSqlVarchar, "startDate")));
                columnElement.addElement((Element)new TextElement(String.format(fuzzyStartDateColumnSql, column.getActualColumnName(), "startDate")));
                trimElement.addElement((Element)columnElement);
                columnElement = new XmlElement("if");
                columnElement.addAttribute(new Attribute("test", String.format(testSqlVarchar, "endDate")));
                columnElement.addElement((Element)new TextElement(String.format(fuzzyendDateColumnSql, column.getActualColumnName(), "endDate")));
                trimElement.addElement((Element)columnElement);
                continue;
            }
            columnElement = new XmlElement("if");
            if (column.getJdbcType() == 12) {
                columnElement.addAttribute(new Attribute("test", String.format(testSqlVarchar, column.getJavaProperty())));
            } else {
                columnElement.addAttribute(new Attribute("test", String.format(testSql, column.getJavaProperty())));
            }
            if (column.getJdbcType() == 12 && fuzzy && !column.getActualColumnName().toUpperCase().equals("TENANT_CODE")) {
                columnElement.addElement((Element)new TextElement(String.format(fuzzyColumnSql, column.getActualColumnName(), column.getJavaProperty())));
            } else {
                columnElement.addElement((Element)new TextElement(String.format(normalColumnSql, column.getActualColumnName(), column.getJavaProperty())));
            }
            trimElement.addElement((Element)columnElement);
        }
        XmlElement columnElement = new XmlElement("if");
        columnElement.addAttribute(new Attribute("test", String.format(testSqlVarchar, "dataStateStr")));
        columnElement.addElement((Element)new TextElement("AND (DATA_STATE  in  (${dataStateStr}))"));
        trimElement.addElement((Element)columnElement);
        XmlElement ocolumnElement = new XmlElement("if");
        ocolumnElement.addAttribute(new Attribute("test", String.format(testInSqlVarchar, "colValue0")));
        ocolumnElement.addElement((Element)new TextElement("AND (${colName0}  in  <foreach collection=\"colValue0.split(',')\" index=\"index\" item=\"other\" open=\"(\" separator=\",\" close=\")\">   #{other} </foreach>)"));
        trimElement.addElement((Element)ocolumnElement);
        XmlElement ocolumnElement01 = new XmlElement("if");
        ocolumnElement01.addAttribute(new Attribute("test", String.format(testSqlVarchar, "colValue0")));
        ocolumnElement01.addElement((Element)new TextElement("AND (${colName0}  = ${colValue0})"));
        trimElement.addElement((Element)ocolumnElement01);
        XmlElement ocolumnElement1 = new XmlElement("if");
        ocolumnElement1.addAttribute(new Attribute("test", String.format(testInSqlVarchar, "colValue1")));
        ocolumnElement1.addElement((Element)new TextElement("AND (${colName1}  in  <foreach collection=\"colValue1.split(',')\" index=\"index\" item=\"other\" open=\"(\" separator=\",\" close=\")\">   #{other} </foreach>)"));
        trimElement.addElement((Element)ocolumnElement1);
        XmlElement ocolumnElement11 = new XmlElement("if");
        ocolumnElement11.addAttribute(new Attribute("test", String.format(testSqlVarchar, "colValue1")));
        ocolumnElement11.addElement((Element)new TextElement("AND (${colName1}  = ${colValue1})"));
        trimElement.addElement((Element)ocolumnElement11);
        XmlElement ocolumnElement2 = new XmlElement("if");
        ocolumnElement2.addAttribute(new Attribute("test", String.format(testInSqlVarchar, "colValue2")));
        ocolumnElement2.addElement((Element)new TextElement("AND (${colName2}  in  <foreach collection=\"colValue2.split(',')\" index=\"index\" item=\"other\" open=\"(\" separator=\",\" close=\")\">   #{other} </foreach>)"));
        trimElement.addElement((Element)ocolumnElement2);
        XmlElement ocolumnElement21 = new XmlElement("if");
        ocolumnElement21.addAttribute(new Attribute("test", String.format(testSqlVarchar, "colValue2")));
        ocolumnElement21.addElement((Element)new TextElement("AND (${colName2}  = ${colValue2})"));
        trimElement.addElement((Element)ocolumnElement21);
        XmlElement ocolumnElement3 = new XmlElement("if");
        ocolumnElement3.addAttribute(new Attribute("test", String.format(testInSqlVarchar, "colValue3")));
        ocolumnElement3.addElement((Element)new TextElement("AND (${colName3}  in  <foreach collection=\"colValue3.split(',')\" index=\"index\" item=\"other\" open=\"(\" separator=\",\" close=\")\">   #{other} </foreach>)"));
        trimElement.addElement((Element)ocolumnElement3);
        XmlElement ocolumnElement31 = new XmlElement("if");
        ocolumnElement31.addAttribute(new Attribute("test", String.format(testSqlVarchar, "colValue3")));
        ocolumnElement31.addElement((Element)new TextElement("AND (${colName3}  = ${colValue3})"));
        trimElement.addElement((Element)ocolumnElement31);
        XmlElement ocolumnElement4 = new XmlElement("if");
        ocolumnElement4.addAttribute(new Attribute("test", String.format(testInSqlVarchar, "colValue4")));
        ocolumnElement4.addElement((Element)new TextElement("AND (${colName4}  in  <foreach collection=\"colValue4.split(',')\" index=\"index\" item=\"other\" open=\"(\" separator=\",\" close=\")\">   #{other} </foreach>)"));
        trimElement.addElement((Element)ocolumnElement4);
        XmlElement ocolumnElement41 = new XmlElement("if");
        ocolumnElement41.addAttribute(new Attribute("test", String.format(testSqlVarchar, "colValue4")));
        ocolumnElement41.addElement((Element)new TextElement("AND (${colName4}  = ${colValue4})"));
        trimElement.addElement((Element)ocolumnElement41);
        XmlElement ocolumnElement5 = new XmlElement("if");
        ocolumnElement5.addAttribute(new Attribute("test", String.format(testInSqlVarchar, "colValue5")));
        ocolumnElement5.addElement((Element)new TextElement("AND (${colName5}  in  <foreach collection=\"colValue5.split(',')\" index=\"index\" item=\"other\" open=\"(\" separator=\",\" close=\")\">   #{other} </foreach>)"));
        trimElement.addElement((Element)ocolumnElement5);
        XmlElement ocolumnElement51 = new XmlElement("if");
        ocolumnElement51.addAttribute(new Attribute("test", String.format(testSqlVarchar, "colValue5")));
        ocolumnElement51.addElement((Element)new TextElement("AND (${colName5}  = ${colValue5})"));
        trimElement.addElement((Element)ocolumnElement51);
        queryCondition.addElement((Element)trimElement);
        return queryCondition;
    }

    private List<XmlElement> copyAndSaveElement(IntrospectedTable introspectedTable) {
        ArrayList<XmlElement> xmlElementsToAdd = new ArrayList<XmlElement>();
        XmlElement fuzzyCondition = null;
        if (this.isFuzzy) {
            fuzzyCondition = this.generateCondition(introspectedTable, true);
            xmlElementsToAdd.add(fuzzyCondition);
        }
        XmlElement normalCondition = this.generateCondition(introspectedTable, false);
        xmlElementsToAdd.add(normalCondition);
        XmlElement selectElement = this.generateSelectQuery(introspectedTable);
        xmlElementsToAdd.add(selectElement);
        XmlElement batchinsertElement = this.generateBatchinsert(introspectedTable);
        xmlElementsToAdd.add(batchinsertElement);
        xmlElementsToAdd.add(this.generateSelectCount(introspectedTable));
        xmlElementsToAdd.add(this.generateSelectSysDate(introspectedTable));
        xmlElementsToAdd.add(this.generateUpdateState(introspectedTable));
        xmlElementsToAdd.add(this.generateupdateStateByCode(introspectedTable));
        String codeColumn = introspectedTable.getTableConfigurationProperty("codeColumn");
        if (StringUtils.isNotBlank((String)codeColumn)) {
            xmlElementsToAdd.add(this.generateSelectByCode(introspectedTable));
            xmlElementsToAdd.add(this.generateDelByCode(introspectedTable));
        }
        return xmlElementsToAdd;
    }

    private XmlElement generateSelectQuery(IntrospectedTable introspectedTable) {
        XmlElement selectElement = new XmlElement("select");
        selectElement.addAttribute(new Attribute("id", "query"));
        if (introspectedTable.getBLOBColumns() != null && !introspectedTable.getBLOBColumns().isEmpty()) {
            selectElement.addAttribute(new Attribute("resultMap", "ResultMapWithBLOBs"));
        } else {
            selectElement.addAttribute(new Attribute("resultMap", "BaseResultMap"));
        }
        XmlElement paginationStart = new XmlElement("include");
        paginationStart.addAttribute(new Attribute("refid", this.paginationStartId));
        selectElement.addElement((Element)paginationStart);
        TextElement selectText = new TextElement("select ");
        selectElement.addElement((Element)selectText);
        XmlElement columnListElement = new XmlElement("include");
        columnListElement.addAttribute(new Attribute("refid", "Base_Column_List"));
        selectElement.addElement((Element)columnListElement);
        if (introspectedTable.getBLOBColumns() != null && !introspectedTable.getBLOBColumns().isEmpty()) {
            selectElement.addElement((Element)new TextElement(","));
            XmlElement bcolumnListElement = new XmlElement("include");
            bcolumnListElement.addAttribute(new Attribute("refid", "Blob_Column_List"));
            selectElement.addElement((Element)bcolumnListElement);
        }
        TextElement formText = new TextElement(" from " + introspectedTable.getFullyQualifiedTable().getIntrospectedTableName() + " ");
        selectElement.addElement((Element)formText);
        XmlElement normalInc = new XmlElement("include");
        normalInc.addAttribute(new Attribute("refid", String.format(normalQueryId, introspectedTable.getFullyQualifiedTable().getIntrospectedTableName())));
        if (this.isFuzzy) {
            selectElement.addElement((Element)this.generateTestFuzzy(introspectedTable));
            selectElement.addElement((Element)this.generateTestNotFuzzy(normalInc));
        } else {
            selectElement.addElement((Element)normalInc);
        }
        XmlElement testOrder = new XmlElement("if");
        testOrder.addAttribute(new Attribute("test", "order and orderStr == null"));
        testOrder.addElement((Element)new TextElement("order by " + this.orderbyColumns));
        selectElement.addElement((Element)testOrder);
        XmlElement testOrderStr = new XmlElement("if");
        testOrderStr.addAttribute(new Attribute("test", "order and orderStr != null and orderStr.trim().length() != 0"));
        testOrderStr.addElement((Element)new TextElement("order by ${orderStr}"));
        selectElement.addElement((Element)testOrderStr);
        XmlElement paginationEnd = new XmlElement("include");
        paginationEnd.addAttribute(new Attribute("refid", this.paginationEndId));
        selectElement.addElement((Element)paginationEnd);
        return selectElement;
    }

    private XmlElement generateSelectByCode(IntrospectedTable introspectedTable) {
        XmlElement selectElement = new XmlElement("select");
        selectElement.addAttribute(new Attribute("id", "getByCode"));
        if (introspectedTable.getBLOBColumns() != null && !introspectedTable.getBLOBColumns().isEmpty()) {
            selectElement.addAttribute(new Attribute("resultMap", "ResultMapWithBLOBs"));
        } else {
            selectElement.addAttribute(new Attribute("resultMap", "BaseResultMap"));
        }
        TextElement selectText = new TextElement("select ");
        selectElement.addElement((Element)selectText);
        XmlElement columnListElement = new XmlElement("include");
        columnListElement.addAttribute(new Attribute("refid", "Base_Column_List"));
        selectElement.addElement((Element)columnListElement);
        if (introspectedTable.getBLOBColumns() != null && !introspectedTable.getBLOBColumns().isEmpty()) {
            selectElement.addElement((Element)new TextElement(","));
            XmlElement bcolumnListElement = new XmlElement("include");
            bcolumnListElement.addAttribute(new Attribute("refid", "Blob_Column_List"));
            selectElement.addElement((Element)bcolumnListElement);
        }
        TextElement formText = new TextElement(" from " + introspectedTable.getFullyQualifiedTable().getIntrospectedTableName() + " ");
        selectElement.addElement((Element)formText);
        TextElement whereText = new TextElement(" where  " + introspectedTable.getTableConfigurationProperty("codeColumn") + " = #{" + this.getColumn(introspectedTable.getTableConfigurationProperty("codeColumn")) + ",jdbcType=VARCHAR} ");
        selectElement.addElement((Element)whereText);
        XmlElement settestFuzzy = new XmlElement("if");
        settestFuzzy.addAttribute(new Attribute("test", "tenantCode != null and tenantCode.trim().length() != 0"));
        TextElement setifText = new TextElement(" and TENANT_CODE = #{tenantCode,jdbcType=VARCHAR} ");
        settestFuzzy.addElement((Element)setifText);
        selectElement.addElement((Element)settestFuzzy);
        return selectElement;
    }

    public String getColumn(String tableName) {
        String[] tabs = tableName.split("_");
        String codeColumn = "";
        for (int i = 0; i < tabs.length; ++i) {
            tabs[i] = this.toUpperCaseFirstOne(tabs[i].toLowerCase());
            codeColumn = codeColumn + tabs[i];
        }
        return this.toLowerCaseFirstOne(codeColumn);
    }

    public String toUpperCaseFirstOne(String s) {
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public String toLowerCaseFirstOne(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    private XmlElement generateDelByCode(IntrospectedTable introspectedTable) {
        XmlElement selectElement = new XmlElement("delete");
        selectElement.addAttribute(new Attribute("id", "delByCode"));
        selectElement.addAttribute(new Attribute("parameterType", "Map"));
        TextElement formText = new TextElement(" delete from " + introspectedTable.getFullyQualifiedTable().getIntrospectedTableName() + " ");
        selectElement.addElement((Element)formText);
        TextElement whereText = new TextElement(" where  " + introspectedTable.getTableConfigurationProperty("codeColumn") + " = #{" + this.getColumn(introspectedTable.getTableConfigurationProperty("codeColumn")) + ",jdbcType=VARCHAR} ");
        selectElement.addElement((Element)whereText);
        XmlElement settestFuzzy = new XmlElement("if");
        settestFuzzy.addAttribute(new Attribute("test", "tenantCode != null and tenantCode.trim().length() != 0"));
        TextElement setifText = new TextElement(" and TENANT_CODE = #{tenantCode,jdbcType=VARCHAR} ");
        settestFuzzy.addElement((Element)setifText);
        selectElement.addElement((Element)settestFuzzy);
        return selectElement;
    }

    public XmlElement generateInsertAndGetId(IntrospectedTable introspectedTable) {
        XmlElement insertElement = new XmlElement("insert");
        insertElement.addAttribute(new Attribute("id", "insertAndGetId"));
        insertElement.addAttribute(new Attribute("useGeneratedKeys", "true"));
        insertElement.addAttribute(new Attribute("keyProperty", this.getColumn(introspectedTable.getTableConfigurationProperty("codeColumn"))));
        insertElement.addAttribute(new Attribute("parameterType", "java.util.List"));
        TextElement intoText = new TextElement("insert into " + introspectedTable.getFullyQualifiedTable().getIntrospectedTableName() + " ( ");
        insertElement.addElement((Element)intoText);
        String acls = "";
        for (IntrospectedColumn introspectedColumn : introspectedTable.getAllColumns()) {
            if (!"".equals(acls)) {
                acls = acls + ",";
            }
            acls = acls + introspectedColumn.getActualColumnName();
        }
        TextElement valuesText = new TextElement(acls + " ) values ");
        insertElement.addElement((Element)valuesText);
        XmlElement valuesOrder = new XmlElement("foreach");
        valuesOrder.addAttribute(new Attribute("collection", "list"));
        valuesOrder.addAttribute(new Attribute("item", "item"));
        valuesOrder.addAttribute(new Attribute("index", "index"));
        valuesOrder.addAttribute(new Attribute("separator", ","));
        String vls = " ( ";
        String cls = "";
        for (IntrospectedColumn introspectedColumn : introspectedTable.getAllColumns()) {
            if (!"".equals(cls)) {
                cls = cls + ",";
            }
            cls = cls + "#{item." + introspectedColumn.getJavaProperty() + ",jdbcType=" + introspectedColumn.getJdbcTypeName() + "}";
        }
        vls = vls + cls + " ) ";
        valuesOrder.addElement((Element)new TextElement(vls));
        insertElement.addElement((Element)valuesOrder);
        return insertElement;
    }

    private XmlElement generateBatchinsert(IntrospectedTable introspectedTable) {
        XmlElement insertElement = new XmlElement("insert");
        insertElement.addAttribute(new Attribute("id", "insertBatch"));
        insertElement.addAttribute(new Attribute("useGeneratedKeys", "true"));
        insertElement.addAttribute(new Attribute("parameterType", "java.util.List"));
        TextElement intoText = new TextElement("insert into " + introspectedTable.getFullyQualifiedTable().getIntrospectedTableName() + " ( ");
        insertElement.addElement((Element)intoText);
        String acls = "";
        for (IntrospectedColumn introspectedColumn : introspectedTable.getAllColumns()) {
            if (!"".equals(acls)) {
                acls = acls + ",";
            }
            acls = acls + introspectedColumn.getActualColumnName();
        }
        TextElement valuesText = new TextElement(acls + " ) values ");
        insertElement.addElement((Element)valuesText);
        XmlElement valuesOrder = new XmlElement("foreach");
        valuesOrder.addAttribute(new Attribute("collection", "list"));
        valuesOrder.addAttribute(new Attribute("item", "item"));
        valuesOrder.addAttribute(new Attribute("index", "index"));
        valuesOrder.addAttribute(new Attribute("separator", ","));
        String vls = " ( ";
        String cls = "";
        for (IntrospectedColumn introspectedColumn : introspectedTable.getAllColumns()) {
            if (!"".equals(cls)) {
                cls = cls + ",";
            }
            cls = cls + "#{item." + introspectedColumn.getJavaProperty() + ",jdbcType=" + introspectedColumn.getJdbcTypeName() + "}";
        }
        vls = vls + cls + " ) ";
        valuesOrder.addElement((Element)new TextElement(vls));
        insertElement.addElement((Element)valuesOrder);
        return insertElement;
    }

    private XmlElement generateSelectCount(IntrospectedTable introspectedTable) {
        XmlElement countElement = new XmlElement("select");
        countElement.addAttribute(new Attribute("id", "count"));
        countElement.addAttribute(new Attribute("resultType", "int"));
        TextElement selectText = new TextElement("select count(*) from " + introspectedTable.getFullyQualifiedTable().getIntrospectedTableName() + " ");
        countElement.addElement((Element)selectText);
        XmlElement normalInc = new XmlElement("include");
        normalInc.addAttribute(new Attribute("refid", String.format(normalQueryId, introspectedTable.getFullyQualifiedTable().getIntrospectedTableName())));
        if (this.isFuzzy) {
            countElement.addElement((Element)this.generateTestFuzzy(introspectedTable));
            countElement.addElement((Element)this.generateTestNotFuzzy(normalInc));
        } else {
            countElement.addElement((Element)normalInc);
        }
        return countElement;
    }

    private XmlElement generateSelectSysDate(IntrospectedTable introspectedTable) {
        XmlElement countElement = new XmlElement("select");
        countElement.addAttribute(new Attribute("id", "selectSysDate"));
        countElement.addAttribute(new Attribute("resultType", "java.util.Date"));
        XmlElement normalInc = new XmlElement("include");
        normalInc.addAttribute(new Attribute("refid", this.paginationSysDateId));
        countElement.addElement((Element)normalInc);
        return countElement;
    }

    private XmlElement generateupdateStateByCode(IntrospectedTable introspectedTable) {
        XmlElement countElement = new XmlElement("update");
        countElement.addAttribute(new Attribute("id", "updateStateByCode"));
        countElement.addAttribute(new Attribute("parameterType", "Map"));
        TextElement updateText = new TextElement("update " + introspectedTable.getFullyQualifiedTable().getIntrospectedTableName() + " ");
        countElement.addElement((Element)updateText);
        TextElement setText = new TextElement(" set DATA_STATE = #{dataState,jdbcType=INTEGER},GMT_MODIFIED=SYSDATE() ");
        countElement.addElement((Element)setText);
        XmlElement settestFuzzy = new XmlElement("if");
        settestFuzzy.addAttribute(new Attribute("test", "memo != null"));
        TextElement setifText = new TextElement(" , MEMO = #{memo,jdbcType=VARCHAR} ");
        settestFuzzy.addElement((Element)setifText);
        countElement.addElement((Element)settestFuzzy);
        TextElement whereText = new TextElement(" where  " + introspectedTable.getTableConfigurationProperty("codeColumn") + " = #{" + this.getColumn(introspectedTable.getTableConfigurationProperty("codeColumn")) + ",jdbcType=VARCHAR} ");
        countElement.addElement((Element)whereText);
        XmlElement settestFuzzywhere = new XmlElement("if");
        settestFuzzywhere.addAttribute(new Attribute("test", "tenantCode != null and tenantCode.trim().length() != 0"));
        TextElement setifTextwhere = new TextElement(" and TENANT_CODE = #{tenantCode,jdbcType=VARCHAR} ");
        settestFuzzywhere.addElement((Element)setifTextwhere);
        countElement.addElement((Element)settestFuzzywhere);
        XmlElement testFuzzy = new XmlElement("if");
        testFuzzy.addAttribute(new Attribute("test", "oldDataState != null"));
        TextElement whereandText = new TextElement(" and DATA_STATE = #{oldDataState,jdbcType=INTEGER} ");
        testFuzzy.addElement((Element)whereandText);
        countElement.addElement((Element)testFuzzy);
        return countElement;
    }

    private XmlElement generateUpdateState(IntrospectedTable introspectedTable) {
        XmlElement countElement = new XmlElement("update");
        countElement.addAttribute(new Attribute("id", "updateStateByPrimaryKey"));
        countElement.addAttribute(new Attribute("parameterType", "Map"));
        TextElement updateText = new TextElement("update " + introspectedTable.getFullyQualifiedTable().getIntrospectedTableName() + " ");
        countElement.addElement((Element)updateText);
        TextElement setText = new TextElement(" set DATA_STATE = #{dataState,jdbcType=INTEGER},GMT_MODIFIED=SYSDATE() ");
        countElement.addElement((Element)setText);
        XmlElement settestFuzzy = new XmlElement("if");
        settestFuzzy.addAttribute(new Attribute("test", "memo != null"));
        TextElement setifText = new TextElement(" , MEMO = #{memo,jdbcType=VARCHAR} ");
        settestFuzzy.addElement((Element)setifText);
        countElement.addElement((Element)settestFuzzy);
        String whereSql = "where ";
        for (IntrospectedColumn introspectedColumn : introspectedTable.getPrimaryKeyColumns()) {
            whereSql = whereSql + " " + introspectedColumn.getActualColumnName() + " = #{" + introspectedColumn.getJavaProperty() + ",jdbcType=" + introspectedColumn.getJdbcTypeName() + "}";
        }
        TextElement whereText = new TextElement(whereSql);
        countElement.addElement((Element)whereText);
        XmlElement testFuzzy = new XmlElement("if");
        testFuzzy.addAttribute(new Attribute("test", "oldDataState != null"));
        TextElement whereandText = new TextElement(" and DATA_STATE = #{oldDataState,jdbcType=INTEGER} ");
        testFuzzy.addElement((Element)whereandText);
        countElement.addElement((Element)testFuzzy);
        return countElement;
    }

    private XmlElement generateTestFuzzy(IntrospectedTable introspectedTable) {
        XmlElement testFuzzy = new XmlElement("if");
        testFuzzy.addAttribute(new Attribute("test", "fuzzy"));
        XmlElement fuzzyInc = new XmlElement("include");
        fuzzyInc.addAttribute(new Attribute("refid", String.format(fuzzyQueryId, introspectedTable.getFullyQualifiedTable().getIntrospectedTableName())));
        testFuzzy.addElement((Element)fuzzyInc);
        return testFuzzy;
    }

    private XmlElement generateTestNotFuzzy(XmlElement normalInc) {
        XmlElement testNotFuzzy = new XmlElement("if");
        testNotFuzzy.addAttribute(new Attribute("test", "!fuzzy"));
        testNotFuzzy.addElement((Element)normalInc);
        return testNotFuzzy;
    }
}

