<#include '/common/copyright.ftl' />
<#assign serverConfig={}>
<#if data??>
    <#if data.controlConfig??>
        <#assign serverConfig=data.controlConfig>
    </#if>
</#if>
package com.qjsoft.laser.controller.${serverConfig.pagename}.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.${serverConfig.mm}.domain.${serverConfig.upModel}${serverConfig.domainName};
import com.qjsoft.laser.controller.facade.${serverConfig.mm}.domain.${serverConfig.upModel}${serverConfig.reDomainName};
import com.qjsoft.laser.controller.facade.${serverConfig.mm}.repository.${serverConfig.upRepositoryName};
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * ${serverConfig.name}操作控制类
 * @author qjsoft
 *
 */
@Controller
@RequestMapping(value ="/web/${serverConfig.mm}/${serverConfig.context}",name = "${serverConfig.name}")
public class ${serverConfig.upContext}Con extends SpringmvcController{
	private static String CODE="${serverConfig.mm}.${serverConfig.context}.con";
	
	protected String getContext(){
		return "${serverConfig.context}";
	}
	
	@Autowired
    private ${serverConfig.upRepositoryName} ${serverConfig.repositoryName};
    
	@RequestMapping(value = "save${serverConfig.upContext}.json",name = "增加${serverConfig.name}")
	@ResponseBody
    public HtmlJsonReBean save${serverConfig.upContext}(HttpServletRequest request,${serverConfig.upModel}${serverConfig.domainName} ${serverConfig.model}${serverConfig.domainName}) {
		 if (null == ${serverConfig.model}${serverConfig.domainName}) {
            logger.error(CODE + ".save${serverConfig.upContext}", "param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
		${serverConfig.model}${serverConfig.domainName}.setTenantCode(getTenantCode(request));
        return ${serverConfig.repositoryName}.save${serverConfig.upContext}(${serverConfig.model}${serverConfig.domainName});
	}
	
	@RequestMapping(value = "get${serverConfig.upContext}.json",name = "获取${serverConfig.name}信息")
    @ResponseBody
    public ${serverConfig.upModel}${serverConfig.reDomainName} get${serverConfig.upContext}(Integer ${serverConfig.idName}) {
        if (StringUtils.isBlank(${serverConfig.idName})) {
            logger.error(CODE + ".get${serverConfig.upContext}", "param is null");
            return null;
        }
        return ${serverConfig.repositoryName}.get${serverConfig.upContext}(${serverConfig.idName});
    }

    @RequestMapping(value = "update${serverConfig.upContext}.json",name = "更新${serverConfig.name}")
    @ResponseBody
    public HtmlJsonReBean update${serverConfig.upContext}(HttpServletRequest request,${serverConfig.upModel}${serverConfig.domainName} ${serverConfig.model}${serverConfig.domainName}) {
        if (null == ${serverConfig.model}${serverConfig.domainName}) {
            logger.error(CODE + ".update${serverConfig.upContext}", "param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
		${serverConfig.model}${serverConfig.domainName}.setTenantCode(getTenantCode(request));
        return ${serverConfig.repositoryName}.update${serverConfig.upContext}(${serverConfig.model}${serverConfig.domainName});
    }

    @RequestMapping(value = "delete${serverConfig.upContext}.json",name = "删除${serverConfig.name}")
    @ResponseBody
    public HtmlJsonReBean delete${serverConfig.upContext}(Integer ${serverConfig.idName}) {
        if (StringUtils.isBlank(${serverConfig.idName})) {
            logger.error(CODE + ".delete${serverConfig.upContext}", "param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return ${serverConfig.repositoryName}.delete${serverConfig.upContext}(${serverConfig.idName});
    }

    @RequestMapping(value = "query${serverConfig.upContext}Page.json",name = "查询${serverConfig.name}分页列表")
    @ResponseBody
    public SupQueryResult<${serverConfig.upModel}${serverConfig.reDomainName}> query${serverConfig.upContext}Page(HttpServletRequest request) {Map<String, Object> param = assemMapParam(request);
        if (null != param) {
            param.put("order", true);// 排序
            param.put("fuzzy", true);// 模糊
        }
        return ${serverConfig.repositoryName}.query${serverConfig.upContext}Page(param);
    }

    @RequestMapping(value = "update${serverConfig.upContext}State.json",name = "更新${serverConfig.name}状态")
    @ResponseBody
    public HtmlJsonReBean update${serverConfig.upContext}State(String ${serverConfig.idName}, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank(${serverConfig.idName})) {
            logger.error(CODE + ".update${serverConfig.upContext}State", "param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return ${serverConfig.repositoryName}.update${serverConfig.upContext}State(Integer.valueOf(${serverConfig.idName}),dataState,oldDataState,null);
    }
    
	
}