/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.vaadin.base.devserver.AbstractDevServerRunner;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendUtils;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ViteHandler
extends AbstractDevServerRunner {
    public static final String VITE_SERVER = "node_modules/vite/bin/vite.js";
    private static final String[] FILES_IN_ROOT = new String[]{"index.html", "web-component.html", "sw.js"};

    public ViteHandler(Lookup lookup, int runningPort, File npmFolder, CompletableFuture<Void> waitFor) {
        super(lookup, runningPort, npmFolder, waitFor);
    }

    @Override
    protected List<String> getServerStartupCommand(FrontendTools frontendTools) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(frontendTools.getNodeExecutable());
        command.add(this.getServerBinary().getAbsolutePath());
        command.add("--config");
        command.add(this.getServerConfig().getAbsolutePath());
        command.add("--port");
        command.add(String.valueOf(this.getPort()));
        command.add("--base");
        command.add(this.getPathToVaadin());
        String customParameters = this.getApplicationConfiguration().getStringProperty("devmode.vite.options", "");
        if (!customParameters.isEmpty()) {
            command.addAll(Arrays.asList(customParameters.split(" +")));
            ViteHandler.getLogger().info("Starting {} using: {}", (Object)this.getServerName(), (Object)String.join((CharSequence)" ", command));
        }
        return command;
    }

    @Override
    protected String getServerName() {
        return "Vite";
    }

    @Override
    protected File getServerBinary() {
        return new File(this.getProjectRoot(), VITE_SERVER);
    }

    @Override
    protected File getServerConfig() {
        return new File(this.getProjectRoot(), "vite.config.ts");
    }

    @Override
    protected Pattern getServerFailurePattern() {
        return null;
    }

    @Override
    protected Pattern getServerSuccessPattern() {
        return Pattern.compile("ready in .*ms");
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ViteHandler.class);
    }

    @Override
    public HttpURLConnection prepareConnection(String path, String method) throws IOException {
        for (String fileInSerlvetPath : FILES_IN_ROOT) {
            if (!path.equals("/" + fileInSerlvetPath)) continue;
            return super.prepareConnection(this.getPathToVaadin() + fileInSerlvetPath, method);
        }
        String vitePath = this.getPathToVaadin().replace("/VAADIN/", "") + path;
        return super.prepareConnection(vitePath, method);
    }

    private String getPathToVaadin() {
        return this.getContextPath() + this.getPathToVaadinInContext();
    }

    public String getPathToVaadinInContext() {
        return FrontendUtils.getFrontendServletPath((ServletContext)this.getServletContext().getContext()) + "/VAADIN/";
    }

    private String getContextPath() {
        VaadinServletContext servletContext = this.getServletContext();
        return servletContext.getContext().getContextPath();
    }

    private VaadinServletContext getServletContext() {
        return (VaadinServletContext)this.getApplicationConfiguration().getContext();
    }
}

