/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.viteproxy;

import com.vaadin.base.devserver.viteproxy.ViteWebsocketConnection;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViteWebsocketProxy
implements MessageHandler.Whole<String> {
    private final ViteWebsocketConnection viteConnection;

    public ViteWebsocketProxy(Session browserSession, Integer vitePort) throws InterruptedException, ExecutionException {
        this.viteConnection = new ViteWebsocketConnection(vitePort, browserSession.getNegotiatedSubprotocol(), msg -> browserSession.getAsyncRemote().sendText(msg, result -> {
            if (result.isOK()) {
                this.getLogger().debug("Message sent to browser: {}", msg);
            } else {
                this.getLogger().debug("Error sending message to browser", result.getException());
            }
        }), () -> {
            try {
                browserSession.close();
            }
            catch (IOException e) {
                this.getLogger().debug("Error closing browser connection", (Throwable)e);
            }
        });
    }

    protected Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    public void onMessage(String message) {
        this.getLogger().debug("Got message from browser: " + message);
        try {
            this.viteConnection.send(message);
            this.getLogger().debug("Sent message to Vite: " + message);
        }
        catch (InterruptedException | ExecutionException e) {
            this.getLogger().debug("Error sending message (" + message + ") to Vite", (Throwable)e);
        }
    }

    public void close() {
        try {
            this.viteConnection.close();
        }
        catch (InterruptedException | ExecutionException e) {
            this.getLogger().debug("Error closing connection to Vite", (Throwable)e);
        }
    }
}

