/*
 * Decompiled with CFR 0.152.
 */
package com.xkw.xop.client;

import com.xkw.xop.client.XopHttpClient;
import com.xkw.xop.client.hmac.XopHmacVersionEnum;
import com.xkw.xop.client.impl.XopHttpClientImpl;
import com.xkw.xop.client.utils.Constants;
import com.xkw.xop.client.utils.XopClientUtils;
import kong.unirest.Config;
import kong.unirest.Proxy;
import kong.unirest.apache.ApacheClient;

public class XopClientBuilder {
    private String gatewayHost;
    private String appId;
    private String secret;
    private Integer timeout;
    private Proxy proxy;
    private int maxPoolSize;
    private int maxConnectionPerRoute;
    private Integer connectionValidatePeriod;
    private Config config;
    private XopHmacVersionEnum hmacVersionEnum;

    public XopClientBuilder gatewayHost(String gatewayHost) {
        this.gatewayHost = gatewayHost;
        return this;
    }

    public XopClientBuilder appId(String appId) {
        this.appId = appId;
        return this;
    }

    public XopClientBuilder secret(String secret) {
        this.secret = secret;
        return this;
    }

    public XopClientBuilder timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public XopClientBuilder proxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public XopClientBuilder maxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public XopClientBuilder maxConnectionPerRoute(int maxConnectionPerRoute) {
        this.maxConnectionPerRoute = maxConnectionPerRoute;
        return this;
    }

    public XopClientBuilder connectionValidatePeriod(Integer connectionValidatePeriod) {
        this.connectionValidatePeriod = connectionValidatePeriod;
        return this;
    }

    public XopClientBuilder hmacVersion(XopHmacVersionEnum hmacVersionEnum) {
        this.hmacVersionEnum = hmacVersionEnum;
        return this;
    }

    private void build() throws RuntimeException {
        if (XopClientUtils.isEmpty(this.gatewayHost)) {
            this.gatewayHost = "https://openapi.xkw.com";
        }
        if (XopClientUtils.isEmpty(this.appId)) {
            throw new RuntimeException("App Id must be set!");
        }
        if (XopClientUtils.isEmpty(this.secret)) {
            throw new RuntimeException("App secret must be set!");
        }
        this.config = new Config();
        if (this.timeout == null || this.timeout.compareTo(0) <= 0) {
            this.timeout = Constants.TIMEOUT;
        }
        this.config.socketTimeout(this.timeout * 1000).connectTimeout(this.timeout * 1000);
        if (this.maxPoolSize <= 0) {
            this.maxPoolSize = Constants.MAX_CONNECTION_POOL_SIZE;
        }
        if (this.maxConnectionPerRoute <= 0) {
            this.maxConnectionPerRoute = Constants.MAX_CONNECTION_PER_ROUTE;
        }
        this.config.concurrency(this.maxPoolSize, this.maxConnectionPerRoute);
        this.config.proxy(this.proxy);
        if (this.connectionValidatePeriod != null) {
            this.config.httpClient(conf -> {
                ApacheClient cli = new ApacheClient(conf);
                cli.getManager().setValidateAfterInactivity(this.connectionValidatePeriod.intValue());
                return cli;
            });
        }
        if (this.hmacVersionEnum == null) {
            this.hmacVersionEnum = XopHmacVersionEnum.V1;
        }
    }

    public XopHttpClient buildHttpClient() {
        this.build();
        return new XopHttpClientImpl(this.gatewayHost, this.appId, this.secret, this.config, this.hmacVersionEnum);
    }
}

