/*
 * Decompiled with CFR 0.152.
 */
package com.xkw.xop.client.hmac;

import com.google.gson.Gson;
import com.xkw.xop.client.hmac.HmacResult;
import com.xkw.xop.client.hmac.SignatureFunction;
import com.xkw.xop.client.hmac.XopHmacVersionEnum;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.codec.binary.Hex;

public class HmacUtils {
    public static HmacResult sign(String appId, String secret, Map<String, ?> urlParam, String requestBodyStr) throws RuntimeException {
        return HmacUtils.sign(appId, secret, urlParam, requestBodyStr, "Xop-Sign", HmacUtils::getSignatureString);
    }

    protected static HmacResult sign(String appId, String secret, Map<String, ?> urlParam, String requestBodyStr, String signHeader, SignatureFunction signatureFunction) throws RuntimeException {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        if (urlParam != null) {
            map.putAll(urlParam);
        }
        map.put("Xop-App-Id", appId);
        XopHmacVersionEnum.clearSignFromMap(map);
        map.remove("Xop-Nonce");
        String nonce = HmacUtils.getNonce();
        map.put("Xop-Nonce", nonce);
        Long timeStamp = System.currentTimeMillis() / 1000L;
        map.put("Xop-Timestamp", timeStamp);
        String signStr = signatureFunction.apply(map, secret, requestBodyStr);
        map.put(signHeader, signStr);
        return new HmacResult(timeStamp, signStr, nonce);
    }

    public static String getNonce() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String generateQueryString(Map<String, Object> params) {
        ArrayList<String> tempParams = new ArrayList<String>(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String str = entry.getKey() + "=" + (entry.getValue() instanceof String ? entry.getValue() : new Gson().toJson(entry.getValue()));
            tempParams.add(str);
        }
        return String.join((CharSequence)"&", tempParams);
    }

    protected static String getSignatureString(Map<String, ?> urlParams, String secret, String requestBodyStr) throws RuntimeException {
        HashMap signParams = new HashMap(urlParams);
        if (requestBodyStr != null && !Objects.equals("", requestBodyStr)) {
            signParams.put("xop_body", requestBodyStr);
        }
        TreeMap<String, Object> sortParams = new TreeMap<String, Object>(signParams);
        String sortParamStr = HmacUtils.generateQueryString(sortParams);
        String keyListStr = sortParamStr + "&secret=" + secret;
        String base64Str = HmacUtils.base64Str(keyListStr);
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            byte[] bytes = sha1.digest(base64Str.getBytes(StandardCharsets.UTF_8));
            return Hex.encodeHexString((byte[])bytes);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid sign");
        }
    }

    protected static String base64Str(String str) {
        try {
            Base64.Encoder encoder = Base64.getEncoder();
            byte[] bytes = encoder.encode(str.getBytes(StandardCharsets.UTF_8.name()));
            return new String(bytes, StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            throw new RuntimeException("unsupported");
        }
    }
}

