/*
 * Decompiled with CFR 0.152.
 */
package com.xkw.xop.client.hmac;

import com.xkw.xop.client.hmac.HmacResult;
import com.xkw.xop.client.hmac.HmacUtils;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;

public class HmacUtilsV2
extends HmacUtils {
    public static HmacResult sign(String appId, String secret, Map<String, ?> urlParam, String requestBodyStr) throws RuntimeException {
        return HmacUtilsV2.sign(appId, secret, urlParam, requestBodyStr, "Xop-Sign-V2", HmacUtilsV2::getSignatureString);
    }

    protected static String getSignatureString(Map<String, ?> urlParams, String secret, String requestBodyStr) throws RuntimeException {
        HashMap signParams = new HashMap(urlParams);
        if (requestBodyStr != null && !Objects.equals("", requestBodyStr)) {
            signParams.put("xop_body", requestBodyStr);
        }
        TreeMap<String, Object> sortParams = new TreeMap<String, Object>(signParams);
        String keyListStr = HmacUtilsV2.generateQueryString(sortParams);
        String base64Str = HmacUtilsV2.base64Str(keyListStr);
        try {
            byte[] key = secret.getBytes(StandardCharsets.UTF_8);
            Mac hmacSha256 = Mac.getInstance("HmacSHA256");
            hmacSha256.init(new SecretKeySpec(key, 0, key.length, ""));
            byte[] bytes = hmacSha256.doFinal(base64Str.getBytes(StandardCharsets.UTF_8));
            return Hex.encodeHexString((byte[])bytes);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid sign");
        }
    }
}

