/*
 * Decompiled with CFR 0.152.
 */
package com.xkw.xop.client.hmac;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum XopHmacVersionEnum {
    V1(1, "Xop-Sign"),
    V2(2, "Xop-Sign-V2");

    private final Integer version;
    private final String signHeader;
    private static final List<XopHmacVersionEnum> VERSION_LIST;

    private XopHmacVersionEnum(Integer version, String signHeader) {
        this.version = version;
        this.signHeader = signHeader;
    }

    public static void clearSignFromMap(Map<String, Object> map) {
        for (XopHmacVersionEnum versionEnum : VERSION_LIST) {
            map.remove(versionEnum.getSignHeader());
        }
    }

    public Integer getVersion() {
        return this.version;
    }

    public String getSignHeader() {
        return this.signHeader;
    }

    static {
        VERSION_LIST = Stream.of(XopHmacVersionEnum.values()).sorted(Comparator.comparing(XopHmacVersionEnum::getVersion)).collect(Collectors.toList());
    }
}

