/*
 * Decompiled with CFR 0.152.
 */
package com.xkw.xop.client.impl;

import com.xkw.xop.client.hmac.HmacResult;
import com.xkw.xop.client.hmac.HmacUtils;
import com.xkw.xop.client.hmac.HmacUtilsV2;
import com.xkw.xop.client.hmac.XopHmacVersionEnum;
import com.xkw.xop.client.request.impl.XopHttpRequestBase;
import com.xkw.xop.client.response.XopHttpResponse;
import com.xkw.xop.client.response.impl.XopHttpResponseImpl;
import com.xkw.xop.client.utils.XopClientUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kong.unirest.Config;
import kong.unirest.GetRequest;
import kong.unirest.HttpMethod;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.UnirestInstance;

public class XopClientBase {
    protected final String gatewayHost;
    protected final String appId;
    protected final String secret;
    protected final UnirestInstance client;
    protected final XopHmacVersionEnum hmacVersionEnum;

    public XopClientBase(String gatewayHost, String appId, String secret, Config config, XopHmacVersionEnum hmacVersionEnum) {
        this.gatewayHost = gatewayHost;
        this.appId = appId;
        this.secret = secret;
        if (config == null) {
            config = new Config();
        }
        this.hmacVersionEnum = hmacVersionEnum;
        this.client = new UnirestInstance(config);
    }

    protected XopHttpResponse<String> getHttpResponse(XopHttpRequestBase request, Map<String, String> headerMap, String bodyString, Map<String, String> customHeaderMap) {
        HttpResponse response;
        if (request.getHttpMethod() == null) {
            throw new IllegalArgumentException("http method can NOT be null");
        }
        if (XopClientUtils.isEmpty(request.getUri())) {
            throw new IllegalArgumentException("http uri can NOT be null");
        }
        HttpMethod method = request.getHttpMethod();
        String fullUri = this.gatewayHost + request.getUri();
        String requestId = XopClientUtils.getRequestId();
        headerMap.put("X-Request-Id", requestId);
        if (customHeaderMap != null && customHeaderMap.size() > 0) {
            HashMap<String, String> wholeHeaderMap = new HashMap<String, String>(headerMap);
            wholeHeaderMap.putAll(customHeaderMap);
            if (headerMap.size() + customHeaderMap.size() != wholeHeaderMap.size()) {
                HashSet<String> dupHeaderSet = new HashSet<String>(customHeaderMap.keySet());
                dupHeaderSet.retainAll(headerMap.keySet());
                throw new IllegalArgumentException("\u81ea\u5b9a\u4e49Header\u4e2d\u5305\u542bXOP\u5ba2\u6237\u7aef\u6240\u4f20Key\uff1a " + String.join((CharSequence)",", dupHeaderSet));
            }
            headerMap.putAll(customHeaderMap);
        }
        if (method == HttpMethod.GET) {
            response = ((GetRequest)((GetRequest)this.client.get(fullUri).headers(headerMap)).queryString(request.getQueryParams())).asString();
        } else {
            HttpRequestWithBody req = (HttpRequestWithBody)((HttpRequestWithBody)this.client.post(fullUri).headers(headerMap)).queryString(request.getQueryParams());
            response = XopClientUtils.isEmpty(bodyString) ? req.asString() : req.body(bodyString).asString();
        }
        return new XopHttpResponseImpl<String>(response, requestId);
    }

    protected HmacResult getHmacResult(String uri, Map<String, Object> queryParams, String bodyString) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        if (queryParams != null) {
            map.putAll(queryParams);
        }
        map.put("xop_url", uri);
        if (XopHmacVersionEnum.V2 == this.hmacVersionEnum) {
            return HmacUtilsV2.sign(this.appId, this.secret, map, bodyString);
        }
        return HmacUtils.sign(this.appId, this.secret, map, bodyString);
    }

    protected Map<String, String> getHeaderMap(HmacResult result) {
        HashMap<String, String> headerMap = new HashMap<String, String>(8);
        headerMap.put("Xop-App-Id", this.appId);
        headerMap.put("Xop-Timestamp", result.getTimeStamp().toString());
        headerMap.put(this.hmacVersionEnum.getSignHeader(), result.getSign());
        headerMap.put("Xop-Nonce", result.getNonce());
        headerMap.put("Content-Type", "application/json");
        return headerMap;
    }
}

