/*
 * Decompiled with CFR 0.152.
 */
package com.xkw.xop.client.impl;

import com.xkw.xop.client.XopHttpClient;
import com.xkw.xop.client.hmac.HmacResult;
import com.xkw.xop.client.hmac.XopHmacVersionEnum;
import com.xkw.xop.client.impl.XopClientBase;
import com.xkw.xop.client.request.XopHttpRequest;
import com.xkw.xop.client.request.impl.XopHttpRequestImpl;
import com.xkw.xop.client.response.XopHttpResponse;
import java.util.Map;
import kong.unirest.Config;
import kong.unirest.HttpMethod;

public class XopHttpClientImpl
extends XopClientBase
implements XopHttpClient {
    public XopHttpClientImpl(String gatewayHost, String appId, String secret, Config config, XopHmacVersionEnum hmacVersionEnum) {
        super(gatewayHost, appId, secret, config, hmacVersionEnum);
    }

    @Override
    public XopHttpResponse<String> get(String uri) {
        return this.get(uri, null);
    }

    @Override
    public XopHttpResponse<String> get(String uri, Map<String, Object> queryParams) {
        return this.sendRequest(HttpMethod.GET, uri, queryParams, null);
    }

    @Override
    public XopHttpResponse<String> post(String uri, Map<String, Object> queryParams, Object body) {
        return this.sendRequest(HttpMethod.POST, uri, queryParams, body);
    }

    @Override
    public XopHttpRequest getRequest() {
        XopHttpRequestImpl request = new XopHttpRequestImpl();
        return request.httpMethod(HttpMethod.GET);
    }

    @Override
    public XopHttpRequest postRequest() {
        XopHttpRequestImpl request = new XopHttpRequestImpl();
        return request.httpMethod(HttpMethod.POST);
    }

    @Override
    public XopHttpResponse<String> sendRequest(XopHttpRequest request) {
        return this.sendRequest(request.getHttpMethod(), request.getUri(), request.getQueryParams(), request.getBody(), request.getCustomHeaders());
    }

    private XopHttpResponse<String> sendRequest(HttpMethod method, String uri, Map<String, Object> queryParams, Object body) {
        return this.sendRequest(method, uri, queryParams, body, null);
    }

    private XopHttpResponse<String> sendRequest(HttpMethod method, String uri, Map<String, Object> queryParams, Object body, Map<String, String> customHeaderMap) {
        XopHttpRequestImpl request = new XopHttpRequestImpl();
        request.httpMethod(method).uri(uri).queryParams(queryParams).body(body);
        String bodyString = request.getBodyString();
        HmacResult result = this.getHmacResult(uri, queryParams, bodyString);
        Map<String, String> headerMap = this.getHeaderMap(result);
        return this.getHttpResponse(request, headerMap, bodyString, customHeaderMap);
    }
}

