/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.client;

import com.google.common.collect.Maps;
import com.yeepay.g3.sdk.yop.client.ResponseConfig;
import com.yeepay.g3.sdk.yop.client.YopConnectionKeepAliveStrategy;
import com.yeepay.g3.sdk.yop.client.YopHttpRequestRetryHandler;
import com.yeepay.g3.sdk.yop.client.YopRequest;
import com.yeepay.g3.sdk.yop.client.YopResponse;
import com.yeepay.g3.sdk.yop.client.router.GateWayRouter;
import com.yeepay.g3.sdk.yop.client.router.ServerRootSpace;
import com.yeepay.g3.sdk.yop.client.router.SimpleGateWayRouter;
import com.yeepay.g3.sdk.yop.config.AppSdkConfig;
import com.yeepay.g3.sdk.yop.config.AppSdkConfigProvider;
import com.yeepay.g3.sdk.yop.config.AppSdkConfigProviderRegistry;
import com.yeepay.g3.sdk.yop.config.support.BackUpAppSdkConfigManager;
import com.yeepay.g3.sdk.yop.encrypt.AESEncrypter;
import com.yeepay.g3.sdk.yop.encrypt.DigestAlgEnum;
import com.yeepay.g3.sdk.yop.encrypt.RSA;
import com.yeepay.g3.sdk.yop.error.YopError;
import com.yeepay.g3.sdk.yop.exception.VerifySignFailedException;
import com.yeepay.g3.sdk.yop.exception.YopClientException;
import com.yeepay.g3.sdk.yop.http.HttpMethodName;
import com.yeepay.g3.sdk.yop.http.YopHttpResponse;
import com.yeepay.g3.sdk.yop.model.DownloadInputStream;
import com.yeepay.g3.sdk.yop.model.YopErrorResponse;
import com.yeepay.g3.sdk.yop.unmarshaller.JacksonJsonMarshaller;
import com.yeepay.g3.sdk.yop.utils.FileUtils;
import com.yeepay.g3.sdk.yop.utils.InternalConfig;
import com.yeepay.g3.sdk.yop.utils.UUIDUtils;
import com.yeepay.g3.sdk.yop.utils.checksum.CRC64;
import com.yeepay.g3.sdk.yop.utils.io.MarkableFileInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.zip.CheckedInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractClient {
    private static final Logger LOGGER;
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final int EXT_READ_BUFFER_SIZE = 65536;
    private static final GateWayRouter GATE_WAY_ROUTER;
    private static CloseableHttpClient httpClient;
    private static RequestConfig.Builder requestConfigBuilder;
    private static CredentialsProvider credentialsProvider;
    private static HttpHost proxyHttpHost;
    protected static final String SESSION_ID;
    private static final YopError FILE_CHECK_ERROR;
    private static final YopError FILE_UPLOAD_ERROR;

    public static void initApacheHttpClient() {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(InternalConfig.READ_TIMEOUT).setConnectTimeout(InternalConfig.CONNECT_TIMEOUT).build();
        httpClient = HttpClientBuilder.create().setMaxConnTotal(InternalConfig.MAX_CONN_TOTAL).setMaxConnPerRoute(InternalConfig.MAX_CONN_PER_ROUTE).setSSLSocketFactory((LayeredConnectionSocketFactory)(InternalConfig.TRUST_ALL_CERTS ? AbstractClient.getTrustedAllSSLConnectionSocketFactory() : null)).setDefaultRequestConfig(requestConfig).evictExpiredConnections().evictIdleConnections(3L, TimeUnit.SECONDS).setRetryHandler((HttpRequestRetryHandler)new YopHttpRequestRetryHandler()).setKeepAliveStrategy((ConnectionKeepAliveStrategy)new YopConnectionKeepAliveStrategy()).build();
        requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setConnectTimeout(InternalConfig.CONNECT_TIMEOUT);
        requestConfigBuilder.setStaleConnectionCheckEnabled(true);
        if (InternalConfig.proxy != null) {
            String proxyHost = InternalConfig.proxy.getHost();
            int proxyPort = InternalConfig.proxy.getPort();
            String scheme = InternalConfig.proxy.getScheme();
            if (proxyHost != null && proxyPort > 0) {
                proxyHttpHost = new HttpHost(proxyHost, proxyPort, scheme);
                requestConfigBuilder.setProxy(proxyHttpHost);
                credentialsProvider = new BasicCredentialsProvider();
                String proxyUsername = InternalConfig.proxy.getUsername();
                String proxyPassword = InternalConfig.proxy.getPassword();
                String proxyDomain = InternalConfig.proxy.getDomain();
                String proxyWorkstation = InternalConfig.proxy.getWorkstation();
                if (proxyUsername != null && proxyPassword != null) {
                    credentialsProvider.setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new NTCredentials(proxyUsername, proxyPassword, proxyWorkstation, proxyDomain));
                }
            }
        }
    }

    public static void destroyApacheHttpClient() {
        try {
            httpClient.close();
        }
        catch (IOException e) {
            LOGGER.error("httpclient close fail", (Throwable)e);
        }
    }

    private static SSLConnectionSocketFactory getTrustedAllSSLConnectionSocketFactory() {
        LOGGER.warn("[yop-sdk]\u5df2\u8bbe\u7f6e\u4fe1\u4efb\u6240\u6709\u8bc1\u4e66\u3002\u4ec5\u4f9b\u5185\u6d4b\u4f7f\u7528\uff0c\u8bf7\u52ff\u5728\u751f\u4ea7\u73af\u5883\u914d\u7f6e\u3002");
        SSLConnectionSocketFactory sslConnectionSocketFactory = null;
        try {
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            });
            sslConnectionSocketFactory = new SSLConnectionSocketFactory(builder.build());
        }
        catch (Exception e) {
            LOGGER.error("error when get trust-all-certs request factory,will return normal request factory instead", (Throwable)e);
        }
        return sslConnectionSocketFactory;
    }

    protected static HttpUriRequest buildFormHttpRequest(YopRequest request, String contentUrl, HttpMethodName httpMethod) {
        RequestBuilder requestBuilder;
        if (HttpMethodName.POST == httpMethod) {
            requestBuilder = RequestBuilder.post();
        } else if (HttpMethodName.GET == httpMethod) {
            requestBuilder = RequestBuilder.get();
        } else if (HttpMethodName.DELETE == httpMethod) {
            requestBuilder = RequestBuilder.delete();
        } else if (HttpMethodName.PUT == httpMethod) {
            requestBuilder = RequestBuilder.put();
        } else {
            throw new YopClientException("unsupported http method");
        }
        requestBuilder.setUri(contentUrl);
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            requestBuilder.addHeader(entry.getKey(), entry.getValue());
        }
        try {
            for (Map.Entry<String, String> entry : request.getParams().asMap().entrySet()) {
                String paramKey = entry.getKey();
                for (String value : (Collection)((Object)entry.getValue())) {
                    requestBuilder.addParameter(paramKey, URLEncoder.encode(value, "UTF-8"));
                }
            }
        }
        catch (IOException ex) {
            throw new YopClientException("unable to create http request.", ex);
        }
        return requestBuilder.build();
    }

    protected static HttpUriRequest buildJsonHttpRequest(YopRequest request, String contentUrl, HttpMethodName httpMethod, String jsonString) {
        RequestBuilder requestBuilder = RequestBuilder.post();
        requestBuilder.setUri(contentUrl);
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            requestBuilder.addHeader(entry.getKey(), entry.getValue());
        }
        StringEntity entity = new StringEntity(jsonString, "UTF-8");
        entity.setContentEncoding("UTF-8");
        entity.setContentType(ContentType.APPLICATION_JSON.getMimeType());
        requestBuilder.setEntity((HttpEntity)entity);
        return requestBuilder.build();
    }

    protected static Pair<HttpUriRequest, List<CheckedInputStream>> buildMultiFormRequest(YopRequest request, String contentUrl) {
        RequestBuilder requestBuilder = RequestBuilder.post().setUri(contentUrl);
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            requestBuilder.addHeader(entry.getKey(), entry.getValue());
        }
        TreeMap checkedInputStreams = null;
        try {
            if (!request.hasFiles()) {
                for (Map.Entry entry : request.getParams().asMap().entrySet()) {
                    String string = (String)entry.getKey();
                    for (String value : (Collection)entry.getValue()) {
                        requestBuilder.addParameter(string, URLEncoder.encode(value, "UTF-8"));
                    }
                }
            } else {
                checkedInputStreams = Maps.newTreeMap();
                MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setCharset(Charset.forName("UTF-8"));
                for (Map.Entry<String, Object> entry : request.getMultipartFiles().entrySet()) {
                    String paramName = entry.getKey();
                    Pair<String, CheckedInputStream> checkedInputStreamPair = AbstractClient.wrapToCheckInputStream(entry.getValue());
                    multipartEntityBuilder.addBinaryBody(paramName, (InputStream)checkedInputStreamPair.getRight(), ContentType.DEFAULT_BINARY, (String)checkedInputStreamPair.getLeft());
                    checkedInputStreams.put(paramName, checkedInputStreamPair.getRight());
                }
                for (Map.Entry entry : request.getParams().entries()) {
                    multipartEntityBuilder.addTextBody((String)entry.getKey(), URLEncoder.encode((String)entry.getValue(), "UTF-8"));
                }
                requestBuilder.setEntity(multipartEntityBuilder.build());
            }
        }
        catch (IOException iOException) {
            throw new YopClientException("unable to create http request.", iOException);
        }
        HttpUriRequest httpUriRequest = requestBuilder.build();
        ArrayList arrayList = checkedInputStreams == null ? null : new ArrayList(checkedInputStreams.values());
        return new ImmutablePair((Object)httpUriRequest, arrayList);
    }

    protected static Pair<HttpUriRequest, CheckedInputStream> buildMultiPartUploadRequest(YopRequest request, String contentUrl, Object file, long partSize) {
        RequestBuilder requestBuilder = RequestBuilder.put().setUri(contentUrl);
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            requestBuilder.addHeader(entry.getKey(), entry.getValue());
        }
        CheckedInputStream checkedInputStream = null;
        try {
            Pair<String, CheckedInputStream> checkedInputStreamPair = AbstractClient.wrapToCheckInputStream(file);
            checkedInputStream = (CheckedInputStream)checkedInputStreamPair.getRight();
            InputStreamEntity reqEntity = new InputStreamEntity((InputStream)checkedInputStream, partSize);
            reqEntity.setContentType(ContentType.DEFAULT_BINARY.getMimeType());
            requestBuilder.setEntity((HttpEntity)reqEntity);
        }
        catch (IOException ex) {
            throw new YopClientException("unable to create http request.", ex);
        }
        HttpUriRequest httpPost = requestBuilder.build();
        return new ImmutablePair((Object)httpPost, (Object)checkedInputStream);
    }

    private static Pair<String, CheckedInputStream> wrapToCheckInputStream(Object file) throws IOException {
        if (file instanceof String) {
            File paramFile = new File((String)file);
            CheckedInputStream inputStream = new CheckedInputStream(new FileInputStream(paramFile), new CRC64());
            return new ImmutablePair((Object)paramFile.getName(), (Object)inputStream);
        }
        if (file instanceof File) {
            CheckedInputStream inputStream = new CheckedInputStream(new FileInputStream((File)file), new CRC64());
            return new ImmutablePair((Object)((File)file).getName(), (Object)inputStream);
        }
        if (file instanceof FileInputStream) {
            return AbstractClient.getCheckedInputStreamPair((FileInputStream)file);
        }
        if (file instanceof InputStream) {
            return AbstractClient.getCheckedInputStreamPair((InputStream)file);
        }
        throw new YopClientException("\u4e0d\u652f\u6301\u7684\u4e0a\u4f20\u6587\u4ef6\u7c7b\u578b");
    }

    private static Pair<String, CheckedInputStream> getCheckedInputStreamPair(FileInputStream fileInputStream) throws IOException {
        MarkableFileInputStream in = new MarkableFileInputStream(fileInputStream);
        in.mark(0);
        String fileName = FileUtils.getFileName(in);
        in.reset();
        CheckedInputStream inputStream = new CheckedInputStream(in, new CRC64());
        return new ImmutablePair((Object)fileName, (Object)inputStream);
    }

    private static Pair<String, CheckedInputStream> getCheckedInputStreamPair(InputStream inputStream) throws IOException {
        byte[] extReadBuffer = new byte[65536];
        int totalRead = 0;
        int lastRead = inputStream.read(extReadBuffer);
        while (lastRead != -1 && (totalRead += lastRead) != 65536) {
            lastRead = inputStream.read(extReadBuffer, totalRead, 65536 - totalRead);
        }
        ByteArrayInputStream extReadIn = new ByteArrayInputStream(extReadBuffer, 0, totalRead);
        String fileName = FileUtils.getFileName(extReadIn);
        extReadIn.reset();
        SequenceInputStream sequenceInputStream = new SequenceInputStream(extReadIn, inputStream);
        return new ImmutablePair((Object)fileName, (Object)new CheckedInputStream(sequenceInputStream, new CRC64()));
    }

    protected static YopResponse fetchContentByApacheHttpClient(HttpUriRequest request) throws IOException {
        return AbstractClient.fetchContentByApacheHttpClient(request, ResponseConfig.NONE_OPERATION_CONFIG);
    }

    protected static YopResponse fetchContentByApacheHttpClient(HttpUriRequest request, ResponseConfig responseConfig) throws IOException {
        HttpClientContext httpContext = AbstractClient.createHttpContext();
        CloseableHttpResponse remoteResponse = null;
        Throwable exception = null;
        try {
            remoteResponse = AbstractClient.getHttpClient().execute(request, (HttpContext)httpContext);
            YopResponse yopResponse = AbstractClient.parseResponse(remoteResponse, responseConfig);
            return yopResponse;
        }
        catch (Throwable ex) {
            String requestId = AbstractClient.getRequestId(request);
            LOGGER.error("request failure, requestId:" + requestId, ex);
            exception = ex;
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof YopClientException) {
                throw (YopClientException)ex;
            }
            throw new YopClientException("unable to execute request.", ex);
        }
        finally {
            if (exception != null || remoteResponse != null && AbstractClient.isJsonResponse(remoteResponse)) {
                HttpClientUtils.closeQuietly((CloseableHttpResponse)remoteResponse);
            }
        }
    }

    private static String getRequestId(HttpUriRequest request) {
        return request.getFirstHeader("x-yop-request-id").getValue();
    }

    protected static YopResponse parseResponse(CloseableHttpResponse httpResponse, ResponseConfig responseConfig) throws IOException {
        int statusCode;
        YopHttpResponse response = new YopHttpResponse(httpResponse);
        Header yopViaHeader = httpResponse.getFirstHeader("x-yop-via");
        if (yopViaHeader != null && StringUtils.equals((CharSequence)yopViaHeader.getValue(), (CharSequence)"sandbox")) {
            LOGGER.info("response from sandbox-gateway");
        }
        if ((statusCode = response.getStatusCode()) / 100 == 2 && statusCode != 204) {
            YopResponse result = new YopResponse();
            AbstractClient.handleHeaders(result, httpResponse);
            result.setState("SUCCESS");
            result.setRequestId(response.getHeader("x-yop-request-id"));
            if (response.getContent() != null) {
                if (AbstractClient.isJsonResponse(httpResponse)) {
                    String content = IOUtils.toString((InputStream)response.getContent(), (String)"UTF-8");
                    if (responseConfig != ResponseConfig.NONE_OPERATION_CONFIG) {
                        AbstractClient.verifySignature(content, response.getHeader("x-yop-sign"), responseConfig.getYopPublicKey());
                        content = AbstractClient.decryptResponse(content, responseConfig);
                    }
                    JacksonJsonMarshaller.load(content, result);
                    if (result.getStringResult() != null) {
                        result.setResult(JacksonJsonMarshaller.unmarshal(result.getStringResult(), Object.class));
                    }
                } else {
                    result.setResult(new DownloadInputStream(response.getContent(), httpResponse));
                }
            }
            return result;
        }
        if (statusCode >= 500 && statusCode != 502) {
            if (response.getContent() != null) {
                String content = IOUtils.toString((InputStream)response.getContent(), (String)"UTF-8");
                if (responseConfig != ResponseConfig.NONE_OPERATION_CONFIG) {
                    AbstractClient.verifySignature(content, response.getHeader("x-yop-sign"), responseConfig.getYopPublicKey());
                    content = AbstractClient.decryptResponse(content, responseConfig);
                }
                YopResponse result = new YopResponse();
                AbstractClient.handleHeaders(result, httpResponse);
                result.setState("FAILURE");
                YopErrorResponse errorResponse = JacksonJsonMarshaller.unmarshal(content, YopErrorResponse.class);
                result.setRequestId(errorResponse.getRequestId());
                result.setError(YopError.Builder.anYopError().withCode(errorResponse.getCode()).withSubCode(errorResponse.getSubCode()).withMessage(errorResponse.getMessage()).withSubMessage(errorResponse.getSubMessage()).build());
                return result;
            }
            throw new YopClientException("empty result with httpStatusCode:" + response.getStatusCode());
        }
        throw new YopClientException("unexpected httpStatusCode:" + response.getStatusCode());
    }

    private static String decryptResponse(String content, ResponseConfig response) {
        if (BooleanUtils.isTrue((Boolean)response.isNeedDecrypt()) && !StringUtils.startsWith((CharSequence)content, (CharSequence)"{")) {
            return AESEncrypter.decrypt(content, response.getDecryptKey());
        }
        return content;
    }

    private static void verifySignature(String content, String signature, PublicKey yopPublicKey) {
        if (StringUtils.isEmpty((CharSequence)signature)) {
            return;
        }
        if (!RSA.verifySign(content = content.replaceAll("[ \t\n]", ""), signature, yopPublicKey, DigestAlgEnum.SHA256)) {
            throw new VerifySignFailedException("response sign verify failure");
        }
    }

    private static boolean isJsonResponse(CloseableHttpResponse response) {
        return StringUtils.startsWith((CharSequence)response.getEntity().getContentType().getValue(), (CharSequence)CONTENT_TYPE_JSON);
    }

    private static void handleHeaders(YopResponse yopResponse, CloseableHttpResponse response) {
        HeaderIterator headerIterator = response.headerIterator();
        while (headerIterator.hasNext()) {
            Header header = headerIterator.nextHeader();
            if (StringUtils.startsWith((CharSequence)header.getName(), (CharSequence)"x-yop-")) {
                yopResponse.addHeader(header.getName(), header.getValue());
            }
            if (!StringUtils.equals((CharSequence)header.getName(), (CharSequence)"ETag")) continue;
            yopResponse.addHeader(header.getName(), header.getValue());
        }
    }

    protected static void checkFileIntegrity(YopResponse response, String crc64) {
        if (response.isSuccess()) {
            String responseCrc64 = response.getHeaders().get("x-yop-hash-crc64ecma");
            if (null == responseCrc64 || StringUtils.equals((CharSequence)responseCrc64, (CharSequence)crc64)) {
                return;
            }
            response.setState("FAILURE");
            response.setError(AbstractClient.getFileCheckError());
        }
    }

    public static YopError getFileCheckError() {
        return FILE_CHECK_ERROR;
    }

    public static YopError getFileUploadError() {
        return FILE_UPLOAD_ERROR;
    }

    private static HttpClientContext createHttpContext() {
        HttpClientContext context = HttpClientContext.create();
        context.setRequestConfig(requestConfigBuilder.build());
        if (credentialsProvider != null) {
            context.setCredentialsProvider(credentialsProvider);
        }
        return context;
    }

    public static CloseableHttpClient getHttpClient() {
        return httpClient;
    }

    protected static String richRequest(String methodOrUri, YopRequest request) {
        return GATE_WAY_ROUTER.route(methodOrUri, request) + methodOrUri;
    }

    protected static String getUUID() {
        return UUIDUtils.compressV4UUID();
    }

    static {
        ServerRootSpace serverRootSpace;
        LOGGER = LoggerFactory.getLogger(AbstractClient.class);
        SESSION_ID = AbstractClient.getUUID();
        AbstractClient.initApacheHttpClient();
        FILE_CHECK_ERROR = new YopError();
        FILE_CHECK_ERROR.setCode("40044");
        FILE_CHECK_ERROR.setMessage("\u4e1a\u52a1\u5904\u7406\u5931\u8d25");
        FILE_CHECK_ERROR.setSubCode("isv.scene.filestore.put.crc-failed");
        FILE_CHECK_ERROR.setSubMessage("\u6587\u4ef6\u4e0a\u4f20crc\u6821\u9a8c\u5931\u8d25");
        FILE_UPLOAD_ERROR = new YopError();
        FILE_UPLOAD_ERROR.setCode("40044");
        FILE_UPLOAD_ERROR.setMessage("\u4e1a\u52a1\u5904\u7406\u5931\u8d25");
        FILE_UPLOAD_ERROR.setSubCode("isv.scene.filestore.put.failed");
        FILE_UPLOAD_ERROR.setSubMessage("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        AppSdkConfigProvider sdkConfigProvider = AppSdkConfigProviderRegistry.getProvider();
        AppSdkConfig appSdkConfig = sdkConfigProvider.getDefaultConfig() == null ? BackUpAppSdkConfigManager.getBackUpConfig() : sdkConfigProvider.getDefaultConfig();
        try {
            serverRootSpace = new ServerRootSpace((String)StringUtils.defaultIfBlank((CharSequence)appSdkConfig.getServerRoot(), (CharSequence)"https://openapi.yeepay.com/yop-center"), (String)StringUtils.defaultIfBlank((CharSequence)appSdkConfig.getYosServerRoot(), (CharSequence)"https://yos.yeepay.com/yop-center"), (String)StringUtils.defaultIfBlank((CharSequence)appSdkConfig.getSandboxServerRoot(), (CharSequence)"https://sandbox.yeepay.com/yop-center"));
        }
        catch (MalformedURLException e) {
            throw new YopClientException("server root illegal");
        }
        GATE_WAY_ROUTER = new SimpleGateWayRouter(serverRootSpace);
    }
}

