/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.yeepay.g3.sdk.yop.client.AbstractClient;
import com.yeepay.g3.sdk.yop.client.YopRequest;
import com.yeepay.g3.sdk.yop.client.YopResponse;
import com.yeepay.g3.sdk.yop.encrypt.AESEncrypter;
import com.yeepay.g3.sdk.yop.encrypt.Digests;
import com.yeepay.g3.sdk.yop.http.HttpMethodName;
import com.yeepay.g3.sdk.yop.unmarshaller.JacksonJsonMarshaller;
import com.yeepay.g3.sdk.yop.utils.CheckUtils;
import com.yeepay.g3.sdk.yop.utils.DateUtils;
import com.yeepay.g3.sdk.yop.utils.JsonUtils;
import com.yeepay.g3.sdk.yop.utils.checksum.CRC64Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.CheckedInputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopClient
extends AbstractClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopClient.class);

    public static YopResponse post(String apiUri, YopRequest request) throws IOException {
        CheckUtils.checkApiUri(apiUri);
        String contentUrl = YopClient.richRequest(apiUri, request);
        YopClient.normalize(request);
        YopClient.sign(apiUri, request);
        HttpUriRequest httpPost = YopClient.buildFormHttpRequest(request, contentUrl, HttpMethodName.POST);
        YopResponse response = YopClient.fetchContentByApacheHttpClient(httpPost);
        YopClient.handleResult(response);
        return response;
    }

    public static YopResponse get(String apiUri, YopRequest request) throws IOException {
        CheckUtils.checkApiUri(apiUri);
        String contentUrl = YopClient.richRequest(apiUri, request);
        YopClient.normalize(request);
        YopClient.sign(apiUri, request);
        HttpUriRequest httpGet = YopClient.buildFormHttpRequest(request, contentUrl, HttpMethodName.GET);
        YopResponse response = YopClient.fetchContentByApacheHttpClient(httpGet);
        YopClient.handleResult(response);
        return response;
    }

    public static YopResponse upload(String apiUri, YopRequest request) throws IOException {
        CheckUtils.checkApiUri(apiUri);
        String contentUrl = YopClient.richRequest(apiUri, request);
        YopClient.normalize(request);
        YopClient.sign(apiUri, request);
        Pair<HttpUriRequest, List<CheckedInputStream>> pair = YopClient.buildMultiFormRequest(request, contentUrl);
        YopResponse response = YopClient.fetchContentByApacheHttpClient((HttpUriRequest)pair.getLeft());
        YopClient.handleResult(response);
        if (pair.getRight() != null) {
            YopClient.checkFileIntegrity(response, CRC64Utils.getCRC64((List)pair.getRight()));
        }
        return response;
    }

    public static String getCanonicalQueryString(String apiUri, YopRequest request, boolean forSignature) {
        request.addParam("ts", String.valueOf(System.currentTimeMillis()));
        TreeMap<String, String> signParams = new TreeMap<String, String>();
        Multimap<String, String> parameters = request.getParams();
        if (!parameters.isEmpty()) {
            for (Map.Entry entry : parameters.asMap().entrySet()) {
                if (forSignature && ("Authorization".equalsIgnoreCase((String)entry.getKey()) || request.getIgnoreSignParams().contains(entry.getKey()))) continue;
                String key = (String)entry.getKey();
                Preconditions.checkNotNull((Object)key, (Object)"parameter key should not be null");
                ArrayList list = new ArrayList((Collection)entry.getValue());
                Collections.sort(list);
                signParams.put(key, StringUtils.join(list, (String)","));
            }
        }
        signParams.put("method", apiUri);
        signParams.put("v", StringUtils.substringBefore((String)StringUtils.substringAfter((String)apiUri, (String)"/v"), (String)"/"));
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : signParams.entrySet()) {
            sb.append((String)entry.getKey()).append(StringUtils.trim((String)((String)entry.getValue())));
        }
        return sb.toString();
    }

    private static void normalize(YopRequest request) {
        request.addHeader("x-yop-session-id", SESSION_ID);
        if (!request.getHeaders().containsKey("x-yop-request-id")) {
            request.addHeader("x-yop-request-id", YopClient.getUUID());
        }
        String timestamp = DateUtils.formatAlternateIso8601Date(new Date());
        request.addHeader("x-yop-date", timestamp);
    }

    private static void sign(String apiUri, YopRequest request) {
        if (request.getHeaders().containsKey("Authorization")) {
            return;
        }
        String canonicalQueryString = YopClient.getCanonicalQueryString(apiUri, request, true);
        String secret = request.getAesSecretKey();
        String algName = request.getSignAlg();
        algName = StringUtils.isBlank((CharSequence)algName) ? "SHA1" : algName;
        String sb = secret + canonicalQueryString + secret;
        String signature = Digests.digest2Hex(sb, algName);
        if (32 == Base64.decodeBase64((String)secret).length) {
            request.addHeader("Authorization", "YOP-HMAC-AES256 " + signature);
        } else {
            request.addHeader("Authorization", "YOP-HMAC-AES128 " + signature);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("========\ncanonicalQueryString:" + canonicalQueryString + "\nsha1(secret):" + Digests.digest2Hex(secret, "sha1") + "\nsignature:" + signature);
        }
    }

    private static void handleResult(YopResponse response) {
        String stringResult = response.getStringResult();
        if (StringUtils.isNotBlank((CharSequence)stringResult)) {
            response.setResult(JacksonJsonMarshaller.unmarshal(stringResult, Object.class));
        }
    }

    public static String acceptNotificationAsJson(String key, String response) {
        return YopClient.validateAndDecryptNotification(key, response);
    }

    public static Map acceptNotificationAsMap(String key, String response) {
        String s = YopClient.acceptNotificationAsJson(key, response);
        return s == null ? null : JsonUtils.fromJsonString(YopClient.acceptNotificationAsJson(key, response), Map.class);
    }

    private static String validateAndDecryptNotification(String key, String response) {
        String localSignature;
        Map map = JsonUtils.fromJsonString(response, Map.class);
        boolean doEncryption = Boolean.valueOf(map.get("doEncryption").toString());
        String encryption = map.get("encryption").toString();
        String signature = map.get("signature").toString();
        String signatureAlg = map.get("signatureAlg").toString();
        if (doEncryption) {
            encryption = AESEncrypter.decrypt(encryption, key);
        }
        if (!(localSignature = Digests.digest2Hex(key + encryption + key, signatureAlg)).equals(signature)) {
            return null;
        }
        return encryption;
    }
}

