/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.client;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

public class YopHttpRequestRetryHandler
implements HttpRequestRetryHandler {
    private final int retryCount;
    private final boolean requestSentRetryEnabled;
    private static final int SCALE_FACTOR = 300;
    private final Set<Class<? extends IOException>> nonRetriableClasses = Sets.newHashSet((Object[])new Class[]{InterruptedIOException.class, UnknownHostException.class, SocketException.class, ConnectException.class, SSLException.class});

    public YopHttpRequestRetryHandler() {
        this(3, false);
    }

    public YopHttpRequestRetryHandler(int retryCount, boolean requestSentRetryEnabled) {
        this.retryCount = retryCount;
        this.requestSentRetryEnabled = requestSentRetryEnabled;
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        Args.notNull((Object)exception, (String)"Exception parameter");
        Args.notNull((Object)context, (String)"HTTP context");
        if (executionCount > this.retryCount) {
            return false;
        }
        if (this.nonRetriableClasses.contains(exception.getClass())) {
            return false;
        }
        for (Class<? extends IOException> rejectException : this.nonRetriableClasses) {
            if (!rejectException.isInstance(exception)) continue;
            return false;
        }
        if (this.retryRequestWithSleep(exception, executionCount, context)) {
            try {
                Thread.sleep(this.getDelayBeforeNextRetryInMillis(executionCount));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return true;
        }
        return false;
    }

    private long getDelayBeforeNextRetryInMillis(int retriesAttempted) {
        return (1 << retriesAttempted + 1) * 300;
    }

    private boolean retryRequestWithSleep(IOException exception, int executionCount, HttpContext context) {
        int statusCode;
        if (exception instanceof ConnectTimeoutException || exception instanceof NoHttpResponseException || exception instanceof UnknownHostException || exception instanceof ConnectionPoolTimeoutException) {
            return true;
        }
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        HttpRequest request = clientContext.getRequest();
        if (this.handleAsIdempotent(request)) {
            return true;
        }
        if (!clientContext.isRequestSent() || this.requestSentRetryEnabled) {
            return true;
        }
        int n = statusCode = null != clientContext.getResponse() ? clientContext.getResponse().getStatusLine().getStatusCode() : 0;
        return 502 == statusCode;
    }

    public boolean isRequestSentRetryEnabled() {
        return this.requestSentRetryEnabled;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    protected boolean handleAsIdempotent(HttpRequest request) {
        return !(request instanceof HttpEntityEnclosingRequest);
    }
}

