/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.client.router;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;

public class ServerRootSpace
implements Serializable {
    private static final long serialVersionUID = -3149208992494791001L;
    private final String serverRoot;
    private final URL serverRootURL;
    private final String yosServerRoot;
    private final URL yosServerRootURL;
    private final String sandboxServerRoot;
    private final URL sandboxServerRootURL;

    public ServerRootSpace(String serverRoot, String yosServerRoot, String sandboxServerRoot) throws MalformedURLException {
        this.serverRoot = this.normalize(serverRoot);
        this.yosServerRoot = this.normalize(yosServerRoot);
        this.sandboxServerRoot = this.normalize(sandboxServerRoot);
        this.serverRootURL = new URL(this.serverRoot);
        this.yosServerRootURL = new URL(this.yosServerRoot);
        this.sandboxServerRootURL = new URL(this.sandboxServerRoot);
    }

    private String normalize(String serverRoot) {
        if (StringUtils.endsWith((CharSequence)serverRoot, (CharSequence)"/")) {
            return StringUtils.substring((String)serverRoot, (int)0, (int)(serverRoot.length() - 1));
        }
        return serverRoot;
    }

    public String getServerRoot() {
        return this.serverRoot;
    }

    public URL getServerRootURL() {
        return this.serverRootURL;
    }

    public String getYosServerRoot() {
        return this.yosServerRoot;
    }

    public URL getYosServerRootURL() {
        return this.yosServerRootURL;
    }

    public String getSandboxServerRoot() {
        return this.sandboxServerRoot;
    }

    public URL getSandboxServerRootURL() {
        return this.sandboxServerRootURL;
    }
}

