/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.config;

import com.google.common.collect.Maps;
import com.yeepay.g3.sdk.yop.config.CertConfig;
import com.yeepay.g3.sdk.yop.config.HttpClientConfig;
import com.yeepay.g3.sdk.yop.config.ProxyConfig;
import com.yeepay.g3.sdk.yop.config.SDKConfig;
import com.yeepay.g3.sdk.yop.config.enums.ModeEnum;
import com.yeepay.g3.sdk.yop.config.support.ConfigUtils;
import com.yeepay.g3.sdk.yop.encrypt.CertTypeEnum;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class AppSdkConfig
implements Serializable {
    private static final long serialVersionUID = -1L;
    private String appKey;
    private String serverRoot;
    private String yosServerRoot;
    private String sandboxServerRoot;
    private String aesSecretKey;
    private PublicKey defaultYopPublicKey;
    private PrivateKey defaultIsvPrivateKey;
    private String encryptKey;
    private HttpClientConfig httpClientConfig;
    private Map<CertTypeEnum, PublicKey> yopPublicKeys;
    private Map<CertTypeEnum, PrivateKey> isvPrivateKeys;
    private ProxyConfig proxy;
    private ModeEnum mode;
    private boolean trustAllCerts;

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public AppSdkConfig withAppKey(String appKey) {
        this.appKey = appKey;
        return this;
    }

    public String getServerRoot() {
        return this.serverRoot;
    }

    public void setServerRoot(String serverRoot) {
        this.serverRoot = serverRoot;
    }

    public AppSdkConfig withServerRoot(String serverRoot) {
        this.serverRoot = serverRoot;
        return this;
    }

    public String getYosServerRoot() {
        return this.yosServerRoot;
    }

    public void setYosServerRoot(String yosServerRoot) {
        this.yosServerRoot = yosServerRoot;
    }

    public AppSdkConfig withYosServerRot(String yosServerRoot) {
        this.yosServerRoot = yosServerRoot;
        return this;
    }

    public String getSandboxServerRoot() {
        return this.sandboxServerRoot;
    }

    public void setSandboxServerRoot(String sandboxServerRoot) {
        this.sandboxServerRoot = sandboxServerRoot;
    }

    public AppSdkConfig withSandboxServerRoot(String sandboxServerRoot) {
        this.sandboxServerRoot = sandboxServerRoot;
        return this;
    }

    public String getAesSecretKey() {
        return this.aesSecretKey;
    }

    public void setAesSecretKey(String aesSecretKey) {
        this.aesSecretKey = aesSecretKey;
    }

    public AppSdkConfig withAesSecretKey(String aesSecretKey) {
        this.aesSecretKey = aesSecretKey;
        return this;
    }

    public PublicKey getDefaultYopPublicKey() {
        return this.defaultYopPublicKey;
    }

    public void setDefaultYopPublicKey(PublicKey defaultYopPublicKey) {
        this.defaultYopPublicKey = defaultYopPublicKey;
    }

    public String getEncryptKey() {
        return this.encryptKey;
    }

    public void setEncryptKey(String encryptKey) {
        this.encryptKey = encryptKey;
    }

    public AppSdkConfig withEncryptKey(String encryptKey) {
        this.encryptKey = encryptKey;
        return this;
    }

    public PrivateKey getDefaultIsvPrivateKey() {
        return this.defaultIsvPrivateKey;
    }

    public void setDefaultIsvPrivateKey(PrivateKey defaultIsvPrivateKey) {
        this.defaultIsvPrivateKey = defaultIsvPrivateKey;
    }

    public HttpClientConfig getHttpClientConfig() {
        return this.httpClientConfig;
    }

    public void setHttpClientConfig(HttpClientConfig httpClientConfig) {
        this.httpClientConfig = httpClientConfig;
    }

    public AppSdkConfig withHttpClientConfig(HttpClientConfig httpClientConfig) {
        this.httpClientConfig = httpClientConfig;
        return this;
    }

    public void storeYopPublicKey(CertConfig[] yopPublicKeys) {
        this.defaultYopPublicKey = ConfigUtils.loadPublicKey(yopPublicKeys[0]);
        this.yopPublicKeys = Maps.newHashMap();
        this.yopPublicKeys.put(yopPublicKeys[0].getCertType(), this.defaultYopPublicKey);
        for (int i = 1; i < yopPublicKeys.length; ++i) {
            this.yopPublicKeys.put(yopPublicKeys[i].getCertType(), ConfigUtils.loadPublicKey(yopPublicKeys[i]));
        }
    }

    public void storeIsvPrivateKey(CertConfig[] isvPrivateKeys) {
        this.defaultIsvPrivateKey = ConfigUtils.loadPrivateKey(isvPrivateKeys[0]);
        this.isvPrivateKeys = Maps.newHashMap();
        this.isvPrivateKeys.put(isvPrivateKeys[0].getCertType(), this.defaultIsvPrivateKey);
        for (int i = 1; i < isvPrivateKeys.length; ++i) {
            this.isvPrivateKeys.put(isvPrivateKeys[i].getCertType(), ConfigUtils.loadPrivateKey(isvPrivateKeys[i]));
        }
    }

    public PublicKey loadYopPublicKey(CertTypeEnum certType) {
        return this.yopPublicKeys.get((Object)certType);
    }

    public PrivateKey loadPrivateKey(CertTypeEnum certType) {
        return this.isvPrivateKeys.get((Object)certType);
    }

    public ProxyConfig getProxy() {
        return this.proxy;
    }

    public void setProxy(ProxyConfig proxy) {
        this.proxy = proxy;
    }

    public AppSdkConfig withProxy(ProxyConfig proxy) {
        this.proxy = proxy;
        return this;
    }

    public ModeEnum getMode() {
        return this.mode;
    }

    public void setMode(ModeEnum mode) {
        this.mode = mode;
    }

    public AppSdkConfig withMode(ModeEnum mode) {
        this.mode = mode;
        return this;
    }

    public boolean getTrustAllCerts() {
        return this.trustAllCerts;
    }

    public void setTrustAllCerts(boolean trustAllCerts) {
        this.trustAllCerts = trustAllCerts;
    }

    public AppSdkConfig withTrustAllCerts(boolean trustAllCerts) {
        this.trustAllCerts = trustAllCerts;
        return this;
    }

    public static final class Builder {
        private SDKConfig sdkConfig;

        public static Builder anAppSdkConfig() {
            return new Builder();
        }

        public Builder withSDKConfig(SDKConfig sdkConfig) {
            this.sdkConfig = sdkConfig;
            return this;
        }

        public AppSdkConfig build() {
            AppSdkConfig appSdkConfig = new AppSdkConfig().withAppKey(this.sdkConfig.getAppKey()).withAesSecretKey(this.sdkConfig.getAesSecretKey()).withServerRoot((String)StringUtils.defaultIfBlank((CharSequence)this.sdkConfig.getServerRoot(), (CharSequence)"https://openapi.yeepay.com/yop-center")).withYosServerRot((String)StringUtils.defaultIfBlank((CharSequence)this.sdkConfig.getYosServerRoot(), (CharSequence)"https://yos.yeepay.com/yop-center")).withSandboxServerRoot((String)StringUtils.defaultIfBlank((CharSequence)this.sdkConfig.getSandboxServerRoot(), (CharSequence)"https://sandbox.yeepay.com/yop-center")).withEncryptKey(this.sdkConfig.getEncryptKey()).withHttpClientConfig(this.sdkConfig.getHttpClient()).withProxy(this.sdkConfig.getProxy()).withMode(this.sdkConfig.getMode()).withTrustAllCerts(BooleanUtils.isTrue((Boolean)this.sdkConfig.getTrustAllCerts()));
            if (this.sdkConfig.getYopPublicKey() != null && this.sdkConfig.getYopPublicKey().length >= 1) {
                appSdkConfig.storeYopPublicKey(this.sdkConfig.getYopPublicKey());
            }
            if (this.sdkConfig.getIsvPrivateKey() != null && this.sdkConfig.getIsvPrivateKey().length >= 1) {
                appSdkConfig.storeIsvPrivateKey(this.sdkConfig.getIsvPrivateKey());
            }
            return appSdkConfig;
        }
    }
}

