/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.config.provider;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.yeepay.g3.sdk.yop.config.AppSdkConfig;
import com.yeepay.g3.sdk.yop.config.AppSdkConfigProvider;
import com.yeepay.g3.sdk.yop.config.SDKConfig;
import com.yeepay.g3.sdk.yop.config.provider.support.AppSdkConfigInitTask;
import com.yeepay.g3.sdk.yop.utils.Holder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCachedAppSdkConfigProvider
implements AppSdkConfigProvider {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LoadingCache<String, Holder<AppSdkConfig>> configCache;
    private final String defaultAppKey;

    public BaseCachedAppSdkConfigProvider() {
        this(null, -1L, null);
    }

    public BaseCachedAppSdkConfigProvider(String defaultAppKey) {
        this(defaultAppKey, -1L, null);
    }

    public BaseCachedAppSdkConfigProvider(Long expire, TimeUnit timeUnit) {
        this(null, expire, timeUnit);
    }

    public BaseCachedAppSdkConfigProvider(String defaultAppKey, Long expire, TimeUnit timeUnit) {
        this.configCache = this.initCache(expire, timeUnit);
        List<SDKConfig> initSdkConfigs = this.loadOnInit();
        if (CollectionUtils.isNotEmpty(initSdkConfigs)) {
            for (SDKConfig sdkConfig : initSdkConfigs) {
                this.configCache.put((Object)sdkConfig.getAppKey(), new Holder<AppSdkConfig>(new AppSdkConfigInitTask(sdkConfig)));
                if (!BooleanUtils.isTrue((Boolean)sdkConfig.getDefaulted()) || defaultAppKey != null) continue;
                defaultAppKey = sdkConfig.getAppKey();
            }
        }
        this.defaultAppKey = defaultAppKey;
    }

    private final LoadingCache<String, Holder<AppSdkConfig>> initCache(Long expire, TimeUnit timeUnit) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (expire > 0L) {
            cacheBuilder.expireAfterWrite(expire.longValue(), timeUnit);
        }
        return cacheBuilder.build((CacheLoader)new CacheLoader<String, Holder<AppSdkConfig>>(){

            public Holder<AppSdkConfig> load(String key) throws Exception {
                BaseCachedAppSdkConfigProvider.this.logger.debug("try to load appSdkConfig for appKey:" + key);
                try {
                    SDKConfig sdkConfig = BaseCachedAppSdkConfigProvider.this.loadSDKConfig(key);
                    if (sdkConfig == null) {
                        return null;
                    }
                    return new Holder<AppSdkConfig>(new AppSdkConfigInitTask(sdkConfig));
                }
                catch (Exception ex) {
                    BaseCachedAppSdkConfigProvider.this.logger.warn("UnexpectedException occurred when loading appSdkConfig for appKey:" + key, (Throwable)ex);
                    return null;
                }
            }
        });
    }

    @Override
    public AppSdkConfig getConfig(String appKey) {
        try {
            Holder holder = (Holder)this.configCache.get((Object)appKey);
            return holder == null ? null : (AppSdkConfig)holder.getValue();
        }
        catch (CacheLoader.InvalidCacheLoadException ex) {
            this.logger.warn("Null value was loaded when getting config for appKey:" + appKey);
            return null;
        }
        catch (Exception ex) {
            this.logger.error("Unexpected exception occurred when getting config for appKey:" + appKey, (Throwable)ex);
            return null;
        }
    }

    @Override
    public AppSdkConfig getDefaultConfig() {
        if (this.defaultAppKey == null) {
            return null;
        }
        return this.getConfig(this.defaultAppKey);
    }

    @Override
    public AppSdkConfig getConfigWithDefault(String appKey) {
        AppSdkConfig appSdkConfig = this.getConfig(appKey);
        return appSdkConfig == null ? (this.defaultAppKey == null ? null : this.getConfig(this.defaultAppKey)) : appSdkConfig;
    }

    protected List<SDKConfig> loadOnInit() {
        return null;
    }

    protected abstract SDKConfig loadSDKConfig(String var1);
}

