/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.config.provider;

import com.yeepay.g3.sdk.yop.config.SDKConfig;
import com.yeepay.g3.sdk.yop.config.provider.BaseFixedAppSdkConfigProvider;
import com.yeepay.g3.sdk.yop.config.support.ConfigUtils;
import com.yeepay.g3.sdk.yop.config.support.SDKConfigUtils;
import com.yeepay.g3.sdk.yop.exception.YopClientException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public final class DefaultFileAppSdkConfigProvider
extends BaseFixedAppSdkConfigProvider {
    private static final String SDK_CONFIG_FILE_PROPERTY_KEY = "yop.sdk.config.file";
    private static final String SDK_CONFIG_DIR_PROPERTY_KEY = "yop.sdk.config.dir";
    private static final String SDK_CONFIG_FILE_SEPARATOR = ",";
    private static final String SDK_CONFIG_DIR = "config";
    private static final Pattern SDK_CONFIG_FILE_NAME_PATTERN = Pattern.compile("^yop_sdk_config_(.+).json$");

    @Override
    protected List<SDKConfig> loadCustomSdkConfig() {
        List<String> files = this.loadSystemConfigSdkFiles();
        if (CollectionUtils.isEmpty(files)) {
            files = this.loadConfigFilesFromClassPath();
        }
        if (CollectionUtils.isEmpty(files)) {
            return Collections.emptyList();
        }
        this.checkFilePath(files);
        ArrayList<SDKConfig> customSdkConfigs = new ArrayList<SDKConfig>(files.size());
        for (String filePath : files) {
            String fileName = this.getFileName(filePath);
            Matcher matcher = SDK_CONFIG_FILE_NAME_PATTERN.matcher(fileName);
            if (matcher.matches()) {
                customSdkConfigs.add(SDKConfigUtils.loadConfig(filePath));
                continue;
            }
            this.logger.warn("Illegal SDkConfig File Name:" + fileName);
        }
        return customSdkConfigs;
    }

    private List<String> loadSystemConfigSdkFiles() {
        String configDir = System.getProperty(SDK_CONFIG_DIR_PROPERTY_KEY);
        String configFile = System.getProperty(SDK_CONFIG_FILE_PROPERTY_KEY);
        if (StringUtils.isEmpty((CharSequence)configDir) && StringUtils.isEmpty((CharSequence)configFile)) {
            return Collections.emptyList();
        }
        if (StringUtils.isEmpty((CharSequence)configFile)) {
            try {
                return ConfigUtils.listFiles(configDir);
            }
            catch (Exception ex) {
                this.logger.error("Unexpected exception occurred when loaded configFiles from dir:" + configDir, (Throwable)ex);
                throw new YopClientException("unable to load configFiles from dir:" + configDir, ex);
            }
        }
        String[] subFiles = StringUtils.split((String)configFile, (String)SDK_CONFIG_FILE_SEPARATOR);
        if (subFiles == null || subFiles.length == 0) {
            return Collections.emptyList();
        }
        if (StringUtils.isEmpty((CharSequence)configDir)) {
            return Arrays.asList(subFiles);
        }
        ArrayList<String> files = new ArrayList<String>(subFiles.length);
        for (String subFile : subFiles) {
            files.add(configDir + File.separator + subFile);
        }
        return files;
    }

    private List<String> loadConfigFilesFromClassPath() {
        try {
            return ConfigUtils.listFiles(SDK_CONFIG_DIR);
        }
        catch (Exception ex) {
            this.logger.warn("Unexpected exception occurred when loaded configFiles from dir:config", (Throwable)ex);
            return Collections.emptyList();
        }
    }

    private void checkFilePath(List<String> files) {
        for (String file : files) {
            if (StringUtils.isBlank((CharSequence)file)) {
                throw new YopClientException("sdkConfig filePath is blank");
            }
            if (file.charAt(0) != '/' && file.charAt(0) != '\\') continue;
            throw new YopClientException("sdkConfig filePath should not start with file separator.");
        }
    }

    private String getFileName(String filePath) {
        String fileName = StringUtils.substringAfterLast((String)filePath, (String)File.separator);
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            fileName = filePath;
        }
        return fileName;
    }
}

