/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.config.support;

import com.yeepay.g3.sdk.yop.YopServiceException;
import com.yeepay.g3.sdk.yop.config.SDKConfig;
import com.yeepay.g3.sdk.yop.config.support.ConfigUtils;
import com.yeepay.g3.sdk.yop.exception.YopClientException;
import com.yeepay.g3.sdk.yop.utils.JsonUtils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SDKConfigUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SDKConfigUtils.class);

    public static SDKConfig loadConfig(String configFile) {
        SDKConfig config;
        InputStream fis = null;
        try {
            fis = ConfigUtils.getInputStream(configFile);
            config = JsonUtils.loadFrom(fis, SDKConfig.class);
        }
        catch (Exception e) {
            throw new YopClientException("Errors occurred when loading SDKConfig.", e);
        }
        finally {
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (StringUtils.endsWith((CharSequence)config.getServerRoot(), (CharSequence)"/")) {
            config.setServerRoot(StringUtils.substring((String)config.getServerRoot(), (int)0, (int)-1));
        }
        if (StringUtils.endsWith((CharSequence)config.getYosServerRoot(), (CharSequence)"/")) {
            config.setYosServerRoot(StringUtils.substring((String)config.getYosServerRoot(), (int)0, (int)-1));
        }
        return config;
    }

    public static SDKConfig loadConfig(InputStream in) {
        SDKConfig config;
        InputStream fis = null;
        try {
            config = JsonUtils.loadFrom(in, SDKConfig.class);
        }
        catch (Exception ex) {
            throw new YopServiceException(ex, "Errors occurred when loading SDKConfig.");
        }
        finally {
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (StringUtils.endsWith((CharSequence)config.getServerRoot(), (CharSequence)"/")) {
            config.setServerRoot(StringUtils.substring((String)config.getServerRoot(), (int)0, (int)-1));
        }
        return config;
    }
}

