/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.unmarshaller;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeepAsRawStringDeserializer
extends JsonDeserializer<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeepAsRawStringDeserializer.class);

    public String deserialize(JsonParser jp, DeserializationContext context) throws IOException {
        if (jp.isExpectedStartObjectToken() || jp.isExpectedStartArrayToken()) {
            String rawJson = this.getStringFromSource(jp.getCurrentLocation().getSourceRef());
            int startLocation = (int)jp.getCurrentLocation().getCharOffset();
            jp.skipChildren();
            int endLocation = (int)jp.getCurrentLocation().getCharOffset();
            return rawJson.substring(startLocation - 1, endLocation);
        }
        if (jp.getCurrentToken() == JsonToken.VALUE_STRING) {
            return "\"" + jp.getText() + "\"";
        }
        return jp.getText();
    }

    private String getStringFromSource(Object sourceRef) {
        if (sourceRef instanceof String) {
            return (String)sourceRef;
        }
        if (sourceRef instanceof StringReader) {
            return this.getStringViaReflection((StringReader)sourceRef);
        }
        throw new IllegalArgumentException("source ref of json is not an instance of String/StringReader,can't use KeepAsRawStringDeserializer here!");
    }

    private String getStringViaReflection(StringReader reader) {
        try {
            Field strField = StringReader.class.getDeclaredField("str");
            strField.setAccessible(true);
            return (String)strField.get(reader);
        }
        catch (Exception e) {
            LOGGER.error("error when get str from StringReader via reflection", (Throwable)e);
            return null;
        }
    }
}

