/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.utils;

import com.yeepay.g3.sdk.yop.client.YopConstants;
import com.yeepay.g3.sdk.yop.config.SDKConfig;
import com.yeepay.g3.sdk.yop.encrypt.Base64;
import com.yeepay.g3.sdk.yop.exception.YopClientException;
import com.yeepay.g3.sdk.yop.exception.config.IllegalConfigFormtException;
import com.yeepay.g3.sdk.yop.exception.config.IllegalConfigLengthException;
import com.yeepay.g3.sdk.yop.exception.config.MissingConfigException;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CheckUtils {
    public static void checkCustomSDKConfig(SDKConfig sdkConfig) {
        byte[] decoded;
        if (StringUtils.isEmpty((CharSequence)sdkConfig.getAppKey())) {
            throw new MissingConfigException("appKey", "appKey is empty");
        }
        if (StringUtils.isNotEmpty((CharSequence)sdkConfig.getServerRoot())) {
            try {
                new URL(sdkConfig.getServerRoot());
            }
            catch (MalformedURLException e) {
                throw new IllegalConfigFormtException("serverRoot", "serverRoot is illegal");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)sdkConfig.getYosServerRoot())) {
            try {
                new URL(sdkConfig.getYosServerRoot());
            }
            catch (MalformedURLException e) {
                throw new IllegalConfigFormtException("yosServerRoot", "yosServerRoot is illegal");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)sdkConfig.getSandboxServerRoot())) {
            try {
                new URL(sdkConfig.getSandboxServerRoot());
            }
            catch (MalformedURLException e) {
                throw new IllegalConfigFormtException("sandboxServerRoot", "sandboxServerRoot is illegal");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)sdkConfig.getEncryptKey()) && (decoded = Base64.decode(sdkConfig.getEncryptKey().getBytes())).length != 16 && decoded.length != 32) {
            throw new IllegalConfigLengthException("encryptKey", "encryptKey is illegal");
        }
    }

    public static void checkApiUri(String apiUri) {
        if (StringUtils.isEmpty((CharSequence)apiUri)) {
            throw new YopClientException("apiUri is empty");
        }
        if (!StringUtils.startsWithAny((CharSequence)apiUri, (CharSequence[])YopConstants.API_URI_PREFIX)) {
            throw new YopClientException("apiUri is illegal");
        }
    }

    public static void notNull(Object obj, String message) {
        if (obj == null) {
            throw new IllegalArgumentException(message + " must be specified");
        }
    }

    public static void notEmpty(Object obj, String message) {
        if (obj == null) {
            throw new IllegalArgumentException(message + " must be specified");
        }
        if (obj instanceof String && obj.toString().trim().length() == 0) {
            throw new IllegalArgumentException(message + " must be specified");
        }
        if (obj.getClass().isArray() && Array.getLength(obj) == 0) {
            throw new IllegalArgumentException(message + " must be specified");
        }
        if (obj instanceof Collection && ((Collection)obj).isEmpty()) {
            throw new IllegalArgumentException(message + " must be specified");
        }
        if (obj instanceof Map && ((Map)obj).isEmpty()) {
            throw new IllegalArgumentException(message + " must be specified");
        }
    }
}

