/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.utils;

import com.google.common.base.Charsets;
import com.yeepay.g3.sdk.yop.encrypt.DigestAlgEnum;
import com.yeepay.g3.sdk.yop.encrypt.DigitalEnvelopeDTO;
import com.yeepay.g3.sdk.yop.encrypt.DigitalSignatureDTO;
import com.yeepay.g3.sdk.yop.encrypt.Encodes;
import com.yeepay.g3.sdk.yop.encrypt.RSA;
import com.yeepay.g3.sdk.yop.encrypt.SymmetricEncryptAlgEnum;
import com.yeepay.g3.sdk.yop.encrypt.SymmetricEncryption;
import com.yeepay.g3.sdk.yop.encrypt.SymmetricEncryptionFactory;
import com.yeepay.g3.sdk.yop.exception.VerifySignFailedException;
import com.yeepay.g3.sdk.yop.exception.YopClientException;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.commons.lang3.StringUtils;

public final class DigitalEnvelopeUtils {
    public static final String SEPERATOR = "$";

    public static DigitalEnvelopeDTO encrypt(DigitalEnvelopeDTO digitalEnvelopeDTO, PrivateKey privateKey, PublicKey publicKey) {
        String source = digitalEnvelopeDTO.getPlainText();
        byte[] data = source.getBytes(Charsets.UTF_8);
        SymmetricEncryptAlgEnum symmetricEncryptAlg = digitalEnvelopeDTO.getSymmetricEncryptAlg();
        SymmetricEncryption symmetricEncryption = SymmetricEncryptionFactory.getSymmetricEncryption(symmetricEncryptAlg);
        byte[] randomKey = symmetricEncryption.generateRandomKey();
        DigestAlgEnum digestAlg = digitalEnvelopeDTO.getDigestAlg();
        byte[] sign = RSA.sign(data, privateKey, digestAlg);
        String signToBase64 = Encodes.encodeUrlSafeBase64(sign);
        data = (source + SEPERATOR + signToBase64).getBytes(Charsets.UTF_8);
        byte[] encryptedData = symmetricEncryption.encrypt(data, randomKey);
        String encryptedDataToBase64 = Encodes.encodeUrlSafeBase64(encryptedData);
        byte[] encryptedRandomKey = RSA.encrypt(randomKey, publicKey);
        String encryptedRandomKeyToBase64 = Encodes.encodeUrlSafeBase64(encryptedRandomKey);
        String cipherText = encryptedRandomKeyToBase64 + SEPERATOR + encryptedDataToBase64 + SEPERATOR + symmetricEncryptAlg.getValue() + SEPERATOR + digestAlg.getValue();
        digitalEnvelopeDTO.setCipherText(cipherText);
        return digitalEnvelopeDTO;
    }

    public static DigitalEnvelopeDTO decrypt(DigitalEnvelopeDTO digitalEnvelopeDTO, PrivateKey privateKey, PublicKey publicKey) {
        String source = digitalEnvelopeDTO.getCipherText();
        String[] args = source.split("\\$");
        if (args.length != 4) {
            throw new YopClientException("source invalid : " + source);
        }
        String encryptedRandomKeyToBase64 = args[0];
        String encryptedDataToBase64 = args[1];
        SymmetricEncryptAlgEnum symmetricEncryptAlg = SymmetricEncryptAlgEnum.parse(args[2]);
        DigestAlgEnum digestAlg = DigestAlgEnum.parse(args[3]);
        digitalEnvelopeDTO.setSymmetricEncryptAlg(symmetricEncryptAlg);
        SymmetricEncryption symmetricEncryption = SymmetricEncryptionFactory.getSymmetricEncryption(symmetricEncryptAlg);
        digitalEnvelopeDTO.setDigestAlg(digestAlg);
        byte[] randomKey = RSA.decrypt(Encodes.decodeBase64(encryptedRandomKeyToBase64), privateKey);
        byte[] encryptedData = symmetricEncryption.decrypt(Encodes.decodeBase64(encryptedDataToBase64), randomKey);
        String data = new String(encryptedData, Charsets.UTF_8);
        String sourceData = StringUtils.substringBeforeLast((String)data, (String)SEPERATOR);
        String signToBase64 = StringUtils.substringAfterLast((String)data, (String)SEPERATOR);
        boolean verifySign = RSA.verifySign(sourceData, signToBase64, publicKey, digestAlg);
        if (!verifySign) {
            throw new VerifySignFailedException("verifySign fail!");
        }
        digitalEnvelopeDTO.setPlainText(sourceData);
        return digitalEnvelopeDTO;
    }

    public static DigitalSignatureDTO sign(DigitalSignatureDTO digitalSignatureDTO, PrivateKey privateKey) {
        digitalSignatureDTO.setSignature(DigitalEnvelopeUtils.sign0(digitalSignatureDTO, privateKey));
        return digitalSignatureDTO;
    }

    public static String sign0(DigitalSignatureDTO digitalSignatureDTO, PrivateKey privateKey) {
        String source = digitalSignatureDTO.getPlainText();
        byte[] data = source.getBytes(Charsets.UTF_8);
        DigestAlgEnum digestAlg = digitalSignatureDTO.getDigestAlg();
        byte[] sign = RSA.sign(data, privateKey, digestAlg);
        String signToBase64 = Encodes.encodeUrlSafeBase64(sign);
        return signToBase64 + SEPERATOR + digestAlg.getValue();
    }
}

