/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;

public class FileUtils {
    public static String getFileName(InputStream file) {
        String fileName = "";
        String fileExt = FileUtils.getFileExt(file);
        fileName = FileUtils.randomFileName(8, fileExt);
        return fileName;
    }

    public static String randomFileName(int len, String fileExt) {
        return System.currentTimeMillis() + "-yop-" + RandomStringUtils.randomAlphanumeric((int)len) + fileExt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getMimeType(File file) {
        String mimeType = "application/octet-stream";
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            mimeType = FileUtils.getMimeType(new FileInputStream(file));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != stream) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return mimeType;
    }

    private static String getMimeType(InputStream stream) {
        String mimeType = "application/octet-stream";
        AutoDetectParser parser = new AutoDetectParser();
        parser.setParsers(new HashMap());
        Metadata metadata = new Metadata();
        try {
            BodyContentHandler contenthandler = new BodyContentHandler();
            parser.parse(stream, (ContentHandler)contenthandler, metadata);
            mimeType = metadata.get("Content-Type");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mimeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileExt(File file) {
        String fileExt = ".bin";
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            fileExt = FileUtils.getFileExt(new FileInputStream(file));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != stream) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return fileExt;
    }

    public static String getFileExt(InputStream stream) {
        String fileExt = ".bin";
        try {
            String mimeType = FileUtils.getMimeType(stream);
            fileExt = TikaConfig.getDefaultConfig().getMimeRepository().getRegisteredMimeType(mimeType).getExtension();
        }
        catch (MimeTypeException e) {
            e.printStackTrace();
        }
        return fileExt;
    }
}

