/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.g3.sdk.yop.utils.checksum;

import com.google.common.primitives.UnsignedLong;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CheckedInputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRC64Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CRC64Utils.class);

    public static String getCRC64(List<CheckedInputStream> inputStreams) {
        ArrayList<String> crc64s = new ArrayList<String>(inputStreams.size());
        for (CheckedInputStream in : inputStreams) {
            crc64s.add(UnsignedLong.fromLongBits((long)in.getChecksum().getValue()).toString());
        }
        return StringUtils.join(crc64s, (String)"/");
    }

    public static String getCRC64(CheckedInputStream inputStream) {
        String crc64 = UnsignedLong.fromLongBits((long)inputStream.getChecksum().getValue()).toString();
        return crc64;
    }
}

