/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.log;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class LFLog
implements Logger {
    private Logger log;
    private LiteflowConfig liteflowConfig;

    public LFLog(Logger log) {
        this.log = log;
    }

    private String getRId() {
        String requestId = LFLoggerManager.getRequestId();
        if (StrUtil.isBlank((CharSequence)requestId)) {
            return "";
        }
        return StrUtil.format((CharSequence)"[{}]:", (Object[])new Object[]{LFLoggerManager.getRequestId()});
    }

    private boolean isPrint() {
        try {
            if (ObjectUtil.isNull((Object)this.liteflowConfig)) {
                this.liteflowConfig = LiteflowConfigGetter.get();
            }
            if (ObjectUtil.isNull((Object)this.liteflowConfig)) {
                return true;
            }
            return this.liteflowConfig.getPrintExecutionLog();
        }
        catch (Exception e) {
            return true;
        }
    }

    public String getName() {
        return this.log.getName();
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    public void trace(String s) {
        this.log.trace(this.getRId() + s);
    }

    public void trace(String s, Object o) {
        this.log.trace(this.getRId() + s, o);
    }

    public void trace(String s, Object o, Object o1) {
        this.log.trace(this.getRId() + s, o, o1);
    }

    public void trace(String s, Object ... objects) {
        this.log.trace(this.getRId() + s, objects);
    }

    public void trace(String s, Throwable throwable) {
        this.log.trace(this.getRId() + s, throwable);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.log.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String s) {
        this.log.trace(marker, this.getRId() + s);
    }

    public void trace(Marker marker, String s, Object o) {
        this.log.trace(marker, this.getRId() + s, o);
    }

    public void trace(Marker marker, String s, Object o, Object o1) {
        this.log.trace(marker, this.getRId() + s, o, o1);
    }

    public void trace(Marker marker, String s, Object ... objects) {
        this.log.trace(marker, this.getRId() + s, objects);
    }

    public void trace(Marker marker, String s, Throwable throwable) {
        this.log.trace(marker, this.getRId() + s, throwable);
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public void debug(String s) {
        this.log.debug(this.getRId() + s);
    }

    public void debug(String s, Object o) {
        this.log.debug(this.getRId() + s, o);
    }

    public void debug(String s, Object o, Object o1) {
        this.log.debug(this.getRId() + s, o, o1);
    }

    public void debug(String s, Object ... objects) {
        this.log.debug(this.getRId() + s, objects);
    }

    public void debug(String s, Throwable throwable) {
        this.log.debug(this.getRId() + s, throwable);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.log.isDebugEnabled(marker);
    }

    public void debug(Marker marker, String s) {
        this.log.debug(marker, this.getRId() + s);
    }

    public void debug(Marker marker, String s, Object o) {
        this.log.debug(marker, this.getRId() + s, o);
    }

    public void debug(Marker marker, String s, Object o, Object o1) {
        this.log.debug(marker, this.getRId() + s, o, o1);
    }

    public void debug(Marker marker, String s, Object ... objects) {
        this.log.debug(marker, this.getRId() + s, objects);
    }

    public void debug(Marker marker, String s, Throwable throwable) {
        this.log.debug(marker, this.getRId() + s, throwable);
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public void info(String s) {
        if (this.isPrint()) {
            this.log.info(this.getRId() + s);
        }
    }

    public void info(String s, Object o) {
        if (this.isPrint()) {
            this.log.info(this.getRId() + s, o);
        }
    }

    public void info(String s, Object o, Object o1) {
        if (this.isPrint()) {
            this.log.info(this.getRId() + s, o, o1);
        }
    }

    public void info(String s, Object ... objects) {
        if (this.isPrint()) {
            this.log.info(this.getRId() + s, objects);
        }
    }

    public void info(String s, Throwable throwable) {
        if (this.isPrint()) {
            this.log.info(this.getRId() + s, throwable);
        }
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.log.isInfoEnabled(marker);
    }

    public void info(Marker marker, String s) {
        if (this.isPrint()) {
            this.log.info(marker, this.getRId() + s);
        }
    }

    public void info(Marker marker, String s, Object o) {
        if (this.isPrint()) {
            this.log.info(marker, this.getRId() + s, o);
        }
    }

    public void info(Marker marker, String s, Object o, Object o1) {
        if (this.isPrint()) {
            this.log.info(marker, this.getRId() + s, o, o1);
        }
    }

    public void info(Marker marker, String s, Object ... objects) {
        if (this.isPrint()) {
            this.log.info(marker, this.getRId() + s, objects);
        }
    }

    public void info(Marker marker, String s, Throwable throwable) {
        if (this.isPrint()) {
            this.log.info(marker, this.getRId() + s, throwable);
        }
    }

    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    public void warn(String s) {
        if (this.isPrint()) {
            this.log.warn(this.getRId() + s);
        }
    }

    public void warn(String s, Object o) {
        if (this.isPrint()) {
            this.log.warn(this.getRId() + s, o);
        }
    }

    public void warn(String s, Object ... objects) {
        if (this.isPrint()) {
            this.log.warn(this.getRId() + s, objects);
        }
    }

    public void warn(String s, Object o, Object o1) {
        if (this.isPrint()) {
            this.log.warn(this.getRId() + s, o, o1);
        }
    }

    public void warn(String s, Throwable throwable) {
        if (this.isPrint()) {
            this.log.warn(this.getRId() + s, throwable);
        }
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.log.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String s) {
        if (this.isPrint()) {
            this.log.warn(marker, this.getRId() + s);
        }
    }

    public void warn(Marker marker, String s, Object o) {
        if (this.isPrint()) {
            this.log.warn(marker, this.getRId() + s, o);
        }
    }

    public void warn(Marker marker, String s, Object o, Object o1) {
        if (this.isPrint()) {
            this.log.warn(marker, this.getRId() + s, o, o1);
        }
    }

    public void warn(Marker marker, String s, Object ... objects) {
        if (this.isPrint()) {
            this.log.warn(marker, this.getRId() + s, objects);
        }
    }

    public void warn(Marker marker, String s, Throwable throwable) {
        if (this.isPrint()) {
            this.log.warn(marker, this.getRId() + s, throwable);
        }
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    public void error(String s) {
        if (this.isPrint()) {
            this.log.error(this.getRId() + s);
        }
    }

    public void error(String s, Object o) {
        if (this.isPrint()) {
            this.log.error(this.getRId() + s, o);
        }
    }

    public void error(String s, Object o, Object o1) {
        if (this.isPrint()) {
            this.log.error(this.getRId() + s, o, o1);
        }
    }

    public void error(String s, Object ... objects) {
        if (this.isPrint()) {
            this.log.error(this.getRId() + s, objects);
        }
    }

    public void error(String s, Throwable throwable) {
        if (this.isPrint()) {
            this.log.error(this.getRId() + s, throwable);
        }
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.log.isErrorEnabled(marker);
    }

    public void error(Marker marker, String s) {
        if (this.isPrint()) {
            this.log.error(marker, this.getRId() + s);
        }
    }

    public void error(Marker marker, String s, Object o) {
        if (this.isPrint()) {
            this.log.error(marker, this.getRId() + s, o);
        }
    }

    public void error(Marker marker, String s, Object o, Object o1) {
        if (this.isPrint()) {
            this.log.error(marker, this.getRId() + s, o, o1);
        }
    }

    public void error(Marker marker, String s, Object ... objects) {
        if (this.isPrint()) {
            this.log.error(marker, this.getRId() + s, objects);
        }
    }

    public void error(Marker marker, String s, Throwable throwable) {
        if (this.isPrint()) {
            this.log.error(marker, this.getRId() + s, throwable);
        }
    }
}

