/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.core;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.annotation.LiteflowRetry;
import com.yomahub.liteflow.annotation.util.AnnoUtil;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.flow.executor.NodeExecutor;
import com.yomahub.liteflow.monitor.MonitorBus;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import com.yomahub.liteflow.spi.holder.ContextAwareHolder;
import com.yomahub.liteflow.spi.holder.LiteflowComponentSupportHolder;

public class ComponentInitializer {
    private static ComponentInitializer instance;

    public static ComponentInitializer loadInstance() {
        if (ObjectUtil.isNull((Object)instance)) {
            instance = new ComponentInitializer();
        }
        return instance;
    }

    public NodeComponent initComponent(NodeComponent nodeComponent, NodeTypeEnum type, String name, String nodeId) {
        MonitorBus monitorBus;
        nodeComponent.setNodeId(nodeId);
        nodeComponent.setSelf(nodeComponent);
        nodeComponent.setType(type);
        if (ContextAwareHolder.loadContextAware().hasBean("monitorBus") && ObjectUtil.isNotNull((Object)(monitorBus = ContextAwareHolder.loadContextAware().getBean(MonitorBus.class)))) {
            nodeComponent.setMonitorBus(monitorBus);
        }
        nodeComponent.setName(name);
        if (!type.isScript() && StrUtil.isBlank((CharSequence)nodeComponent.getName())) {
            nodeComponent.setName(LiteflowComponentSupportHolder.loadLiteflowComponentSupport().getCmpName(nodeComponent));
        }
        LiteflowRetry liteFlowRetryAnnotation = AnnoUtil.getAnnotation(nodeComponent.getClass(), LiteflowRetry.class);
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        if (liteFlowRetryAnnotation != null) {
            nodeComponent.setRetryCount(liteFlowRetryAnnotation.retry());
            nodeComponent.setRetryForExceptions(liteFlowRetryAnnotation.forExceptions());
        } else {
            nodeComponent.setRetryCount(liteflowConfig.getRetryCount());
        }
        nodeComponent.setNodeExecutorClass(this.buildNodeExecutorClass(liteflowConfig));
        return nodeComponent;
    }

    private Class<? extends NodeExecutor> buildNodeExecutorClass(LiteflowConfig liteflowConfig) {
        Class<?> nodeExecutorClass;
        try {
            nodeExecutorClass = Class.forName(liteflowConfig.getNodeExecutorClass());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
        return nodeExecutorClass;
    }
}

