/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.comment.controller;

import com.qianjiang.comment.bean.Comment;
import com.qianjiang.comment.service.CommentReplayServiceMapper;
import com.qianjiang.comment.service.CommentServiceMapper;
import com.qianjiang.common.util.DateUtil;
import com.qianjiang.customer.bean.Customer;
import com.qianjiang.operlog.util.OperaLogBean;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.DateUtils;
import com.qianjiang.util.IPAddress;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller(value="commentController")
public class CommentController {
    private CommentServiceMapper commentServiceMapper;
    private CommentReplayServiceMapper commentReplayServiceMapper;
    private static final MyLogger LOGGER = new MyLogger(CommentController.class);

    @RequestMapping(value={"/initComment"})
    public ModelAndView initCommnet(HttpServletRequest req, PageBean pageBean, Comment comment) {
        ModelAndView mav = null;
        pageBean.setUrl("initComment.htm");
        try {
            PageBean pageBeans = this.commentServiceMapper.selectAllComment(pageBean, comment, Long.valueOf(0L));
            mav = new ModelAndView("jsp/customer/commentlist", "pagebean", (Object)pageBeans);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u521d\u59cb\u5316\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/initcommentthird"})
    public ModelAndView initCommnetThird(HttpServletRequest request, PageBean pageBean, String n, String l) {
        if (n != null && !"".equals(n)) {
            request.getSession().setAttribute("n", (Object)n);
        }
        if (l != null && !"".equals(l)) {
            request.getSession().setAttribute("l", (Object)l);
        }
        pageBean.setUrl("initcommentthird.html");
        Comment comment = new Comment();
        return new ModelAndView("goods/thirdcomment", "pagebean", (Object)this.commentServiceMapper.selectAllComment(pageBean, comment, (Long)request.getSession().getAttribute("thirdId"))).addObject("storeName", (Object)((String)request.getSession().getAttribute("storeName")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/querybycommentthird"})
    public ModelAndView queryByCommentThird(HttpServletRequest request, PageBean pageBean, @Valid Comment comment, String[] attr) throws UnsupportedEncodingException, ParseException {
        if (null != comment) {
            comment.setCustomerNickNameChina();
            comment.setGoodsNameChine();
        }
        String startpublishTime = request.getParameter("startpublishTime");
        String endlishTime = request.getParameter("endlishTime");
        String init = request.getParameter("init");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if ("init".equals(init)) {
            startpublishTime = DateUtils.getBeforeTodayAfter((SimpleDateFormat)format, (int)-1);
            endlishTime = DateUtils.getTodayDate((SimpleDateFormat)format);
        }
        if (!StringUtils.isEmpty((String)startpublishTime)) {
            comment.setPublishTime(format.parse(startpublishTime));
        }
        if (!StringUtils.isEmpty((String)endlishTime)) {
            comment.setPublishTimeTo(format.parse(endlishTime));
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            comment.setStartTime(startpublishTime);
            comment.setEndTime(endlishTime);
            resultMap.put("pagebean", this.commentServiceMapper.selectAllComment(pageBean, comment, (Long)request.getSession().getAttribute("thirdId")));
            resultMap.put("comment", comment);
            resultMap.put("attr", attr);
            pageBean.setUrl("queryByComment.htm");
            ModelAndView modelAndView = new ModelAndView("goods/thirdcomment").addAllObjects(resultMap).addObject("storeName", (Object)((String)request.getSession().getAttribute("storeName")));
            return modelAndView;
        }
        finally {
            resultMap = null;
        }
    }

    @RequestMapping(value={"updateComment"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public void updateComment(Long commentId, String isDisplay, HttpServletRequest request) {
        Comment comment = new Comment();
        try {
            comment.setCommentId(commentId);
            comment.setIsDisplay(isDisplay);
            this.commentServiceMapper.updateComment(comment);
        }
        catch (Exception e) {
            LOGGER.error("" + e);
        }
    }

    @RequestMapping(value={"/queryByComment"})
    public ModelAndView queryByComment(HttpServletRequest request, PageBean pageBean, @Valid Comment comment, String[] attr, String commentType) {
        ModelAndView mav = null;
        pageBean.setUrl("queryByComment.htm");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String startTime = "";
        String endTime = "";
        try {
            if (commentType != null && "3".equals(commentType)) {
                startTime = DateUtil.getPreDate((Date)new Date(), (String)DateUtil.DEFAULT_TIME_PATTERN, (int)-1);
                endTime = DateUtil.getSysCurrentDate((String)DateUtil.DEFAULT_TIME_PATTERN);
                comment.setPublishTime(DateUtil.stringtoDate((String)startTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
                comment.setPublishTimeTo(DateUtil.stringtoDate((String)endTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            } else {
                startTime = comment.getStartTime();
                endTime = comment.getEndTime();
                if (startTime == null || "".equals(startTime)) {
                    comment.setPublishTime(null);
                } else {
                    comment.setPublishTime(DateUtil.stringtoDate((String)startTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
                }
                if (endTime == null || "".equals(endTime)) {
                    comment.setPublishTimeTo(null);
                } else {
                    comment.setPublishTimeTo(DateUtil.stringtoDate((String)endTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
                }
            }
            resultMap.put("pagebean", this.commentServiceMapper.selectAllComment(pageBean, comment, Long.valueOf(0L)));
            resultMap.put("comment", comment);
            resultMap.put("attr", attr);
            mav = new ModelAndView("jsp/customer/commentlist");
            mav.addAllObjects(resultMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/queryByCommentId"})
    public ModelAndView queryByCommentId(HttpServletRequest request, String publishtime, String publishtimeTo, Long commentId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            resultMap.put("comment", this.commentServiceMapper.selectByCommentId(commentId));
            resultMap.put("replist", this.commentReplayServiceMapper.selectByCommentId(commentId));
            ModelAndView modelAndView = new ModelAndView("jsp/customer/commentdetail").addAllObjects(resultMap);
            return modelAndView;
        }
        finally {
            resultMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/queryByCommentIdAjax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> queryByCommentIdAjax(HttpServletRequest request, Long commentId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            resultMap.put("comment", this.commentServiceMapper.selectByCommentId(commentId));
            resultMap.put("replist", this.commentReplayServiceMapper.selectByCommentId(commentId));
            HashMap<String, Object> hashMap = resultMap;
            return hashMap;
        }
        finally {
            resultMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/deleteComment"})
    public ModelAndView deleteComment(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pr = null;
        try {
            pr = response.getWriter();
            String[] commentIds = request.getParameterValues("parameterIds");
            int num = this.commentServiceMapper.deleteComment(commentIds);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6279\u91cf\u5220\u9664\u8bc4\u8bba", (String)((String)request.getSession().getAttribute("operaPath") + "\u6279\u91cf\u5220\u9664\u8bc4\u8bba,\u7528\u6237\u540d\uff1a" + (String)request.getSession().getAttribute("name")));
            pr.print(num);
        }
        finally {
            if (pr != null) {
                pr = null;
            }
        }
        return null;
    }

    @RequestMapping(value={"/updatecomment"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int updateComment(HttpServletRequest request, @Valid Comment comment) {
        return this.commentServiceMapper.updateComment(comment);
    }

    @RequestMapping(value={"/initConsult"})
    public ModelAndView initConsult(HttpServletRequest request, PageBean pageBean, Comment comment) {
        ModelAndView mav = null;
        pageBean.setUrl("initConsult.htm");
        try {
            PageBean pageBeans = this.commentServiceMapper.selectAllConsult(pageBean, comment, Long.valueOf(0L));
            mav = new ModelAndView("jsp/customer/consultlist", "pagebean", (Object)pageBeans);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u521d\u59cb\u5316\u54a8\u8be2\u5217\u8868\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/initconsultthird"})
    public ModelAndView initConsult(HttpServletRequest request, PageBean pageBean, String n, String l) {
        if (n != null && !"".equals(n)) {
            request.getSession().setAttribute("n", (Object)n);
        }
        if (l != null && !"".equals(l)) {
            request.getSession().setAttribute("l", (Object)l);
        }
        pageBean.setUrl("initconsultthird.html");
        return new ModelAndView("goods/thirdconsult", "pagebean", (Object)this.commentServiceMapper.selectAllConsult(pageBean, null, (Long)request.getSession().getAttribute("thirdId")));
    }

    @RequestMapping(value={"/queryByConsult"})
    public ModelAndView queryByConsult(HttpServletRequest request, PageBean pageBean, @Valid Comment comment, String[] attr, String commentType) {
        ModelAndView mav = null;
        pageBean.setUrl("queryByConsult.htm");
        Long thirdId = 0L;
        String startTime = comment.getStartTime();
        String endTime = comment.getEndTime();
        try {
            if (startTime == null || "".equals(startTime)) {
                comment.setPublishTime(null);
            } else {
                comment.setPublishTime(DateUtil.stringtoDate((String)startTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            }
            if (endTime == null || "".equals(endTime)) {
                comment.setPublishTimeTo(null);
            } else {
                comment.setPublishTimeTo(DateUtil.stringtoDate((String)endTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            }
            if (commentType != null && "1".equals(commentType)) {
                comment.setIsDisplay("1");
            }
            PageBean pageBeans = this.commentServiceMapper.selectAllConsult(pageBean, comment, thirdId);
            mav = new ModelAndView("jsp/customer/consultlist", "pagebean", (Object)pageBeans);
            mav.addObject("comment", (Object)comment);
            mav.addObject("attr", (Object)attr);
        }
        catch (Exception pe) {
            pe.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u5931\u8d25" + pe.getMessage(), (Throwable)pe);
        }
        return mav;
    }

    @RequestMapping(value={"/querybyconsultthird"})
    public ModelAndView queryByConsultThird(HttpServletRequest request, PageBean pageBean, @Valid Comment comment, String[] attr) throws UnsupportedEncodingException, ParseException {
        if (null != comment) {
            comment.setCustomerNickNameChina();
            comment.setGoodsNameChine();
        }
        pageBean.setUrl("querybyconsultthird.html");
        return new ModelAndView("goods/thirdconsult", "pagebean", (Object)this.commentServiceMapper.selectAllConsult(pageBean, comment, (Long)request.getSession().getAttribute("thirdId"))).addObject("comment", (Object)comment).addObject("attr", (Object)attr);
    }

    public void check(Comment comment) {
        int ch = 44;
        if (comment.getCustomerNickname() != null) {
            int indexu = comment.getCustomerNickname().indexOf(ch);
            comment.setCustomerNickname(comment.getCustomerNickname().substring(0, indexu == -1 ? comment.getCustomerNickname().length() : indexu));
        }
        if (comment.getGoodsName() != null) {
            int indexr = comment.getGoodsName().indexOf(ch);
            comment.setGoodsName(comment.getGoodsName().substring(0, indexr == -1 ? comment.getGoodsName().length() : indexr));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"exportComment"})
    public void exporComment(HttpServletResponse response) {
        Object ouputStream2;
        HSSFRow tempRow;
        LOGGER.info((Object)"\u5bfc\u51fa\u8bc4\u8bba");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Comment comment = null;
        List comments = this.commentServiceMapper.exportComment();
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment((short)2);
        HSSFSheet sheet1 = wb.createSheet("\u5546\u54c1\u8bc4\u8bba\u5217\u8868");
        sheet1.createFreezePane(255, 1);
        HSSFRow headRow = sheet1.createRow(0);
        headRow.createCell(0).setCellValue("\u5e8f\u53f7");
        headRow.createCell(1).setCellValue("\u5546\u54c1\u540d\u79f0");
        headRow.createCell(2).setCellValue("\u53d1\u8868\u4eba\uff08\u6635\u79f0\uff09");
        headRow.createCell(3).setCellValue("\u5185\u5bb9");
        headRow.createCell(4).setCellValue("\u53d1\u8868\u65f6\u95f4");
        if (null != comments && !comments.isEmpty()) {
            for (int i = 0; i < comments.size(); ++i) {
                comment = (Comment)comments.get(i);
                tempRow = sheet1.createRow(1 + i);
                tempRow.createCell(0).setCellValue((double)(i + 1));
                tempRow.createCell(1).setCellValue(comment.getGoodsName());
                tempRow.createCell(2).setCellValue(comment.getCustomerNickname());
                tempRow.createCell(3).setCellValue(comment.getCommentContent());
                tempRow.createCell(4).setCellValue(sdf.format(comment.getPublishTime()));
            }
        }
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode("\u5546\u54c1\u8bc4\u8bba\u5907\u4efd.xls"));
        try {
            ServletOutputStream ouputStream2 = response.getOutputStream();
            wb.write((OutputStream)ouputStream2);
            ouputStream2.flush();
            ouputStream2.close();
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
            ouputStream2 = null;
        }
        finally {
            comment = null;
            wb = null;
            ouputStream2 = null;
            style = null;
            tempRow = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"exportCommentTemp"})
    public void exportCommentTemp(HttpServletResponse response) {
        Object ouputStream2;
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment((short)2);
        HSSFSheet sheet1 = wb.createSheet("\u5206\u7c7b\u5bfc\u5165\u6a21\u677f");
        sheet1.createFreezePane(255, 1);
        HSSFRow headRow = sheet1.createRow(0);
        headRow.createCell(0).setCellValue("\u5546\u54c1\u7f16\u53f7");
        headRow.createCell(1).setCellValue("\u8bc4\u8bba\u5185\u5bb9");
        headRow.createCell(2).setCellValue("\u662f\u5426\u663e\u793a\uff080\u54261\u662f\uff09");
        headRow.createCell(3).setCellValue("\u8bc4\u5206");
        headRow.createCell(4).setCellValue("\u662f\u5426\u533f\u540d\uff080\u54261\u662f\uff09");
        headRow.createCell(5).setCellValue("\u7528\u6237\u8d26\u53f7");
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode("\u5546\u54c1\u8bc4\u8bba\u6a21\u677f.xls"));
        try {
            ServletOutputStream ouputStream2 = response.getOutputStream();
            wb.write((OutputStream)ouputStream2);
            ouputStream2.flush();
            ouputStream2.close();
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
            ouputStream2 = null;
        }
        finally {
            wb = null;
            ouputStream2 = null;
            style = null;
        }
    }

    @RequestMapping(value={"/importComment"})
    public void importComment(HttpServletRequest request, HttpServletResponse response, Long goodsCateId, MultipartHttpServletRequest multiRequest) {
        String result = "200";
        Customer cust = (Customer)request.getSession().getAttribute("cust");
        String name = (String)request.getSession().getAttribute("name");
        String ip = IPAddress.getIpAddr((HttpServletRequest)request);
        long loginUserId = (Long)request.getSession().getAttribute("loginUserId");
        try {
            MultipartFile file = multiRequest.getFile("importExcel");
            if (file.isEmpty()) {
                result = "401";
            } else if (!".xls".equals(file.getOriginalFilename().substring(file.getOriginalFilename().indexOf("."), file.getOriginalFilename().length()))) {
                result = "402";
            }
            result = this.commentServiceMapper.importCommentByExcel(cust, name, ip, loginUserId, file.getBytes());
            PrintWriter out = response.getWriter();
            out.append("<script>parent.import_callback('" + result + "');</script>");
            out.flush();
            LOGGER.info((Object)"\u5bfc\u5165\u5546\u54c1\u8bc4\u8bba");
        }
        catch (Exception e) {
            OperaLogBean operaLogBean = new OperaLogBean(e, cust.getCustomerUsername());
            operaLogBean.setName(name);
            operaLogBean.setIp(ip);
            operaLogBean.setLoginUserId(Long.valueOf(loginUserId));
            OperaLogUtil.addOperaException((OperaLogBean)operaLogBean);
        }
    }

    public CommentReplayServiceMapper getCommentReplayServiceMapper() {
        return this.commentReplayServiceMapper;
    }

    @Resource(name="commentReplayServiceMapper")
    public void setCommentReplayServiceMapper(CommentReplayServiceMapper commentReplayServiceMapper) {
        this.commentReplayServiceMapper = commentReplayServiceMapper;
    }

    public CommentServiceMapper getCommentServiceMapper() {
        return this.commentServiceMapper;
    }

    @Resource(name="commentServiceMapper")
    public void setCommentServiceMapper(CommentServiceMapper commentServiceMapper) {
        this.commentServiceMapper = commentServiceMapper;
    }
}

