/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.gift.controller;

import com.qianjiang.gift.bean.Gift;
import com.qianjiang.gift.bean.GiftPic;
import com.qianjiang.gift.service.GiftCateService;
import com.qianjiang.gift.service.GiftPicService;
import com.qianjiang.gift.service.GiftService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UploadUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class GiftController {
    private static final MyLogger LOGGER = new MyLogger(GiftController.class);
    private static final String LOGGERINFO1 = "-->\u8d60\u54c1\u540d\u79f0\u3010";
    private static final String LOGGERINFO2 = "\u3011,\u7528\u6237\u540d\uff1a";
    private GiftService giftService;
    private GiftCateService giftCateService;
    private GiftPicService giftPicService;

    @RequestMapping(value={"/searchgiftlist"})
    public ModelAndView searchGiftList(PageBean pageBean, Gift gift) {
        pageBean.setUrl("searchgiftlist.htm");
        return new ModelAndView("jsp/gift/giftlist", "pageBean", (Object)this.giftService.searchGiftList(gift, pageBean));
    }

    @RequestMapping(value={"/querygiftlistall"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public PageBean queryGiftListAll(HttpServletRequest request, PageBean pageBean, Gift gift) {
        String name = gift.getGiftName();
        if (name != null && !"".equals(name)) {
            try {
                name = URLDecoder.decode(name, "utf-8");
                gift.setGiftName(name);
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("", (Throwable)e);
                name = null;
            }
        }
        return this.giftService.searchGiftList(gift, pageBean);
    }

    @RequestMapping(value={"/toaddgift"})
    public ModelAndView toAddGift(Gift gift) {
        return new ModelAndView("jsp/gift/addgift");
    }

    @RequestMapping(value={"/doaddgift"})
    public ModelAndView doAddgift(HttpServletRequest request, Gift gift) {
        if (1 == this.giftService.doAddGift(gift) && null != gift.getGiftName()) {
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6dfb\u52a0\u8d60\u54c1", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + gift.getGiftName() + LOGGERINFO2 + (String)request.getSession().getAttribute("name")));
            LOGGER.info((Object)("\u6dfb\u52a0\u8d60\u54c1\u3010" + gift.getGiftName() + "\u3011\u6210\u529f\uff01"));
        }
        return new ModelAndView((View)new RedirectView("searchgiftlist.htm"));
    }

    @RequestMapping(value={"/toupdategift"})
    public ModelAndView toUpdateGift(Long giftId) {
        Gift gift = this.giftService.selectGiftDetailById(giftId);
        return new ModelAndView("jsp/gift/updategift").addObject("giftPic", (Object)gift);
    }

    @RequestMapping(value={"/ajaxupdategift"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Gift ajaxupdategift(Long giftId) {
        return this.giftService.selectGiftDetailById(giftId);
    }

    @RequestMapping(value={"/doupdategift"})
    public ModelAndView doUpdateGift(HttpServletRequest request, Gift gift) {
        if (1 == this.giftService.doUpdateGift(gift) && null != gift.getGiftName()) {
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u4fee\u6539\u8d60\u54c1", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + gift.getGiftName() + LOGGERINFO2 + (String)request.getSession().getAttribute("name")));
            LOGGER.info((Object)("\u4fee\u6539\u8d60\u54c1\u3010" + gift.getGiftName() + "\u3011\u6210\u529f\uff01"));
        }
        return new ModelAndView((View)new RedirectView("searchgiftlist.htm"));
    }

    @RequestMapping(value={"/delgift"})
    public ModelAndView delGift(HttpServletRequest request, Long giftId) {
        Gift gift;
        if (1 == this.giftService.delGift(giftId) && null != (gift = this.giftService.selectGiftDetailById(giftId)).getGiftName()) {
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u5220\u9664\u8d60\u54c1", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + gift.getGiftName() + LOGGERINFO2 + (String)request.getSession().getAttribute("name")));
            LOGGER.info((Object)("\u5220\u9664\u8d60\u54c1\u3010" + gift.getGiftName() + "\u3011\u6210\u529f\uff01"));
        }
        return new ModelAndView((View)new RedirectView("searchgiftlist.htm"));
    }

    @RequestMapping(value={"/delallgift"})
    public ModelAndView delAllGift(HttpServletRequest request, Long[] giftId) {
        this.giftService.delAllGift(giftId);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6279\u91cf\u5220\u9664\u8d60\u54c1", (String)((String)request.getSession().getAttribute("operaPath") + ",\u7528\u6237\u540d\uff1a" + (String)request.getSession().getAttribute("name")));
        return new ModelAndView((View)new RedirectView("searchgiftlist.htm"));
    }

    @RequestMapping(value={"/selectgiftpicbyId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<GiftPic> selectGiftPicById(Long giftId) {
        Gift gift = this.giftService.selectGiftDetailById(giftId);
        if (null != gift.getGiftCateName()) {
            LOGGER.info((Object)("\u67e5\u8be2\u8d60\u54c1\u3010" + gift.getGiftCateName() + "\u3011\u4e0b\u9762\u6240\u5305\u542b\u7684\u56fe\u7247\uff01"));
        }
        return this.giftPicService.selectGiftPicByGiftId(giftId);
    }

    @RequestMapping(value={"/deletepicbypicid"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int deletePicByPicId(Long picId) {
        return this.giftPicService.delGiftPicByPicId(picId);
    }

    @RequestMapping(value={"/batchSaveGiftImage"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public GiftPic batchSaveGiftImage(Long giftIds, HttpServletRequest request, MultipartHttpServletRequest request2, Long flag, String[] url) {
        List fileList = request2.getFiles("filedata");
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6279\u91cf\u6dfb\u52a0\u8d60\u54c1", (String)((String)request.getSession().getAttribute("operaPath") + ",\u7528\u6237\u540d\uff1a" + (String)request.getSession().getAttribute("name")));
        ArrayList<Map> picList = null;
        if (null != fileList && !fileList.isEmpty()) {
            picList = new ArrayList<Map>();
            for (int i = 0; i < fileList.size(); ++i) {
                if (((MultipartFile)fileList.get(i)).isEmpty()) continue;
                Map resultMap = UploadUtil.uploadFile((MultipartFile)((MultipartFile)fileList.get(i)));
                picList.add(resultMap);
            }
        }
        return this.giftPicService.uploadImage(giftIds, (String)request.getSession().getAttribute(""), picList);
    }

    @RequestMapping(value={"/newbatchSaveGiftImage"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Boolean batchSaveGiftImage(Long giftIds, String[] url) {
        return this.giftPicService.newuploadImage(giftIds, url);
    }

    public GiftService getGiftService() {
        return this.giftService;
    }

    @Resource(name="GiftService")
    public void setGiftService(GiftService giftService) {
        this.giftService = giftService;
    }

    public GiftCateService getGiftCateService() {
        return this.giftCateService;
    }

    @Resource(name="GiftCateService")
    public void setGiftCateService(GiftCateService giftCateService) {
        this.giftCateService = giftCateService;
    }

    public GiftPicService getGiftPicService() {
        return this.giftPicService;
    }

    @Resource(name="GiftPicService")
    public void setGiftPicService(GiftPicService giftPicService) {
        this.giftPicService = giftPicService;
    }
}

