/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.gift.controller;

import com.qianjiang.gift.bean.GiftOrder;
import com.qianjiang.gift.service.GiftOrderService;
import com.qianjiang.gift.vo.GiftOrderVo;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.service.ILogisticsCompanyBiz;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class GiftOrderController {
    private static final MyLogger LOGGER = new MyLogger(GiftOrderController.class);
    private GiftOrderService orderService;
    @Resource(name="logisticsCompanyBizImpl")
    private ILogisticsCompanyBiz iLogisticsCompanyBiz;

    @RequestMapping(value={"/giftorderlist"})
    public ModelAndView giftOrderList(PageBean pageBean, GiftOrderVo orderVo, HttpServletRequest request) {
        pageBean.setUrl("giftorderlist.htm");
        return new ModelAndView("jsp/gift/giftorderlist").addObject("pageBean", (Object)this.orderService.queryGiftOrder(orderVo, pageBean)).addObject("order", (Object)orderVo).addObject("expressList", (Object)this.iLogisticsCompanyBiz.queryAllLogisticsCompany());
    }

    @RequestMapping(value={"/ajaxSelectGiftDetail"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public GiftOrderVo ajaxSelectGiftDetail(Long giftOrderId) {
        return this.orderService.orderDetail(giftOrderId);
    }

    @RequestMapping(value={"/updategiftorder"})
    public ModelAndView updateGiftOrder(HttpServletRequest request, GiftOrder order, String url) {
        order.setGiftOrderStatus("1");
        if (1 == this.orderService.updateOrderVice(order) && null != order.getGiftOrderCode()) {
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u4fee\u6539\u8ba2\u5355\u4fe1\u606f", (String)((String)request.getSession().getAttribute("operaPath") + "-->\u8ba2\u5355\u53f7\u3010" + order.getGiftOrderCode() + "\u3011,\u7528\u6237\u540d\uff1a" + (String)request.getSession().getAttribute("name")));
            LOGGER.info((Object)("\u4fee\u6539\u5355\u53f7\u4e3a\uff1a" + order.getGiftOrderCode() + "\u79ef\u5206\u5151\u6362\u8d60\u54c1\u7684\u8ba2\u5355\u4fe1\u606f"));
        }
        return new ModelAndView((View)new RedirectView(url));
    }

    @RequestMapping(value={"/selectgiftdetails"})
    public ModelAndView selectGiftDetails(Long giftOrderId) {
        GiftOrderVo giftOrderVo = this.orderService.orderDetail(giftOrderId);
        if (null != giftOrderVo.getGiftName()) {
            LOGGER.info((Object)("\u67e5\u8be2\u5355\u53f7\u4e3a\uff1a" + giftOrderVo.getGiftName() + "\u79ef\u5206\u5151\u6362\u8d60\u54c1\u8ba2\u5355\u8be6\u60c5"));
        }
        return new ModelAndView("jsp/gift/giftorderdetail").addObject("order", (Object)giftOrderVo);
    }

    @Resource(name="GiftOrderWebService")
    public void setOrderService(GiftOrderService orderService) {
        this.orderService = orderService;
    }
}

