/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.promotion.controller;

import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.promotion.bean.PromotionLogo;
import com.qianjiang.promotion.service.PromotionLogoService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UploadUtil;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class PromotionLogoController {
    private static final MyLogger LOGGER = new MyLogger(PromotionLogoController.class);
    private static final String LOGOIMAGE = "logoImage";
    private static final String PICFILE = "picFile";
    private static final String OLDIMG = "oldimg";
    @Resource(name="PromotionLogoService")
    private PromotionLogoService promotionLogoService;

    @RequestMapping(value={"/findalllogo"})
    public ModelAndView findAllLogo(PageBean pb, PromotionLogo promotionLogo) {
        LOGGER.info((Object)"\u5206\u9875\u67e5\u8be2\u4fc3\u9500LOGO");
        return new ModelAndView("jsp/marketing/promotionlogolist", "pb", (Object)this.promotionLogoService.queryAllPromotionLogo(pb, promotionLogo));
    }

    @RequestMapping(value={"/addlogo"})
    public ModelAndView addLogo(@Valid PromotionLogo logo, HttpServletRequest request, MultipartHttpServletRequest request2) {
        MultipartFile imageFile = request2.getFile(LOGOIMAGE);
        if (imageFile == null) {
            imageFile = request2.getFile(PICFILE);
        }
        if (!imageFile.isEmpty()) {
            logo.setPromotionLogoUrl((String)UploadUtil.uploadFile((MultipartFile)imageFile).get(OLDIMG));
        }
        this.promotionLogoService.addPromotionLogo(logo);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6dfb\u52a0\u4fc3\u9500LOGO", (String)((String)request.getSession().getAttribute("operaPath") + "-->LOGO\u540d\u79f0\u3010" + logo.getPromotionLogoName() + "\u3011,\u7528\u6237\u540d\uff1a" + (String)request.getSession().getAttribute("name")));
        return new ModelAndView((View)new RedirectView("findalllogo.htm"));
    }

    @RequestMapping(value={"/checklogoname"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean checkLogoName(String promotionLogoName) {
        if (promotionLogoName != null && !"".equals(promotionLogoName)) {
            LOGGER.info((Object)("\u9a8c\u8bc1\u4fc3\u9500LOGO\u540d\u79f0\u662f\u5426\u53ef\u7528\u4fc3\u9500logo\u540d\u79f0" + promotionLogoName));
        } else {
            LOGGER.info((Object)"\u9a8c\u8bc1\u4fc3\u9500LOGO\u540d\u79f0\u662f\u5426\u53ef\u7528");
        }
        return this.promotionLogoService.checkLogoName(promotionLogoName);
    }

    @RequestMapping(value={"/dellogo"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int delLogo(HttpServletRequest request, Long[] promotionLogoId) {
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6279\u91cf\u5220\u9664\u5e97\u94fa", (String)((String)request.getSession().getAttribute("operaPath") + "\u6279\u91cf\u5220\u9664\u5e97\u94fa,\u7528\u6237\u540d\uff1a" + (String)request.getSession().getAttribute("name")));
        return this.promotionLogoService.delAllPromotionLogo(promotionLogoId);
    }

    @RequestMapping(value={"/updatelogo"})
    public ModelAndView updateLogo(@Valid PromotionLogo logo, int pageNo, HttpServletRequest request, MultipartHttpServletRequest request2) {
        PromotionLogo promotionLogo = this.promotionLogoService.selectByLogoId(logo.getPromotionLogoId());
        MultipartFile imageFile = request2.getFile(LOGOIMAGE);
        if (imageFile == null) {
            imageFile = request2.getFile(PICFILE);
        }
        if (!imageFile.isEmpty()) {
            logo.setPromotionLogoUrl((String)UploadUtil.uploadFile((MultipartFile)imageFile).get(OLDIMG));
        }
        this.promotionLogoService.updatePromotionLogo(logo);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u66f4\u65b0\u5546\u54c1\u6807\u7b7e", (String)((String)request.getSession().getAttribute("operaPath") + "-->logo\u540d\u79f0\u3010" + promotionLogo.getPromotionLogoName() + "\u3011,\u7528\u6237\u540d\uff1a" + (String)request.getSession().getAttribute("name")));
        return new ModelAndView((View)new RedirectView("findalllogo.htm?pageNo=" + pageNo));
    }

    @RequestMapping(value={"/addthirdlogo"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public PromotionLogo addThirdLogo(@Valid PromotionLogo logo, HttpServletRequest request, MultipartHttpServletRequest multipartRequest) {
        int i;
        PromotionLogo promotionLogo = null;
        MultipartFile imageFile = multipartRequest.getFile(LOGOIMAGE);
        if (imageFile == null) {
            imageFile = multipartRequest.getFile(PICFILE);
        }
        if (!imageFile.isEmpty()) {
            logo.setPromotionLogoUrl((String)UploadUtil.uploadFile((MultipartFile)imageFile).get(OLDIMG));
        }
        if ((i = this.promotionLogoService.addPromotionLogo(logo)) > 0) {
            Long promotionLogoId = logo.getPromotionLogoId();
            promotionLogo = this.promotionLogoService.selectByPrimaryKey(promotionLogoId);
        }
        return promotionLogo;
    }
}

