/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.promotion.controller;

import com.qianjiang.common.util.DateUtil;
import com.qianjiang.coupon.service.CouponService;
import com.qianjiang.customer.service.PointLevelServiceMapper;
import com.qianjiang.goods.bean.Goods;
import com.qianjiang.goods.bean.GoodsProduct;
import com.qianjiang.goods.service.GoodsBrandService;
import com.qianjiang.goods.service.GoodsCateService;
import com.qianjiang.goods.service.GoodsGroupService;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.service.GoodsService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.promotion.bean.Codex;
import com.qianjiang.promotion.bean.Promotion;
import com.qianjiang.promotion.bean.PromotionCodex;
import com.qianjiang.promotion.bean.PromotionGroup;
import com.qianjiang.promotion.bean.PromotionLogger;
import com.qianjiang.promotion.bean.PromotionScope;
import com.qianjiang.promotion.service.CodexService;
import com.qianjiang.promotion.service.PromotionLoggerService;
import com.qianjiang.promotion.service.PromotionLogoService;
import com.qianjiang.promotion.service.PromotionService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class PromotionController {
    private static final MyLogger LOGGER = new MyLogger(PromotionController.class);
    private static final String PAGEBEAN = "pageBean";
    private static final String MARKETING = "marketing";
    private static final String BRANDLIST = "brandlist";
    private static final String CODEXLIST = "codexlist";
    private static final String THIRDCATELIST = "thirdCateList";
    private static final String CODEXTYPE = "codexType";
    private static final String QUERYPRELIST_HTM = "queryprelist.htm";
    @Resource(name="CodexService")
    private CodexService codexService;
    @Resource(name="MarketingService")
    private PromotionService marketingService;
    @Resource(name="GoodsBrandService")
    private GoodsBrandService goodsBrandService;
    @Resource(name="GoodsCateService")
    private GoodsCateService goodsCateService;
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;
    @Resource(name="GoodsService")
    private GoodsService goodsService;
    @Resource(name="pointLevelServiceMapper")
    private PointLevelServiceMapper pointLevelServiceMapper;
    @Resource(name="CouponService")
    private CouponService couponService;
    @Resource(name="PromotionLogoService")
    private PromotionLogoService logoService;
    @Autowired
    private GoodsGroupService goodsGroupService;
    @Resource(name="promotionLoggerService")
    private PromotionLoggerService promotionLoggerService;

    @RequestMapping(value={"/marketorderlist"})
    public ModelAndView marketOrderList(PageBean pageBean, Promotion marketing, String marketingBeginTime, String marketingEndTime, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        pageBean.setUrl("marketorderlist.htm");
        try {
            marketing.setMarketingType("1");
            marketing.setBusinessId(Long.valueOf(0L));
            PageBean marketOrderList = this.marketingService.marketOrderList(pageBean, marketing, marketingBeginTime, marketingEndTime);
            mav.addObject(PAGEBEAN, (Object)marketOrderList);
            mav.setViewName("jsp/marketing/marketorderlist");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u521d\u59cb\u5316\u8ba2\u5355\u4fc3\u9500\u5217\u8868\u5931\u8d25");
        }
        return mav;
    }

    @RequestMapping(value={"/marketgoodslist"})
    public ModelAndView marketGoodsList(PageBean pageBean, Promotion marketing, String marketingBeginTime, String marketingEndTime, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        pageBean.setUrl("marketogoodslist.htm");
        String pageId = request.getParameter("pageId");
        try {
            if (pageId != null) {
                marketing.setMarketingType("0");
                marketing.setBusinessId(Long.valueOf(0L));
                if (Integer.parseInt(pageId) == 5601) {
                    marketing.setCodexId(Long.valueOf(1L));
                    PageBean marketOrderList = this.marketingService.marketOrderList(pageBean, marketing, marketingBeginTime, marketingEndTime);
                    mav.addObject(PAGEBEAN, (Object)marketOrderList);
                    mav.addObject("pageId", (Object)pageId);
                    mav.setViewName("jsp/marketing/marketgoodslist");
                    return mav;
                }
                if (Integer.parseInt(pageId) == 5602) {
                    marketing.setCodexId(Long.valueOf(5L));
                    PageBean marketOrderList = this.marketingService.marketOrderList(pageBean, marketing, marketingBeginTime, marketingEndTime);
                    mav.addObject(PAGEBEAN, (Object)marketOrderList);
                    mav.addObject("pageId", (Object)pageId);
                    mav.setViewName("jsp/marketing/marketgoodslist");
                    return mav;
                }
                if (Integer.parseInt(pageId) == 5603) {
                    marketing.setCodexId(Long.valueOf(6L));
                    PageBean marketOrderList = this.marketingService.marketOrderList(pageBean, marketing, marketingBeginTime, marketingEndTime);
                    mav.addObject(PAGEBEAN, (Object)marketOrderList);
                    mav.addObject("pageId", (Object)pageId);
                    mav.setViewName("jsp/marketing/marketgoodslist");
                    return mav;
                }
                if (Integer.parseInt(pageId) == 5604) {
                    marketing.setCodexId(Long.valueOf(13L));
                    PageBean marketOrderList = this.marketingService.marketOrderList(pageBean, marketing, marketingBeginTime, marketingEndTime);
                    mav.addObject(PAGEBEAN, (Object)marketOrderList);
                    mav.addObject("pageId", (Object)pageId);
                    mav.setViewName("jsp/marketing/marketgoodslist");
                    return mav;
                }
                if (Integer.parseInt(pageId) == 5605) {
                    marketing.setCodexId(Long.valueOf(15L));
                    PageBean marketOrderList = this.marketingService.marketOrderList(pageBean, marketing, marketingBeginTime, marketingEndTime);
                    mav.addObject(PAGEBEAN, (Object)marketOrderList);
                    mav.addObject("pageId", (Object)pageId);
                    mav.setViewName("jsp/marketing/marketgoodslist");
                    return mav;
                }
                if (Integer.parseInt(pageId) == 5606) {
                    marketing.setCodexId(Long.valueOf(12L));
                    PageBean marketOrderList = this.marketingService.marketOrderList(pageBean, marketing, marketingBeginTime, marketingEndTime);
                    mav.addObject(PAGEBEAN, (Object)marketOrderList);
                    mav.addObject("pageId", (Object)pageId);
                    mav.setViewName("jsp/marketing/marketgoodslist");
                    return mav;
                }
                if (Integer.parseInt(pageId) == 2032) {
                    marketing.setCodexId(Long.valueOf(11L));
                    PageBean marketOrderList = this.marketingService.marketOrderList(pageBean, marketing, marketingBeginTime, marketingEndTime);
                    mav.addObject(PAGEBEAN, (Object)marketOrderList);
                    mav.addObject("pageId", (Object)pageId);
                    mav.setViewName("jsp/marketing/marketgoodslist");
                    return mav;
                }
                if (Integer.parseInt(pageId) == 2030) {
                    marketing.setCodexId(Long.valueOf(10L));
                    PageBean marketOrderList = this.marketingService.marketOrderList(pageBean, marketing, marketingBeginTime, marketingEndTime);
                    mav.addObject(PAGEBEAN, (Object)marketOrderList);
                    mav.addObject("pageId", (Object)pageId);
                    mav.setViewName("jsp/marketing/marketgoodslist");
                    return mav;
                }
            }
            PageBean marketOrderList = this.marketingService.marketOrderList(pageBean, marketing, marketingBeginTime, marketingEndTime);
            mav.addObject(PAGEBEAN, (Object)marketOrderList);
            mav.setViewName("jsp/marketing/marketgoodslist");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u521d\u59cb\u5316\u5546\u54c1\u4fc3\u9500\u5217\u8868\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/toModifyMarketingdetail"})
    public ModelAndView toModifyMarketingdetail(Long marketingId, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        try {
            Promotion marketing = this.marketingService.searchMarketByMarketingId(marketingId);
            PromotionCodex marketingCodex = this.marketingService.searchMarketRuleByMarketingId(marketingId);
            Promotion marketingDetail = this.marketingService.queryMarketingDetail(marketingId, marketingCodex.getCodexId());
            mav.addObject("marketingId", (Object)marketingId);
            mav.addObject(MARKETING, (Object)marketing);
            mav.addObject("marketingCodex", (Object)marketingCodex);
            mav.addObject("marketingDetail", (Object)marketingDetail);
            mav.setViewName("jsp/marketing/modifymarketlist");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u8c03\u6574\u4fee\u6539\u4fc3\u9500\u9875\u9762\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/queryGoodsByAjax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List queryGoodsByAjax(Long marketingId, Long codexType) {
        List list = this.marketingService.queryMarketingScope(marketingId);
        ArrayList<GoodsProduct> product = new ArrayList<GoodsProduct>();
        if (codexType.intValue() != 15) {
            for (int i = 0; i < list.size(); ++i) {
                product.add(this.goodsProductService.queryProductByGoodsId(((PromotionScope)list.get(i)).getScopeId()));
            }
            return product;
        }
        ArrayList<Long> lista = new ArrayList<Long>();
        ArrayList<BigDecimal> listb = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> listc = new ArrayList<BigDecimal>();
        for (int i = 0; i < list.size(); ++i) {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("marketingId", marketingId);
            map.put("productId", ((PromotionScope)list.get(i)).getScopeId());
            GoodsProduct goodsproduct = this.goodsProductService.queryProductById(map);
            if (goodsproduct == null) continue;
            lista.add(goodsproduct.getGoodsId());
            listb.add(goodsproduct.getDiscountInfo());
            listc.add(goodsproduct.getDiscountPrice());
        }
        ArrayList<Goods> goods = new ArrayList<Goods>();
        for (int k = 0; k < lista.size(); ++k) {
            Goods gd = this.goodsService.queryGoodsByGoodsId((Long)lista.get(k));
            gd.setDiscountInfo((BigDecimal)listb.get(k));
            if (listc.get(k) == null) {
                gd.setDiscountPrice(gd.getGoodsPrice().multiply((BigDecimal)listb.get(k)));
            } else {
                gd.setDiscountPrice((BigDecimal)listc.get(k));
            }
            goods.add(gd);
        }
        for (int i = 0; i < goods.size() - 1; ++i) {
            for (int j = goods.size() - 1; j > i; --j) {
                if (!((Goods)goods.get(j)).getGoodsId().equals(((Goods)goods.get(i)).getGoodsId())) continue;
                goods.remove(j);
            }
        }
        return goods;
    }

    @RequestMapping(value={"/marketingdetail"})
    public ModelAndView marketingDetail(Long marketingId) {
        ModelAndView mav = new ModelAndView();
        try {
            Promotion marketingDetailNotTime = this.marketingService.marketingDetailNotTime(marketingId);
            Object catelist = this.marketingService.selectMarketingScope(marketingId, "0");
            Object brandlist = this.marketingService.selectMarketingScope(marketingId, "1");
            Object kulist = this.marketingService.selectMarketingScope(marketingId, "2");
            mav.addObject(MARKETING, (Object)marketingDetailNotTime);
            mav.addObject("catelist", catelist);
            mav.addObject(BRANDLIST, brandlist);
            mav.addObject("kulist", kulist);
            mav.setViewName("jsp/marketing/marketdetail");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u4fc3\u9500\u8be6\u60c5\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/toaddordermarketing"})
    public ModelAndView toAddOrderMarketing(HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        try {
            Promotion mk = new Promotion();
            mk.setMarketingType("1");
            List selectCodexListUseBox = this.codexService.selectCodexListUseBox();
            List queryAllBrandList = this.goodsBrandService.queryAllBrandList();
            List selectAll = this.marketingService.selectAll();
            List queryAllGoodThirdCate = this.goodsCateService.queryAllGoodThirdCate();
            mav.addObject("mk", (Object)mk);
            mav.addObject(CODEXLIST, (Object)selectCodexListUseBox);
            mav.addObject(BRANDLIST, (Object)queryAllBrandList);
            mav.addObject("pre", (Object)selectAll);
            mav.addObject(THIRDCATELIST, (Object)queryAllGoodThirdCate);
            mav.setViewName("jsp/marketing/createmarket");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u8df3\u8f6c\u6dfb\u52a0\u8ba2\u5355\u4fc3\u9500\u9875\u9762\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/toaddgoodsmarketing"})
    public ModelAndView toAddGoodsMarketing(HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        try {
            Promotion mk = new Promotion();
            mk.setMarketingType("0");
            List selectAll = this.marketingService.selectAll();
            List queryAllGoodThirdCate = this.goodsCateService.queryAllGoodThirdCate();
            List selectCodexListUseBox = this.codexService.selectCodexListUseBox();
            List queryAllBrandList = this.goodsBrandService.queryAllBrandList();
            mav.addObject(CODEXLIST, (Object)selectCodexListUseBox);
            mav.addObject(BRANDLIST, (Object)queryAllBrandList);
            mav.addObject("pre", (Object)selectAll);
            mav.addObject(THIRDCATELIST, (Object)queryAllGoodThirdCate);
            mav.addObject("mk", (Object)mk);
            mav.setViewName("jsp/marketing/createmarket");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(" \u8df3\u8f6c\u6dfb\u52a0\u5546\u54c1\u4fc3\u9500\u9875\u9762\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/toaddgoodspainc"})
    public ModelAndView toAddGoodsPainc(HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        try {
            Promotion mk = new Promotion();
            mk.setMarketingType("0");
            List selectAll = this.marketingService.selectAll();
            List queryAllGoodThirdCate = this.goodsCateService.queryAllGoodThirdCate();
            List selectCodexListUseBox = this.codexService.selectCodexListUseBox();
            List queryAllBrandList = this.goodsBrandService.queryAllBrandList();
            mav.addObject("pre", (Object)selectAll);
            mav.addObject(THIRDCATELIST, (Object)queryAllGoodThirdCate);
            mav.addObject(CODEXLIST, (Object)selectCodexListUseBox);
            mav.addObject(BRANDLIST, (Object)queryAllBrandList);
            mav.addObject("mk", (Object)mk);
            mav.setViewName("jsp/marketing/creategoodspanic");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u8df3\u8f6c\u6dfb\u52a0\u62a2\u8d2d\u4fc3\u9500\u9875\u9762\u5931\u8d25" + e.getMessage());
        }
        return mav;
    }

    @RequestMapping(value={"/toaddgoodsgroup"})
    public ModelAndView toAddGoodsGroup(HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        try {
            Promotion mk = new Promotion();
            mk.setMarketingType("0");
            List selectAll = this.marketingService.selectAll();
            List queryAllGoodThirdCate = this.goodsCateService.queryAllGoodThirdCate();
            List selectCodexListUseBox = this.codexService.selectCodexListUseBox();
            List queryAllBrandList = this.goodsBrandService.queryAllBrandList();
            mav.addObject("pre", (Object)selectAll);
            mav.addObject(THIRDCATELIST, (Object)queryAllGoodThirdCate);
            mav.addObject(CODEXLIST, (Object)selectCodexListUseBox);
            mav.addObject(BRANDLIST, (Object)queryAllBrandList);
            mav.addObject("mk", (Object)mk);
            mav.setViewName("jsp/marketing/creategoodsgroup");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u8df3\u8f6c\u6dfb\u52a0\u5546\u54c1\u7ec4\u5408\u9875\u9762\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/toupdatemarketing"})
    public ModelAndView toupdateMarketing(Long marketingId) {
        ModelAndView mav = new ModelAndView();
        try {
            mav.addObject(MARKETING, (Object)this.marketingService.marketingDetail(marketingId));
            mav.addObject("skulist", this.marketingService.selectMarketingScope(marketingId, "2"));
            mav.addObject(CODEXLIST, (Object)this.codexService.selectCodexListUseBox());
            mav.addObject(BRANDLIST, (Object)this.goodsBrandService.queryAllBrandList());
            mav.addObject("pre", (Object)this.marketingService.selectAll());
            mav.setViewName("jsp/marketing/updatemarket");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mav;
    }

    @RequestMapping(value={"/doupdatemarketing"})
    public ModelAndView doUpdateMarketing(HttpServletRequest request, Promotion marketing, String sTime, String eTime) {
        ModelAndView mav = new ModelAndView();
        try {
            if (null != marketing.getMarketingName()) {
                LOGGER.info((Object)("\u4fee\u6539\u8ba2\u5355\u4fc3\u9500,\u4fc3\u9500\u7684\u540d\u79f0\u4e3a\uff1a" + marketing.getMarketingName()));
            }
            marketing.setBusinessId(Long.valueOf(0L));
            marketing.setMarketingBegin(DateUtil.stringToDate((String)sTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            marketing.setMarketingEnd(DateUtil.stringToDate((String)eTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            String codexType = request.getParameter(CODEXTYPE);
            this.marketingService.doUpdateMarketing(marketing, codexType, request);
            if ("1".equals(marketing.getMarketingType())) {
                mav.setView((View)new RedirectView("marketorderlist.htm"));
            } else {
                mav.setView((View)new RedirectView("marketgoodslist.htm"));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8f6c\u6362\u5f02\u5e38" + e);
        }
        return mav;
    }

    @RequestMapping(value={"/doaddmarketing"})
    public ModelAndView doAddMarketing(HttpServletRequest request, @Valid Promotion marketing, String sTime, String eTime, String status, BindingResult result) {
        ModelAndView mav = new ModelAndView();
        try {
            if (status == null) {
                throw new RuntimeException("\u5546\u54c1\u4fc3\u9500\u7c7b\u578b\u4e0d\u6b63\u786e");
            }
            marketing.setBusinessId(Long.valueOf(0L));
            marketing.setMarketingBegin(DateUtil.stringToDate((String)sTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            marketing.setMarketingEnd(DateUtil.stringToDate((String)eTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            String codexType = request.getParameter(CODEXTYPE);
            this.marketingService.doAddMarketing(marketing, codexType, request, status);
            if ("1".equals(marketing.getMarketingType())) {
                mav.setView((View)new RedirectView("marketorderlist.htm"));
                return mav;
            }
            if ("10".equals(codexType)) {
                mav.setView((View)new RedirectView("marketgoodslist.htm?pageId=2030"));
                return mav;
            }
            if ("11".equals(codexType)) {
                mav.setView((View)new RedirectView("marketgoodslist.htm?pageId=2032"));
                return mav;
            }
            mav.setView((View)new RedirectView("marketgoodslist.htm"));
        }
        catch (Exception e) {
            e.printStackTrace();
            String operaCode = "\u5546\u54c1\u4fc3\u9500";
            String operaContent = request.getSession().getAttribute("operaPath") + "\u6dfb\u52a0\u5546\u54c1\u4fc3\u9500\u51fa\u9519";
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)request.getSession().getAttribute("name").toString(), (String)operaCode, (String)operaContent);
        }
        return mav;
    }

    @RequestMapping(value={"/newdoaddmarketing"})
    public ModelAndView newDoAddMarketing(HttpServletRequest request, @Valid Promotion marketing, String sTime, String eTime, String status, BindingResult result, Long[] lelvelId, Long[] promotionLogoId) {
        ModelAndView mav = new ModelAndView();
        try {
            if (status == null) {
                throw new RuntimeException("\u5546\u54c1\u4fc3\u9500\u7c7b\u578b\u4e0d\u6b63\u786e");
            }
            marketing.setBusinessId(Long.valueOf(0L));
            marketing.setMarketingBegin(DateUtil.stringToDate((String)sTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            marketing.setMarketingEnd(DateUtil.stringToDate((String)eTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            String codexType = request.getParameter(CODEXTYPE);
            this.marketingService.newDoAddMarketing(marketing, codexType, request, status, lelvelId, promotionLogoId);
            if ("1".equals("1")) {
                PromotionLogger promotionLogger = new PromotionLogger();
                promotionLogger.setName((String)request.getSession().getAttribute("name"));
                promotionLogger.setPromotionCode(null == marketing.getMarketingId() ? null : marketing.getMarketingId().toString());
                promotionLogger.setPromotionName(marketing.getMarketingName());
                promotionLogger.setType("\u6dfb\u52a0");
                promotionLogger.setStatus("0");
                this.promotionLoggerService.saveLogger(promotionLogger);
            }
            if ("1".equals(marketing.getMarketingType())) {
                mav.setView((View)new RedirectView("marketorderlist.htm"));
                return mav;
            }
            if ("10".equals(codexType)) {
                mav.setView((View)new RedirectView("marketgoodslist.htm?pageId=2030"));
                return mav;
            }
            if ("11".equals(codexType)) {
                mav.setView((View)new RedirectView("marketgoodslist.htm?pageId=2032"));
                return mav;
            }
            if ("1".equals(codexType)) {
                mav.setView((View)new RedirectView("marketgoodslist.htm?pageId=5601"));
                return mav;
            }
            if ("5".equals(codexType) || "8".equals(codexType)) {
                mav.setView((View)new RedirectView("marketgoodslist.htm?pageId=5602"));
                return mav;
            }
            if ("13".equals(codexType) || "14".equals(codexType)) {
                mav.setView((View)new RedirectView("marketgoodslist.htm?pageId=5604"));
                return mav;
            }
            if ("15".equals(codexType)) {
                mav.setView((View)new RedirectView("marketgoodslist.htm?pageId=5605"));
                return mav;
            }
            if ("12".equals(codexType)) {
                mav.setView((View)new RedirectView("marketgoodslist.htm?pageId=5606"));
                return mav;
            }
            if ("6".equals(codexType)) {
                mav.setView((View)new RedirectView("marketgoodslist.htm?pageId=5603"));
                return mav;
            }
            mav.setView((View)new RedirectView("marketgoodslist.htm"));
        }
        catch (Exception e) {
            e.printStackTrace();
            String operaCode = "\u5546\u54c1\u4fc3\u9500";
            String operaContent = request.getSession().getAttribute("operaPath") + "\u6dfb\u52a0\u5546\u54c1\u4fc3\u9500\u51fa\u9519";
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)request.getSession().getAttribute("name").toString(), (String)operaCode, (String)operaContent);
        }
        return mav;
    }

    @RequestMapping(value={"/domodifymarketing"})
    public ModelAndView doModifyMarketing(HttpServletRequest request, @Valid Promotion marketing, String sTime, String eTime, String status) {
        ModelAndView mav = new ModelAndView();
        try {
            marketing.setBusinessId(Long.valueOf(0L));
            marketing.setMarketingBegin(DateUtil.stringToDate((String)sTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            marketing.setMarketingEnd(DateUtil.stringToDate((String)eTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            String codexType = request.getParameter(CODEXTYPE);
            this.marketingService.doModifyMarketing(marketing, codexType, request, status);
            mav.setView((View)new RedirectView("marketgoodslist.htm"));
        }
        catch (Exception e) {
            String operaCode = "\u5546\u54c1\u4fc3\u9500";
            String operaContent = request.getSession().getAttribute("operaPath") + "\u4fee\u6539\u5546\u54c1\u4fc3\u9500\u51fa\u9519";
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)request.getSession().getAttribute("name").toString(), (String)operaCode, (String)operaContent);
        }
        return mav;
    }

    @RequestMapping(value={"/queryGoodsMarketAndGroup"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, List> queryProductMarketAndGroupByForm(Long goodsInfoId, Long brandId, Long cateId) {
        HashMap<String, List> promotionMap = new HashMap<String, List>(2);
        try {
            List groupVoList = this.goodsGroupService.queryGroupVoListWithProductId(goodsInfoId);
            List marketingList = this.marketingService.selectMarketingByGoodsInfoId(goodsInfoId, brandId, cateId);
            promotionMap.put(MARKETING, marketingList);
            promotionMap.put("group", groupVoList);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u53c2\u6570\u67e5\u8be2\u5546\u54c1\u4fc3\u9500\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return promotionMap;
    }

    @RequestMapping(value={"/queryGoodsGroup"})
    public ModelAndView queryGroupByGoodsInfoId(HttpServletRequest req, HttpServletResponse resp, Long goodsInfoId, Long distinctId) {
        ModelAndView mav = new ModelAndView();
        try {
            List groupVoList = this.goodsGroupService.queryGroupVoListWithProductId(goodsInfoId);
            LOGGER.info((Object)("=====goodsInfoId====" + goodsInfoId));
            mav.addObject("groupList", (Object)groupVoList);
            mav.addObject("goodsInfoId", (Object)goodsInfoId);
            mav.addObject("dId", (Object)distinctId);
            mav.setViewName("goods/group_sales");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("App\u7aef\u5546\u54c1\u53c2\u52a0\u5546\u54c1\u7ec4\u5408\u67e5\u8be2\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/queryGoodsMarket"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Promotion> queryProductMarketBySomeId(Long goodsInfoId, Long brandId, Long cateId) {
        ArrayList<Promotion> list = new ArrayList();
        try {
            list = this.marketingService.selectMarketingByGoodsInfoId(goodsInfoId, brandId, cateId);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u8d27\u54c1id\uff0c\u54c1\u724cid\uff0c\u5206\u7c7bid\u67e5\u8be2\u4fc3\u9500\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return list;
    }

    @RequestMapping(value={"/delmarketingbyid"})
    public ModelAndView delMarketingById(HttpServletRequest req, Long marketingId, String codexType) {
        Promotion marketing = this.marketingService.marketingDetailNotTime(marketingId);
        if (null != marketing.getMarketingName()) {
            LOGGER.info((Object)("\u5355\u4e2a\u5220\u9664\u8425\u9500\u4fe1\u606f,\u5220\u9664\u7684\u8425\u9500\u4fe1\u606f\u540d\u79f0\u4e3a\uff1a" + marketing.getMarketingName()));
        }
        this.marketingService.deleteMarketingById(marketing);
        if ("1".equals("1")) {
            PromotionLogger promotionLogger = new PromotionLogger();
            promotionLogger.setName((String)req.getSession().getAttribute("name"));
            promotionLogger.setPromotionCode(marketing.getMarketingId().toString());
            promotionLogger.setPromotionName(marketing.getMarketingName());
            promotionLogger.setType("\u5220\u9664");
            promotionLogger.setStatus("0");
            this.promotionLoggerService.saveLogger(promotionLogger);
        }
        if ("1".equals(marketing.getMarketingType())) {
            return new ModelAndView((View)new RedirectView("marketorderlist.htm"));
        }
        if ("10".equals(codexType)) {
            return new ModelAndView((View)new RedirectView("marketgoodslist.htm?pageId=2030"));
        }
        if ("11".equals(codexType)) {
            return new ModelAndView((View)new RedirectView("marketgoodslist.htm?pageId=2032"));
        }
        if ("1".equals(codexType)) {
            return new ModelAndView((View)new RedirectView("marketgoodslist.htm?pageId=5601"));
        }
        if ("5".equals(codexType) || "8".equals(codexType)) {
            return new ModelAndView((View)new RedirectView("marketgoodslist.htm?pageId=5602"));
        }
        if ("13".equals(codexType) || "14".equals(codexType)) {
            return new ModelAndView((View)new RedirectView("marketgoodslist.htm?pageId=5604"));
        }
        if ("15".equals(codexType)) {
            return new ModelAndView((View)new RedirectView("marketgoodslist.htm?pageId=5605"));
        }
        if ("12".equals(codexType)) {
            return new ModelAndView((View)new RedirectView("marketgoodslist.htm?pageId=5606"));
        }
        if ("6".equals(codexType)) {
            return new ModelAndView((View)new RedirectView("marketgoodslist.htm?pageId=5603"));
        }
        return new ModelAndView((View)new RedirectView("marketgoodslist.htm"));
    }

    @RequestMapping(value={"/delallmarketingbyids"})
    public ModelAndView delAllMarketingByIds(HttpServletRequest request, Long[] marketingId, String marketingType, String codexType) {
        if ("1".equals("1")) {
            for (int i = 0; i < marketingId.length; ++i) {
                Promotion marketing = this.marketingService.marketingDetailNotTime(marketingId[i]);
                PromotionLogger promotionLogger = new PromotionLogger();
                promotionLogger.setName((String)request.getSession().getAttribute("name"));
                promotionLogger.setPromotionCode(marketing.getMarketingId().toString());
                promotionLogger.setPromotionName(marketing.getMarketingName());
                promotionLogger.setType("\u5220\u9664");
                promotionLogger.setStatus("0");
                this.promotionLoggerService.saveLogger(promotionLogger);
            }
        }
        this.marketingService.delAllMarketingByIds(marketingId, Long.valueOf(0L));
        String[] arr = codexType.split(",");
        String type = arr[0];
        LOGGER.info((Object)("\u9700\u8981\u5220\u9664\u7684codexType\uff1a" + type));
        if ("1".equals(marketingType)) {
            return new ModelAndView((View)new RedirectView("marketorderlist.htm"));
        }
        if ("10".equals(type)) {
            return new ModelAndView((View)new RedirectView("marketgoodslist.htm?pageId=2030"));
        }
        if ("11".equals(type)) {
            return new ModelAndView((View)new RedirectView("marketgoodslist.htm?pageId=2032"));
        }
        if ("1".equals(type)) {
            return new ModelAndView((View)new RedirectView("marketgoodslist.htm?pageId=5601"));
        }
        if ("5".equals(type) || "8".equals(type)) {
            return new ModelAndView((View)new RedirectView("marketgoodslist.htm?pageId=5602"));
        }
        if ("13".equals(type) || "14".equals(type)) {
            return new ModelAndView((View)new RedirectView("marketgoodslist.htm?pageId=5604"));
        }
        if ("15".equals(type)) {
            return new ModelAndView((View)new RedirectView("marketgoodslist.htm?pageId=5605"));
        }
        if ("12".equals(type)) {
            return new ModelAndView((View)new RedirectView("marketgoodslist.htm?pageId=5606"));
        }
        if ("6".equals(type)) {
            return new ModelAndView((View)new RedirectView("marketgoodslist.htm?pageId=5603"));
        }
        return new ModelAndView((View)new RedirectView("marketgoodslist.htm"));
    }

    @RequestMapping(value={"/removegoodsbymIdandgid"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int removeGoodsByMidAndGid(Long goodsId, Long codexId, Long marketingId) {
        int count = -1;
        if (codexId != 15L) {
            count = this.marketingService.removeGoodsByMidAndGid(goodsId, marketingId);
        } else {
            List product = this.goodsProductService.queryProductsByGoodsId(goodsId);
            for (int i = 0; i < product.size(); ++i) {
                count = this.marketingService.removeMarketByMidAndGid(((GoodsProduct)product.get(i)).getGoodsInfoId(), marketingId);
            }
        }
        return count;
    }

    @RequestMapping(value={"/querycodexListbyparam"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Codex> queryCodexListByParam(Long codexStatus) {
        LOGGER.info((Object)("\u6839\u636e\u5206\u7ec4\u7f16\u53f7\u3010" + codexStatus + "\u3011\u67e5\u8be2\u4fc3\u9500\u89c4\u5219"));
        return this.codexService.queryCodexListByParam(codexStatus);
    }

    @RequestMapping(value={"/insertmaketinggroup"})
    public ModelAndView insertMaketingGroup(PromotionGroup group) {
        if (null != group.getPreferentialName()) {
            LOGGER.info((Object)("\u65b0\u589e\u7684\u4fc3\u9500\u5206\u7ec4\u540d\u79f0\u4e3a\uff1a" + group.getPreferentialName()));
        }
        this.marketingService.insertMarketingGroup(group);
        return new ModelAndView((View)new RedirectView(QUERYPRELIST_HTM));
    }

    @RequestMapping(value={"/delmarketinggroupbyparam"})
    public ModelAndView delMarketingGroupByParam(Long groupId) {
        this.marketingService.deleteByPrimaryKey(groupId);
        return new ModelAndView((View)new RedirectView(QUERYPRELIST_HTM));
    }

    @RequestMapping(value={"/updatemarketing"})
    public ModelAndView updateMarketing(PromotionGroup group) {
        if (null != group.getPreferentialName()) {
            LOGGER.info((Object)("\u4fee\u6539\u4fc3\u9500\u5206\u7ec4\uff0c\u4fee\u6539\u7684\u4fc3\u9500\u5206\u7ec4\u540d\u79f0\u4e3a\uff1a" + group.getPreferentialName()));
        }
        this.marketingService.updateByPrimaryKeySelective(group);
        return new ModelAndView((View)new RedirectView(QUERYPRELIST_HTM));
    }

    @RequestMapping(value={"/delgroupbycodexis"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int delGroupByCodexIs(Long groupId) {
        return this.marketingService.delGroupByCodexIs(groupId);
    }

    @RequestMapping(value={"/queryprelist"})
    public ModelAndView queryprelist(PageBean pb, String preferentialName, HttpServletRequest request) {
        pb.setUrl("/queryprelist.htm");
        return new ModelAndView("jsp/marketing/prefergroup").addObject("pb", (Object)this.marketingService.selectByPrimary(pb, preferentialName)).addObject("preferentialName", (Object)preferentialName);
    }

    @RequestMapping(value={"/modifybossmarketing"})
    public ModelAndView newModifyBossMarketing(Long marketingId, String marketingFlag) {
        ModelAndView mav = new ModelAndView();
        try {
            Promotion marketingDetailNotTime = this.marketingService.marketingDetailNotTime(marketingId);
            List selectCodexListUseBox = this.codexService.selectCodexListUseBox();
            List queryAllGoodThirdCate = this.goodsCateService.queryAllGoodThirdCate();
            List queryAllBrandList = this.goodsBrandService.queryAllBrandList();
            Object catelist = this.marketingService.selectMarketingScope(marketingId, "0");
            Object brandlist = this.marketingService.selectMarketingScope(marketingId, "1");
            Object kulist = this.marketingService.selectMarketingScope(marketingId, "2");
            List selectAllPointLevel = this.pointLevelServiceMapper.selectAllPointLevel();
            List selectCouponListByAble = this.couponService.selectCouponListByAble();
            List queryAllLogoList = this.logoService.queryAllLogoList();
            mav.addObject(MARKETING, (Object)marketingDetailNotTime);
            mav.addObject(CODEXLIST, (Object)selectCodexListUseBox);
            mav.addObject(THIRDCATELIST, (Object)queryAllGoodThirdCate);
            mav.addObject("allbrandlist", (Object)queryAllBrandList);
            mav.addObject("catelist", catelist);
            mav.addObject(BRANDLIST, brandlist);
            mav.addObject("kulist", kulist);
            mav.addObject("customerLevel", (Object)selectAllPointLevel);
            mav.addObject("couponlist", (Object)selectCouponListByAble);
            mav.addObject("logolist", (Object)queryAllLogoList);
            mav.addObject("marketingFlag", (Object)marketingFlag);
            mav.setViewName("jsp/marketing/modifymarketing");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u8df3\u8f6c\u4fee\u6539\u4fc3\u9500\u9875\u9762\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/newdomodifymarketing"})
    public ModelAndView newDoModifyMarketing(HttpServletRequest request, @Valid Promotion marketing, String sTime, String eTime, String status, Long[] lelvelId, Long[] promotionLogoId) {
        ModelAndView mav = new ModelAndView();
        try {
            marketing.setBusinessId(Long.valueOf(0L));
            marketing.setMarketingBegin(DateUtil.stringToDate((String)sTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            marketing.setMarketingEnd(DateUtil.stringToDate((String)eTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            String giveIntegral = request.getParameter("giveIntegral");
            if (giveIntegral == null || "".equals(giveIntegral)) {
                marketing.setGiveIntegral(Integer.valueOf(0));
            }
            String codexType = request.getParameter(CODEXTYPE);
            this.marketingService.newDoUpdateMarketing(marketing, codexType, status, request, lelvelId, promotionLogoId);
            if ("1".equals("1")) {
                PromotionLogger promotionLogger = new PromotionLogger();
                promotionLogger.setName((String)request.getSession().getAttribute("name"));
                promotionLogger.setPromotionCode(marketing.getMarketingId().toString());
                promotionLogger.setPromotionName(marketing.getMarketingName());
                promotionLogger.setType("\u4fee\u6539");
                promotionLogger.setStatus("0");
                this.promotionLoggerService.saveLogger(promotionLogger);
            }
            if ("1".equals(marketing.getMarketingType())) {
                mav.setView((View)new RedirectView("marketorderlist.htm"));
                return mav;
            }
            if ("10".equals(codexType)) {
                mav.setView((View)new RedirectView("marketgoodslist.htm?pageId=2030"));
                return mav;
            }
            if ("11".equals(codexType)) {
                mav.setView((View)new RedirectView("marketgoodslist.htm?pageId=2032"));
                return mav;
            }
            if ("1".equals(codexType)) {
                mav.setView((View)new RedirectView("marketgoodslist.htm?pageId=5601"));
                return mav;
            }
            if ("5".equals(codexType) || "8".equals(codexType)) {
                mav.setView((View)new RedirectView("marketgoodslist.htm?pageId=5602"));
                return mav;
            }
            if ("13".equals(codexType) || "14".equals(codexType)) {
                mav.setView((View)new RedirectView("marketgoodslist.htm?pageId=5604"));
                return mav;
            }
            if ("15".equals(codexType)) {
                mav.setView((View)new RedirectView("marketgoodslist.htm?pageId=5605"));
                return mav;
            }
            if ("12".equals(codexType)) {
                mav.setView((View)new RedirectView("marketgoodslist.htm?pageId=5606"));
                return mav;
            }
            if ("6".equals(codexType)) {
                mav.setView((View)new RedirectView("marketgoodslist.htm?pageId=5603"));
                return mav;
            }
            mav.setView((View)new RedirectView("marketgoodslist.htm"));
        }
        catch (Exception e) {
            e.printStackTrace();
            String operaCode = "\u5546\u54c1\u4fc3\u9500";
            String operaContent = request.getSession().getAttribute("operaPath") + "\u4fee\u6539\u5546\u54c1\u4fc3\u9500\u51fa\u9519";
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)request.getSession().getAttribute("name").toString(), (String)operaCode, (String)operaContent);
        }
        return mav;
    }

    @RequestMapping(value={"/doaddpresentmarketing"})
    public ModelAndView doAddPresentMarketing(HttpServletRequest request, @Valid Promotion marketing, String sTime, String eTime, String status, BindingResult result) {
        ModelAndView mav = new ModelAndView();
        try {
            if (status == null) {
                throw new RuntimeException("\u5546\u54c1\u4fc3\u9500\u7c7b\u578b\u4e0d\u6b63\u786e");
            }
            marketing.setBusinessId(Long.valueOf(0L));
            marketing.setMarketingBegin(DateUtil.stringToDate((String)sTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            marketing.setMarketingEnd(DateUtil.stringToDate((String)eTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            String codexType = request.getParameter(CODEXTYPE);
            this.marketingService.doAddPresentMarketing(marketing, codexType, request, status);
            mav.setView((View)new RedirectView("marketgoodslist.htm?pageId=5603"));
        }
        catch (Exception e) {
            String operaCode = "\u5546\u54c1\u6ee1\u8d60\u4fc3\u9500";
            String operaContent = request.getSession().getAttribute("operaPath") + "\u6dfb\u52a0\u6ee1\u8d60\u5546\u54c1\u4fc3\u9500\u51fa\u9519";
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)request.getSession().getAttribute("name").toString(), (String)operaCode, (String)operaContent);
        }
        return mav;
    }

    @RequestMapping(value={"/domodifypresentmarketing"})
    public ModelAndView doModifyPresentMarketing(HttpServletRequest request, @Valid Promotion marketing, String sTime, String eTime, String status) {
        ModelAndView mav = new ModelAndView();
        try {
            marketing.setBusinessId(Long.valueOf(0L));
            marketing.setMarketingBegin(DateUtil.stringToDate((String)sTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            marketing.setMarketingEnd(DateUtil.stringToDate((String)eTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            String codexType = request.getParameter(CODEXTYPE);
            this.marketingService.doUpdatePresentMarketing(marketing, codexType, status, request);
            mav.setView((View)new RedirectView("marketgoodslist.htm?pageId=5603"));
        }
        catch (Exception e) {
            e.printStackTrace();
            String operaCode = "\u5546\u54c1\u4fc3\u9500";
            String operaContent = request.getSession().getAttribute("operaPath") + "\u4fee\u6539\u6ee1\u8d60\u4fc3\u9500\u51fa\u9519";
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)request.getSession().getAttribute("name").toString(), (String)operaCode, (String)operaContent);
        }
        return mav;
    }
}

