/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.login_exchange.controller;

import com.yqbsoft.laser.html.annotation.Layout;
import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.facade.mm.bean.MmAddress;
import com.yqbsoft.laser.html.facade.mm.repository.MmAddressRepository;
import com.yqbsoft.laser.html.login_exchange.bean.BsArea;
import com.yqbsoft.laser.html.login_exchange.bean.BsProvince;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.SupperSysException;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/mi/address"})
@Layout(frameName="application")
public class AddressCon
extends SpringmvcController {
    @Autowired
    private MmAddressRepository addressRepository;

    protected String getContext() {
        return "address";
    }

    @RequestMapping(value={"addresslist"})
    public String getAddresslist(HttpServletRequest request, ModelMap map) {
        this.queryAddressList(request, map);
        return String.valueOf(this.getFtlTempPath(request)) + "addressList";
    }

    protected void queryAddressList(HttpServletRequest request, ModelMap map) {
        UserSession user = this.getUserSession(request);
        List list = SupDisUtil.getListJson((String)"provinceCache_key", BsProvince.class);
        map.addAttribute("list", (Object)this.addressRepository.getAddressPage(user.getUserCode(), this.getTenantCode(request), null));
        map.addAttribute("province", (Object)list);
    }

    @RequestMapping(value={"saveAddress.json"})
    @ResponseBody
    public HtmlJsonReBean saveAddress(HttpServletRequest request, MmAddress address) {
        if (address == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6570\u636e\u4e3a\u7a7a");
        }
        UserSession user = this.getUserSession(request);
        address.setMerberCode(user.getUserCode());
        address.setTenantCode(user.getTenantCode());
        return this.addressRepository.addAddress(address);
    }

    @RequestMapping(value={"getAddress.json"})
    @ResponseBody
    public HtmlJsonReBean getAddress(HttpServletRequest request, String addressCode) {
        if (StringUtils.isBlank((String)addressCode)) {
            return null;
        }
        MmAddress mmaddress = this.addressRepository.getAddressByCode(addressCode, this.getTenantCode(request));
        return new HtmlJsonReBean((Object)mmaddress);
    }

    @RequestMapping(value={"deleteAddress.json"})
    @ResponseBody
    public HtmlJsonReBean delete(HttpServletRequest request, Integer addressId) {
        MmAddress mmAddress = this.addressRepository.getAddress(addressId);
        if (mmAddress == null || this.getUserSession(request).getUserCode().equals(mmAddress.getAddressMember())) {
            return new HtmlJsonReBean("error", "\u64cd\u4f5c\u5931\u8d25");
        }
        return this.addressRepository.deleteAddress(addressId);
    }

    @RequestMapping(value={"updateAddress.json"})
    @ResponseBody
    public HtmlJsonReBean updateAddress(HttpServletRequest request, MmAddress mmaddress) {
        try {
            MmAddress mmaddressold = this.addressRepository.getAddressByCode(mmaddress.getAddressCode(), this.getTenantCode(request));
            BeanUtils.copyAllPropertysNotNull((Object)mmaddressold, (Object)mmaddress);
            return this.addressRepository.updateAddress(mmaddressold);
        }
        catch (Exception e) {
            throw new SupperSysException(e.getMessage());
        }
    }

    @RequestMapping(value={"setaddressDefault.json"})
    @ResponseBody
    public HtmlJsonReBean setDefault(HttpServletRequest request, String addressCode) {
        UserSession user = this.getUserSession(request);
        return this.addressRepository.setDefault(user.getUserCode(), addressCode, user.getTenantCode());
    }

    @RequestMapping(value={"getarea.json"})
    @ResponseBody
    public HtmlJsonReBean getareaBycode(HttpServletRequest request, String provinceCode) {
        Map area = SupDisUtil.getMapAll((String)"areaCache_key");
        String rs = (String)area.get(provinceCode);
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(rs, BsArea.class);
        return new HtmlJsonReBean((Object)list);
    }
}

