/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.login_exchange.valcode;

import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;

public class GeetestLib {
    protected final String verName = "4.0";
    protected final String sdkLang = "java";
    protected final String apiUrl = "http://api.geetest.com";
    protected final String registerUrl = "/register.php";
    protected final String validateUrl = "/validate.php";
    protected final String json_format = "1";
    public static final String fn_geetest_challenge = "geetest_challenge";
    public static final String fn_geetest_validate = "geetest_validate";
    public static final String fn_geetest_seccode = "geetest_seccode";
    private String captchaId = "";
    private String privateKey = "";
    private boolean newFailback = false;
    private String responseStr = "";
    public boolean debugCode = true;
    public String gtServerStatusSessionKey = "gt_server_status";
    public String userId = "";
    public String clientType = "";
    public String ipAddress = "";

    public GeetestLib(String captchaId, String privateKey, boolean newFailback) {
        this.captchaId = captchaId;
        this.privateKey = privateKey;
        this.newFailback = newFailback;
    }

    public String getResponseStr() {
        return this.responseStr;
    }

    public String getVersionInfo() {
        return "4.0";
    }

    private String getFailPreProcessRes() {
        Long rnd1 = Math.round(Math.random() * 100.0);
        Long rnd2 = Math.round(Math.random() * 100.0);
        String md5Str1 = this.md5Encode("" + rnd1);
        String md5Str2 = this.md5Encode("" + rnd2);
        String challenge = String.valueOf(md5Str1) + md5Str2.substring(0, 2);
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        try {
            jsonObject.put("success", 0);
            jsonObject.put("gt", this.captchaId);
            jsonObject.put("challenge", challenge);
            jsonObject.put("new_captcha", this.newFailback);
        }
        catch (Exception e) {
            this.gtlog("json dumps error");
        }
        return jsonObject.toString();
    }

    private String getSuccessPreProcessRes(String challenge) {
        this.gtlog("challenge:" + challenge);
        HashMap<String, Object> jsonObject = new HashMap<String, Object>();
        try {
            jsonObject.put("success", 1);
            jsonObject.put("gt", this.captchaId);
            jsonObject.put("challenge", challenge);
        }
        catch (Exception e) {
            this.gtlog("json dumps error");
        }
        return JsonUtil.buildNormalBinder().toJson(jsonObject);
    }

    public int preProcess() {
        if (this.registerChallenge() != 1) {
            this.responseStr = this.getFailPreProcessRes();
            return 0;
        }
        return 1;
    }

    public int preProcess(String userid) {
        this.userId = userid;
        return this.preProcess();
    }

    private int registerChallenge() {
        block8: {
            String result_str;
            block7: {
                try {
                    String getUrl = "http://api.geetest.com/register.php?";
                    String param = "gt=" + this.captchaId + "&json_format=" + "1";
                    if (this.userId != "") {
                        param = String.valueOf(param) + "&user_id=" + this.userId;
                        this.userId = "";
                    }
                    if (this.clientType != "") {
                        param = String.valueOf(param) + "&client_type=" + this.clientType;
                        this.clientType = "";
                    }
                    if (this.ipAddress != "") {
                        param = String.valueOf(param) + "&ip_address=" + this.ipAddress;
                        this.ipAddress = "";
                    }
                    this.gtlog("GET_URL:" + getUrl + param);
                    result_str = this.readContentFromGet(String.valueOf(getUrl) + param);
                    if (result_str != "fail") break block7;
                    this.gtlog("gtServer register challenge failed");
                    return 0;
                }
                catch (Exception e) {
                    this.gtlog(e.toString());
                    this.gtlog("exception:register api");
                    return 0;
                }
            }
            this.gtlog("result:" + result_str);
            HashMap jsonObject = (HashMap)JsonUtil.buildNormalBinder().getJsonToMap(result_str, String.class, Object.class);
            String return_challenge = jsonObject.get("challenge").toString();
            this.gtlog("return_challenge:" + return_challenge);
            if (return_challenge.length() != 32) break block8;
            this.responseStr = this.getSuccessPreProcessRes(this.md5Encode(String.valueOf(return_challenge) + this.privateKey));
            return 1;
        }
        this.gtlog("gtServer register challenge error");
        return 0;
    }

    protected boolean objIsEmpty(Object gtObj) {
        if (gtObj == null) {
            return true;
        }
        return gtObj.toString().trim().length() == 0;
    }

    private boolean resquestIsLegal(String challenge, String validate, String seccode) {
        if (this.objIsEmpty(challenge)) {
            return false;
        }
        if (this.objIsEmpty(validate)) {
            return false;
        }
        return !this.objIsEmpty(seccode);
    }

    public int enhencedValidateRequest(String challenge, String validate, String seccode) {
        String response;
        String param;
        String postUrl;
        block9: {
            block8: {
                if (!this.resquestIsLegal(challenge, validate, seccode)) {
                    return 0;
                }
                this.gtlog("request legitimate");
                postUrl = String.valueOf("http://api.geetest.com") + "/validate.php";
                param = String.format("challenge=%s&validate=%s&seccode=%s&json_format=%s", challenge, validate, seccode, "1");
                response = "";
                if (validate.length() > 0) break block8;
                return 0;
            }
            if (this.checkResultByPrivate(challenge, validate)) break block9;
            return 0;
        }
        try {
            this.gtlog("checkResultByPrivate");
            response = this.readContentFromPost(postUrl, param);
            this.gtlog("response: " + response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String return_seccode = "";
        try {
            HashMap return_map = (HashMap)JsonUtil.buildNormalBinder().getJsonToMap(response, String.class, Object.class);
            return_seccode = return_map.get("seccode").toString();
            this.gtlog("md5: " + this.md5Encode(return_seccode));
            if (return_seccode.equals(this.md5Encode(seccode))) {
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            this.gtlog("json load error");
            return 0;
        }
    }

    public int enhencedValidateRequest(String challenge, String validate, String seccode, String userid) {
        this.userId = userid;
        return this.enhencedValidateRequest(challenge, validate, seccode);
    }

    public int failbackValidateRequest(String challenge, String validate, String seccode) {
        this.gtlog("in failback validate");
        if (!this.resquestIsLegal(challenge, validate, seccode)) {
            return 0;
        }
        this.gtlog("request legitimate");
        return 1;
    }

    public void gtlog(String message) {
        if (this.debugCode) {
            System.out.println("gtlog: " + message);
        }
    }

    protected boolean checkResultByPrivate(String challenge, String validate) {
        String encodeStr = this.md5Encode(String.valueOf(this.privateKey) + "geetest" + challenge);
        return validate.equals(encodeStr);
    }

    private String readContentFromGet(String URL2) throws IOException {
        URL getUrl = new URL(URL2);
        HttpURLConnection connection = (HttpURLConnection)getUrl.openConnection();
        connection.setConnectTimeout(2000);
        connection.setReadTimeout(2000);
        connection.connect();
        if (connection.getResponseCode() == 200) {
            int n;
            StringBuffer sBuffer = new StringBuffer();
            InputStream inStream = null;
            byte[] buf = new byte[1024];
            inStream = connection.getInputStream();
            while ((n = inStream.read(buf)) != -1) {
                sBuffer.append(new String(buf, 0, n, "UTF-8"));
            }
            inStream.close();
            connection.disconnect();
            return sBuffer.toString();
        }
        return "fail";
    }

    private String readContentFromPost(String URL2, String data) throws IOException {
        this.gtlog(data);
        URL postUrl = new URL(URL2);
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setConnectTimeout(2000);
        connection.setReadTimeout(2000);
        connection.setRequestMethod("POST");
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        connection.connect();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(connection.getOutputStream(), "utf-8");
        outputStreamWriter.write(data);
        outputStreamWriter.flush();
        outputStreamWriter.close();
        if (connection.getResponseCode() == 200) {
            int n;
            StringBuffer sBuffer = new StringBuffer();
            InputStream inStream = null;
            byte[] buf = new byte[1024];
            inStream = connection.getInputStream();
            while ((n = inStream.read(buf)) != -1) {
                sBuffer.append(new String(buf, 0, n, "UTF-8"));
            }
            inStream.close();
            connection.disconnect();
            return sBuffer.toString();
        }
        return "fail";
    }

    private String md5Encode(String plainText) {
        String re_md5 = new String();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(plainText.getBytes());
            byte[] b = md.digest();
            StringBuffer buf = new StringBuffer("");
            int offset = 0;
            while (offset < b.length) {
                int i = b[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
                ++offset;
            }
            re_md5 = buf.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return re_md5;
    }
}

