<!--新增收货地址弹框-->
<div id="addadress" class="weui-popup__container">
  <div class="weui-popup__overlay"></div>
  <div class="weui-popup__modal">
      <header class="popup_header weui-flex">
      	<a href="javascript:;" class="close-popup">取消</a>
      	<h1 class="weui-flex__item" id="titleShow"> 新增地址</h1>
      	<a href="javascript:;" class="" onclick="submitForm()">保存</a>
      </header>
      <form id="addressForm" name="addressForm" method="post">
      <div class="content">
      	<div class="weui-cells weui-cells_form">
      		<div class="weui-cell">
		        <div class="weui-cell__hd" id="member_error">
		          <label class="weui-label">联系人</label>
		        </div>
		        <div class="weui-cell__bd">
		          <input class="weui-input" type="text" onkeyup="javascript:$('#member_error').removeClass('weui-cell_warn');"  name="addressMember" id="addressMember" placeholder="姓名">
		        </div>
		        <div class="weui-cell__ft">
			      <i class="weui-cell_warn"></i>
			    </div>
		    </div>
	    		<!--下面这个加了错误提示的样式-->
    		<div class="weui-cell" id="phone_error">
		        <div class="weui-cell__hd">
		          <label class="weui-label">手机号</label>
		        </div>
		        <div class="weui-cell__bd">
		          <input class="weui-input" type="tel" name="addressPhone" onkeyup="javascript:$('#phone_error').removeClass('weui-cell_warn');" id="addressPhone" placeholder="请输入手机号">
		        </div>
		        <div class="weui-cell__ft weui-cell_warn">
			      <i class="weui-cell_warn"></i>
			    </div>
		    </div>
		    <div class="weui-cell" id="address_error">
		        <div class="weui-cell__hd">
		          <label class="weui-label">省市区</label>
		        </div>
		        <div class="weui-cell__bd">
		          <input class="weui-input" type="text" placeholder="地区信息" onchange="javascript:$('#address_error').removeClass('weui-cell_warn');"  id="selectAdress">
		        </div>
		        <div class="weui-cell__ft">
			      <i class="weui-cell_warn" ></i>
			    </div>
		    </div>
		    <div class="weui-cell form_cell" id="detail_error">
		        <div class="weui-cell__hd">
		          <label class="weui-label">详细地址</label>
		        </div>
		        <div class="weui-cell__bd">
		          <textarea class="weui-textarea" placeholder="请输入详情地址" onkeyup="javascript:$('#detail_error').removeClass('weui-cell_warn');" rows="2" id="addressDetail" name="addressDetail"></textarea>
		        </div>
		        <div class="weui-cell__ft">
			      <i class="weui-cell_warn" ></i>
			    </div>
		    </div>
		    <div style="display: none;">
		    <input id="provinceName" name="provinceName" type="text"/>
		    <input id="areaName" name="areaName" type="text"/>
		    <input id="cityName" name="cityName" type="text"/>
		    <input id="provinceCode" name="provinceCode" type="text"/>
		    <input id="areaCode" name="areaCode" type="text"/>
		    <input id="cityCode" name="cityCode" type="text"/>
		    <input id="addressCode" name="addressCode" type="text"/>
		    </div>
	    </div>
      </div>
      </form>
  </div>
</div>
<!--新增收货地址弹框  end-->
<script>

$(function() {
	//新增地址弹框
	$("#addadressBtn").click(function() {
		$("#titleShow").html("新增地址");
		$("#addadress").popup();
		$("input[name='addressCode']").val("");
		$("input[name='provinceCode']").val("");
		$("input[name='areaCode']").val("");
		$("input[name='cityCode']").val("");
		$("input[name='provinceName']").val("");
		$("input[name='areaName']").val("");
		$("input[name='cityName']").val("");
		$("input[name='addressPhone']").val("");
		$("input[name='addressMember']").val("");
		$("textarea[name='addressDetail']").html("");
		$("#selectAdress").val("");
	})
	//省市区选择
	$("#selectAdress").cityPicker({
        title: "选择地区",
        onChange: function(p, v, dv) {
        	var code = v;
        	var name = dv;
        	$("#provinceCode").val(v[0]);
        	$("#areaCode").val(v[1]);
        	$("#cityCode").val(v[2]);
        	$("#provinceName").val(dv[0]);
        	$("#areaName").val(dv[1]);
        	$("#cityName").val(dv[2]);
    	}
    });
	
})

function submitForm(){
	var addressCode =$("#addressCode").val();
	if(addressCode == "" || addressCode == null){
		saveAddress();
	} else{
		updateAddress();
	}
}

function saveAddress(){
	if(checkForm()){
		var config = {
				url : "${sysAppContextPath}/web/mi/address/saveAddress.json",
				postData : getFormData($("#addressForm")),
				onSuccessFunction : function(data) {
					if(data == null){
						$.closePopup();
						window.location.reload();
					} else{
						alert(data.msg);
					}
				},
				mask : false
			};
			myAjaxRequest(config);
	}
}
function checkForm(){
	var flag = true;
	var addressMember = $("#addressMember").val();
	var addressPhone = $("#addressPhone").val();
	var addressDetail = $("#addressDetail").val();
	var areaCode = $("#areaCode").val();
 	if(addressPhone==""){
		$("#phone_error").addClass("weui-cell_warn");
		flag = false
 	} else{
	 	if(!(/^1[1-9][0-9]\d{8}$/.test(addressPhone))){
	 		$("#phone_error").addClass("weui-cell_warn");
	 		alert("手机号格式不正确")
	 		flag = false;
	 	} else{
	 		$("#phone_error").removeClass("weui-cell_warn");
	 	}
 	}
 	if(addressMember == ""){
 		$("#member_error").addClass("weui-cell_warn");
 		flag = false;
 	} else{
 		$("#member_error").removeClass("weui-cell_warn");
 	}
 	if(addressDetail == ""){
 		$("#detail_error").addClass("weui-cell_warn");
 		flag = false;
 	} else{
 		$("#detail_error").removeClass("weui-cell_warn");
 	}
 	if(areaCode == ""){
 		$("#address_error").addClass("weui-cell_warn");
 		flag = false;
 	} else{
 		$("#address_error").removeClass("weui-cell_warn");
 	}
 	return flag;
}

function getAddress(addressCode){
	$("#addadress").popup();
	$("#titleShow").html("修改地址");
	var config = {
		url : "${sysAppContextPath}/web/mi/address/getAddress.json",
		postData : {"addressCode": addressCode},
		onSuccessFunction : function(data) {
			if(data != null){
				$("input[name='addressCode']").val(data.addressCode);
				$("input[name='provinceCode']").val(data.provinceCode);
				$("input[name='areaCode']").val(data.areaCode);
				$("input[name='cityCode']").val(data.cityCode);
				$("input[name='provinceName']").val(data.provinceName);
				$("input[name='areaName']").val(data.areaName);
				$("input[name='cityName']").val(data.cityName);
				$("input[name='addressPhone']").val(data.addressPhone);
				$("input[name='addressMember']").val(data.addressMember);
				$("textarea[name='addressDetail']").html(data.addressDetail);
				$("#selectAdress").val(data.provinceName + " " + data.areaName + " " + data.cityName);
			}
		},
		mask : false
	};
	myAjaxRequest(config);
}

function updateAddress(){
	if(checkForm()){
		var config = {
				url : "${sysAppContextPath}/web/mi/address/updateAddress.json",
				postData : getFormData($("#addressForm")),
				onSuccessFunction : function(data) {
					debugger;
					if(data == null){
						$.closePopup();
						window.location.reload();
					} else{
						alert(data.msg);
					}
				},
				mask : false
			};
			myAjaxRequest(config);
	}
}

</script>