/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.mlogin.controller;

import com.yqbsoft.laser.html.common.util.CookieUtil;
import com.yqbsoft.laser.html.common.util.ResourceUtil;
import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.facade.ar.repository.OsLoginRepository;
import com.yqbsoft.laser.html.facade.ar.repository.RdrandomRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.tool.util.BrowTypeUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.VerifyImgUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/mi/mlogin"})
public class MloginCon
extends SpringmvcController {
    private static String CODE = "mi.mlogin.con";
    private static String Tokenkey = "tokenkey";
    private static String TenantCode = "tenantCode";
    @Autowired
    private RdrandomRepository rdrandomRepository;
    @Autowired
    private OsLoginRepository loginRepository;

    protected String getContext() {
        return "mlogin";
    }

    @RequestMapping(value={"noresource"})
    public String noresource(HttpServletRequest request, ModelMap map, String redirectURL) {
        map.addAttribute("redirectURL", (Object)redirectURL);
        return this.getFtlTempPath(request) + "noresource";
    }

    @RequestMapping(value={"noper"})
    public String noper(HttpServletRequest request, ModelMap map, String redirectURL) {
        map.addAttribute("redirectURL", (Object)redirectURL);
        return this.getFtlTempPath(request) + "noper";
    }

    @RequestMapping(value={"login"})
    public String login(HttpServletRequest request, ModelMap map, String redirectURL) {
        map.addAttribute("redirectURL", (Object)redirectURL);
        return this.getFtlTempPath(request) + "login";
    }

    @RequestMapping(value={"loginIn.json"})
    public ResponseEntity<HtmlJsonReBean> loginIn(HttpServletRequest request, HttpServletResponse response, String loginName, String passwd, String code, String redirectURL) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_PLAIN);
        if (StringUtils.isBlank((String)loginName) || StringUtils.isBlank((String)passwd)) {
            this.logger.error(CODE + ".loginIn", (Object)"param is null");
            return new ResponseEntity((Object)new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null"), (MultiValueMap)headers, HttpStatus.OK);
        }
        String tenantCode = ResourceUtil.getOut((String)"laser", (String)"", (String)"tenantCode");
        String browType = BrowTypeUtil.getBrowType((String)request.getHeader("User-Agent"));
        Map result_code = this.rdrandomRepository.check("2", request.getRemoteAddr(), tenantCode, code);
        if (!((Boolean)result_code.get("flag")).booleanValue()) {
            return new ResponseEntity((Object)new HtmlJsonReBean(CODE + ".loginIn.no", result_code.get("message").toString()), (MultiValueMap)headers, HttpStatus.OK);
        }
        Map result = this.loginRepository.dologin(loginName, passwd, browType, ServletMain.getAppName(), tenantCode);
        if (!((Boolean)result.get("flag")).booleanValue()) {
            return new ResponseEntity((Object)new HtmlJsonReBean(CODE + ".loginIn.no", result.get("message").toString()), (MultiValueMap)headers, HttpStatus.OK);
        }
        UserSession userSession = (UserSession)JsonUtil.getAllJsonUtil().getJsonToObject(result.get("session").toString(), UserSession.class);
        this.setUserSession(request, userSession);
        String group = SupDisUtil.getMap((String)"osconfig_key", (String)ServletMain.getAppName());
        CookieUtil.CreateCook((HttpServletResponse)response, (String)Tokenkey, (String)userSession.getTicketTokenid(), (String)group);
        return new ResponseEntity((Object)new HtmlJsonReBean((Object)redirectURL), (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"loginOut.json"})
    @ResponseBody
    public HtmlJsonReBean loginOut(HttpServletRequest request, HttpServletResponse response) {
        this.setUserSession(request, null);
        String token = "";
        if (null != request.getCookies()) {
            Cookie[] cookies;
            for (Cookie cookie : cookies = request.getCookies()) {
                if (!cookie.getName().equalsIgnoreCase(Tokenkey)) continue;
                token = cookie.getValue();
            }
        }
        String tenantCode = ResourceUtil.getOut((String)"laser", (String)"", (String)"tenantCode");
        String browType = BrowTypeUtil.getBrowType((String)request.getHeader("User-Agent"));
        this.loginRepository.loginOut(token, browType, ServletMain.getAppName(), tenantCode);
        String group = SupDisUtil.getMap((String)"osconfig_key", (String)ServletMain.getAppName());
        CookieUtil.CreateCook((HttpServletResponse)response, (String)Tokenkey, null, (String)group);
        CookieUtil.CreateCook((HttpServletResponse)response, (String)TenantCode, null, (String)group);
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"getVerCode.img"})
    @ResponseBody
    public void getVerCode(HttpServletRequest request, HttpServletResponse response) {
        String tenantCode = ResourceUtil.getOut((String)"laser", (String)"", (String)"tenantCode");
        String verCode = "";
        Map result = this.rdrandomRepository.getRandom("2", request.getRemoteAddr(), ServletMain.getAppName(), tenantCode);
        if (((Boolean)result.get("flag")).booleanValue()) {
            response.setHeader("Content-Type", "image/jped");
            response.setDateHeader("expries", -1L);
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Pragma", "no-cache");
            verCode = (String)result.get("message");
            BufferedImage bufferedImage = new VerifyImgUtils(verCode).getBuffImg();
            try {
                ImageIO.write((RenderedImage)bufferedImage, "jpg", (OutputStream)response.getOutputStream());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

